import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ChildOrganizationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/child_organization#id ChildOrganization#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name for Child Organization after creation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/child_organization#name ChildOrganization#name}
    */
    readonly name: string;
}
export interface ChildOrganizationApiKey {
}
export declare function childOrganizationApiKeyToTerraform(struct?: ChildOrganizationApiKey): any;
export declare class ChildOrganizationApiKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ChildOrganizationApiKey | undefined;
    set internalValue(value: ChildOrganizationApiKey | undefined);
    get key(): string;
    get name(): string;
}
export declare class ChildOrganizationApiKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ChildOrganizationApiKeyOutputReference;
}
export interface ChildOrganizationApplicationKey {
}
export declare function childOrganizationApplicationKeyToTerraform(struct?: ChildOrganizationApplicationKey): any;
export declare class ChildOrganizationApplicationKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ChildOrganizationApplicationKey | undefined;
    set internalValue(value: ChildOrganizationApplicationKey | undefined);
    get hash(): string;
    get name(): string;
    get owner(): string;
}
export declare class ChildOrganizationApplicationKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ChildOrganizationApplicationKeyOutputReference;
}
export interface ChildOrganizationSettingsSaml {
}
export declare function childOrganizationSettingsSamlToTerraform(struct?: ChildOrganizationSettingsSaml): any;
export declare class ChildOrganizationSettingsSamlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ChildOrganizationSettingsSaml | undefined;
    set internalValue(value: ChildOrganizationSettingsSaml | undefined);
    get enabled(): cdktf.IResolvable;
}
export declare class ChildOrganizationSettingsSamlList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ChildOrganizationSettingsSamlOutputReference;
}
export interface ChildOrganizationSettingsSamlAutocreateUsersDomains {
}
export declare function childOrganizationSettingsSamlAutocreateUsersDomainsToTerraform(struct?: ChildOrganizationSettingsSamlAutocreateUsersDomains): any;
export declare class ChildOrganizationSettingsSamlAutocreateUsersDomainsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ChildOrganizationSettingsSamlAutocreateUsersDomains | undefined;
    set internalValue(value: ChildOrganizationSettingsSamlAutocreateUsersDomains | undefined);
    get domains(): string[];
    get enabled(): cdktf.IResolvable;
}
export declare class ChildOrganizationSettingsSamlAutocreateUsersDomainsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ChildOrganizationSettingsSamlAutocreateUsersDomainsOutputReference;
}
export interface ChildOrganizationSettingsSamlIdpInitiatedLogin {
}
export declare function childOrganizationSettingsSamlIdpInitiatedLoginToTerraform(struct?: ChildOrganizationSettingsSamlIdpInitiatedLogin): any;
export declare class ChildOrganizationSettingsSamlIdpInitiatedLoginOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ChildOrganizationSettingsSamlIdpInitiatedLogin | undefined;
    set internalValue(value: ChildOrganizationSettingsSamlIdpInitiatedLogin | undefined);
    get enabled(): cdktf.IResolvable;
}
export declare class ChildOrganizationSettingsSamlIdpInitiatedLoginList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ChildOrganizationSettingsSamlIdpInitiatedLoginOutputReference;
}
export interface ChildOrganizationSettingsSamlStrictMode {
}
export declare function childOrganizationSettingsSamlStrictModeToTerraform(struct?: ChildOrganizationSettingsSamlStrictMode): any;
export declare class ChildOrganizationSettingsSamlStrictModeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ChildOrganizationSettingsSamlStrictMode | undefined;
    set internalValue(value: ChildOrganizationSettingsSamlStrictMode | undefined);
    get enabled(): cdktf.IResolvable;
}
export declare class ChildOrganizationSettingsSamlStrictModeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ChildOrganizationSettingsSamlStrictModeOutputReference;
}
export interface ChildOrganizationSettings {
}
export declare function childOrganizationSettingsToTerraform(struct?: ChildOrganizationSettings): any;
export declare class ChildOrganizationSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ChildOrganizationSettings | undefined;
    set internalValue(value: ChildOrganizationSettings | undefined);
    get privateWidgetShare(): cdktf.IResolvable;
    private _saml;
    get saml(): ChildOrganizationSettingsSamlList;
    get samlAutocreateAccessRole(): string;
    private _samlAutocreateUsersDomains;
    get samlAutocreateUsersDomains(): ChildOrganizationSettingsSamlAutocreateUsersDomainsList;
    get samlCanBeEnabled(): cdktf.IResolvable;
    get samlIdpEndpoint(): string;
    private _samlIdpInitiatedLogin;
    get samlIdpInitiatedLogin(): ChildOrganizationSettingsSamlIdpInitiatedLoginList;
    get samlIdpMetadataUploaded(): cdktf.IResolvable;
    get samlLoginUrl(): string;
    private _samlStrictMode;
    get samlStrictMode(): ChildOrganizationSettingsSamlStrictModeList;
}
export declare class ChildOrganizationSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ChildOrganizationSettingsOutputReference;
}
export interface ChildOrganizationUser {
}
export declare function childOrganizationUserToTerraform(struct?: ChildOrganizationUser): any;
export declare class ChildOrganizationUserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ChildOrganizationUser | undefined;
    set internalValue(value: ChildOrganizationUser | undefined);
    get accessRole(): string;
    get email(): string;
    get name(): string;
}
export declare class ChildOrganizationUserList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ChildOrganizationUserOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/child_organization datadog_child_organization}
*/
export declare class ChildOrganization extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_child_organization";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/child_organization datadog_child_organization} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ChildOrganizationConfig
    */
    constructor(scope: Construct, id: string, config: ChildOrganizationConfig);
    private _apiKey;
    get apiKey(): ChildOrganizationApiKeyList;
    private _applicationKey;
    get applicationKey(): ChildOrganizationApplicationKeyList;
    get description(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get publicId(): string;
    private _settings;
    get settings(): ChildOrganizationSettingsList;
    private _user;
    get user(): ChildOrganizationUserList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
