import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudConfigurationRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Whether the cloud configuration rule is enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/cloud_configuration_rule#enabled CloudConfigurationRule#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Fields to group by when generating signals, e.g. @resource. Defaults to empty list.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/cloud_configuration_rule#group_by CloudConfigurationRule#group_by}
    */
    readonly groupBy?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/cloud_configuration_rule#id CloudConfigurationRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The message associated to the rule that will be shown in findings and signals.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/cloud_configuration_rule#message CloudConfigurationRule#message}
    */
    readonly message: string;
    /**
    * The name of the cloud configuration rule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/cloud_configuration_rule#name CloudConfigurationRule#name}
    */
    readonly name: string;
    /**
    * Notification targets for signals. Defaults to empty list.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/cloud_configuration_rule#notifications CloudConfigurationRule#notifications}
    */
    readonly notifications?: string[];
    /**
    * Policy written in Rego format.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/cloud_configuration_rule#policy CloudConfigurationRule#policy}
    */
    readonly policy: string;
    /**
    * Related resource types to be checked by the rule. Defaults to empty list.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/cloud_configuration_rule#related_resource_types CloudConfigurationRule#related_resource_types}
    */
    readonly relatedResourceTypes?: string[];
    /**
    * Main resource type to be checked by the rule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/cloud_configuration_rule#resource_type CloudConfigurationRule#resource_type}
    */
    readonly resourceType: string;
    /**
    * Severity of the rule and associated signals. Valid values are `info`, `low`, `medium`, `high`, `critical`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/cloud_configuration_rule#severity CloudConfigurationRule#severity}
    */
    readonly severity: string;
    /**
    * Tags of the rule, propagated to findings and signals. Defaults to empty list.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/cloud_configuration_rule#tags CloudConfigurationRule#tags}
    */
    readonly tags?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/cloud_configuration_rule datadog_cloud_configuration_rule}
*/
export declare class CloudConfigurationRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_cloud_configuration_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/cloud_configuration_rule datadog_cloud_configuration_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CloudConfigurationRuleConfig
    */
    constructor(scope: Construct, id: string, config: CloudConfigurationRuleConfig);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _groupBy?;
    get groupBy(): string[];
    set groupBy(value: string[]);
    resetGroupBy(): void;
    get groupByInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _message?;
    get message(): string;
    set message(value: string);
    get messageInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _notifications?;
    get notifications(): string[];
    set notifications(value: string[]);
    resetNotifications(): void;
    get notificationsInput(): string[] | undefined;
    private _policy?;
    get policy(): string;
    set policy(value: string);
    get policyInput(): string | undefined;
    private _relatedResourceTypes?;
    get relatedResourceTypes(): string[];
    set relatedResourceTypes(value: string[]);
    resetRelatedResourceTypes(): void;
    get relatedResourceTypesInput(): string[] | undefined;
    private _resourceType?;
    get resourceType(): string;
    set resourceType(value: string);
    get resourceTypeInput(): string | undefined;
    private _severity?;
    get severity(): string;
    set severity(value: string);
    get severityInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
