import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DashboardJsonConfig extends cdktf.TerraformMetaArguments {
    /**
    * The JSON formatted definition of the Dashboard.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_json#dashboard DashboardJson#dashboard}
    */
    readonly dashboard: string;
    /**
    * The list of dashboard lists this dashboard belongs to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_json#dashboard_lists DashboardJson#dashboard_lists}
    */
    readonly dashboardLists?: number[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_json#id DashboardJson#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The URL of the dashboard.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_json#url DashboardJson#url}
    */
    readonly url?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_json datadog_dashboard_json}
*/
export declare class DashboardJson extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_dashboard_json";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_json datadog_dashboard_json} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DashboardJsonConfig
    */
    constructor(scope: Construct, id: string, config: DashboardJsonConfig);
    private _dashboard?;
    get dashboard(): string;
    set dashboard(value: string);
    get dashboardInput(): string | undefined;
    private _dashboardLists?;
    get dashboardLists(): number[];
    set dashboardLists(value: number[]);
    resetDashboardLists(): void;
    get dashboardListsInput(): number[] | undefined;
    get dashboardListsRemoved(): number[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    resetUrl(): void;
    get urlInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
