import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DashboardListConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_list#id DashboardList#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the Dashboard List
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_list#name DashboardList#name}
    */
    readonly name: string;
    /**
    * dash_item block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_list#dash_item DashboardList#dash_item}
    */
    readonly dashItem?: DashboardListDashItem[] | cdktf.IResolvable;
}
export interface DashboardListDashItem {
    /**
    * The ID of the dashboard to add
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_list#dash_id DashboardList#dash_id}
    */
    readonly dashId: string;
    /**
    * The type of this dashboard. Valid values are `custom_timeboard`, `custom_screenboard`, `integration_screenboard`, `integration_timeboard`, `host_timeboard`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_list#type DashboardList#type}
    */
    readonly type: string;
}
export declare function dashboardListDashItemToTerraform(struct?: DashboardListDashItem | cdktf.IResolvable): any;
export declare class DashboardListDashItemOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardListDashItem | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardListDashItem | cdktf.IResolvable | undefined);
    private _dashId?;
    get dashId(): string;
    set dashId(value: string);
    get dashIdInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class DashboardListDashItemList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardListDashItem[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardListDashItemOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_list datadog_dashboard_list}
*/
export declare class DashboardList extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_dashboard_list";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_list datadog_dashboard_list} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DashboardListConfig
    */
    constructor(scope: Construct, id: string, config: DashboardListConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _dashItem;
    get dashItem(): DashboardListDashItemList;
    putDashItem(value: DashboardListDashItem[] | cdktf.IResolvable): void;
    resetDashItem(): void;
    get dashItemInput(): cdktf.IResolvable | DashboardListDashItem[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
