import * as cdktf from 'cdktf';
export interface DashboardTemplateVariable {
    /**
    * The list of values that the template variable drop-down is be limited to
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#available_values Dashboard#available_values}
    */
    readonly availableValues?: string[];
    /**
    * The default value for the template variable on dashboard load. Cannot be used in conjunction with `defaults`. **Deprecated.** Use `defaults` instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#default Dashboard#default}
    */
    readonly default?: string;
    /**
    * One or many default values for template variables on load. If more than one default is specified, they will be unioned together with `OR`. Cannot be used in conjunction with `default`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#defaults Dashboard#defaults}
    */
    readonly defaults?: string[];
    /**
    * The name of the variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
    */
    readonly name: string;
    /**
    * The tag prefix associated with the variable. Only tags with this prefix appear in the variable dropdown.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#prefix Dashboard#prefix}
    */
    readonly prefix?: string;
}
export declare function dashboardTemplateVariableToTerraform(struct?: DashboardTemplateVariable | cdktf.IResolvable): any;
export declare class DashboardTemplateVariableOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardTemplateVariable | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardTemplateVariable | cdktf.IResolvable | undefined);
    private _availableValues?;
    get availableValues(): string[];
    set availableValues(value: string[]);
    resetAvailableValues(): void;
    get availableValuesInput(): string[] | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _defaults?;
    get defaults(): string[];
    set defaults(value: string[]);
    resetDefaults(): void;
    get defaultsInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _prefix?;
    get prefix(): string;
    set prefix(value: string);
    resetPrefix(): void;
    get prefixInput(): string | undefined;
}
export declare class DashboardTemplateVariableList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardTemplateVariable[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardTemplateVariableOutputReference;
}
export interface DashboardTemplateVariablePresetTemplateVariable {
    /**
    * The name of the template variable
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
    */
    readonly name?: string;
    /**
    * The value that should be assumed by the template variable in this preset. Cannot be used in conjunction with `values`. **Deprecated.** Use `values` instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#value Dashboard#value}
    */
    readonly value?: string;
    /**
    * One or many template variable values within the saved view, which will be unioned together using `OR` if more than one is specified. Cannot be used in conjunction with `value`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#values Dashboard#values}
    */
    readonly values?: string[];
}
export declare function dashboardTemplateVariablePresetTemplateVariableToTerraform(struct?: DashboardTemplateVariablePresetTemplateVariable | cdktf.IResolvable): any;
export declare class DashboardTemplateVariablePresetTemplateVariableOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardTemplateVariablePresetTemplateVariable | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardTemplateVariablePresetTemplateVariable | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class DashboardTemplateVariablePresetTemplateVariableList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardTemplateVariablePresetTemplateVariable[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardTemplateVariablePresetTemplateVariableOutputReference;
}
export interface DashboardTemplateVariablePreset {
    /**
    * The name of the preset.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
    */
    readonly name?: string;
    /**
    * template_variable block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#template_variable Dashboard#template_variable}
    */
    readonly templateVariable?: DashboardTemplateVariablePresetTemplateVariable[] | cdktf.IResolvable;
}
export declare function dashboardTemplateVariablePresetToTerraform(struct?: DashboardTemplateVariablePreset | cdktf.IResolvable): any;
export declare class DashboardTemplateVariablePresetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardTemplateVariablePreset | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardTemplateVariablePreset | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _templateVariable;
    get templateVariable(): DashboardTemplateVariablePresetTemplateVariableList;
    putTemplateVariable(value: DashboardTemplateVariablePresetTemplateVariable[] | cdktf.IResolvable): void;
    resetTemplateVariable(): void;
    get templateVariableInput(): cdktf.IResolvable | DashboardTemplateVariablePresetTemplateVariable[] | undefined;
}
export declare class DashboardTemplateVariablePresetList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardTemplateVariablePreset[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardTemplateVariablePresetOutputReference;
}
export interface DashboardWidgetAlertGraphDefinition {
    /**
    * The ID of the monitor used by the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alert_id Dashboard#alert_id}
    */
    readonly alertId: string;
    /**
    * The timeframe to use when displaying the widget. Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
    */
    readonly liveSpan?: string;
    /**
    * The title of the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
    */
    readonly title?: string;
    /**
    * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
    */
    readonly titleAlign?: string;
    /**
    * The size of the widget's title (defaults to 16).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
    */
    readonly titleSize?: string;
    /**
    * Type of visualization to use when displaying the widget. Valid values are `timeseries`, `toplist`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#viz_type Dashboard#viz_type}
    */
    readonly vizType: string;
}
export declare function dashboardWidgetAlertGraphDefinitionToTerraform(struct?: DashboardWidgetAlertGraphDefinitionOutputReference | DashboardWidgetAlertGraphDefinition): any;
export declare class DashboardWidgetAlertGraphDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetAlertGraphDefinition | undefined;
    set internalValue(value: DashboardWidgetAlertGraphDefinition | undefined);
    private _alertId?;
    get alertId(): string;
    set alertId(value: string);
    get alertIdInput(): string | undefined;
    private _liveSpan?;
    get liveSpan(): string;
    set liveSpan(value: string);
    resetLiveSpan(): void;
    get liveSpanInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
    private _titleAlign?;
    get titleAlign(): string;
    set titleAlign(value: string);
    resetTitleAlign(): void;
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    get titleSize(): string;
    set titleSize(value: string);
    resetTitleSize(): void;
    get titleSizeInput(): string | undefined;
    private _vizType?;
    get vizType(): string;
    set vizType(value: string);
    get vizTypeInput(): string | undefined;
}
export interface DashboardWidgetAlertValueDefinition {
    /**
    * The ID of the monitor used by the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alert_id Dashboard#alert_id}
    */
    readonly alertId: string;
    /**
    * The precision to use when displaying the value. Use `*` for maximum precision.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#precision Dashboard#precision}
    */
    readonly precision?: number;
    /**
    * The alignment of the text in the widget. Valid values are `center`, `left`, `right`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#text_align Dashboard#text_align}
    */
    readonly textAlign?: string;
    /**
    * The title of the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
    */
    readonly title?: string;
    /**
    * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
    */
    readonly titleAlign?: string;
    /**
    * The size of the widget's title (defaults to 16).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
    */
    readonly titleSize?: string;
    /**
    * The unit for the value displayed in the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#unit Dashboard#unit}
    */
    readonly unit?: string;
}
export declare function dashboardWidgetAlertValueDefinitionToTerraform(struct?: DashboardWidgetAlertValueDefinitionOutputReference | DashboardWidgetAlertValueDefinition): any;
export declare class DashboardWidgetAlertValueDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetAlertValueDefinition | undefined;
    set internalValue(value: DashboardWidgetAlertValueDefinition | undefined);
    private _alertId?;
    get alertId(): string;
    set alertId(value: string);
    get alertIdInput(): string | undefined;
    private _precision?;
    get precision(): number;
    set precision(value: number);
    resetPrecision(): void;
    get precisionInput(): number | undefined;
    private _textAlign?;
    get textAlign(): string;
    set textAlign(value: string);
    resetTextAlign(): void;
    get textAlignInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
    private _titleAlign?;
    get titleAlign(): string;
    set titleAlign(value: string);
    resetTitleAlign(): void;
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    get titleSize(): string;
    set titleSize(value: string);
    resetTitleSize(): void;
    get titleSizeInput(): string | undefined;
    private _unit?;
    get unit(): string;
    set unit(value: string);
    resetUnit(): void;
    get unitInput(): string | undefined;
}
export interface DashboardWidgetChangeDefinitionCustomLink {
    /**
    * The flag for toggling context menu link visibility.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_hidden Dashboard#is_hidden}
    */
    readonly isHidden?: boolean | cdktf.IResolvable;
    /**
    * The label for the custom link URL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#label Dashboard#label}
    */
    readonly label?: string;
    /**
    * The URL of the custom link.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#link Dashboard#link}
    */
    readonly link?: string;
    /**
    * The label id that refers to a context menu link item. When override_label is provided, the client request omits the label field.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#override_label Dashboard#override_label}
    */
    readonly overrideLabel?: string;
}
export declare function dashboardWidgetChangeDefinitionCustomLinkToTerraform(struct?: DashboardWidgetChangeDefinitionCustomLink | cdktf.IResolvable): any;
export declare class DashboardWidgetChangeDefinitionCustomLinkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetChangeDefinitionCustomLink | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetChangeDefinitionCustomLink | cdktf.IResolvable | undefined);
    private _isHidden?;
    get isHidden(): boolean | cdktf.IResolvable;
    set isHidden(value: boolean | cdktf.IResolvable);
    resetIsHidden(): void;
    get isHiddenInput(): boolean | cdktf.IResolvable | undefined;
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _link?;
    get link(): string;
    set link(value: string);
    resetLink(): void;
    get linkInput(): string | undefined;
    private _overrideLabel?;
    get overrideLabel(): string;
    set overrideLabel(value: string);
    resetOverrideLabel(): void;
    get overrideLabelInput(): string | undefined;
}
export declare class DashboardWidgetChangeDefinitionCustomLinkList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetChangeDefinitionCustomLink[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetChangeDefinitionCustomLinkOutputReference;
}
export interface DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetChangeDefinitionRequestApmQueryComputeQueryToTerraform(struct?: DashboardWidgetChangeDefinitionRequestApmQueryComputeQueryOutputReference | DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery): any;
export declare class DashboardWidgetChangeDefinitionRequestApmQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery | undefined;
    set internalValue(value: DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export interface DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Widget sorting methods. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
    */
    readonly order: string;
}
export declare function dashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQueryOutputReference | DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQuery): any;
export declare class DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQuery | undefined;
    set internalValue(value: DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    get orderInput(): string | undefined;
}
export interface DashboardWidgetChangeDefinitionRequestApmQueryGroupBy {
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * The maximum number of items in the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * sort_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
    */
    readonly sortQuery?: DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQuery;
}
export declare function dashboardWidgetChangeDefinitionRequestApmQueryGroupByToTerraform(struct?: DashboardWidgetChangeDefinitionRequestApmQueryGroupBy | cdktf.IResolvable): any;
export declare class DashboardWidgetChangeDefinitionRequestApmQueryGroupByOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetChangeDefinitionRequestApmQueryGroupBy | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetChangeDefinitionRequestApmQueryGroupBy | cdktf.IResolvable | undefined);
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _sortQuery;
    get sortQuery(): DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQueryOutputReference;
    putSortQuery(value: DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQuery): void;
    resetSortQuery(): void;
    get sortQueryInput(): DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQuery | undefined;
}
export declare class DashboardWidgetChangeDefinitionRequestApmQueryGroupByList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetChangeDefinitionRequestApmQueryGroupBy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetChangeDefinitionRequestApmQueryGroupByOutputReference;
}
export interface DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetChangeDefinitionRequestApmQueryMultiComputeToTerraform(struct?: DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute | cdktf.IResolvable): any;
export declare class DashboardWidgetChangeDefinitionRequestApmQueryMultiComputeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute | cdktf.IResolvable | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export declare class DashboardWidgetChangeDefinitionRequestApmQueryMultiComputeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetChangeDefinitionRequestApmQueryMultiComputeOutputReference;
}
export interface DashboardWidgetChangeDefinitionRequestApmQuery {
    /**
    * The name of the index to query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
    */
    readonly index: string;
    /**
    * The search query to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
    */
    readonly searchQuery?: string;
    /**
    * compute_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
    */
    readonly computeQuery?: DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery;
    /**
    * group_by block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
    */
    readonly groupBy?: DashboardWidgetChangeDefinitionRequestApmQueryGroupBy[] | cdktf.IResolvable;
    /**
    * multi_compute block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
    */
    readonly multiCompute?: DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetChangeDefinitionRequestApmQueryToTerraform(struct?: DashboardWidgetChangeDefinitionRequestApmQueryOutputReference | DashboardWidgetChangeDefinitionRequestApmQuery): any;
export declare class DashboardWidgetChangeDefinitionRequestApmQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetChangeDefinitionRequestApmQuery | undefined;
    set internalValue(value: DashboardWidgetChangeDefinitionRequestApmQuery | undefined);
    private _index?;
    get index(): string;
    set index(value: string);
    get indexInput(): string | undefined;
    private _searchQuery?;
    get searchQuery(): string;
    set searchQuery(value: string);
    resetSearchQuery(): void;
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    get computeQuery(): DashboardWidgetChangeDefinitionRequestApmQueryComputeQueryOutputReference;
    putComputeQuery(value: DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery): void;
    resetComputeQuery(): void;
    get computeQueryInput(): DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery | undefined;
    private _groupBy;
    get groupBy(): DashboardWidgetChangeDefinitionRequestApmQueryGroupByList;
    putGroupBy(value: DashboardWidgetChangeDefinitionRequestApmQueryGroupBy[] | cdktf.IResolvable): void;
    resetGroupBy(): void;
    get groupByInput(): cdktf.IResolvable | DashboardWidgetChangeDefinitionRequestApmQueryGroupBy[] | undefined;
    private _multiCompute;
    get multiCompute(): DashboardWidgetChangeDefinitionRequestApmQueryMultiComputeList;
    putMultiCompute(value: DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute[] | cdktf.IResolvable): void;
    resetMultiCompute(): void;
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute[] | undefined;
}
export interface DashboardWidgetChangeDefinitionRequestFormulaConditionalFormats {
    /**
    * The comparator to use. Valid values are `>`, `>=`, `<`, `<=`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#comparator Dashboard#comparator}
    */
    readonly comparator: string;
    /**
    * The color palette to apply to the background, same values available as palette.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_bg_color Dashboard#custom_bg_color}
    */
    readonly customBgColor?: string;
    /**
    * The color palette to apply to the foreground, same values available as palette.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_fg_color Dashboard#custom_fg_color}
    */
    readonly customFgColor?: string;
    /**
    * Setting this to True hides values.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#hide_value Dashboard#hide_value}
    */
    readonly hideValue?: boolean | cdktf.IResolvable;
    /**
    * Displays an image as the background.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#image_url Dashboard#image_url}
    */
    readonly imageUrl?: string;
    /**
    * The metric from the request to correlate with this conditional format.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
    */
    readonly metric?: string;
    /**
    * The color palette to apply. Valid values are `blue`, `custom_bg`, `custom_image`, `custom_text`, `gray_on_white`, `grey`, `green`, `orange`, `red`, `red_on_white`, `white_on_gray`, `white_on_green`, `green_on_white`, `white_on_red`, `white_on_yellow`, `yellow_on_white`, `black_on_light_yellow`, `black_on_light_green`, `black_on_light_red`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
    */
    readonly palette: string;
    /**
    * Defines the displayed timeframe.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#timeframe Dashboard#timeframe}
    */
    readonly timeframe?: string;
    /**
    * A value for the comparator.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#value Dashboard#value}
    */
    readonly value: number;
}
export declare function dashboardWidgetChangeDefinitionRequestFormulaConditionalFormatsToTerraform(struct?: DashboardWidgetChangeDefinitionRequestFormulaConditionalFormats | cdktf.IResolvable): any;
export declare class DashboardWidgetChangeDefinitionRequestFormulaConditionalFormatsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetChangeDefinitionRequestFormulaConditionalFormats | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetChangeDefinitionRequestFormulaConditionalFormats | cdktf.IResolvable | undefined);
    private _comparator?;
    get comparator(): string;
    set comparator(value: string);
    get comparatorInput(): string | undefined;
    private _customBgColor?;
    get customBgColor(): string;
    set customBgColor(value: string);
    resetCustomBgColor(): void;
    get customBgColorInput(): string | undefined;
    private _customFgColor?;
    get customFgColor(): string;
    set customFgColor(value: string);
    resetCustomFgColor(): void;
    get customFgColorInput(): string | undefined;
    private _hideValue?;
    get hideValue(): boolean | cdktf.IResolvable;
    set hideValue(value: boolean | cdktf.IResolvable);
    resetHideValue(): void;
    get hideValueInput(): boolean | cdktf.IResolvable | undefined;
    private _imageUrl?;
    get imageUrl(): string;
    set imageUrl(value: string);
    resetImageUrl(): void;
    get imageUrlInput(): string | undefined;
    private _metric?;
    get metric(): string;
    set metric(value: string);
    resetMetric(): void;
    get metricInput(): string | undefined;
    private _palette?;
    get palette(): string;
    set palette(value: string);
    get paletteInput(): string | undefined;
    private _timeframe?;
    get timeframe(): string;
    set timeframe(value: string);
    resetTimeframe(): void;
    get timeframeInput(): string | undefined;
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
}
export declare class DashboardWidgetChangeDefinitionRequestFormulaConditionalFormatsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetChangeDefinitionRequestFormulaConditionalFormats[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetChangeDefinitionRequestFormulaConditionalFormatsOutputReference;
}
export interface DashboardWidgetChangeDefinitionRequestFormulaLimit {
    /**
    * The number of results to return
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#count Dashboard#count}
    */
    readonly count?: number;
    /**
    * The direction of the sort. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
    */
    readonly order?: string;
}
export declare function dashboardWidgetChangeDefinitionRequestFormulaLimitToTerraform(struct?: DashboardWidgetChangeDefinitionRequestFormulaLimitOutputReference | DashboardWidgetChangeDefinitionRequestFormulaLimit): any;
export declare class DashboardWidgetChangeDefinitionRequestFormulaLimitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetChangeDefinitionRequestFormulaLimit | undefined;
    set internalValue(value: DashboardWidgetChangeDefinitionRequestFormulaLimit | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    resetCount(): void;
    get countInput(): number | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    resetOrder(): void;
    get orderInput(): string | undefined;
}
export interface DashboardWidgetChangeDefinitionRequestFormulaStyle {
    /**
    * The color palette used to display the formula. A guide to the available color palettes can be found at https://docs.datadoghq.com/dashboards/guide/widget_colors
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
    */
    readonly palette?: string;
    /**
    * Index specifying which color to use within the palette.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette_index Dashboard#palette_index}
    */
    readonly paletteIndex?: number;
}
export declare function dashboardWidgetChangeDefinitionRequestFormulaStyleToTerraform(struct?: DashboardWidgetChangeDefinitionRequestFormulaStyleOutputReference | DashboardWidgetChangeDefinitionRequestFormulaStyle): any;
export declare class DashboardWidgetChangeDefinitionRequestFormulaStyleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetChangeDefinitionRequestFormulaStyle | undefined;
    set internalValue(value: DashboardWidgetChangeDefinitionRequestFormulaStyle | undefined);
    private _palette?;
    get palette(): string;
    set palette(value: string);
    resetPalette(): void;
    get paletteInput(): string | undefined;
    private _paletteIndex?;
    get paletteIndex(): number;
    set paletteIndex(value: number);
    resetPaletteIndex(): void;
    get paletteIndexInput(): number | undefined;
}
export interface DashboardWidgetChangeDefinitionRequestFormula {
    /**
    * An expression alias.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alias Dashboard#alias}
    */
    readonly alias?: string;
    /**
    * A list of display modes for each table cell. Valid values are `number`, `bar`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#cell_display_mode Dashboard#cell_display_mode}
    */
    readonly cellDisplayMode?: string;
    /**
    * A string expression built from queries, formulas, and functions.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#formula_expression Dashboard#formula_expression}
    */
    readonly formulaExpression: string;
    /**
    * conditional_formats block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#conditional_formats Dashboard#conditional_formats}
    */
    readonly conditionalFormats?: DashboardWidgetChangeDefinitionRequestFormulaConditionalFormats[] | cdktf.IResolvable;
    /**
    * limit block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: DashboardWidgetChangeDefinitionRequestFormulaLimit;
    /**
    * style block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#style Dashboard#style}
    */
    readonly style?: DashboardWidgetChangeDefinitionRequestFormulaStyle;
}
export declare function dashboardWidgetChangeDefinitionRequestFormulaToTerraform(struct?: DashboardWidgetChangeDefinitionRequestFormula | cdktf.IResolvable): any;
export declare class DashboardWidgetChangeDefinitionRequestFormulaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetChangeDefinitionRequestFormula | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetChangeDefinitionRequestFormula | cdktf.IResolvable | undefined);
    private _alias?;
    get alias(): string;
    set alias(value: string);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    private _cellDisplayMode?;
    get cellDisplayMode(): string;
    set cellDisplayMode(value: string);
    resetCellDisplayMode(): void;
    get cellDisplayModeInput(): string | undefined;
    private _formulaExpression?;
    get formulaExpression(): string;
    set formulaExpression(value: string);
    get formulaExpressionInput(): string | undefined;
    private _conditionalFormats;
    get conditionalFormats(): DashboardWidgetChangeDefinitionRequestFormulaConditionalFormatsList;
    putConditionalFormats(value: DashboardWidgetChangeDefinitionRequestFormulaConditionalFormats[] | cdktf.IResolvable): void;
    resetConditionalFormats(): void;
    get conditionalFormatsInput(): cdktf.IResolvable | DashboardWidgetChangeDefinitionRequestFormulaConditionalFormats[] | undefined;
    private _limit;
    get limit(): DashboardWidgetChangeDefinitionRequestFormulaLimitOutputReference;
    putLimit(value: DashboardWidgetChangeDefinitionRequestFormulaLimit): void;
    resetLimit(): void;
    get limitInput(): DashboardWidgetChangeDefinitionRequestFormulaLimit | undefined;
    private _style;
    get style(): DashboardWidgetChangeDefinitionRequestFormulaStyleOutputReference;
    putStyle(value: DashboardWidgetChangeDefinitionRequestFormulaStyle): void;
    resetStyle(): void;
    get styleInput(): DashboardWidgetChangeDefinitionRequestFormulaStyle | undefined;
}
export declare class DashboardWidgetChangeDefinitionRequestFormulaList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetChangeDefinitionRequestFormula[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetChangeDefinitionRequestFormulaOutputReference;
}
export interface DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetChangeDefinitionRequestLogQueryComputeQueryToTerraform(struct?: DashboardWidgetChangeDefinitionRequestLogQueryComputeQueryOutputReference | DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery): any;
export declare class DashboardWidgetChangeDefinitionRequestLogQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery | undefined;
    set internalValue(value: DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export interface DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Widget sorting methods. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
    */
    readonly order: string;
}
export declare function dashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQueryOutputReference | DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQuery): any;
export declare class DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQuery | undefined;
    set internalValue(value: DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    get orderInput(): string | undefined;
}
export interface DashboardWidgetChangeDefinitionRequestLogQueryGroupBy {
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * The maximum number of items in the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * sort_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
    */
    readonly sortQuery?: DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQuery;
}
export declare function dashboardWidgetChangeDefinitionRequestLogQueryGroupByToTerraform(struct?: DashboardWidgetChangeDefinitionRequestLogQueryGroupBy | cdktf.IResolvable): any;
export declare class DashboardWidgetChangeDefinitionRequestLogQueryGroupByOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetChangeDefinitionRequestLogQueryGroupBy | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetChangeDefinitionRequestLogQueryGroupBy | cdktf.IResolvable | undefined);
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _sortQuery;
    get sortQuery(): DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQueryOutputReference;
    putSortQuery(value: DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQuery): void;
    resetSortQuery(): void;
    get sortQueryInput(): DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQuery | undefined;
}
export declare class DashboardWidgetChangeDefinitionRequestLogQueryGroupByList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetChangeDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetChangeDefinitionRequestLogQueryGroupByOutputReference;
}
export interface DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetChangeDefinitionRequestLogQueryMultiComputeToTerraform(struct?: DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute | cdktf.IResolvable): any;
export declare class DashboardWidgetChangeDefinitionRequestLogQueryMultiComputeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute | cdktf.IResolvable | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export declare class DashboardWidgetChangeDefinitionRequestLogQueryMultiComputeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetChangeDefinitionRequestLogQueryMultiComputeOutputReference;
}
export interface DashboardWidgetChangeDefinitionRequestLogQuery {
    /**
    * The name of the index to query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
    */
    readonly index: string;
    /**
    * The search query to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
    */
    readonly searchQuery?: string;
    /**
    * compute_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
    */
    readonly computeQuery?: DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery;
    /**
    * group_by block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
    */
    readonly groupBy?: DashboardWidgetChangeDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable;
    /**
    * multi_compute block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
    */
    readonly multiCompute?: DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetChangeDefinitionRequestLogQueryToTerraform(struct?: DashboardWidgetChangeDefinitionRequestLogQueryOutputReference | DashboardWidgetChangeDefinitionRequestLogQuery): any;
export declare class DashboardWidgetChangeDefinitionRequestLogQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetChangeDefinitionRequestLogQuery | undefined;
    set internalValue(value: DashboardWidgetChangeDefinitionRequestLogQuery | undefined);
    private _index?;
    get index(): string;
    set index(value: string);
    get indexInput(): string | undefined;
    private _searchQuery?;
    get searchQuery(): string;
    set searchQuery(value: string);
    resetSearchQuery(): void;
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    get computeQuery(): DashboardWidgetChangeDefinitionRequestLogQueryComputeQueryOutputReference;
    putComputeQuery(value: DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery): void;
    resetComputeQuery(): void;
    get computeQueryInput(): DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery | undefined;
    private _groupBy;
    get groupBy(): DashboardWidgetChangeDefinitionRequestLogQueryGroupByList;
    putGroupBy(value: DashboardWidgetChangeDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable): void;
    resetGroupBy(): void;
    get groupByInput(): cdktf.IResolvable | DashboardWidgetChangeDefinitionRequestLogQueryGroupBy[] | undefined;
    private _multiCompute;
    get multiCompute(): DashboardWidgetChangeDefinitionRequestLogQueryMultiComputeList;
    putMultiCompute(value: DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable): void;
    resetMultiCompute(): void;
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute[] | undefined;
}
export interface DashboardWidgetChangeDefinitionRequestProcessQuery {
    /**
    * A list of processes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#filter_by Dashboard#filter_by}
    */
    readonly filterBy?: string[];
    /**
    * The max number of items in the filter list.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * Your chosen metric.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
    */
    readonly metric: string;
    /**
    * Your chosen search term.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_by Dashboard#search_by}
    */
    readonly searchBy?: string;
}
export declare function dashboardWidgetChangeDefinitionRequestProcessQueryToTerraform(struct?: DashboardWidgetChangeDefinitionRequestProcessQueryOutputReference | DashboardWidgetChangeDefinitionRequestProcessQuery): any;
export declare class DashboardWidgetChangeDefinitionRequestProcessQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetChangeDefinitionRequestProcessQuery | undefined;
    set internalValue(value: DashboardWidgetChangeDefinitionRequestProcessQuery | undefined);
    private _filterBy?;
    get filterBy(): string[];
    set filterBy(value: string[]);
    resetFilterBy(): void;
    get filterByInput(): string[] | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _metric?;
    get metric(): string;
    set metric(value: string);
    get metricInput(): string | undefined;
    private _searchBy?;
    get searchBy(): string;
    set searchBy(value: string);
    resetSearchBy(): void;
    get searchByInput(): string | undefined;
}
export interface DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery {
    /**
    * The data source for APM Dependency Stats queries. Valid values are `apm_dependency_stats`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
    */
    readonly dataSource: string;
    /**
    * APM Environment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#env Dashboard#env}
    */
    readonly env: string;
    /**
    * Determines whether stats for upstream or downstream dependencies should be queried.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_upstream Dashboard#is_upstream}
    */
    readonly isUpstream?: boolean | cdktf.IResolvable;
    /**
    * The name of query for use in formulas.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
    */
    readonly name: string;
    /**
    * Name of operation on service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#operation_name Dashboard#operation_name}
    */
    readonly operationName: string;
    /**
    * The name of the second primary tag used within APM; required when `primary_tag_value` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_name Dashboard#primary_tag_name}
    */
    readonly primaryTagName?: string;
    /**
    * Filter APM data by the second primary tag. `primary_tag_name` must also be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_value Dashboard#primary_tag_value}
    */
    readonly primaryTagValue?: string;
    /**
    * APM resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#resource_name Dashboard#resource_name}
    */
    readonly resourceName: string;
    /**
    * APM service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service Dashboard#service}
    */
    readonly service: string;
    /**
    * APM statistic. Valid values are `avg_duration`, `avg_root_duration`, `avg_spans_per_trace`, `error_rate`, `pct_exec_time`, `pct_of_traces`, `total_traces_count`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#stat Dashboard#stat}
    */
    readonly stat: string;
}
export declare function dashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQueryToTerraform(struct?: DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQueryOutputReference | DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery): any;
export declare class DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery | undefined;
    set internalValue(value: DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery | undefined);
    private _dataSource?;
    get dataSource(): string;
    set dataSource(value: string);
    get dataSourceInput(): string | undefined;
    private _env?;
    get env(): string;
    set env(value: string);
    get envInput(): string | undefined;
    private _isUpstream?;
    get isUpstream(): boolean | cdktf.IResolvable;
    set isUpstream(value: boolean | cdktf.IResolvable);
    resetIsUpstream(): void;
    get isUpstreamInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _operationName?;
    get operationName(): string;
    set operationName(value: string);
    get operationNameInput(): string | undefined;
    private _primaryTagName?;
    get primaryTagName(): string;
    set primaryTagName(value: string);
    resetPrimaryTagName(): void;
    get primaryTagNameInput(): string | undefined;
    private _primaryTagValue?;
    get primaryTagValue(): string;
    set primaryTagValue(value: string);
    resetPrimaryTagValue(): void;
    get primaryTagValueInput(): string | undefined;
    private _resourceName?;
    get resourceName(): string;
    set resourceName(value: string);
    get resourceNameInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _stat?;
    get stat(): string;
    set stat(value: string);
    get statInput(): string | undefined;
}
export interface DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQuery {
    /**
    * The data source for APM Resource Stats queries. Valid values are `apm_resource_stats`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
    */
    readonly dataSource: string;
    /**
    * APM Environment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#env Dashboard#env}
    */
    readonly env: string;
    /**
    * Array of fields to group results by.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
    */
    readonly groupBy?: string[];
    /**
    * The name of query for use in formulas.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
    */
    readonly name: string;
    /**
    * Name of operation on service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#operation_name Dashboard#operation_name}
    */
    readonly operationName?: string;
    /**
    * The name of the second primary tag used within APM; required when `primary_tag_value` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_name Dashboard#primary_tag_name}
    */
    readonly primaryTagName?: string;
    /**
    * Filter APM data by the second primary tag. `primary_tag_name` must also be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_value Dashboard#primary_tag_value}
    */
    readonly primaryTagValue?: string;
    /**
    * APM resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#resource_name Dashboard#resource_name}
    */
    readonly resourceName?: string;
    /**
    * APM service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service Dashboard#service}
    */
    readonly service: string;
    /**
    * APM statistic. Valid values are `errors`, `error_rate`, `hits`, `latency_avg`, `latency_distribution`, `latency_max`, `latency_p50`, `latency_p75`, `latency_p90`, `latency_p95`, `latency_p99`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#stat Dashboard#stat}
    */
    readonly stat: string;
}
export declare function dashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQueryToTerraform(struct?: DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQueryOutputReference | DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQuery): any;
export declare class DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQuery | undefined;
    set internalValue(value: DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQuery | undefined);
    private _dataSource?;
    get dataSource(): string;
    set dataSource(value: string);
    get dataSourceInput(): string | undefined;
    private _env?;
    get env(): string;
    set env(value: string);
    get envInput(): string | undefined;
    private _groupBy?;
    get groupBy(): string[];
    set groupBy(value: string[]);
    resetGroupBy(): void;
    get groupByInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _operationName?;
    get operationName(): string;
    set operationName(value: string);
    resetOperationName(): void;
    get operationNameInput(): string | undefined;
    private _primaryTagName?;
    get primaryTagName(): string;
    set primaryTagName(value: string);
    resetPrimaryTagName(): void;
    get primaryTagNameInput(): string | undefined;
    private _primaryTagValue?;
    get primaryTagValue(): string;
    set primaryTagValue(value: string);
    resetPrimaryTagValue(): void;
    get primaryTagValueInput(): string | undefined;
    private _resourceName?;
    get resourceName(): string;
    set resourceName(value: string);
    resetResourceName(): void;
    get resourceNameInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _stat?;
    get stat(): string;
    set stat(value: string);
    get statInput(): string | undefined;
}
export interface DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute {
    /**
    * The aggregation methods for event platform queries. Valid values are `count`, `cardinality`, `median`, `pc75`, `pc90`, `pc95`, `pc98`, `pc99`, `sum`, `min`, `max`, `avg`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * A time interval in milliseconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
    /**
    * The measurable attribute to compute.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
    */
    readonly metric?: string;
}
export declare function dashboardWidgetChangeDefinitionRequestQueryEventQueryComputeToTerraform(struct?: DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute | cdktf.IResolvable): any;
export declare class DashboardWidgetChangeDefinitionRequestQueryEventQueryComputeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute | cdktf.IResolvable | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
    private _metric?;
    get metric(): string;
    set metric(value: string);
    resetMetric(): void;
    get metricInput(): string | undefined;
}
export declare class DashboardWidgetChangeDefinitionRequestQueryEventQueryComputeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetChangeDefinitionRequestQueryEventQueryComputeOutputReference;
}
export interface DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySort {
    /**
    * The aggregation methods for the event platform queries. Valid values are `count`, `cardinality`, `median`, `pc75`, `pc90`, `pc95`, `pc98`, `pc99`, `sum`, `min`, `max`, `avg`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The metric used for sorting group by results.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
    */
    readonly metric?: string;
    /**
    * Direction of sort. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
    */
    readonly order?: string;
}
export declare function dashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySortToTerraform(struct?: DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySortOutputReference | DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySort): any;
export declare class DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySort | undefined;
    set internalValue(value: DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySort | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _metric?;
    get metric(): string;
    set metric(value: string);
    resetMetric(): void;
    get metricInput(): string | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    resetOrder(): void;
    get orderInput(): string | undefined;
}
export interface DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy {
    /**
    * The event facet.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet: string;
    /**
    * The number of groups to return.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * sort block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort Dashboard#sort}
    */
    readonly sort?: DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySort;
}
export declare function dashboardWidgetChangeDefinitionRequestQueryEventQueryGroupByToTerraform(struct?: DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy | cdktf.IResolvable): any;
export declare class DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupByOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy | cdktf.IResolvable | undefined);
    private _facet?;
    get facet(): string;
    set facet(value: string);
    get facetInput(): string | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _sort;
    get sort(): DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySortOutputReference;
    putSort(value: DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySort): void;
    resetSort(): void;
    get sortInput(): DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBySort | undefined;
}
export declare class DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupByList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupByOutputReference;
}
export interface DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch {
    /**
    * The events search string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
    */
    readonly query: string;
}
export declare function dashboardWidgetChangeDefinitionRequestQueryEventQuerySearchToTerraform(struct?: DashboardWidgetChangeDefinitionRequestQueryEventQuerySearchOutputReference | DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch): any;
export declare class DashboardWidgetChangeDefinitionRequestQueryEventQuerySearchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch | undefined;
    set internalValue(value: DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch | undefined);
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
}
export interface DashboardWidgetChangeDefinitionRequestQueryEventQuery {
    /**
    * The data source for event platform-based queries. Valid values are `logs`, `spans`, `network`, `rum`, `security_signals`, `profiles`, `audit`, `events`, `ci_tests`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
    */
    readonly dataSource: string;
    /**
    * An array of index names to query in the stream.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#indexes Dashboard#indexes}
    */
    readonly indexes?: string[];
    /**
    * The name of query for use in formulas.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
    */
    readonly name: string;
    /**
    * Storage location (private beta).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#storage Dashboard#storage}
    */
    readonly storage?: string;
    /**
    * compute block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute Dashboard#compute}
    */
    readonly compute: DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute[] | cdktf.IResolvable;
    /**
    * group_by block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
    */
    readonly groupBy?: DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy[] | cdktf.IResolvable;
    /**
    * search block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search Dashboard#search}
    */
    readonly search?: DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch;
}
export declare function dashboardWidgetChangeDefinitionRequestQueryEventQueryToTerraform(struct?: DashboardWidgetChangeDefinitionRequestQueryEventQueryOutputReference | DashboardWidgetChangeDefinitionRequestQueryEventQuery): any;
export declare class DashboardWidgetChangeDefinitionRequestQueryEventQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetChangeDefinitionRequestQueryEventQuery | undefined;
    set internalValue(value: DashboardWidgetChangeDefinitionRequestQueryEventQuery | undefined);
    private _dataSource?;
    get dataSource(): string;
    set dataSource(value: string);
    get dataSourceInput(): string | undefined;
    private _indexes?;
    get indexes(): string[];
    set indexes(value: string[]);
    resetIndexes(): void;
    get indexesInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _storage?;
    get storage(): string;
    set storage(value: string);
    resetStorage(): void;
    get storageInput(): string | undefined;
    private _compute;
    get compute(): DashboardWidgetChangeDefinitionRequestQueryEventQueryComputeList;
    putCompute(value: DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute[] | cdktf.IResolvable): void;
    get computeInput(): cdktf.IResolvable | DashboardWidgetChangeDefinitionRequestQueryEventQueryCompute[] | undefined;
    private _groupBy;
    get groupBy(): DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupByList;
    putGroupBy(value: DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy[] | cdktf.IResolvable): void;
    resetGroupBy(): void;
    get groupByInput(): cdktf.IResolvable | DashboardWidgetChangeDefinitionRequestQueryEventQueryGroupBy[] | undefined;
    private _search;
    get search(): DashboardWidgetChangeDefinitionRequestQueryEventQuerySearchOutputReference;
    putSearch(value: DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch): void;
    resetSearch(): void;
    get searchInput(): DashboardWidgetChangeDefinitionRequestQueryEventQuerySearch | undefined;
}
export interface DashboardWidgetChangeDefinitionRequestQueryMetricQuery {
    /**
    * The aggregation methods available for metrics queries. Valid values are `avg`, `min`, `max`, `sum`, `last`, `area`, `l2norm`, `percentile`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregator Dashboard#aggregator}
    */
    readonly aggregator?: string;
    /**
    * The data source for metrics queries.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
    */
    readonly dataSource?: string;
    /**
    * The name of the query for use in formulas.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
    */
    readonly name: string;
    /**
    * The metrics query definition.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
    */
    readonly query: string;
}
export declare function dashboardWidgetChangeDefinitionRequestQueryMetricQueryToTerraform(struct?: DashboardWidgetChangeDefinitionRequestQueryMetricQueryOutputReference | DashboardWidgetChangeDefinitionRequestQueryMetricQuery): any;
export declare class DashboardWidgetChangeDefinitionRequestQueryMetricQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetChangeDefinitionRequestQueryMetricQuery | undefined;
    set internalValue(value: DashboardWidgetChangeDefinitionRequestQueryMetricQuery | undefined);
    private _aggregator?;
    get aggregator(): string;
    set aggregator(value: string);
    resetAggregator(): void;
    get aggregatorInput(): string | undefined;
    private _dataSource?;
    get dataSource(): string;
    set dataSource(value: string);
    resetDataSource(): void;
    get dataSourceInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
}
export interface DashboardWidgetChangeDefinitionRequestQueryProcessQuery {
    /**
    * The aggregation methods available for metrics queries. Valid values are `avg`, `min`, `max`, `sum`, `last`, `area`, `l2norm`, `percentile`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregator Dashboard#aggregator}
    */
    readonly aggregator?: string;
    /**
    * The data source for process queries. Valid values are `process`, `container`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
    */
    readonly dataSource: string;
    /**
    * Whether to normalize the CPU percentages.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_normalized_cpu Dashboard#is_normalized_cpu}
    */
    readonly isNormalizedCpu?: boolean | cdktf.IResolvable;
    /**
    * The number of hits to return.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * The process metric name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
    */
    readonly metric: string;
    /**
    * The name of query for use in formulas.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
    */
    readonly name: string;
    /**
    * The direction of the sort. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort Dashboard#sort}
    */
    readonly sort?: string;
    /**
    * An array of tags to filter by.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#tag_filters Dashboard#tag_filters}
    */
    readonly tagFilters?: string[];
    /**
    * The text to use as a filter.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#text_filter Dashboard#text_filter}
    */
    readonly textFilter?: string;
}
export declare function dashboardWidgetChangeDefinitionRequestQueryProcessQueryToTerraform(struct?: DashboardWidgetChangeDefinitionRequestQueryProcessQueryOutputReference | DashboardWidgetChangeDefinitionRequestQueryProcessQuery): any;
export declare class DashboardWidgetChangeDefinitionRequestQueryProcessQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetChangeDefinitionRequestQueryProcessQuery | undefined;
    set internalValue(value: DashboardWidgetChangeDefinitionRequestQueryProcessQuery | undefined);
    private _aggregator?;
    get aggregator(): string;
    set aggregator(value: string);
    resetAggregator(): void;
    get aggregatorInput(): string | undefined;
    private _dataSource?;
    get dataSource(): string;
    set dataSource(value: string);
    get dataSourceInput(): string | undefined;
    private _isNormalizedCpu?;
    get isNormalizedCpu(): boolean | cdktf.IResolvable;
    set isNormalizedCpu(value: boolean | cdktf.IResolvable);
    resetIsNormalizedCpu(): void;
    get isNormalizedCpuInput(): boolean | cdktf.IResolvable | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _metric?;
    get metric(): string;
    set metric(value: string);
    get metricInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _sort?;
    get sort(): string;
    set sort(value: string);
    resetSort(): void;
    get sortInput(): string | undefined;
    private _tagFilters?;
    get tagFilters(): string[];
    set tagFilters(value: string[]);
    resetTagFilters(): void;
    get tagFiltersInput(): string[] | undefined;
    private _textFilter?;
    get textFilter(): string;
    set textFilter(value: string);
    resetTextFilter(): void;
    get textFilterInput(): string | undefined;
}
export interface DashboardWidgetChangeDefinitionRequestQuery {
    /**
    * apm_dependency_stats_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_dependency_stats_query Dashboard#apm_dependency_stats_query}
    */
    readonly apmDependencyStatsQuery?: DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery;
    /**
    * apm_resource_stats_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_resource_stats_query Dashboard#apm_resource_stats_query}
    */
    readonly apmResourceStatsQuery?: DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQuery;
    /**
    * event_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#event_query Dashboard#event_query}
    */
    readonly eventQuery?: DashboardWidgetChangeDefinitionRequestQueryEventQuery;
    /**
    * metric_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric_query Dashboard#metric_query}
    */
    readonly metricQuery?: DashboardWidgetChangeDefinitionRequestQueryMetricQuery;
    /**
    * process_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#process_query Dashboard#process_query}
    */
    readonly processQuery?: DashboardWidgetChangeDefinitionRequestQueryProcessQuery;
}
export declare function dashboardWidgetChangeDefinitionRequestQueryToTerraform(struct?: DashboardWidgetChangeDefinitionRequestQuery | cdktf.IResolvable): any;
export declare class DashboardWidgetChangeDefinitionRequestQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetChangeDefinitionRequestQuery | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetChangeDefinitionRequestQuery | cdktf.IResolvable | undefined);
    private _apmDependencyStatsQuery;
    get apmDependencyStatsQuery(): DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQueryOutputReference;
    putApmDependencyStatsQuery(value: DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery): void;
    resetApmDependencyStatsQuery(): void;
    get apmDependencyStatsQueryInput(): DashboardWidgetChangeDefinitionRequestQueryApmDependencyStatsQuery | undefined;
    private _apmResourceStatsQuery;
    get apmResourceStatsQuery(): DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQueryOutputReference;
    putApmResourceStatsQuery(value: DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQuery): void;
    resetApmResourceStatsQuery(): void;
    get apmResourceStatsQueryInput(): DashboardWidgetChangeDefinitionRequestQueryApmResourceStatsQuery | undefined;
    private _eventQuery;
    get eventQuery(): DashboardWidgetChangeDefinitionRequestQueryEventQueryOutputReference;
    putEventQuery(value: DashboardWidgetChangeDefinitionRequestQueryEventQuery): void;
    resetEventQuery(): void;
    get eventQueryInput(): DashboardWidgetChangeDefinitionRequestQueryEventQuery | undefined;
    private _metricQuery;
    get metricQuery(): DashboardWidgetChangeDefinitionRequestQueryMetricQueryOutputReference;
    putMetricQuery(value: DashboardWidgetChangeDefinitionRequestQueryMetricQuery): void;
    resetMetricQuery(): void;
    get metricQueryInput(): DashboardWidgetChangeDefinitionRequestQueryMetricQuery | undefined;
    private _processQuery;
    get processQuery(): DashboardWidgetChangeDefinitionRequestQueryProcessQueryOutputReference;
    putProcessQuery(value: DashboardWidgetChangeDefinitionRequestQueryProcessQuery): void;
    resetProcessQuery(): void;
    get processQueryInput(): DashboardWidgetChangeDefinitionRequestQueryProcessQuery | undefined;
}
export declare class DashboardWidgetChangeDefinitionRequestQueryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetChangeDefinitionRequestQuery[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetChangeDefinitionRequestQueryOutputReference;
}
export interface DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetChangeDefinitionRequestRumQueryComputeQueryToTerraform(struct?: DashboardWidgetChangeDefinitionRequestRumQueryComputeQueryOutputReference | DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery): any;
export declare class DashboardWidgetChangeDefinitionRequestRumQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery | undefined;
    set internalValue(value: DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export interface DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Widget sorting methods. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
    */
    readonly order: string;
}
export declare function dashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQueryOutputReference | DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQuery): any;
export declare class DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQuery | undefined;
    set internalValue(value: DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    get orderInput(): string | undefined;
}
export interface DashboardWidgetChangeDefinitionRequestRumQueryGroupBy {
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * The maximum number of items in the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * sort_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
    */
    readonly sortQuery?: DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQuery;
}
export declare function dashboardWidgetChangeDefinitionRequestRumQueryGroupByToTerraform(struct?: DashboardWidgetChangeDefinitionRequestRumQueryGroupBy | cdktf.IResolvable): any;
export declare class DashboardWidgetChangeDefinitionRequestRumQueryGroupByOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetChangeDefinitionRequestRumQueryGroupBy | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetChangeDefinitionRequestRumQueryGroupBy | cdktf.IResolvable | undefined);
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _sortQuery;
    get sortQuery(): DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQueryOutputReference;
    putSortQuery(value: DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQuery): void;
    resetSortQuery(): void;
    get sortQueryInput(): DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQuery | undefined;
}
export declare class DashboardWidgetChangeDefinitionRequestRumQueryGroupByList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetChangeDefinitionRequestRumQueryGroupBy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetChangeDefinitionRequestRumQueryGroupByOutputReference;
}
export interface DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetChangeDefinitionRequestRumQueryMultiComputeToTerraform(struct?: DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute | cdktf.IResolvable): any;
export declare class DashboardWidgetChangeDefinitionRequestRumQueryMultiComputeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute | cdktf.IResolvable | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export declare class DashboardWidgetChangeDefinitionRequestRumQueryMultiComputeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetChangeDefinitionRequestRumQueryMultiComputeOutputReference;
}
export interface DashboardWidgetChangeDefinitionRequestRumQuery {
    /**
    * The name of the index to query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
    */
    readonly index: string;
    /**
    * The search query to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
    */
    readonly searchQuery?: string;
    /**
    * compute_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
    */
    readonly computeQuery?: DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery;
    /**
    * group_by block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
    */
    readonly groupBy?: DashboardWidgetChangeDefinitionRequestRumQueryGroupBy[] | cdktf.IResolvable;
    /**
    * multi_compute block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
    */
    readonly multiCompute?: DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetChangeDefinitionRequestRumQueryToTerraform(struct?: DashboardWidgetChangeDefinitionRequestRumQueryOutputReference | DashboardWidgetChangeDefinitionRequestRumQuery): any;
export declare class DashboardWidgetChangeDefinitionRequestRumQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetChangeDefinitionRequestRumQuery | undefined;
    set internalValue(value: DashboardWidgetChangeDefinitionRequestRumQuery | undefined);
    private _index?;
    get index(): string;
    set index(value: string);
    get indexInput(): string | undefined;
    private _searchQuery?;
    get searchQuery(): string;
    set searchQuery(value: string);
    resetSearchQuery(): void;
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    get computeQuery(): DashboardWidgetChangeDefinitionRequestRumQueryComputeQueryOutputReference;
    putComputeQuery(value: DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery): void;
    resetComputeQuery(): void;
    get computeQueryInput(): DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery | undefined;
    private _groupBy;
    get groupBy(): DashboardWidgetChangeDefinitionRequestRumQueryGroupByList;
    putGroupBy(value: DashboardWidgetChangeDefinitionRequestRumQueryGroupBy[] | cdktf.IResolvable): void;
    resetGroupBy(): void;
    get groupByInput(): cdktf.IResolvable | DashboardWidgetChangeDefinitionRequestRumQueryGroupBy[] | undefined;
    private _multiCompute;
    get multiCompute(): DashboardWidgetChangeDefinitionRequestRumQueryMultiComputeList;
    putMultiCompute(value: DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute[] | cdktf.IResolvable): void;
    resetMultiCompute(): void;
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute[] | undefined;
}
export interface DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetChangeDefinitionRequestSecurityQueryComputeQueryToTerraform(struct?: DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQueryOutputReference | DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery): any;
export declare class DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery | undefined;
    set internalValue(value: DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export interface DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Widget sorting methods. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
    */
    readonly order: string;
}
export declare function dashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQueryOutputReference | DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery): any;
export declare class DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery | undefined;
    set internalValue(value: DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    get orderInput(): string | undefined;
}
export interface DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy {
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * The maximum number of items in the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * sort_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
    */
    readonly sortQuery?: DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery;
}
export declare function dashboardWidgetChangeDefinitionRequestSecurityQueryGroupByToTerraform(struct?: DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy | cdktf.IResolvable): any;
export declare class DashboardWidgetChangeDefinitionRequestSecurityQueryGroupByOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy | cdktf.IResolvable | undefined);
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _sortQuery;
    get sortQuery(): DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQueryOutputReference;
    putSortQuery(value: DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery): void;
    resetSortQuery(): void;
    get sortQueryInput(): DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery | undefined;
}
export declare class DashboardWidgetChangeDefinitionRequestSecurityQueryGroupByList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetChangeDefinitionRequestSecurityQueryGroupByOutputReference;
}
export interface DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetChangeDefinitionRequestSecurityQueryMultiComputeToTerraform(struct?: DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute | cdktf.IResolvable): any;
export declare class DashboardWidgetChangeDefinitionRequestSecurityQueryMultiComputeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute | cdktf.IResolvable | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export declare class DashboardWidgetChangeDefinitionRequestSecurityQueryMultiComputeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetChangeDefinitionRequestSecurityQueryMultiComputeOutputReference;
}
export interface DashboardWidgetChangeDefinitionRequestSecurityQuery {
    /**
    * The name of the index to query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
    */
    readonly index: string;
    /**
    * The search query to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
    */
    readonly searchQuery?: string;
    /**
    * compute_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
    */
    readonly computeQuery?: DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery;
    /**
    * group_by block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
    */
    readonly groupBy?: DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy[] | cdktf.IResolvable;
    /**
    * multi_compute block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
    */
    readonly multiCompute?: DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetChangeDefinitionRequestSecurityQueryToTerraform(struct?: DashboardWidgetChangeDefinitionRequestSecurityQueryOutputReference | DashboardWidgetChangeDefinitionRequestSecurityQuery): any;
export declare class DashboardWidgetChangeDefinitionRequestSecurityQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetChangeDefinitionRequestSecurityQuery | undefined;
    set internalValue(value: DashboardWidgetChangeDefinitionRequestSecurityQuery | undefined);
    private _index?;
    get index(): string;
    set index(value: string);
    get indexInput(): string | undefined;
    private _searchQuery?;
    get searchQuery(): string;
    set searchQuery(value: string);
    resetSearchQuery(): void;
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    get computeQuery(): DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQueryOutputReference;
    putComputeQuery(value: DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery): void;
    resetComputeQuery(): void;
    get computeQueryInput(): DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery | undefined;
    private _groupBy;
    get groupBy(): DashboardWidgetChangeDefinitionRequestSecurityQueryGroupByList;
    putGroupBy(value: DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy[] | cdktf.IResolvable): void;
    resetGroupBy(): void;
    get groupByInput(): cdktf.IResolvable | DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy[] | undefined;
    private _multiCompute;
    get multiCompute(): DashboardWidgetChangeDefinitionRequestSecurityQueryMultiComputeList;
    putMultiCompute(value: DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute[] | cdktf.IResolvable): void;
    resetMultiCompute(): void;
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute[] | undefined;
}
export interface DashboardWidgetChangeDefinitionRequest {
    /**
    * Whether to show absolute or relative change. Valid values are `absolute`, `relative`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#change_type Dashboard#change_type}
    */
    readonly changeType?: string;
    /**
    * Choose from when to compare current data to. Valid values are `hour_before`, `day_before`, `week_before`, `month_before`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compare_to Dashboard#compare_to}
    */
    readonly compareTo?: string;
    /**
    * A Boolean indicating whether an increase in the value is good (displayed in green) or not (displayed in red).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#increase_good Dashboard#increase_good}
    */
    readonly increaseGood?: boolean | cdktf.IResolvable;
    /**
    * What to order by. Valid values are `change`, `name`, `present`, `past`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order_by Dashboard#order_by}
    */
    readonly orderBy?: string;
    /**
    * Widget sorting method. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order_dir Dashboard#order_dir}
    */
    readonly orderDir?: string;
    /**
    * The metric query to use for this widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#q Dashboard#q}
    */
    readonly q?: string;
    /**
    * If set to `true`, displays the current value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#show_present Dashboard#show_present}
    */
    readonly showPresent?: boolean | cdktf.IResolvable;
    /**
    * apm_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_query Dashboard#apm_query}
    */
    readonly apmQuery?: DashboardWidgetChangeDefinitionRequestApmQuery;
    /**
    * formula block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#formula Dashboard#formula}
    */
    readonly formula?: DashboardWidgetChangeDefinitionRequestFormula[] | cdktf.IResolvable;
    /**
    * log_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#log_query Dashboard#log_query}
    */
    readonly logQuery?: DashboardWidgetChangeDefinitionRequestLogQuery;
    /**
    * process_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#process_query Dashboard#process_query}
    */
    readonly processQuery?: DashboardWidgetChangeDefinitionRequestProcessQuery;
    /**
    * query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
    */
    readonly query?: DashboardWidgetChangeDefinitionRequestQuery[] | cdktf.IResolvable;
    /**
    * rum_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#rum_query Dashboard#rum_query}
    */
    readonly rumQuery?: DashboardWidgetChangeDefinitionRequestRumQuery;
    /**
    * security_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#security_query Dashboard#security_query}
    */
    readonly securityQuery?: DashboardWidgetChangeDefinitionRequestSecurityQuery;
}
export declare function dashboardWidgetChangeDefinitionRequestToTerraform(struct?: DashboardWidgetChangeDefinitionRequest | cdktf.IResolvable): any;
export declare class DashboardWidgetChangeDefinitionRequestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetChangeDefinitionRequest | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetChangeDefinitionRequest | cdktf.IResolvable | undefined);
    private _changeType?;
    get changeType(): string;
    set changeType(value: string);
    resetChangeType(): void;
    get changeTypeInput(): string | undefined;
    private _compareTo?;
    get compareTo(): string;
    set compareTo(value: string);
    resetCompareTo(): void;
    get compareToInput(): string | undefined;
    private _increaseGood?;
    get increaseGood(): boolean | cdktf.IResolvable;
    set increaseGood(value: boolean | cdktf.IResolvable);
    resetIncreaseGood(): void;
    get increaseGoodInput(): boolean | cdktf.IResolvable | undefined;
    private _orderBy?;
    get orderBy(): string;
    set orderBy(value: string);
    resetOrderBy(): void;
    get orderByInput(): string | undefined;
    private _orderDir?;
    get orderDir(): string;
    set orderDir(value: string);
    resetOrderDir(): void;
    get orderDirInput(): string | undefined;
    private _q?;
    get q(): string;
    set q(value: string);
    resetQ(): void;
    get qInput(): string | undefined;
    private _showPresent?;
    get showPresent(): boolean | cdktf.IResolvable;
    set showPresent(value: boolean | cdktf.IResolvable);
    resetShowPresent(): void;
    get showPresentInput(): boolean | cdktf.IResolvable | undefined;
    private _apmQuery;
    get apmQuery(): DashboardWidgetChangeDefinitionRequestApmQueryOutputReference;
    putApmQuery(value: DashboardWidgetChangeDefinitionRequestApmQuery): void;
    resetApmQuery(): void;
    get apmQueryInput(): DashboardWidgetChangeDefinitionRequestApmQuery | undefined;
    private _formula;
    get formula(): DashboardWidgetChangeDefinitionRequestFormulaList;
    putFormula(value: DashboardWidgetChangeDefinitionRequestFormula[] | cdktf.IResolvable): void;
    resetFormula(): void;
    get formulaInput(): cdktf.IResolvable | DashboardWidgetChangeDefinitionRequestFormula[] | undefined;
    private _logQuery;
    get logQuery(): DashboardWidgetChangeDefinitionRequestLogQueryOutputReference;
    putLogQuery(value: DashboardWidgetChangeDefinitionRequestLogQuery): void;
    resetLogQuery(): void;
    get logQueryInput(): DashboardWidgetChangeDefinitionRequestLogQuery | undefined;
    private _processQuery;
    get processQuery(): DashboardWidgetChangeDefinitionRequestProcessQueryOutputReference;
    putProcessQuery(value: DashboardWidgetChangeDefinitionRequestProcessQuery): void;
    resetProcessQuery(): void;
    get processQueryInput(): DashboardWidgetChangeDefinitionRequestProcessQuery | undefined;
    private _query;
    get query(): DashboardWidgetChangeDefinitionRequestQueryList;
    putQuery(value: DashboardWidgetChangeDefinitionRequestQuery[] | cdktf.IResolvable): void;
    resetQuery(): void;
    get queryInput(): cdktf.IResolvable | DashboardWidgetChangeDefinitionRequestQuery[] | undefined;
    private _rumQuery;
    get rumQuery(): DashboardWidgetChangeDefinitionRequestRumQueryOutputReference;
    putRumQuery(value: DashboardWidgetChangeDefinitionRequestRumQuery): void;
    resetRumQuery(): void;
    get rumQueryInput(): DashboardWidgetChangeDefinitionRequestRumQuery | undefined;
    private _securityQuery;
    get securityQuery(): DashboardWidgetChangeDefinitionRequestSecurityQueryOutputReference;
    putSecurityQuery(value: DashboardWidgetChangeDefinitionRequestSecurityQuery): void;
    resetSecurityQuery(): void;
    get securityQueryInput(): DashboardWidgetChangeDefinitionRequestSecurityQuery | undefined;
}
export declare class DashboardWidgetChangeDefinitionRequestList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetChangeDefinitionRequest[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetChangeDefinitionRequestOutputReference;
}
export interface DashboardWidgetChangeDefinition {
    /**
    * The timeframe to use when displaying the widget. Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
    */
    readonly liveSpan?: string;
    /**
    * The title of the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
    */
    readonly title?: string;
    /**
    * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
    */
    readonly titleAlign?: string;
    /**
    * The size of the widget's title (defaults to 16).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
    */
    readonly titleSize?: string;
    /**
    * custom_link block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_link Dashboard#custom_link}
    */
    readonly customLink?: DashboardWidgetChangeDefinitionCustomLink[] | cdktf.IResolvable;
    /**
    * request block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#request Dashboard#request}
    */
    readonly request?: DashboardWidgetChangeDefinitionRequest[] | cdktf.IResolvable;
}
export declare function dashboardWidgetChangeDefinitionToTerraform(struct?: DashboardWidgetChangeDefinitionOutputReference | DashboardWidgetChangeDefinition): any;
export declare class DashboardWidgetChangeDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetChangeDefinition | undefined;
    set internalValue(value: DashboardWidgetChangeDefinition | undefined);
    private _liveSpan?;
    get liveSpan(): string;
    set liveSpan(value: string);
    resetLiveSpan(): void;
    get liveSpanInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
    private _titleAlign?;
    get titleAlign(): string;
    set titleAlign(value: string);
    resetTitleAlign(): void;
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    get titleSize(): string;
    set titleSize(value: string);
    resetTitleSize(): void;
    get titleSizeInput(): string | undefined;
    private _customLink;
    get customLink(): DashboardWidgetChangeDefinitionCustomLinkList;
    putCustomLink(value: DashboardWidgetChangeDefinitionCustomLink[] | cdktf.IResolvable): void;
    resetCustomLink(): void;
    get customLinkInput(): cdktf.IResolvable | DashboardWidgetChangeDefinitionCustomLink[] | undefined;
    private _request;
    get request(): DashboardWidgetChangeDefinitionRequestList;
    putRequest(value: DashboardWidgetChangeDefinitionRequest[] | cdktf.IResolvable): void;
    resetRequest(): void;
    get requestInput(): cdktf.IResolvable | DashboardWidgetChangeDefinitionRequest[] | undefined;
}
export interface DashboardWidgetCheckStatusDefinition {
    /**
    * The check to use in the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#check Dashboard#check}
    */
    readonly check: string;
    /**
    * The check group to use in the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group Dashboard#group}
    */
    readonly group?: string;
    /**
    * When `grouping = "cluster"`, indicates a list of tags to use for grouping.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
    */
    readonly groupBy?: string[];
    /**
    * The kind of grouping to use. Valid values are `check`, `cluster`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#grouping Dashboard#grouping}
    */
    readonly grouping: string;
    /**
    * The timeframe to use when displaying the widget. Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
    */
    readonly liveSpan?: string;
    /**
    * A list of tags to use in the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#tags Dashboard#tags}
    */
    readonly tags?: string[];
    /**
    * The title of the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
    */
    readonly title?: string;
    /**
    * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
    */
    readonly titleAlign?: string;
    /**
    * The size of the widget's title (defaults to 16).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
    */
    readonly titleSize?: string;
}
export declare function dashboardWidgetCheckStatusDefinitionToTerraform(struct?: DashboardWidgetCheckStatusDefinitionOutputReference | DashboardWidgetCheckStatusDefinition): any;
export declare class DashboardWidgetCheckStatusDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetCheckStatusDefinition | undefined;
    set internalValue(value: DashboardWidgetCheckStatusDefinition | undefined);
    private _check?;
    get check(): string;
    set check(value: string);
    get checkInput(): string | undefined;
    private _group?;
    get group(): string;
    set group(value: string);
    resetGroup(): void;
    get groupInput(): string | undefined;
    private _groupBy?;
    get groupBy(): string[];
    set groupBy(value: string[]);
    resetGroupBy(): void;
    get groupByInput(): string[] | undefined;
    private _grouping?;
    get grouping(): string;
    set grouping(value: string);
    get groupingInput(): string | undefined;
    private _liveSpan?;
    get liveSpan(): string;
    set liveSpan(value: string);
    resetLiveSpan(): void;
    get liveSpanInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
    private _titleAlign?;
    get titleAlign(): string;
    set titleAlign(value: string);
    resetTitleAlign(): void;
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    get titleSize(): string;
    set titleSize(value: string);
    resetTitleSize(): void;
    get titleSizeInput(): string | undefined;
}
export interface DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetDistributionDefinitionRequestApmQueryComputeQueryToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestApmQueryComputeQueryOutputReference | DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery): any;
export declare class DashboardWidgetDistributionDefinitionRequestApmQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery | undefined;
    set internalValue(value: DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export interface DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Widget sorting methods. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
    */
    readonly order: string;
}
export declare function dashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQueryOutputReference | DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery): any;
export declare class DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery | undefined;
    set internalValue(value: DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    get orderInput(): string | undefined;
}
export interface DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy {
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * The maximum number of items in the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * sort_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
    */
    readonly sortQuery?: DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery;
}
export declare function dashboardWidgetDistributionDefinitionRequestApmQueryGroupByToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy | cdktf.IResolvable): any;
export declare class DashboardWidgetDistributionDefinitionRequestApmQueryGroupByOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy | cdktf.IResolvable | undefined);
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _sortQuery;
    get sortQuery(): DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQueryOutputReference;
    putSortQuery(value: DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery): void;
    resetSortQuery(): void;
    get sortQueryInput(): DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery | undefined;
}
export declare class DashboardWidgetDistributionDefinitionRequestApmQueryGroupByList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetDistributionDefinitionRequestApmQueryGroupByOutputReference;
}
export interface DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetDistributionDefinitionRequestApmQueryMultiComputeToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute | cdktf.IResolvable): any;
export declare class DashboardWidgetDistributionDefinitionRequestApmQueryMultiComputeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute | cdktf.IResolvable | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export declare class DashboardWidgetDistributionDefinitionRequestApmQueryMultiComputeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetDistributionDefinitionRequestApmQueryMultiComputeOutputReference;
}
export interface DashboardWidgetDistributionDefinitionRequestApmQuery {
    /**
    * The name of the index to query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
    */
    readonly index: string;
    /**
    * The search query to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
    */
    readonly searchQuery?: string;
    /**
    * compute_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
    */
    readonly computeQuery?: DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery;
    /**
    * group_by block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
    */
    readonly groupBy?: DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy[] | cdktf.IResolvable;
    /**
    * multi_compute block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
    */
    readonly multiCompute?: DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetDistributionDefinitionRequestApmQueryToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestApmQueryOutputReference | DashboardWidgetDistributionDefinitionRequestApmQuery): any;
export declare class DashboardWidgetDistributionDefinitionRequestApmQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetDistributionDefinitionRequestApmQuery | undefined;
    set internalValue(value: DashboardWidgetDistributionDefinitionRequestApmQuery | undefined);
    private _index?;
    get index(): string;
    set index(value: string);
    get indexInput(): string | undefined;
    private _searchQuery?;
    get searchQuery(): string;
    set searchQuery(value: string);
    resetSearchQuery(): void;
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    get computeQuery(): DashboardWidgetDistributionDefinitionRequestApmQueryComputeQueryOutputReference;
    putComputeQuery(value: DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery): void;
    resetComputeQuery(): void;
    get computeQueryInput(): DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery | undefined;
    private _groupBy;
    get groupBy(): DashboardWidgetDistributionDefinitionRequestApmQueryGroupByList;
    putGroupBy(value: DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy[] | cdktf.IResolvable): void;
    resetGroupBy(): void;
    get groupByInput(): cdktf.IResolvable | DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy[] | undefined;
    private _multiCompute;
    get multiCompute(): DashboardWidgetDistributionDefinitionRequestApmQueryMultiComputeList;
    putMultiCompute(value: DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute[] | cdktf.IResolvable): void;
    resetMultiCompute(): void;
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute[] | undefined;
}
export interface DashboardWidgetDistributionDefinitionRequestApmStatsQueryColumns {
    /**
    * A user-assigned alias for the column.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alias Dashboard#alias}
    */
    readonly alias?: string;
    /**
    * A list of display modes for each table cell. Valid values are `number`, `bar`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#cell_display_mode Dashboard#cell_display_mode}
    */
    readonly cellDisplayMode?: string;
    /**
    * The column name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
    */
    readonly name: string;
    /**
    * Widget sorting methods. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
    */
    readonly order?: string;
}
export declare function dashboardWidgetDistributionDefinitionRequestApmStatsQueryColumnsToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestApmStatsQueryColumns | cdktf.IResolvable): any;
export declare class DashboardWidgetDistributionDefinitionRequestApmStatsQueryColumnsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetDistributionDefinitionRequestApmStatsQueryColumns | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetDistributionDefinitionRequestApmStatsQueryColumns | cdktf.IResolvable | undefined);
    private _alias?;
    get alias(): string;
    set alias(value: string);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    private _cellDisplayMode?;
    get cellDisplayMode(): string;
    set cellDisplayMode(value: string);
    resetCellDisplayMode(): void;
    get cellDisplayModeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    resetOrder(): void;
    get orderInput(): string | undefined;
}
export declare class DashboardWidgetDistributionDefinitionRequestApmStatsQueryColumnsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetDistributionDefinitionRequestApmStatsQueryColumns[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetDistributionDefinitionRequestApmStatsQueryColumnsOutputReference;
}
export interface DashboardWidgetDistributionDefinitionRequestApmStatsQuery {
    /**
    * The environment name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#env Dashboard#env}
    */
    readonly env: string;
    /**
    * The operation name associated with the service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
    */
    readonly name: string;
    /**
    * The organization's host group name and value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag Dashboard#primary_tag}
    */
    readonly primaryTag: string;
    /**
    * The resource name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#resource Dashboard#resource}
    */
    readonly resource?: string;
    /**
    * The level of detail for the request. Valid values are `service`, `resource`, `span`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#row_type Dashboard#row_type}
    */
    readonly rowType: string;
    /**
    * The service name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service Dashboard#service}
    */
    readonly service: string;
    /**
    * columns block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#columns Dashboard#columns}
    */
    readonly columns?: DashboardWidgetDistributionDefinitionRequestApmStatsQueryColumns[] | cdktf.IResolvable;
}
export declare function dashboardWidgetDistributionDefinitionRequestApmStatsQueryToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestApmStatsQueryOutputReference | DashboardWidgetDistributionDefinitionRequestApmStatsQuery): any;
export declare class DashboardWidgetDistributionDefinitionRequestApmStatsQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetDistributionDefinitionRequestApmStatsQuery | undefined;
    set internalValue(value: DashboardWidgetDistributionDefinitionRequestApmStatsQuery | undefined);
    private _env?;
    get env(): string;
    set env(value: string);
    get envInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _primaryTag?;
    get primaryTag(): string;
    set primaryTag(value: string);
    get primaryTagInput(): string | undefined;
    private _resource?;
    get resource(): string;
    set resource(value: string);
    resetResource(): void;
    get resourceInput(): string | undefined;
    private _rowType?;
    get rowType(): string;
    set rowType(value: string);
    get rowTypeInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _columns;
    get columns(): DashboardWidgetDistributionDefinitionRequestApmStatsQueryColumnsList;
    putColumns(value: DashboardWidgetDistributionDefinitionRequestApmStatsQueryColumns[] | cdktf.IResolvable): void;
    resetColumns(): void;
    get columnsInput(): cdktf.IResolvable | DashboardWidgetDistributionDefinitionRequestApmStatsQueryColumns[] | undefined;
}
export interface DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetDistributionDefinitionRequestLogQueryComputeQueryToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestLogQueryComputeQueryOutputReference | DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery): any;
export declare class DashboardWidgetDistributionDefinitionRequestLogQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery | undefined;
    set internalValue(value: DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export interface DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Widget sorting methods. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
    */
    readonly order: string;
}
export declare function dashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQueryOutputReference | DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery): any;
export declare class DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery | undefined;
    set internalValue(value: DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    get orderInput(): string | undefined;
}
export interface DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy {
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * The maximum number of items in the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * sort_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
    */
    readonly sortQuery?: DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery;
}
export declare function dashboardWidgetDistributionDefinitionRequestLogQueryGroupByToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy | cdktf.IResolvable): any;
export declare class DashboardWidgetDistributionDefinitionRequestLogQueryGroupByOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy | cdktf.IResolvable | undefined);
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _sortQuery;
    get sortQuery(): DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQueryOutputReference;
    putSortQuery(value: DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery): void;
    resetSortQuery(): void;
    get sortQueryInput(): DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery | undefined;
}
export declare class DashboardWidgetDistributionDefinitionRequestLogQueryGroupByList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetDistributionDefinitionRequestLogQueryGroupByOutputReference;
}
export interface DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetDistributionDefinitionRequestLogQueryMultiComputeToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute | cdktf.IResolvable): any;
export declare class DashboardWidgetDistributionDefinitionRequestLogQueryMultiComputeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute | cdktf.IResolvable | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export declare class DashboardWidgetDistributionDefinitionRequestLogQueryMultiComputeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetDistributionDefinitionRequestLogQueryMultiComputeOutputReference;
}
export interface DashboardWidgetDistributionDefinitionRequestLogQuery {
    /**
    * The name of the index to query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
    */
    readonly index: string;
    /**
    * The search query to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
    */
    readonly searchQuery?: string;
    /**
    * compute_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
    */
    readonly computeQuery?: DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery;
    /**
    * group_by block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
    */
    readonly groupBy?: DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable;
    /**
    * multi_compute block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
    */
    readonly multiCompute?: DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetDistributionDefinitionRequestLogQueryToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestLogQueryOutputReference | DashboardWidgetDistributionDefinitionRequestLogQuery): any;
export declare class DashboardWidgetDistributionDefinitionRequestLogQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetDistributionDefinitionRequestLogQuery | undefined;
    set internalValue(value: DashboardWidgetDistributionDefinitionRequestLogQuery | undefined);
    private _index?;
    get index(): string;
    set index(value: string);
    get indexInput(): string | undefined;
    private _searchQuery?;
    get searchQuery(): string;
    set searchQuery(value: string);
    resetSearchQuery(): void;
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    get computeQuery(): DashboardWidgetDistributionDefinitionRequestLogQueryComputeQueryOutputReference;
    putComputeQuery(value: DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery): void;
    resetComputeQuery(): void;
    get computeQueryInput(): DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery | undefined;
    private _groupBy;
    get groupBy(): DashboardWidgetDistributionDefinitionRequestLogQueryGroupByList;
    putGroupBy(value: DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable): void;
    resetGroupBy(): void;
    get groupByInput(): cdktf.IResolvable | DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy[] | undefined;
    private _multiCompute;
    get multiCompute(): DashboardWidgetDistributionDefinitionRequestLogQueryMultiComputeList;
    putMultiCompute(value: DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable): void;
    resetMultiCompute(): void;
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute[] | undefined;
}
export interface DashboardWidgetDistributionDefinitionRequestProcessQuery {
    /**
    * A list of processes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#filter_by Dashboard#filter_by}
    */
    readonly filterBy?: string[];
    /**
    * The max number of items in the filter list.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * Your chosen metric.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
    */
    readonly metric: string;
    /**
    * Your chosen search term.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_by Dashboard#search_by}
    */
    readonly searchBy?: string;
}
export declare function dashboardWidgetDistributionDefinitionRequestProcessQueryToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestProcessQueryOutputReference | DashboardWidgetDistributionDefinitionRequestProcessQuery): any;
export declare class DashboardWidgetDistributionDefinitionRequestProcessQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetDistributionDefinitionRequestProcessQuery | undefined;
    set internalValue(value: DashboardWidgetDistributionDefinitionRequestProcessQuery | undefined);
    private _filterBy?;
    get filterBy(): string[];
    set filterBy(value: string[]);
    resetFilterBy(): void;
    get filterByInput(): string[] | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _metric?;
    get metric(): string;
    set metric(value: string);
    get metricInput(): string | undefined;
    private _searchBy?;
    get searchBy(): string;
    set searchBy(value: string);
    resetSearchBy(): void;
    get searchByInput(): string | undefined;
}
export interface DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetDistributionDefinitionRequestRumQueryComputeQueryToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestRumQueryComputeQueryOutputReference | DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery): any;
export declare class DashboardWidgetDistributionDefinitionRequestRumQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery | undefined;
    set internalValue(value: DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export interface DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Widget sorting methods. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
    */
    readonly order: string;
}
export declare function dashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQueryOutputReference | DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery): any;
export declare class DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery | undefined;
    set internalValue(value: DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    get orderInput(): string | undefined;
}
export interface DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy {
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * The maximum number of items in the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * sort_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
    */
    readonly sortQuery?: DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery;
}
export declare function dashboardWidgetDistributionDefinitionRequestRumQueryGroupByToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy | cdktf.IResolvable): any;
export declare class DashboardWidgetDistributionDefinitionRequestRumQueryGroupByOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy | cdktf.IResolvable | undefined);
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _sortQuery;
    get sortQuery(): DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQueryOutputReference;
    putSortQuery(value: DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery): void;
    resetSortQuery(): void;
    get sortQueryInput(): DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery | undefined;
}
export declare class DashboardWidgetDistributionDefinitionRequestRumQueryGroupByList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetDistributionDefinitionRequestRumQueryGroupByOutputReference;
}
export interface DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetDistributionDefinitionRequestRumQueryMultiComputeToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute | cdktf.IResolvable): any;
export declare class DashboardWidgetDistributionDefinitionRequestRumQueryMultiComputeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute | cdktf.IResolvable | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export declare class DashboardWidgetDistributionDefinitionRequestRumQueryMultiComputeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetDistributionDefinitionRequestRumQueryMultiComputeOutputReference;
}
export interface DashboardWidgetDistributionDefinitionRequestRumQuery {
    /**
    * The name of the index to query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
    */
    readonly index: string;
    /**
    * The search query to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
    */
    readonly searchQuery?: string;
    /**
    * compute_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
    */
    readonly computeQuery?: DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery;
    /**
    * group_by block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
    */
    readonly groupBy?: DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy[] | cdktf.IResolvable;
    /**
    * multi_compute block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
    */
    readonly multiCompute?: DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetDistributionDefinitionRequestRumQueryToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestRumQueryOutputReference | DashboardWidgetDistributionDefinitionRequestRumQuery): any;
export declare class DashboardWidgetDistributionDefinitionRequestRumQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetDistributionDefinitionRequestRumQuery | undefined;
    set internalValue(value: DashboardWidgetDistributionDefinitionRequestRumQuery | undefined);
    private _index?;
    get index(): string;
    set index(value: string);
    get indexInput(): string | undefined;
    private _searchQuery?;
    get searchQuery(): string;
    set searchQuery(value: string);
    resetSearchQuery(): void;
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    get computeQuery(): DashboardWidgetDistributionDefinitionRequestRumQueryComputeQueryOutputReference;
    putComputeQuery(value: DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery): void;
    resetComputeQuery(): void;
    get computeQueryInput(): DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery | undefined;
    private _groupBy;
    get groupBy(): DashboardWidgetDistributionDefinitionRequestRumQueryGroupByList;
    putGroupBy(value: DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy[] | cdktf.IResolvable): void;
    resetGroupBy(): void;
    get groupByInput(): cdktf.IResolvable | DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy[] | undefined;
    private _multiCompute;
    get multiCompute(): DashboardWidgetDistributionDefinitionRequestRumQueryMultiComputeList;
    putMultiCompute(value: DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute[] | cdktf.IResolvable): void;
    resetMultiCompute(): void;
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute[] | undefined;
}
export interface DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQueryToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQueryOutputReference | DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQuery): any;
export declare class DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQuery | undefined;
    set internalValue(value: DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export interface DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Widget sorting methods. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
    */
    readonly order: string;
}
export declare function dashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQueryOutputReference | DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQuery): any;
export declare class DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQuery | undefined;
    set internalValue(value: DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    get orderInput(): string | undefined;
}
export interface DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBy {
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * The maximum number of items in the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * sort_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
    */
    readonly sortQuery?: DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQuery;
}
export declare function dashboardWidgetDistributionDefinitionRequestSecurityQueryGroupByToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBy | cdktf.IResolvable): any;
export declare class DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupByOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBy | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBy | cdktf.IResolvable | undefined);
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _sortQuery;
    get sortQuery(): DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQueryOutputReference;
    putSortQuery(value: DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQuery): void;
    resetSortQuery(): void;
    get sortQueryInput(): DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQuery | undefined;
}
export declare class DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupByList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupByOutputReference;
}
export interface DashboardWidgetDistributionDefinitionRequestSecurityQueryMultiCompute {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetDistributionDefinitionRequestSecurityQueryMultiComputeToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestSecurityQueryMultiCompute | cdktf.IResolvable): any;
export declare class DashboardWidgetDistributionDefinitionRequestSecurityQueryMultiComputeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetDistributionDefinitionRequestSecurityQueryMultiCompute | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetDistributionDefinitionRequestSecurityQueryMultiCompute | cdktf.IResolvable | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export declare class DashboardWidgetDistributionDefinitionRequestSecurityQueryMultiComputeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetDistributionDefinitionRequestSecurityQueryMultiCompute[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetDistributionDefinitionRequestSecurityQueryMultiComputeOutputReference;
}
export interface DashboardWidgetDistributionDefinitionRequestSecurityQuery {
    /**
    * The name of the index to query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
    */
    readonly index: string;
    /**
    * The search query to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
    */
    readonly searchQuery?: string;
    /**
    * compute_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
    */
    readonly computeQuery?: DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQuery;
    /**
    * group_by block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
    */
    readonly groupBy?: DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBy[] | cdktf.IResolvable;
    /**
    * multi_compute block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
    */
    readonly multiCompute?: DashboardWidgetDistributionDefinitionRequestSecurityQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetDistributionDefinitionRequestSecurityQueryToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestSecurityQueryOutputReference | DashboardWidgetDistributionDefinitionRequestSecurityQuery): any;
export declare class DashboardWidgetDistributionDefinitionRequestSecurityQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetDistributionDefinitionRequestSecurityQuery | undefined;
    set internalValue(value: DashboardWidgetDistributionDefinitionRequestSecurityQuery | undefined);
    private _index?;
    get index(): string;
    set index(value: string);
    get indexInput(): string | undefined;
    private _searchQuery?;
    get searchQuery(): string;
    set searchQuery(value: string);
    resetSearchQuery(): void;
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    get computeQuery(): DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQueryOutputReference;
    putComputeQuery(value: DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQuery): void;
    resetComputeQuery(): void;
    get computeQueryInput(): DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQuery | undefined;
    private _groupBy;
    get groupBy(): DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupByList;
    putGroupBy(value: DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBy[] | cdktf.IResolvable): void;
    resetGroupBy(): void;
    get groupByInput(): cdktf.IResolvable | DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBy[] | undefined;
    private _multiCompute;
    get multiCompute(): DashboardWidgetDistributionDefinitionRequestSecurityQueryMultiComputeList;
    putMultiCompute(value: DashboardWidgetDistributionDefinitionRequestSecurityQueryMultiCompute[] | cdktf.IResolvable): void;
    resetMultiCompute(): void;
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetDistributionDefinitionRequestSecurityQueryMultiCompute[] | undefined;
}
export interface DashboardWidgetDistributionDefinitionRequestStyle {
    /**
    * A color palette to apply to the widget. The available options are available at: https://docs.datadoghq.com/dashboards/widgets/timeseries/#appearance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
    */
    readonly palette?: string;
}
export declare function dashboardWidgetDistributionDefinitionRequestStyleToTerraform(struct?: DashboardWidgetDistributionDefinitionRequestStyleOutputReference | DashboardWidgetDistributionDefinitionRequestStyle): any;
export declare class DashboardWidgetDistributionDefinitionRequestStyleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetDistributionDefinitionRequestStyle | undefined;
    set internalValue(value: DashboardWidgetDistributionDefinitionRequestStyle | undefined);
    private _palette?;
    get palette(): string;
    set palette(value: string);
    resetPalette(): void;
    get paletteInput(): string | undefined;
}
export interface DashboardWidgetDistributionDefinitionRequest {
    /**
    * The metric query to use for this widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#q Dashboard#q}
    */
    readonly q?: string;
    /**
    * apm_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_query Dashboard#apm_query}
    */
    readonly apmQuery?: DashboardWidgetDistributionDefinitionRequestApmQuery;
    /**
    * apm_stats_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_stats_query Dashboard#apm_stats_query}
    */
    readonly apmStatsQuery?: DashboardWidgetDistributionDefinitionRequestApmStatsQuery;
    /**
    * log_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#log_query Dashboard#log_query}
    */
    readonly logQuery?: DashboardWidgetDistributionDefinitionRequestLogQuery;
    /**
    * process_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#process_query Dashboard#process_query}
    */
    readonly processQuery?: DashboardWidgetDistributionDefinitionRequestProcessQuery;
    /**
    * rum_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#rum_query Dashboard#rum_query}
    */
    readonly rumQuery?: DashboardWidgetDistributionDefinitionRequestRumQuery;
    /**
    * security_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#security_query Dashboard#security_query}
    */
    readonly securityQuery?: DashboardWidgetDistributionDefinitionRequestSecurityQuery;
    /**
    * style block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#style Dashboard#style}
    */
    readonly style?: DashboardWidgetDistributionDefinitionRequestStyle;
}
export declare function dashboardWidgetDistributionDefinitionRequestToTerraform(struct?: DashboardWidgetDistributionDefinitionRequest | cdktf.IResolvable): any;
export declare class DashboardWidgetDistributionDefinitionRequestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetDistributionDefinitionRequest | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetDistributionDefinitionRequest | cdktf.IResolvable | undefined);
    private _q?;
    get q(): string;
    set q(value: string);
    resetQ(): void;
    get qInput(): string | undefined;
    private _apmQuery;
    get apmQuery(): DashboardWidgetDistributionDefinitionRequestApmQueryOutputReference;
    putApmQuery(value: DashboardWidgetDistributionDefinitionRequestApmQuery): void;
    resetApmQuery(): void;
    get apmQueryInput(): DashboardWidgetDistributionDefinitionRequestApmQuery | undefined;
    private _apmStatsQuery;
    get apmStatsQuery(): DashboardWidgetDistributionDefinitionRequestApmStatsQueryOutputReference;
    putApmStatsQuery(value: DashboardWidgetDistributionDefinitionRequestApmStatsQuery): void;
    resetApmStatsQuery(): void;
    get apmStatsQueryInput(): DashboardWidgetDistributionDefinitionRequestApmStatsQuery | undefined;
    private _logQuery;
    get logQuery(): DashboardWidgetDistributionDefinitionRequestLogQueryOutputReference;
    putLogQuery(value: DashboardWidgetDistributionDefinitionRequestLogQuery): void;
    resetLogQuery(): void;
    get logQueryInput(): DashboardWidgetDistributionDefinitionRequestLogQuery | undefined;
    private _processQuery;
    get processQuery(): DashboardWidgetDistributionDefinitionRequestProcessQueryOutputReference;
    putProcessQuery(value: DashboardWidgetDistributionDefinitionRequestProcessQuery): void;
    resetProcessQuery(): void;
    get processQueryInput(): DashboardWidgetDistributionDefinitionRequestProcessQuery | undefined;
    private _rumQuery;
    get rumQuery(): DashboardWidgetDistributionDefinitionRequestRumQueryOutputReference;
    putRumQuery(value: DashboardWidgetDistributionDefinitionRequestRumQuery): void;
    resetRumQuery(): void;
    get rumQueryInput(): DashboardWidgetDistributionDefinitionRequestRumQuery | undefined;
    private _securityQuery;
    get securityQuery(): DashboardWidgetDistributionDefinitionRequestSecurityQueryOutputReference;
    putSecurityQuery(value: DashboardWidgetDistributionDefinitionRequestSecurityQuery): void;
    resetSecurityQuery(): void;
    get securityQueryInput(): DashboardWidgetDistributionDefinitionRequestSecurityQuery | undefined;
    private _style;
    get style(): DashboardWidgetDistributionDefinitionRequestStyleOutputReference;
    putStyle(value: DashboardWidgetDistributionDefinitionRequestStyle): void;
    resetStyle(): void;
    get styleInput(): DashboardWidgetDistributionDefinitionRequestStyle | undefined;
}
export declare class DashboardWidgetDistributionDefinitionRequestList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetDistributionDefinitionRequest[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetDistributionDefinitionRequestOutputReference;
}
export interface DashboardWidgetDistributionDefinition {
    /**
    * The size of the legend displayed in the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#legend_size Dashboard#legend_size}
    */
    readonly legendSize?: string;
    /**
    * The timeframe to use when displaying the widget. Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
    */
    readonly liveSpan?: string;
    /**
    * Whether or not to show the legend on this widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#show_legend Dashboard#show_legend}
    */
    readonly showLegend?: boolean | cdktf.IResolvable;
    /**
    * The title of the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
    */
    readonly title?: string;
    /**
    * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
    */
    readonly titleAlign?: string;
    /**
    * The size of the widget's title (defaults to 16).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
    */
    readonly titleSize?: string;
    /**
    * request block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#request Dashboard#request}
    */
    readonly request?: DashboardWidgetDistributionDefinitionRequest[] | cdktf.IResolvable;
}
export declare function dashboardWidgetDistributionDefinitionToTerraform(struct?: DashboardWidgetDistributionDefinitionOutputReference | DashboardWidgetDistributionDefinition): any;
export declare class DashboardWidgetDistributionDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetDistributionDefinition | undefined;
    set internalValue(value: DashboardWidgetDistributionDefinition | undefined);
    private _legendSize?;
    get legendSize(): string;
    set legendSize(value: string);
    resetLegendSize(): void;
    get legendSizeInput(): string | undefined;
    private _liveSpan?;
    get liveSpan(): string;
    set liveSpan(value: string);
    resetLiveSpan(): void;
    get liveSpanInput(): string | undefined;
    private _showLegend?;
    get showLegend(): boolean | cdktf.IResolvable;
    set showLegend(value: boolean | cdktf.IResolvable);
    resetShowLegend(): void;
    get showLegendInput(): boolean | cdktf.IResolvable | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
    private _titleAlign?;
    get titleAlign(): string;
    set titleAlign(value: string);
    resetTitleAlign(): void;
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    get titleSize(): string;
    set titleSize(value: string);
    resetTitleSize(): void;
    get titleSizeInput(): string | undefined;
    private _request;
    get request(): DashboardWidgetDistributionDefinitionRequestList;
    putRequest(value: DashboardWidgetDistributionDefinitionRequest[] | cdktf.IResolvable): void;
    resetRequest(): void;
    get requestInput(): cdktf.IResolvable | DashboardWidgetDistributionDefinitionRequest[] | undefined;
}
export interface DashboardWidgetEventStreamDefinition {
    /**
    * The size to use to display an event. Valid values are `s`, `l`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#event_size Dashboard#event_size}
    */
    readonly eventSize?: string;
    /**
    * The timeframe to use when displaying the widget. Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
    */
    readonly liveSpan?: string;
    /**
    * The query to use in the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
    */
    readonly query: string;
    /**
    * The execution method for multi-value filters, options: `and` or `or`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#tags_execution Dashboard#tags_execution}
    */
    readonly tagsExecution?: string;
    /**
    * The title of the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
    */
    readonly title?: string;
    /**
    * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
    */
    readonly titleAlign?: string;
    /**
    * The size of the widget's title (defaults to 16).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
    */
    readonly titleSize?: string;
}
export declare function dashboardWidgetEventStreamDefinitionToTerraform(struct?: DashboardWidgetEventStreamDefinitionOutputReference | DashboardWidgetEventStreamDefinition): any;
export declare class DashboardWidgetEventStreamDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetEventStreamDefinition | undefined;
    set internalValue(value: DashboardWidgetEventStreamDefinition | undefined);
    private _eventSize?;
    get eventSize(): string;
    set eventSize(value: string);
    resetEventSize(): void;
    get eventSizeInput(): string | undefined;
    private _liveSpan?;
    get liveSpan(): string;
    set liveSpan(value: string);
    resetLiveSpan(): void;
    get liveSpanInput(): string | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
    private _tagsExecution?;
    get tagsExecution(): string;
    set tagsExecution(value: string);
    resetTagsExecution(): void;
    get tagsExecutionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
    private _titleAlign?;
    get titleAlign(): string;
    set titleAlign(value: string);
    resetTitleAlign(): void;
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    get titleSize(): string;
    set titleSize(value: string);
    resetTitleSize(): void;
    get titleSizeInput(): string | undefined;
}
export interface DashboardWidgetEventTimelineDefinition {
    /**
    * The timeframe to use when displaying the widget. Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
    */
    readonly liveSpan?: string;
    /**
    * The query to use in the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
    */
    readonly query: string;
    /**
    * The execution method for multi-value filters, options: `and` or `or`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#tags_execution Dashboard#tags_execution}
    */
    readonly tagsExecution?: string;
    /**
    * The title of the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
    */
    readonly title?: string;
    /**
    * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
    */
    readonly titleAlign?: string;
    /**
    * The size of the widget's title (defaults to 16).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
    */
    readonly titleSize?: string;
}
export declare function dashboardWidgetEventTimelineDefinitionToTerraform(struct?: DashboardWidgetEventTimelineDefinitionOutputReference | DashboardWidgetEventTimelineDefinition): any;
export declare class DashboardWidgetEventTimelineDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetEventTimelineDefinition | undefined;
    set internalValue(value: DashboardWidgetEventTimelineDefinition | undefined);
    private _liveSpan?;
    get liveSpan(): string;
    set liveSpan(value: string);
    resetLiveSpan(): void;
    get liveSpanInput(): string | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
    private _tagsExecution?;
    get tagsExecution(): string;
    set tagsExecution(value: string);
    resetTagsExecution(): void;
    get tagsExecutionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
    private _titleAlign?;
    get titleAlign(): string;
    set titleAlign(value: string);
    resetTitleAlign(): void;
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    get titleSize(): string;
    set titleSize(value: string);
    resetTitleSize(): void;
    get titleSizeInput(): string | undefined;
}
export interface DashboardWidgetFreeTextDefinition {
    /**
    * The color of the text in the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#color Dashboard#color}
    */
    readonly color?: string;
    /**
    * The size of the text in the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#font_size Dashboard#font_size}
    */
    readonly fontSize?: string;
    /**
    * The text to display in the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#text Dashboard#text}
    */
    readonly text: string;
    /**
    * The alignment of the text in the widget. Valid values are `center`, `left`, `right`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#text_align Dashboard#text_align}
    */
    readonly textAlign?: string;
}
export declare function dashboardWidgetFreeTextDefinitionToTerraform(struct?: DashboardWidgetFreeTextDefinitionOutputReference | DashboardWidgetFreeTextDefinition): any;
export declare class DashboardWidgetFreeTextDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetFreeTextDefinition | undefined;
    set internalValue(value: DashboardWidgetFreeTextDefinition | undefined);
    private _color?;
    get color(): string;
    set color(value: string);
    resetColor(): void;
    get colorInput(): string | undefined;
    private _fontSize?;
    get fontSize(): string;
    set fontSize(value: string);
    resetFontSize(): void;
    get fontSizeInput(): string | undefined;
    private _text?;
    get text(): string;
    set text(value: string);
    get textInput(): string | undefined;
    private _textAlign?;
    get textAlign(): string;
    set textAlign(value: string);
    resetTextAlign(): void;
    get textAlignInput(): string | undefined;
}
export interface DashboardWidgetGeomapDefinitionCustomLink {
    /**
    * The flag for toggling context menu link visibility.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_hidden Dashboard#is_hidden}
    */
    readonly isHidden?: boolean | cdktf.IResolvable;
    /**
    * The label for the custom link URL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#label Dashboard#label}
    */
    readonly label?: string;
    /**
    * The URL of the custom link.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#link Dashboard#link}
    */
    readonly link?: string;
    /**
    * The label id that refers to a context menu link item. When override_label is provided, the client request omits the label field.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#override_label Dashboard#override_label}
    */
    readonly overrideLabel?: string;
}
export declare function dashboardWidgetGeomapDefinitionCustomLinkToTerraform(struct?: DashboardWidgetGeomapDefinitionCustomLink | cdktf.IResolvable): any;
export declare class DashboardWidgetGeomapDefinitionCustomLinkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetGeomapDefinitionCustomLink | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetGeomapDefinitionCustomLink | cdktf.IResolvable | undefined);
    private _isHidden?;
    get isHidden(): boolean | cdktf.IResolvable;
    set isHidden(value: boolean | cdktf.IResolvable);
    resetIsHidden(): void;
    get isHiddenInput(): boolean | cdktf.IResolvable | undefined;
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _link?;
    get link(): string;
    set link(value: string);
    resetLink(): void;
    get linkInput(): string | undefined;
    private _overrideLabel?;
    get overrideLabel(): string;
    set overrideLabel(value: string);
    resetOverrideLabel(): void;
    get overrideLabelInput(): string | undefined;
}
export declare class DashboardWidgetGeomapDefinitionCustomLinkList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetGeomapDefinitionCustomLink[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetGeomapDefinitionCustomLinkOutputReference;
}
export interface DashboardWidgetGeomapDefinitionRequestFormulaConditionalFormats {
    /**
    * The comparator to use. Valid values are `>`, `>=`, `<`, `<=`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#comparator Dashboard#comparator}
    */
    readonly comparator: string;
    /**
    * The color palette to apply to the background, same values available as palette.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_bg_color Dashboard#custom_bg_color}
    */
    readonly customBgColor?: string;
    /**
    * The color palette to apply to the foreground, same values available as palette.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_fg_color Dashboard#custom_fg_color}
    */
    readonly customFgColor?: string;
    /**
    * Setting this to True hides values.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#hide_value Dashboard#hide_value}
    */
    readonly hideValue?: boolean | cdktf.IResolvable;
    /**
    * Displays an image as the background.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#image_url Dashboard#image_url}
    */
    readonly imageUrl?: string;
    /**
    * The metric from the request to correlate with this conditional format.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
    */
    readonly metric?: string;
    /**
    * The color palette to apply. Valid values are `blue`, `custom_bg`, `custom_image`, `custom_text`, `gray_on_white`, `grey`, `green`, `orange`, `red`, `red_on_white`, `white_on_gray`, `white_on_green`, `green_on_white`, `white_on_red`, `white_on_yellow`, `yellow_on_white`, `black_on_light_yellow`, `black_on_light_green`, `black_on_light_red`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
    */
    readonly palette: string;
    /**
    * Defines the displayed timeframe.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#timeframe Dashboard#timeframe}
    */
    readonly timeframe?: string;
    /**
    * A value for the comparator.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#value Dashboard#value}
    */
    readonly value: number;
}
export declare function dashboardWidgetGeomapDefinitionRequestFormulaConditionalFormatsToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestFormulaConditionalFormats | cdktf.IResolvable): any;
export declare class DashboardWidgetGeomapDefinitionRequestFormulaConditionalFormatsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetGeomapDefinitionRequestFormulaConditionalFormats | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetGeomapDefinitionRequestFormulaConditionalFormats | cdktf.IResolvable | undefined);
    private _comparator?;
    get comparator(): string;
    set comparator(value: string);
    get comparatorInput(): string | undefined;
    private _customBgColor?;
    get customBgColor(): string;
    set customBgColor(value: string);
    resetCustomBgColor(): void;
    get customBgColorInput(): string | undefined;
    private _customFgColor?;
    get customFgColor(): string;
    set customFgColor(value: string);
    resetCustomFgColor(): void;
    get customFgColorInput(): string | undefined;
    private _hideValue?;
    get hideValue(): boolean | cdktf.IResolvable;
    set hideValue(value: boolean | cdktf.IResolvable);
    resetHideValue(): void;
    get hideValueInput(): boolean | cdktf.IResolvable | undefined;
    private _imageUrl?;
    get imageUrl(): string;
    set imageUrl(value: string);
    resetImageUrl(): void;
    get imageUrlInput(): string | undefined;
    private _metric?;
    get metric(): string;
    set metric(value: string);
    resetMetric(): void;
    get metricInput(): string | undefined;
    private _palette?;
    get palette(): string;
    set palette(value: string);
    get paletteInput(): string | undefined;
    private _timeframe?;
    get timeframe(): string;
    set timeframe(value: string);
    resetTimeframe(): void;
    get timeframeInput(): string | undefined;
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
}
export declare class DashboardWidgetGeomapDefinitionRequestFormulaConditionalFormatsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetGeomapDefinitionRequestFormulaConditionalFormats[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetGeomapDefinitionRequestFormulaConditionalFormatsOutputReference;
}
export interface DashboardWidgetGeomapDefinitionRequestFormulaLimit {
    /**
    * The number of results to return
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#count Dashboard#count}
    */
    readonly count?: number;
    /**
    * The direction of the sort. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
    */
    readonly order?: string;
}
export declare function dashboardWidgetGeomapDefinitionRequestFormulaLimitToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestFormulaLimitOutputReference | DashboardWidgetGeomapDefinitionRequestFormulaLimit): any;
export declare class DashboardWidgetGeomapDefinitionRequestFormulaLimitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetGeomapDefinitionRequestFormulaLimit | undefined;
    set internalValue(value: DashboardWidgetGeomapDefinitionRequestFormulaLimit | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    resetCount(): void;
    get countInput(): number | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    resetOrder(): void;
    get orderInput(): string | undefined;
}
export interface DashboardWidgetGeomapDefinitionRequestFormulaStyle {
    /**
    * The color palette used to display the formula. A guide to the available color palettes can be found at https://docs.datadoghq.com/dashboards/guide/widget_colors
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
    */
    readonly palette?: string;
    /**
    * Index specifying which color to use within the palette.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette_index Dashboard#palette_index}
    */
    readonly paletteIndex?: number;
}
export declare function dashboardWidgetGeomapDefinitionRequestFormulaStyleToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestFormulaStyleOutputReference | DashboardWidgetGeomapDefinitionRequestFormulaStyle): any;
export declare class DashboardWidgetGeomapDefinitionRequestFormulaStyleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetGeomapDefinitionRequestFormulaStyle | undefined;
    set internalValue(value: DashboardWidgetGeomapDefinitionRequestFormulaStyle | undefined);
    private _palette?;
    get palette(): string;
    set palette(value: string);
    resetPalette(): void;
    get paletteInput(): string | undefined;
    private _paletteIndex?;
    get paletteIndex(): number;
    set paletteIndex(value: number);
    resetPaletteIndex(): void;
    get paletteIndexInput(): number | undefined;
}
export interface DashboardWidgetGeomapDefinitionRequestFormula {
    /**
    * An expression alias.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alias Dashboard#alias}
    */
    readonly alias?: string;
    /**
    * A list of display modes for each table cell. Valid values are `number`, `bar`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#cell_display_mode Dashboard#cell_display_mode}
    */
    readonly cellDisplayMode?: string;
    /**
    * A string expression built from queries, formulas, and functions.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#formula_expression Dashboard#formula_expression}
    */
    readonly formulaExpression: string;
    /**
    * conditional_formats block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#conditional_formats Dashboard#conditional_formats}
    */
    readonly conditionalFormats?: DashboardWidgetGeomapDefinitionRequestFormulaConditionalFormats[] | cdktf.IResolvable;
    /**
    * limit block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: DashboardWidgetGeomapDefinitionRequestFormulaLimit;
    /**
    * style block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#style Dashboard#style}
    */
    readonly style?: DashboardWidgetGeomapDefinitionRequestFormulaStyle;
}
export declare function dashboardWidgetGeomapDefinitionRequestFormulaToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestFormula | cdktf.IResolvable): any;
export declare class DashboardWidgetGeomapDefinitionRequestFormulaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetGeomapDefinitionRequestFormula | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetGeomapDefinitionRequestFormula | cdktf.IResolvable | undefined);
    private _alias?;
    get alias(): string;
    set alias(value: string);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    private _cellDisplayMode?;
    get cellDisplayMode(): string;
    set cellDisplayMode(value: string);
    resetCellDisplayMode(): void;
    get cellDisplayModeInput(): string | undefined;
    private _formulaExpression?;
    get formulaExpression(): string;
    set formulaExpression(value: string);
    get formulaExpressionInput(): string | undefined;
    private _conditionalFormats;
    get conditionalFormats(): DashboardWidgetGeomapDefinitionRequestFormulaConditionalFormatsList;
    putConditionalFormats(value: DashboardWidgetGeomapDefinitionRequestFormulaConditionalFormats[] | cdktf.IResolvable): void;
    resetConditionalFormats(): void;
    get conditionalFormatsInput(): cdktf.IResolvable | DashboardWidgetGeomapDefinitionRequestFormulaConditionalFormats[] | undefined;
    private _limit;
    get limit(): DashboardWidgetGeomapDefinitionRequestFormulaLimitOutputReference;
    putLimit(value: DashboardWidgetGeomapDefinitionRequestFormulaLimit): void;
    resetLimit(): void;
    get limitInput(): DashboardWidgetGeomapDefinitionRequestFormulaLimit | undefined;
    private _style;
    get style(): DashboardWidgetGeomapDefinitionRequestFormulaStyleOutputReference;
    putStyle(value: DashboardWidgetGeomapDefinitionRequestFormulaStyle): void;
    resetStyle(): void;
    get styleInput(): DashboardWidgetGeomapDefinitionRequestFormulaStyle | undefined;
}
export declare class DashboardWidgetGeomapDefinitionRequestFormulaList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetGeomapDefinitionRequestFormula[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetGeomapDefinitionRequestFormulaOutputReference;
}
export interface DashboardWidgetGeomapDefinitionRequestLogQueryComputeQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetGeomapDefinitionRequestLogQueryComputeQueryToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestLogQueryComputeQueryOutputReference | DashboardWidgetGeomapDefinitionRequestLogQueryComputeQuery): any;
export declare class DashboardWidgetGeomapDefinitionRequestLogQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetGeomapDefinitionRequestLogQueryComputeQuery | undefined;
    set internalValue(value: DashboardWidgetGeomapDefinitionRequestLogQueryComputeQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export interface DashboardWidgetGeomapDefinitionRequestLogQueryGroupBySortQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Widget sorting methods. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
    */
    readonly order: string;
}
export declare function dashboardWidgetGeomapDefinitionRequestLogQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestLogQueryGroupBySortQueryOutputReference | DashboardWidgetGeomapDefinitionRequestLogQueryGroupBySortQuery): any;
export declare class DashboardWidgetGeomapDefinitionRequestLogQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetGeomapDefinitionRequestLogQueryGroupBySortQuery | undefined;
    set internalValue(value: DashboardWidgetGeomapDefinitionRequestLogQueryGroupBySortQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    get orderInput(): string | undefined;
}
export interface DashboardWidgetGeomapDefinitionRequestLogQueryGroupBy {
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * The maximum number of items in the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * sort_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
    */
    readonly sortQuery?: DashboardWidgetGeomapDefinitionRequestLogQueryGroupBySortQuery;
}
export declare function dashboardWidgetGeomapDefinitionRequestLogQueryGroupByToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestLogQueryGroupBy | cdktf.IResolvable): any;
export declare class DashboardWidgetGeomapDefinitionRequestLogQueryGroupByOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetGeomapDefinitionRequestLogQueryGroupBy | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetGeomapDefinitionRequestLogQueryGroupBy | cdktf.IResolvable | undefined);
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _sortQuery;
    get sortQuery(): DashboardWidgetGeomapDefinitionRequestLogQueryGroupBySortQueryOutputReference;
    putSortQuery(value: DashboardWidgetGeomapDefinitionRequestLogQueryGroupBySortQuery): void;
    resetSortQuery(): void;
    get sortQueryInput(): DashboardWidgetGeomapDefinitionRequestLogQueryGroupBySortQuery | undefined;
}
export declare class DashboardWidgetGeomapDefinitionRequestLogQueryGroupByList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetGeomapDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetGeomapDefinitionRequestLogQueryGroupByOutputReference;
}
export interface DashboardWidgetGeomapDefinitionRequestLogQueryMultiCompute {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetGeomapDefinitionRequestLogQueryMultiComputeToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestLogQueryMultiCompute | cdktf.IResolvable): any;
export declare class DashboardWidgetGeomapDefinitionRequestLogQueryMultiComputeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetGeomapDefinitionRequestLogQueryMultiCompute | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetGeomapDefinitionRequestLogQueryMultiCompute | cdktf.IResolvable | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export declare class DashboardWidgetGeomapDefinitionRequestLogQueryMultiComputeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetGeomapDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetGeomapDefinitionRequestLogQueryMultiComputeOutputReference;
}
export interface DashboardWidgetGeomapDefinitionRequestLogQuery {
    /**
    * The name of the index to query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
    */
    readonly index: string;
    /**
    * The search query to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
    */
    readonly searchQuery?: string;
    /**
    * compute_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
    */
    readonly computeQuery?: DashboardWidgetGeomapDefinitionRequestLogQueryComputeQuery;
    /**
    * group_by block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
    */
    readonly groupBy?: DashboardWidgetGeomapDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable;
    /**
    * multi_compute block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
    */
    readonly multiCompute?: DashboardWidgetGeomapDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetGeomapDefinitionRequestLogQueryToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestLogQueryOutputReference | DashboardWidgetGeomapDefinitionRequestLogQuery): any;
export declare class DashboardWidgetGeomapDefinitionRequestLogQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetGeomapDefinitionRequestLogQuery | undefined;
    set internalValue(value: DashboardWidgetGeomapDefinitionRequestLogQuery | undefined);
    private _index?;
    get index(): string;
    set index(value: string);
    get indexInput(): string | undefined;
    private _searchQuery?;
    get searchQuery(): string;
    set searchQuery(value: string);
    resetSearchQuery(): void;
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    get computeQuery(): DashboardWidgetGeomapDefinitionRequestLogQueryComputeQueryOutputReference;
    putComputeQuery(value: DashboardWidgetGeomapDefinitionRequestLogQueryComputeQuery): void;
    resetComputeQuery(): void;
    get computeQueryInput(): DashboardWidgetGeomapDefinitionRequestLogQueryComputeQuery | undefined;
    private _groupBy;
    get groupBy(): DashboardWidgetGeomapDefinitionRequestLogQueryGroupByList;
    putGroupBy(value: DashboardWidgetGeomapDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable): void;
    resetGroupBy(): void;
    get groupByInput(): cdktf.IResolvable | DashboardWidgetGeomapDefinitionRequestLogQueryGroupBy[] | undefined;
    private _multiCompute;
    get multiCompute(): DashboardWidgetGeomapDefinitionRequestLogQueryMultiComputeList;
    putMultiCompute(value: DashboardWidgetGeomapDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable): void;
    resetMultiCompute(): void;
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetGeomapDefinitionRequestLogQueryMultiCompute[] | undefined;
}
export interface DashboardWidgetGeomapDefinitionRequestQueryApmDependencyStatsQuery {
    /**
    * The data source for APM Dependency Stats queries. Valid values are `apm_dependency_stats`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
    */
    readonly dataSource: string;
    /**
    * APM Environment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#env Dashboard#env}
    */
    readonly env: string;
    /**
    * Determines whether stats for upstream or downstream dependencies should be queried.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_upstream Dashboard#is_upstream}
    */
    readonly isUpstream?: boolean | cdktf.IResolvable;
    /**
    * The name of query for use in formulas.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
    */
    readonly name: string;
    /**
    * Name of operation on service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#operation_name Dashboard#operation_name}
    */
    readonly operationName: string;
    /**
    * The name of the second primary tag used within APM; required when `primary_tag_value` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_name Dashboard#primary_tag_name}
    */
    readonly primaryTagName?: string;
    /**
    * Filter APM data by the second primary tag. `primary_tag_name` must also be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_value Dashboard#primary_tag_value}
    */
    readonly primaryTagValue?: string;
    /**
    * APM resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#resource_name Dashboard#resource_name}
    */
    readonly resourceName: string;
    /**
    * APM service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service Dashboard#service}
    */
    readonly service: string;
    /**
    * APM statistic. Valid values are `avg_duration`, `avg_root_duration`, `avg_spans_per_trace`, `error_rate`, `pct_exec_time`, `pct_of_traces`, `total_traces_count`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#stat Dashboard#stat}
    */
    readonly stat: string;
}
export declare function dashboardWidgetGeomapDefinitionRequestQueryApmDependencyStatsQueryToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestQueryApmDependencyStatsQueryOutputReference | DashboardWidgetGeomapDefinitionRequestQueryApmDependencyStatsQuery): any;
export declare class DashboardWidgetGeomapDefinitionRequestQueryApmDependencyStatsQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetGeomapDefinitionRequestQueryApmDependencyStatsQuery | undefined;
    set internalValue(value: DashboardWidgetGeomapDefinitionRequestQueryApmDependencyStatsQuery | undefined);
    private _dataSource?;
    get dataSource(): string;
    set dataSource(value: string);
    get dataSourceInput(): string | undefined;
    private _env?;
    get env(): string;
    set env(value: string);
    get envInput(): string | undefined;
    private _isUpstream?;
    get isUpstream(): boolean | cdktf.IResolvable;
    set isUpstream(value: boolean | cdktf.IResolvable);
    resetIsUpstream(): void;
    get isUpstreamInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _operationName?;
    get operationName(): string;
    set operationName(value: string);
    get operationNameInput(): string | undefined;
    private _primaryTagName?;
    get primaryTagName(): string;
    set primaryTagName(value: string);
    resetPrimaryTagName(): void;
    get primaryTagNameInput(): string | undefined;
    private _primaryTagValue?;
    get primaryTagValue(): string;
    set primaryTagValue(value: string);
    resetPrimaryTagValue(): void;
    get primaryTagValueInput(): string | undefined;
    private _resourceName?;
    get resourceName(): string;
    set resourceName(value: string);
    get resourceNameInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _stat?;
    get stat(): string;
    set stat(value: string);
    get statInput(): string | undefined;
}
export interface DashboardWidgetGeomapDefinitionRequestQueryApmResourceStatsQuery {
    /**
    * The data source for APM Resource Stats queries. Valid values are `apm_resource_stats`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
    */
    readonly dataSource: string;
    /**
    * APM Environment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#env Dashboard#env}
    */
    readonly env: string;
    /**
    * Array of fields to group results by.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
    */
    readonly groupBy?: string[];
    /**
    * The name of query for use in formulas.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
    */
    readonly name: string;
    /**
    * Name of operation on service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#operation_name Dashboard#operation_name}
    */
    readonly operationName?: string;
    /**
    * The name of the second primary tag used within APM; required when `primary_tag_value` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_name Dashboard#primary_tag_name}
    */
    readonly primaryTagName?: string;
    /**
    * Filter APM data by the second primary tag. `primary_tag_name` must also be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_value Dashboard#primary_tag_value}
    */
    readonly primaryTagValue?: string;
    /**
    * APM resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#resource_name Dashboard#resource_name}
    */
    readonly resourceName?: string;
    /**
    * APM service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service Dashboard#service}
    */
    readonly service: string;
    /**
    * APM statistic. Valid values are `errors`, `error_rate`, `hits`, `latency_avg`, `latency_distribution`, `latency_max`, `latency_p50`, `latency_p75`, `latency_p90`, `latency_p95`, `latency_p99`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#stat Dashboard#stat}
    */
    readonly stat: string;
}
export declare function dashboardWidgetGeomapDefinitionRequestQueryApmResourceStatsQueryToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestQueryApmResourceStatsQueryOutputReference | DashboardWidgetGeomapDefinitionRequestQueryApmResourceStatsQuery): any;
export declare class DashboardWidgetGeomapDefinitionRequestQueryApmResourceStatsQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetGeomapDefinitionRequestQueryApmResourceStatsQuery | undefined;
    set internalValue(value: DashboardWidgetGeomapDefinitionRequestQueryApmResourceStatsQuery | undefined);
    private _dataSource?;
    get dataSource(): string;
    set dataSource(value: string);
    get dataSourceInput(): string | undefined;
    private _env?;
    get env(): string;
    set env(value: string);
    get envInput(): string | undefined;
    private _groupBy?;
    get groupBy(): string[];
    set groupBy(value: string[]);
    resetGroupBy(): void;
    get groupByInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _operationName?;
    get operationName(): string;
    set operationName(value: string);
    resetOperationName(): void;
    get operationNameInput(): string | undefined;
    private _primaryTagName?;
    get primaryTagName(): string;
    set primaryTagName(value: string);
    resetPrimaryTagName(): void;
    get primaryTagNameInput(): string | undefined;
    private _primaryTagValue?;
    get primaryTagValue(): string;
    set primaryTagValue(value: string);
    resetPrimaryTagValue(): void;
    get primaryTagValueInput(): string | undefined;
    private _resourceName?;
    get resourceName(): string;
    set resourceName(value: string);
    resetResourceName(): void;
    get resourceNameInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _stat?;
    get stat(): string;
    set stat(value: string);
    get statInput(): string | undefined;
}
export interface DashboardWidgetGeomapDefinitionRequestQueryEventQueryCompute {
    /**
    * The aggregation methods for event platform queries. Valid values are `count`, `cardinality`, `median`, `pc75`, `pc90`, `pc95`, `pc98`, `pc99`, `sum`, `min`, `max`, `avg`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * A time interval in milliseconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
    /**
    * The measurable attribute to compute.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
    */
    readonly metric?: string;
}
export declare function dashboardWidgetGeomapDefinitionRequestQueryEventQueryComputeToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestQueryEventQueryCompute | cdktf.IResolvable): any;
export declare class DashboardWidgetGeomapDefinitionRequestQueryEventQueryComputeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetGeomapDefinitionRequestQueryEventQueryCompute | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetGeomapDefinitionRequestQueryEventQueryCompute | cdktf.IResolvable | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
    private _metric?;
    get metric(): string;
    set metric(value: string);
    resetMetric(): void;
    get metricInput(): string | undefined;
}
export declare class DashboardWidgetGeomapDefinitionRequestQueryEventQueryComputeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetGeomapDefinitionRequestQueryEventQueryCompute[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetGeomapDefinitionRequestQueryEventQueryComputeOutputReference;
}
export interface DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBySort {
    /**
    * The aggregation methods for the event platform queries. Valid values are `count`, `cardinality`, `median`, `pc75`, `pc90`, `pc95`, `pc98`, `pc99`, `sum`, `min`, `max`, `avg`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The metric used for sorting group by results.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
    */
    readonly metric?: string;
    /**
    * Direction of sort. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
    */
    readonly order?: string;
}
export declare function dashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBySortToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBySortOutputReference | DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBySort): any;
export declare class DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBySortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBySort | undefined;
    set internalValue(value: DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBySort | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _metric?;
    get metric(): string;
    set metric(value: string);
    resetMetric(): void;
    get metricInput(): string | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    resetOrder(): void;
    get orderInput(): string | undefined;
}
export interface DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBy {
    /**
    * The event facet.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet: string;
    /**
    * The number of groups to return.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * sort block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort Dashboard#sort}
    */
    readonly sort?: DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBySort;
}
export declare function dashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupByToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBy | cdktf.IResolvable): any;
export declare class DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupByOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBy | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBy | cdktf.IResolvable | undefined);
    private _facet?;
    get facet(): string;
    set facet(value: string);
    get facetInput(): string | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _sort;
    get sort(): DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBySortOutputReference;
    putSort(value: DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBySort): void;
    resetSort(): void;
    get sortInput(): DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBySort | undefined;
}
export declare class DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupByList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupByOutputReference;
}
export interface DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearch {
    /**
    * The events search string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
    */
    readonly query: string;
}
export declare function dashboardWidgetGeomapDefinitionRequestQueryEventQuerySearchToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearchOutputReference | DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearch): any;
export declare class DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearch | undefined;
    set internalValue(value: DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearch | undefined);
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
}
export interface DashboardWidgetGeomapDefinitionRequestQueryEventQuery {
    /**
    * The data source for event platform-based queries. Valid values are `logs`, `spans`, `network`, `rum`, `security_signals`, `profiles`, `audit`, `events`, `ci_tests`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
    */
    readonly dataSource: string;
    /**
    * An array of index names to query in the stream.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#indexes Dashboard#indexes}
    */
    readonly indexes?: string[];
    /**
    * The name of query for use in formulas.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
    */
    readonly name: string;
    /**
    * Storage location (private beta).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#storage Dashboard#storage}
    */
    readonly storage?: string;
    /**
    * compute block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute Dashboard#compute}
    */
    readonly compute: DashboardWidgetGeomapDefinitionRequestQueryEventQueryCompute[] | cdktf.IResolvable;
    /**
    * group_by block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
    */
    readonly groupBy?: DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBy[] | cdktf.IResolvable;
    /**
    * search block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search Dashboard#search}
    */
    readonly search?: DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearch;
}
export declare function dashboardWidgetGeomapDefinitionRequestQueryEventQueryToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestQueryEventQueryOutputReference | DashboardWidgetGeomapDefinitionRequestQueryEventQuery): any;
export declare class DashboardWidgetGeomapDefinitionRequestQueryEventQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetGeomapDefinitionRequestQueryEventQuery | undefined;
    set internalValue(value: DashboardWidgetGeomapDefinitionRequestQueryEventQuery | undefined);
    private _dataSource?;
    get dataSource(): string;
    set dataSource(value: string);
    get dataSourceInput(): string | undefined;
    private _indexes?;
    get indexes(): string[];
    set indexes(value: string[]);
    resetIndexes(): void;
    get indexesInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _storage?;
    get storage(): string;
    set storage(value: string);
    resetStorage(): void;
    get storageInput(): string | undefined;
    private _compute;
    get compute(): DashboardWidgetGeomapDefinitionRequestQueryEventQueryComputeList;
    putCompute(value: DashboardWidgetGeomapDefinitionRequestQueryEventQueryCompute[] | cdktf.IResolvable): void;
    get computeInput(): cdktf.IResolvable | DashboardWidgetGeomapDefinitionRequestQueryEventQueryCompute[] | undefined;
    private _groupBy;
    get groupBy(): DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupByList;
    putGroupBy(value: DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBy[] | cdktf.IResolvable): void;
    resetGroupBy(): void;
    get groupByInput(): cdktf.IResolvable | DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBy[] | undefined;
    private _search;
    get search(): DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearchOutputReference;
    putSearch(value: DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearch): void;
    resetSearch(): void;
    get searchInput(): DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearch | undefined;
}
export interface DashboardWidgetGeomapDefinitionRequestQueryMetricQuery {
    /**
    * The aggregation methods available for metrics queries. Valid values are `avg`, `min`, `max`, `sum`, `last`, `area`, `l2norm`, `percentile`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregator Dashboard#aggregator}
    */
    readonly aggregator?: string;
    /**
    * The data source for metrics queries.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
    */
    readonly dataSource?: string;
    /**
    * The name of the query for use in formulas.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
    */
    readonly name: string;
    /**
    * The metrics query definition.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
    */
    readonly query: string;
}
export declare function dashboardWidgetGeomapDefinitionRequestQueryMetricQueryToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestQueryMetricQueryOutputReference | DashboardWidgetGeomapDefinitionRequestQueryMetricQuery): any;
export declare class DashboardWidgetGeomapDefinitionRequestQueryMetricQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetGeomapDefinitionRequestQueryMetricQuery | undefined;
    set internalValue(value: DashboardWidgetGeomapDefinitionRequestQueryMetricQuery | undefined);
    private _aggregator?;
    get aggregator(): string;
    set aggregator(value: string);
    resetAggregator(): void;
    get aggregatorInput(): string | undefined;
    private _dataSource?;
    get dataSource(): string;
    set dataSource(value: string);
    resetDataSource(): void;
    get dataSourceInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
}
export interface DashboardWidgetGeomapDefinitionRequestQueryProcessQuery {
    /**
    * The aggregation methods available for metrics queries. Valid values are `avg`, `min`, `max`, `sum`, `last`, `area`, `l2norm`, `percentile`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregator Dashboard#aggregator}
    */
    readonly aggregator?: string;
    /**
    * The data source for process queries. Valid values are `process`, `container`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
    */
    readonly dataSource: string;
    /**
    * Whether to normalize the CPU percentages.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_normalized_cpu Dashboard#is_normalized_cpu}
    */
    readonly isNormalizedCpu?: boolean | cdktf.IResolvable;
    /**
    * The number of hits to return.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * The process metric name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
    */
    readonly metric: string;
    /**
    * The name of query for use in formulas.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
    */
    readonly name: string;
    /**
    * The direction of the sort. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort Dashboard#sort}
    */
    readonly sort?: string;
    /**
    * An array of tags to filter by.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#tag_filters Dashboard#tag_filters}
    */
    readonly tagFilters?: string[];
    /**
    * The text to use as a filter.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#text_filter Dashboard#text_filter}
    */
    readonly textFilter?: string;
}
export declare function dashboardWidgetGeomapDefinitionRequestQueryProcessQueryToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestQueryProcessQueryOutputReference | DashboardWidgetGeomapDefinitionRequestQueryProcessQuery): any;
export declare class DashboardWidgetGeomapDefinitionRequestQueryProcessQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetGeomapDefinitionRequestQueryProcessQuery | undefined;
    set internalValue(value: DashboardWidgetGeomapDefinitionRequestQueryProcessQuery | undefined);
    private _aggregator?;
    get aggregator(): string;
    set aggregator(value: string);
    resetAggregator(): void;
    get aggregatorInput(): string | undefined;
    private _dataSource?;
    get dataSource(): string;
    set dataSource(value: string);
    get dataSourceInput(): string | undefined;
    private _isNormalizedCpu?;
    get isNormalizedCpu(): boolean | cdktf.IResolvable;
    set isNormalizedCpu(value: boolean | cdktf.IResolvable);
    resetIsNormalizedCpu(): void;
    get isNormalizedCpuInput(): boolean | cdktf.IResolvable | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _metric?;
    get metric(): string;
    set metric(value: string);
    get metricInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _sort?;
    get sort(): string;
    set sort(value: string);
    resetSort(): void;
    get sortInput(): string | undefined;
    private _tagFilters?;
    get tagFilters(): string[];
    set tagFilters(value: string[]);
    resetTagFilters(): void;
    get tagFiltersInput(): string[] | undefined;
    private _textFilter?;
    get textFilter(): string;
    set textFilter(value: string);
    resetTextFilter(): void;
    get textFilterInput(): string | undefined;
}
export interface DashboardWidgetGeomapDefinitionRequestQuery {
    /**
    * apm_dependency_stats_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_dependency_stats_query Dashboard#apm_dependency_stats_query}
    */
    readonly apmDependencyStatsQuery?: DashboardWidgetGeomapDefinitionRequestQueryApmDependencyStatsQuery;
    /**
    * apm_resource_stats_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_resource_stats_query Dashboard#apm_resource_stats_query}
    */
    readonly apmResourceStatsQuery?: DashboardWidgetGeomapDefinitionRequestQueryApmResourceStatsQuery;
    /**
    * event_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#event_query Dashboard#event_query}
    */
    readonly eventQuery?: DashboardWidgetGeomapDefinitionRequestQueryEventQuery;
    /**
    * metric_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric_query Dashboard#metric_query}
    */
    readonly metricQuery?: DashboardWidgetGeomapDefinitionRequestQueryMetricQuery;
    /**
    * process_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#process_query Dashboard#process_query}
    */
    readonly processQuery?: DashboardWidgetGeomapDefinitionRequestQueryProcessQuery;
}
export declare function dashboardWidgetGeomapDefinitionRequestQueryToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestQuery | cdktf.IResolvable): any;
export declare class DashboardWidgetGeomapDefinitionRequestQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetGeomapDefinitionRequestQuery | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetGeomapDefinitionRequestQuery | cdktf.IResolvable | undefined);
    private _apmDependencyStatsQuery;
    get apmDependencyStatsQuery(): DashboardWidgetGeomapDefinitionRequestQueryApmDependencyStatsQueryOutputReference;
    putApmDependencyStatsQuery(value: DashboardWidgetGeomapDefinitionRequestQueryApmDependencyStatsQuery): void;
    resetApmDependencyStatsQuery(): void;
    get apmDependencyStatsQueryInput(): DashboardWidgetGeomapDefinitionRequestQueryApmDependencyStatsQuery | undefined;
    private _apmResourceStatsQuery;
    get apmResourceStatsQuery(): DashboardWidgetGeomapDefinitionRequestQueryApmResourceStatsQueryOutputReference;
    putApmResourceStatsQuery(value: DashboardWidgetGeomapDefinitionRequestQueryApmResourceStatsQuery): void;
    resetApmResourceStatsQuery(): void;
    get apmResourceStatsQueryInput(): DashboardWidgetGeomapDefinitionRequestQueryApmResourceStatsQuery | undefined;
    private _eventQuery;
    get eventQuery(): DashboardWidgetGeomapDefinitionRequestQueryEventQueryOutputReference;
    putEventQuery(value: DashboardWidgetGeomapDefinitionRequestQueryEventQuery): void;
    resetEventQuery(): void;
    get eventQueryInput(): DashboardWidgetGeomapDefinitionRequestQueryEventQuery | undefined;
    private _metricQuery;
    get metricQuery(): DashboardWidgetGeomapDefinitionRequestQueryMetricQueryOutputReference;
    putMetricQuery(value: DashboardWidgetGeomapDefinitionRequestQueryMetricQuery): void;
    resetMetricQuery(): void;
    get metricQueryInput(): DashboardWidgetGeomapDefinitionRequestQueryMetricQuery | undefined;
    private _processQuery;
    get processQuery(): DashboardWidgetGeomapDefinitionRequestQueryProcessQueryOutputReference;
    putProcessQuery(value: DashboardWidgetGeomapDefinitionRequestQueryProcessQuery): void;
    resetProcessQuery(): void;
    get processQueryInput(): DashboardWidgetGeomapDefinitionRequestQueryProcessQuery | undefined;
}
export declare class DashboardWidgetGeomapDefinitionRequestQueryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetGeomapDefinitionRequestQuery[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetGeomapDefinitionRequestQueryOutputReference;
}
export interface DashboardWidgetGeomapDefinitionRequestRumQueryComputeQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetGeomapDefinitionRequestRumQueryComputeQueryToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestRumQueryComputeQueryOutputReference | DashboardWidgetGeomapDefinitionRequestRumQueryComputeQuery): any;
export declare class DashboardWidgetGeomapDefinitionRequestRumQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetGeomapDefinitionRequestRumQueryComputeQuery | undefined;
    set internalValue(value: DashboardWidgetGeomapDefinitionRequestRumQueryComputeQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export interface DashboardWidgetGeomapDefinitionRequestRumQueryGroupBySortQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Widget sorting methods. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
    */
    readonly order: string;
}
export declare function dashboardWidgetGeomapDefinitionRequestRumQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestRumQueryGroupBySortQueryOutputReference | DashboardWidgetGeomapDefinitionRequestRumQueryGroupBySortQuery): any;
export declare class DashboardWidgetGeomapDefinitionRequestRumQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetGeomapDefinitionRequestRumQueryGroupBySortQuery | undefined;
    set internalValue(value: DashboardWidgetGeomapDefinitionRequestRumQueryGroupBySortQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    get orderInput(): string | undefined;
}
export interface DashboardWidgetGeomapDefinitionRequestRumQueryGroupBy {
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * The maximum number of items in the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * sort_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
    */
    readonly sortQuery?: DashboardWidgetGeomapDefinitionRequestRumQueryGroupBySortQuery;
}
export declare function dashboardWidgetGeomapDefinitionRequestRumQueryGroupByToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestRumQueryGroupBy | cdktf.IResolvable): any;
export declare class DashboardWidgetGeomapDefinitionRequestRumQueryGroupByOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetGeomapDefinitionRequestRumQueryGroupBy | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetGeomapDefinitionRequestRumQueryGroupBy | cdktf.IResolvable | undefined);
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _sortQuery;
    get sortQuery(): DashboardWidgetGeomapDefinitionRequestRumQueryGroupBySortQueryOutputReference;
    putSortQuery(value: DashboardWidgetGeomapDefinitionRequestRumQueryGroupBySortQuery): void;
    resetSortQuery(): void;
    get sortQueryInput(): DashboardWidgetGeomapDefinitionRequestRumQueryGroupBySortQuery | undefined;
}
export declare class DashboardWidgetGeomapDefinitionRequestRumQueryGroupByList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetGeomapDefinitionRequestRumQueryGroupBy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetGeomapDefinitionRequestRumQueryGroupByOutputReference;
}
export interface DashboardWidgetGeomapDefinitionRequestRumQueryMultiCompute {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetGeomapDefinitionRequestRumQueryMultiComputeToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestRumQueryMultiCompute | cdktf.IResolvable): any;
export declare class DashboardWidgetGeomapDefinitionRequestRumQueryMultiComputeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetGeomapDefinitionRequestRumQueryMultiCompute | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetGeomapDefinitionRequestRumQueryMultiCompute | cdktf.IResolvable | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export declare class DashboardWidgetGeomapDefinitionRequestRumQueryMultiComputeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetGeomapDefinitionRequestRumQueryMultiCompute[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetGeomapDefinitionRequestRumQueryMultiComputeOutputReference;
}
export interface DashboardWidgetGeomapDefinitionRequestRumQuery {
    /**
    * The name of the index to query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
    */
    readonly index: string;
    /**
    * The search query to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
    */
    readonly searchQuery?: string;
    /**
    * compute_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
    */
    readonly computeQuery?: DashboardWidgetGeomapDefinitionRequestRumQueryComputeQuery;
    /**
    * group_by block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
    */
    readonly groupBy?: DashboardWidgetGeomapDefinitionRequestRumQueryGroupBy[] | cdktf.IResolvable;
    /**
    * multi_compute block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
    */
    readonly multiCompute?: DashboardWidgetGeomapDefinitionRequestRumQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetGeomapDefinitionRequestRumQueryToTerraform(struct?: DashboardWidgetGeomapDefinitionRequestRumQueryOutputReference | DashboardWidgetGeomapDefinitionRequestRumQuery): any;
export declare class DashboardWidgetGeomapDefinitionRequestRumQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetGeomapDefinitionRequestRumQuery | undefined;
    set internalValue(value: DashboardWidgetGeomapDefinitionRequestRumQuery | undefined);
    private _index?;
    get index(): string;
    set index(value: string);
    get indexInput(): string | undefined;
    private _searchQuery?;
    get searchQuery(): string;
    set searchQuery(value: string);
    resetSearchQuery(): void;
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    get computeQuery(): DashboardWidgetGeomapDefinitionRequestRumQueryComputeQueryOutputReference;
    putComputeQuery(value: DashboardWidgetGeomapDefinitionRequestRumQueryComputeQuery): void;
    resetComputeQuery(): void;
    get computeQueryInput(): DashboardWidgetGeomapDefinitionRequestRumQueryComputeQuery | undefined;
    private _groupBy;
    get groupBy(): DashboardWidgetGeomapDefinitionRequestRumQueryGroupByList;
    putGroupBy(value: DashboardWidgetGeomapDefinitionRequestRumQueryGroupBy[] | cdktf.IResolvable): void;
    resetGroupBy(): void;
    get groupByInput(): cdktf.IResolvable | DashboardWidgetGeomapDefinitionRequestRumQueryGroupBy[] | undefined;
    private _multiCompute;
    get multiCompute(): DashboardWidgetGeomapDefinitionRequestRumQueryMultiComputeList;
    putMultiCompute(value: DashboardWidgetGeomapDefinitionRequestRumQueryMultiCompute[] | cdktf.IResolvable): void;
    resetMultiCompute(): void;
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetGeomapDefinitionRequestRumQueryMultiCompute[] | undefined;
}
export interface DashboardWidgetGeomapDefinitionRequest {
    /**
    * The metric query to use for this widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#q Dashboard#q}
    */
    readonly q?: string;
    /**
    * formula block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#formula Dashboard#formula}
    */
    readonly formula?: DashboardWidgetGeomapDefinitionRequestFormula[] | cdktf.IResolvable;
    /**
    * log_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#log_query Dashboard#log_query}
    */
    readonly logQuery?: DashboardWidgetGeomapDefinitionRequestLogQuery;
    /**
    * query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
    */
    readonly query?: DashboardWidgetGeomapDefinitionRequestQuery[] | cdktf.IResolvable;
    /**
    * rum_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#rum_query Dashboard#rum_query}
    */
    readonly rumQuery?: DashboardWidgetGeomapDefinitionRequestRumQuery;
}
export declare function dashboardWidgetGeomapDefinitionRequestToTerraform(struct?: DashboardWidgetGeomapDefinitionRequest | cdktf.IResolvable): any;
export declare class DashboardWidgetGeomapDefinitionRequestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetGeomapDefinitionRequest | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetGeomapDefinitionRequest | cdktf.IResolvable | undefined);
    private _q?;
    get q(): string;
    set q(value: string);
    resetQ(): void;
    get qInput(): string | undefined;
    private _formula;
    get formula(): DashboardWidgetGeomapDefinitionRequestFormulaList;
    putFormula(value: DashboardWidgetGeomapDefinitionRequestFormula[] | cdktf.IResolvable): void;
    resetFormula(): void;
    get formulaInput(): cdktf.IResolvable | DashboardWidgetGeomapDefinitionRequestFormula[] | undefined;
    private _logQuery;
    get logQuery(): DashboardWidgetGeomapDefinitionRequestLogQueryOutputReference;
    putLogQuery(value: DashboardWidgetGeomapDefinitionRequestLogQuery): void;
    resetLogQuery(): void;
    get logQueryInput(): DashboardWidgetGeomapDefinitionRequestLogQuery | undefined;
    private _query;
    get query(): DashboardWidgetGeomapDefinitionRequestQueryList;
    putQuery(value: DashboardWidgetGeomapDefinitionRequestQuery[] | cdktf.IResolvable): void;
    resetQuery(): void;
    get queryInput(): cdktf.IResolvable | DashboardWidgetGeomapDefinitionRequestQuery[] | undefined;
    private _rumQuery;
    get rumQuery(): DashboardWidgetGeomapDefinitionRequestRumQueryOutputReference;
    putRumQuery(value: DashboardWidgetGeomapDefinitionRequestRumQuery): void;
    resetRumQuery(): void;
    get rumQueryInput(): DashboardWidgetGeomapDefinitionRequestRumQuery | undefined;
}
export declare class DashboardWidgetGeomapDefinitionRequestList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetGeomapDefinitionRequest[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetGeomapDefinitionRequestOutputReference;
}
export interface DashboardWidgetGeomapDefinitionStyle {
    /**
    * The color palette to apply to the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
    */
    readonly palette: string;
    /**
    * A Boolean indicating whether to flip the palette tones.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette_flip Dashboard#palette_flip}
    */
    readonly paletteFlip: boolean | cdktf.IResolvable;
}
export declare function dashboardWidgetGeomapDefinitionStyleToTerraform(struct?: DashboardWidgetGeomapDefinitionStyleOutputReference | DashboardWidgetGeomapDefinitionStyle): any;
export declare class DashboardWidgetGeomapDefinitionStyleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetGeomapDefinitionStyle | undefined;
    set internalValue(value: DashboardWidgetGeomapDefinitionStyle | undefined);
    private _palette?;
    get palette(): string;
    set palette(value: string);
    get paletteInput(): string | undefined;
    private _paletteFlip?;
    get paletteFlip(): boolean | cdktf.IResolvable;
    set paletteFlip(value: boolean | cdktf.IResolvable);
    get paletteFlipInput(): boolean | cdktf.IResolvable | undefined;
}
export interface DashboardWidgetGeomapDefinitionView {
    /**
    * The two-letter ISO code of a country to focus the map on (or `WORLD`).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#focus Dashboard#focus}
    */
    readonly focus: string;
}
export declare function dashboardWidgetGeomapDefinitionViewToTerraform(struct?: DashboardWidgetGeomapDefinitionViewOutputReference | DashboardWidgetGeomapDefinitionView): any;
export declare class DashboardWidgetGeomapDefinitionViewOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetGeomapDefinitionView | undefined;
    set internalValue(value: DashboardWidgetGeomapDefinitionView | undefined);
    private _focus?;
    get focus(): string;
    set focus(value: string);
    get focusInput(): string | undefined;
}
export interface DashboardWidgetGeomapDefinition {
    /**
    * The timeframe to use when displaying the widget. Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
    */
    readonly liveSpan?: string;
    /**
    * The title of the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
    */
    readonly title?: string;
    /**
    * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
    */
    readonly titleAlign?: string;
    /**
    * The size of the widget's title (defaults to 16).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
    */
    readonly titleSize?: string;
    /**
    * custom_link block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_link Dashboard#custom_link}
    */
    readonly customLink?: DashboardWidgetGeomapDefinitionCustomLink[] | cdktf.IResolvable;
    /**
    * request block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#request Dashboard#request}
    */
    readonly request?: DashboardWidgetGeomapDefinitionRequest[] | cdktf.IResolvable;
    /**
    * style block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#style Dashboard#style}
    */
    readonly style?: DashboardWidgetGeomapDefinitionStyle;
    /**
    * view block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#view Dashboard#view}
    */
    readonly view: DashboardWidgetGeomapDefinitionView;
}
export declare function dashboardWidgetGeomapDefinitionToTerraform(struct?: DashboardWidgetGeomapDefinitionOutputReference | DashboardWidgetGeomapDefinition): any;
export declare class DashboardWidgetGeomapDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetGeomapDefinition | undefined;
    set internalValue(value: DashboardWidgetGeomapDefinition | undefined);
    private _liveSpan?;
    get liveSpan(): string;
    set liveSpan(value: string);
    resetLiveSpan(): void;
    get liveSpanInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
    private _titleAlign?;
    get titleAlign(): string;
    set titleAlign(value: string);
    resetTitleAlign(): void;
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    get titleSize(): string;
    set titleSize(value: string);
    resetTitleSize(): void;
    get titleSizeInput(): string | undefined;
    private _customLink;
    get customLink(): DashboardWidgetGeomapDefinitionCustomLinkList;
    putCustomLink(value: DashboardWidgetGeomapDefinitionCustomLink[] | cdktf.IResolvable): void;
    resetCustomLink(): void;
    get customLinkInput(): cdktf.IResolvable | DashboardWidgetGeomapDefinitionCustomLink[] | undefined;
    private _request;
    get request(): DashboardWidgetGeomapDefinitionRequestList;
    putRequest(value: DashboardWidgetGeomapDefinitionRequest[] | cdktf.IResolvable): void;
    resetRequest(): void;
    get requestInput(): cdktf.IResolvable | DashboardWidgetGeomapDefinitionRequest[] | undefined;
    private _style;
    get style(): DashboardWidgetGeomapDefinitionStyleOutputReference;
    putStyle(value: DashboardWidgetGeomapDefinitionStyle): void;
    resetStyle(): void;
    get styleInput(): DashboardWidgetGeomapDefinitionStyle | undefined;
    private _view;
    get view(): DashboardWidgetGeomapDefinitionViewOutputReference;
    putView(value: DashboardWidgetGeomapDefinitionView): void;
    get viewInput(): DashboardWidgetGeomapDefinitionView | undefined;
}
export interface DashboardWidgetGroupDefinitionWidgetAlertGraphDefinition {
    /**
    * The ID of the monitor used by the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alert_id Dashboard#alert_id}
    */
    readonly alertId: string;
    /**
    * The timeframe to use when displaying the widget. Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
    */
    readonly liveSpan?: string;
    /**
    * The title of the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
    */
    readonly title?: string;
    /**
    * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
    */
    readonly titleAlign?: string;
    /**
    * The size of the widget's title (defaults to 16).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
    */
    readonly titleSize?: string;
    /**
    * Type of visualization to use when displaying the widget. Valid values are `timeseries`, `toplist`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#viz_type Dashboard#viz_type}
    */
    readonly vizType: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetAlertGraphDefinitionToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetAlertGraphDefinitionOutputReference | DashboardWidgetGroupDefinitionWidgetAlertGraphDefinition): any;
export declare class DashboardWidgetGroupDefinitionWidgetAlertGraphDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetGroupDefinitionWidgetAlertGraphDefinition | undefined;
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetAlertGraphDefinition | undefined);
    private _alertId?;
    get alertId(): string;
    set alertId(value: string);
    get alertIdInput(): string | undefined;
    private _liveSpan?;
    get liveSpan(): string;
    set liveSpan(value: string);
    resetLiveSpan(): void;
    get liveSpanInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
    private _titleAlign?;
    get titleAlign(): string;
    set titleAlign(value: string);
    resetTitleAlign(): void;
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    get titleSize(): string;
    set titleSize(value: string);
    resetTitleSize(): void;
    get titleSizeInput(): string | undefined;
    private _vizType?;
    get vizType(): string;
    set vizType(value: string);
    get vizTypeInput(): string | undefined;
}
export interface DashboardWidgetGroupDefinitionWidgetAlertValueDefinition {
    /**
    * The ID of the monitor used by the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alert_id Dashboard#alert_id}
    */
    readonly alertId: string;
    /**
    * The precision to use when displaying the value. Use `*` for maximum precision.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#precision Dashboard#precision}
    */
    readonly precision?: number;
    /**
    * The alignment of the text in the widget. Valid values are `center`, `left`, `right`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#text_align Dashboard#text_align}
    */
    readonly textAlign?: string;
    /**
    * The title of the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
    */
    readonly title?: string;
    /**
    * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
    */
    readonly titleAlign?: string;
    /**
    * The size of the widget's title (defaults to 16).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
    */
    readonly titleSize?: string;
    /**
    * The unit for the value displayed in the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#unit Dashboard#unit}
    */
    readonly unit?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetAlertValueDefinitionToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetAlertValueDefinitionOutputReference | DashboardWidgetGroupDefinitionWidgetAlertValueDefinition): any;
export declare class DashboardWidgetGroupDefinitionWidgetAlertValueDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetGroupDefinitionWidgetAlertValueDefinition | undefined;
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetAlertValueDefinition | undefined);
    private _alertId?;
    get alertId(): string;
    set alertId(value: string);
    get alertIdInput(): string | undefined;
    private _precision?;
    get precision(): number;
    set precision(value: number);
    resetPrecision(): void;
    get precisionInput(): number | undefined;
    private _textAlign?;
    get textAlign(): string;
    set textAlign(value: string);
    resetTextAlign(): void;
    get textAlignInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
    private _titleAlign?;
    get titleAlign(): string;
    set titleAlign(value: string);
    resetTitleAlign(): void;
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    get titleSize(): string;
    set titleSize(value: string);
    resetTitleSize(): void;
    get titleSizeInput(): string | undefined;
    private _unit?;
    get unit(): string;
    set unit(value: string);
    resetUnit(): void;
    get unitInput(): string | undefined;
}
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionCustomLink {
    /**
    * The flag for toggling context menu link visibility.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_hidden Dashboard#is_hidden}
    */
    readonly isHidden?: boolean | cdktf.IResolvable;
    /**
    * The label for the custom link URL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#label Dashboard#label}
    */
    readonly label?: string;
    /**
    * The URL of the custom link.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#link Dashboard#link}
    */
    readonly link?: string;
    /**
    * The label id that refers to a context menu link item. When override_label is provided, the client request omits the label field.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#override_label Dashboard#override_label}
    */
    readonly overrideLabel?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionCustomLinkToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionCustomLink | cdktf.IResolvable): any;
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionCustomLinkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionCustomLink | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionCustomLink | cdktf.IResolvable | undefined);
    private _isHidden?;
    get isHidden(): boolean | cdktf.IResolvable;
    set isHidden(value: boolean | cdktf.IResolvable);
    resetIsHidden(): void;
    get isHiddenInput(): boolean | cdktf.IResolvable | undefined;
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _link?;
    get link(): string;
    set link(value: string);
    resetLink(): void;
    get linkInput(): string | undefined;
    private _overrideLabel?;
    get overrideLabel(): string;
    set overrideLabel(value: string);
    resetOverrideLabel(): void;
    get overrideLabelInput(): string | undefined;
}
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionCustomLinkList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionCustomLink[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetGroupDefinitionWidgetChangeDefinitionCustomLinkOutputReference;
}
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQueryOutputReference | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQuery): any;
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQuery | undefined;
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBySortQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Widget sorting methods. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
    */
    readonly order: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBySortQueryOutputReference | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBySortQuery): any;
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBySortQuery | undefined;
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBySortQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    get orderInput(): string | undefined;
}
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBy {
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * The maximum number of items in the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * sort_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
    */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBySortQuery;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupByToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBy | cdktf.IResolvable): any;
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupByOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBy | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBy | cdktf.IResolvable | undefined);
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _sortQuery;
    get sortQuery(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBySortQueryOutputReference;
    putSortQuery(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBySortQuery): void;
    resetSortQuery(): void;
    get sortQueryInput(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBySortQuery | undefined;
}
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupByList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupByOutputReference;
}
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryMultiCompute {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryMultiComputeToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryMultiCompute | cdktf.IResolvable): any;
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryMultiComputeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryMultiCompute | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryMultiCompute | cdktf.IResolvable | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryMultiComputeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryMultiCompute[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryMultiComputeOutputReference;
}
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQuery {
    /**
    * The name of the index to query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
    */
    readonly index: string;
    /**
    * The search query to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
    */
    readonly searchQuery?: string;
    /**
    * compute_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
    */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQuery;
    /**
    * group_by block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
    */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBy[] | cdktf.IResolvable;
    /**
    * multi_compute block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
    */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryOutputReference | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQuery): any;
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQuery | undefined;
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQuery | undefined);
    private _index?;
    get index(): string;
    set index(value: string);
    get indexInput(): string | undefined;
    private _searchQuery?;
    get searchQuery(): string;
    set searchQuery(value: string);
    resetSearchQuery(): void;
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQueryOutputReference;
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQuery): void;
    resetComputeQuery(): void;
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQuery | undefined;
    private _groupBy;
    get groupBy(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupByList;
    putGroupBy(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBy[] | cdktf.IResolvable): void;
    resetGroupBy(): void;
    get groupByInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBy[] | undefined;
    private _multiCompute;
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryMultiComputeList;
    putMultiCompute(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryMultiCompute[] | cdktf.IResolvable): void;
    resetMultiCompute(): void;
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryMultiCompute[] | undefined;
}
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaConditionalFormats {
    /**
    * The comparator to use. Valid values are `>`, `>=`, `<`, `<=`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#comparator Dashboard#comparator}
    */
    readonly comparator: string;
    /**
    * The color palette to apply to the background, same values available as palette.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_bg_color Dashboard#custom_bg_color}
    */
    readonly customBgColor?: string;
    /**
    * The color palette to apply to the foreground, same values available as palette.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_fg_color Dashboard#custom_fg_color}
    */
    readonly customFgColor?: string;
    /**
    * Setting this to True hides values.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#hide_value Dashboard#hide_value}
    */
    readonly hideValue?: boolean | cdktf.IResolvable;
    /**
    * Displays an image as the background.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#image_url Dashboard#image_url}
    */
    readonly imageUrl?: string;
    /**
    * The metric from the request to correlate with this conditional format.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
    */
    readonly metric?: string;
    /**
    * The color palette to apply. Valid values are `blue`, `custom_bg`, `custom_image`, `custom_text`, `gray_on_white`, `grey`, `green`, `orange`, `red`, `red_on_white`, `white_on_gray`, `white_on_green`, `green_on_white`, `white_on_red`, `white_on_yellow`, `yellow_on_white`, `black_on_light_yellow`, `black_on_light_green`, `black_on_light_red`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
    */
    readonly palette: string;
    /**
    * Defines the displayed timeframe.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#timeframe Dashboard#timeframe}
    */
    readonly timeframe?: string;
    /**
    * A value for the comparator.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#value Dashboard#value}
    */
    readonly value: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaConditionalFormatsToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaConditionalFormats | cdktf.IResolvable): any;
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaConditionalFormatsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaConditionalFormats | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaConditionalFormats | cdktf.IResolvable | undefined);
    private _comparator?;
    get comparator(): string;
    set comparator(value: string);
    get comparatorInput(): string | undefined;
    private _customBgColor?;
    get customBgColor(): string;
    set customBgColor(value: string);
    resetCustomBgColor(): void;
    get customBgColorInput(): string | undefined;
    private _customFgColor?;
    get customFgColor(): string;
    set customFgColor(value: string);
    resetCustomFgColor(): void;
    get customFgColorInput(): string | undefined;
    private _hideValue?;
    get hideValue(): boolean | cdktf.IResolvable;
    set hideValue(value: boolean | cdktf.IResolvable);
    resetHideValue(): void;
    get hideValueInput(): boolean | cdktf.IResolvable | undefined;
    private _imageUrl?;
    get imageUrl(): string;
    set imageUrl(value: string);
    resetImageUrl(): void;
    get imageUrlInput(): string | undefined;
    private _metric?;
    get metric(): string;
    set metric(value: string);
    resetMetric(): void;
    get metricInput(): string | undefined;
    private _palette?;
    get palette(): string;
    set palette(value: string);
    get paletteInput(): string | undefined;
    private _timeframe?;
    get timeframe(): string;
    set timeframe(value: string);
    resetTimeframe(): void;
    get timeframeInput(): string | undefined;
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
}
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaConditionalFormatsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaConditionalFormats[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaConditionalFormatsOutputReference;
}
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaLimit {
    /**
    * The number of results to return
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#count Dashboard#count}
    */
    readonly count?: number;
    /**
    * The direction of the sort. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
    */
    readonly order?: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaLimitToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaLimitOutputReference | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaLimit): any;
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaLimitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaLimit | undefined;
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaLimit | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    resetCount(): void;
    get countInput(): number | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    resetOrder(): void;
    get orderInput(): string | undefined;
}
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaStyle {
    /**
    * The color palette used to display the formula. A guide to the available color palettes can be found at https://docs.datadoghq.com/dashboards/guide/widget_colors
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
    */
    readonly palette?: string;
    /**
    * Index specifying which color to use within the palette.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette_index Dashboard#palette_index}
    */
    readonly paletteIndex?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaStyleToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaStyleOutputReference | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaStyle): any;
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaStyleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaStyle | undefined;
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaStyle | undefined);
    private _palette?;
    get palette(): string;
    set palette(value: string);
    resetPalette(): void;
    get paletteInput(): string | undefined;
    private _paletteIndex?;
    get paletteIndex(): number;
    set paletteIndex(value: number);
    resetPaletteIndex(): void;
    get paletteIndexInput(): number | undefined;
}
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormula {
    /**
    * An expression alias.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alias Dashboard#alias}
    */
    readonly alias?: string;
    /**
    * A list of display modes for each table cell. Valid values are `number`, `bar`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#cell_display_mode Dashboard#cell_display_mode}
    */
    readonly cellDisplayMode?: string;
    /**
    * A string expression built from queries, formulas, and functions.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#formula_expression Dashboard#formula_expression}
    */
    readonly formulaExpression: string;
    /**
    * conditional_formats block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#conditional_formats Dashboard#conditional_formats}
    */
    readonly conditionalFormats?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaConditionalFormats[] | cdktf.IResolvable;
    /**
    * limit block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaLimit;
    /**
    * style block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#style Dashboard#style}
    */
    readonly style?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaStyle;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormula | cdktf.IResolvable): any;
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormula | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormula | cdktf.IResolvable | undefined);
    private _alias?;
    get alias(): string;
    set alias(value: string);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    private _cellDisplayMode?;
    get cellDisplayMode(): string;
    set cellDisplayMode(value: string);
    resetCellDisplayMode(): void;
    get cellDisplayModeInput(): string | undefined;
    private _formulaExpression?;
    get formulaExpression(): string;
    set formulaExpression(value: string);
    get formulaExpressionInput(): string | undefined;
    private _conditionalFormats;
    get conditionalFormats(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaConditionalFormatsList;
    putConditionalFormats(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaConditionalFormats[] | cdktf.IResolvable): void;
    resetConditionalFormats(): void;
    get conditionalFormatsInput(): cdktf.IResolvable | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaConditionalFormats[] | undefined;
    private _limit;
    get limit(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaLimitOutputReference;
    putLimit(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaLimit): void;
    resetLimit(): void;
    get limitInput(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaLimit | undefined;
    private _style;
    get style(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaStyleOutputReference;
    putStyle(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaStyle): void;
    resetStyle(): void;
    get styleInput(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaStyle | undefined;
}
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormula[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestFormulaOutputReference;
}
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryComputeQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryComputeQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryComputeQueryOutputReference | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryComputeQuery): any;
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryComputeQuery | undefined;
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryComputeQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBySortQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Widget sorting methods. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
    */
    readonly order: string;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBySortQueryOutputReference | DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBySortQuery): any;
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBySortQuery | undefined;
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBySortQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    get orderInput(): string | undefined;
}
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBy {
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * The maximum number of items in the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * sort_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
    */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBySortQuery;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupByToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBy | cdktf.IResolvable): any;
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupByOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBy | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBy | cdktf.IResolvable | undefined);
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _sortQuery;
    get sortQuery(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBySortQueryOutputReference;
    putSortQuery(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBySortQuery): void;
    resetSortQuery(): void;
    get sortQueryInput(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBySortQuery | undefined;
}
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupByList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupByOutputReference;
}
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryMultiCompute {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryMultiComputeToTerraform(struct?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryMultiCompute | cdktf.IResolvable): any;
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryMultiComputeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryMultiCompute | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryMultiCompute | cdktf.IResolvable | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryMultiComputeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryMultiComputeOutputReference;
}
