import * as cdktf from 'cdktf';
import { DashboardWidgetQueryTableDefinitionRequestApmQuery, DashboardWidgetQueryTableDefinitionRequestApmQueryOutputReference, DashboardWidgetQueryTableDefinitionRequestApmStatsQuery, DashboardWidgetQueryTableDefinitionRequestApmStatsQueryOutputReference, DashboardWidgetQueryTableDefinitionCustomLink, DashboardWidgetQueryTableDefinitionCustomLinkList } from './structs2000';
export interface DashboardWidgetQueryTableDefinitionRequestConditionalFormats {
    /**
    * The comparator to use. Valid values are `>`, `>=`, `<`, `<=`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#comparator Dashboard#comparator}
    */
    readonly comparator: string;
    /**
    * The color palette to apply to the background, same values available as palette.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_bg_color Dashboard#custom_bg_color}
    */
    readonly customBgColor?: string;
    /**
    * The color palette to apply to the foreground, same values available as palette.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_fg_color Dashboard#custom_fg_color}
    */
    readonly customFgColor?: string;
    /**
    * Setting this to True hides values.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#hide_value Dashboard#hide_value}
    */
    readonly hideValue?: boolean | cdktf.IResolvable;
    /**
    * Displays an image as the background.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#image_url Dashboard#image_url}
    */
    readonly imageUrl?: string;
    /**
    * The metric from the request to correlate with this conditional format.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
    */
    readonly metric?: string;
    /**
    * The color palette to apply. Valid values are `blue`, `custom_bg`, `custom_image`, `custom_text`, `gray_on_white`, `grey`, `green`, `orange`, `red`, `red_on_white`, `white_on_gray`, `white_on_green`, `green_on_white`, `white_on_red`, `white_on_yellow`, `yellow_on_white`, `black_on_light_yellow`, `black_on_light_green`, `black_on_light_red`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
    */
    readonly palette: string;
    /**
    * Defines the displayed timeframe.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#timeframe Dashboard#timeframe}
    */
    readonly timeframe?: string;
    /**
    * A value for the comparator.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#value Dashboard#value}
    */
    readonly value: number;
}
export declare function dashboardWidgetQueryTableDefinitionRequestConditionalFormatsToTerraform(struct?: DashboardWidgetQueryTableDefinitionRequestConditionalFormats | cdktf.IResolvable): any;
export declare class DashboardWidgetQueryTableDefinitionRequestConditionalFormatsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetQueryTableDefinitionRequestConditionalFormats | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetQueryTableDefinitionRequestConditionalFormats | cdktf.IResolvable | undefined);
    private _comparator?;
    get comparator(): string;
    set comparator(value: string);
    get comparatorInput(): string | undefined;
    private _customBgColor?;
    get customBgColor(): string;
    set customBgColor(value: string);
    resetCustomBgColor(): void;
    get customBgColorInput(): string | undefined;
    private _customFgColor?;
    get customFgColor(): string;
    set customFgColor(value: string);
    resetCustomFgColor(): void;
    get customFgColorInput(): string | undefined;
    private _hideValue?;
    get hideValue(): boolean | cdktf.IResolvable;
    set hideValue(value: boolean | cdktf.IResolvable);
    resetHideValue(): void;
    get hideValueInput(): boolean | cdktf.IResolvable | undefined;
    private _imageUrl?;
    get imageUrl(): string;
    set imageUrl(value: string);
    resetImageUrl(): void;
    get imageUrlInput(): string | undefined;
    private _metric?;
    get metric(): string;
    set metric(value: string);
    resetMetric(): void;
    get metricInput(): string | undefined;
    private _palette?;
    get palette(): string;
    set palette(value: string);
    get paletteInput(): string | undefined;
    private _timeframe?;
    get timeframe(): string;
    set timeframe(value: string);
    resetTimeframe(): void;
    get timeframeInput(): string | undefined;
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
}
export declare class DashboardWidgetQueryTableDefinitionRequestConditionalFormatsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetQueryTableDefinitionRequestConditionalFormats[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetQueryTableDefinitionRequestConditionalFormatsOutputReference;
}
export interface DashboardWidgetQueryTableDefinitionRequestFormulaConditionalFormats {
    /**
    * The comparator to use. Valid values are `>`, `>=`, `<`, `<=`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#comparator Dashboard#comparator}
    */
    readonly comparator: string;
    /**
    * The color palette to apply to the background, same values available as palette.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_bg_color Dashboard#custom_bg_color}
    */
    readonly customBgColor?: string;
    /**
    * The color palette to apply to the foreground, same values available as palette.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_fg_color Dashboard#custom_fg_color}
    */
    readonly customFgColor?: string;
    /**
    * Setting this to True hides values.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#hide_value Dashboard#hide_value}
    */
    readonly hideValue?: boolean | cdktf.IResolvable;
    /**
    * Displays an image as the background.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#image_url Dashboard#image_url}
    */
    readonly imageUrl?: string;
    /**
    * The metric from the request to correlate with this conditional format.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
    */
    readonly metric?: string;
    /**
    * The color palette to apply. Valid values are `blue`, `custom_bg`, `custom_image`, `custom_text`, `gray_on_white`, `grey`, `green`, `orange`, `red`, `red_on_white`, `white_on_gray`, `white_on_green`, `green_on_white`, `white_on_red`, `white_on_yellow`, `yellow_on_white`, `black_on_light_yellow`, `black_on_light_green`, `black_on_light_red`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
    */
    readonly palette: string;
    /**
    * Defines the displayed timeframe.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#timeframe Dashboard#timeframe}
    */
    readonly timeframe?: string;
    /**
    * A value for the comparator.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#value Dashboard#value}
    */
    readonly value: number;
}
export declare function dashboardWidgetQueryTableDefinitionRequestFormulaConditionalFormatsToTerraform(struct?: DashboardWidgetQueryTableDefinitionRequestFormulaConditionalFormats | cdktf.IResolvable): any;
export declare class DashboardWidgetQueryTableDefinitionRequestFormulaConditionalFormatsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetQueryTableDefinitionRequestFormulaConditionalFormats | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetQueryTableDefinitionRequestFormulaConditionalFormats | cdktf.IResolvable | undefined);
    private _comparator?;
    get comparator(): string;
    set comparator(value: string);
    get comparatorInput(): string | undefined;
    private _customBgColor?;
    get customBgColor(): string;
    set customBgColor(value: string);
    resetCustomBgColor(): void;
    get customBgColorInput(): string | undefined;
    private _customFgColor?;
    get customFgColor(): string;
    set customFgColor(value: string);
    resetCustomFgColor(): void;
    get customFgColorInput(): string | undefined;
    private _hideValue?;
    get hideValue(): boolean | cdktf.IResolvable;
    set hideValue(value: boolean | cdktf.IResolvable);
    resetHideValue(): void;
    get hideValueInput(): boolean | cdktf.IResolvable | undefined;
    private _imageUrl?;
    get imageUrl(): string;
    set imageUrl(value: string);
    resetImageUrl(): void;
    get imageUrlInput(): string | undefined;
    private _metric?;
    get metric(): string;
    set metric(value: string);
    resetMetric(): void;
    get metricInput(): string | undefined;
    private _palette?;
    get palette(): string;
    set palette(value: string);
    get paletteInput(): string | undefined;
    private _timeframe?;
    get timeframe(): string;
    set timeframe(value: string);
    resetTimeframe(): void;
    get timeframeInput(): string | undefined;
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
}
export declare class DashboardWidgetQueryTableDefinitionRequestFormulaConditionalFormatsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetQueryTableDefinitionRequestFormulaConditionalFormats[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetQueryTableDefinitionRequestFormulaConditionalFormatsOutputReference;
}
export interface DashboardWidgetQueryTableDefinitionRequestFormulaLimit {
    /**
    * The number of results to return
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#count Dashboard#count}
    */
    readonly count?: number;
    /**
    * The direction of the sort. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
    */
    readonly order?: string;
}
export declare function dashboardWidgetQueryTableDefinitionRequestFormulaLimitToTerraform(struct?: DashboardWidgetQueryTableDefinitionRequestFormulaLimitOutputReference | DashboardWidgetQueryTableDefinitionRequestFormulaLimit): any;
export declare class DashboardWidgetQueryTableDefinitionRequestFormulaLimitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryTableDefinitionRequestFormulaLimit | undefined;
    set internalValue(value: DashboardWidgetQueryTableDefinitionRequestFormulaLimit | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    resetCount(): void;
    get countInput(): number | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    resetOrder(): void;
    get orderInput(): string | undefined;
}
export interface DashboardWidgetQueryTableDefinitionRequestFormulaStyle {
    /**
    * The color palette used to display the formula. A guide to the available color palettes can be found at https://docs.datadoghq.com/dashboards/guide/widget_colors
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
    */
    readonly palette?: string;
    /**
    * Index specifying which color to use within the palette.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette_index Dashboard#palette_index}
    */
    readonly paletteIndex?: number;
}
export declare function dashboardWidgetQueryTableDefinitionRequestFormulaStyleToTerraform(struct?: DashboardWidgetQueryTableDefinitionRequestFormulaStyleOutputReference | DashboardWidgetQueryTableDefinitionRequestFormulaStyle): any;
export declare class DashboardWidgetQueryTableDefinitionRequestFormulaStyleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryTableDefinitionRequestFormulaStyle | undefined;
    set internalValue(value: DashboardWidgetQueryTableDefinitionRequestFormulaStyle | undefined);
    private _palette?;
    get palette(): string;
    set palette(value: string);
    resetPalette(): void;
    get paletteInput(): string | undefined;
    private _paletteIndex?;
    get paletteIndex(): number;
    set paletteIndex(value: number);
    resetPaletteIndex(): void;
    get paletteIndexInput(): number | undefined;
}
export interface DashboardWidgetQueryTableDefinitionRequestFormula {
    /**
    * An expression alias.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alias Dashboard#alias}
    */
    readonly alias?: string;
    /**
    * A list of display modes for each table cell. Valid values are `number`, `bar`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#cell_display_mode Dashboard#cell_display_mode}
    */
    readonly cellDisplayMode?: string;
    /**
    * A string expression built from queries, formulas, and functions.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#formula_expression Dashboard#formula_expression}
    */
    readonly formulaExpression: string;
    /**
    * conditional_formats block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#conditional_formats Dashboard#conditional_formats}
    */
    readonly conditionalFormats?: DashboardWidgetQueryTableDefinitionRequestFormulaConditionalFormats[] | cdktf.IResolvable;
    /**
    * limit block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: DashboardWidgetQueryTableDefinitionRequestFormulaLimit;
    /**
    * style block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#style Dashboard#style}
    */
    readonly style?: DashboardWidgetQueryTableDefinitionRequestFormulaStyle;
}
export declare function dashboardWidgetQueryTableDefinitionRequestFormulaToTerraform(struct?: DashboardWidgetQueryTableDefinitionRequestFormula | cdktf.IResolvable): any;
export declare class DashboardWidgetQueryTableDefinitionRequestFormulaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetQueryTableDefinitionRequestFormula | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetQueryTableDefinitionRequestFormula | cdktf.IResolvable | undefined);
    private _alias?;
    get alias(): string;
    set alias(value: string);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    private _cellDisplayMode?;
    get cellDisplayMode(): string;
    set cellDisplayMode(value: string);
    resetCellDisplayMode(): void;
    get cellDisplayModeInput(): string | undefined;
    private _formulaExpression?;
    get formulaExpression(): string;
    set formulaExpression(value: string);
    get formulaExpressionInput(): string | undefined;
    private _conditionalFormats;
    get conditionalFormats(): DashboardWidgetQueryTableDefinitionRequestFormulaConditionalFormatsList;
    putConditionalFormats(value: DashboardWidgetQueryTableDefinitionRequestFormulaConditionalFormats[] | cdktf.IResolvable): void;
    resetConditionalFormats(): void;
    get conditionalFormatsInput(): cdktf.IResolvable | DashboardWidgetQueryTableDefinitionRequestFormulaConditionalFormats[] | undefined;
    private _limit;
    get limit(): DashboardWidgetQueryTableDefinitionRequestFormulaLimitOutputReference;
    putLimit(value: DashboardWidgetQueryTableDefinitionRequestFormulaLimit): void;
    resetLimit(): void;
    get limitInput(): DashboardWidgetQueryTableDefinitionRequestFormulaLimit | undefined;
    private _style;
    get style(): DashboardWidgetQueryTableDefinitionRequestFormulaStyleOutputReference;
    putStyle(value: DashboardWidgetQueryTableDefinitionRequestFormulaStyle): void;
    resetStyle(): void;
    get styleInput(): DashboardWidgetQueryTableDefinitionRequestFormulaStyle | undefined;
}
export declare class DashboardWidgetQueryTableDefinitionRequestFormulaList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetQueryTableDefinitionRequestFormula[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetQueryTableDefinitionRequestFormulaOutputReference;
}
export interface DashboardWidgetQueryTableDefinitionRequestLogQueryComputeQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetQueryTableDefinitionRequestLogQueryComputeQueryToTerraform(struct?: DashboardWidgetQueryTableDefinitionRequestLogQueryComputeQueryOutputReference | DashboardWidgetQueryTableDefinitionRequestLogQueryComputeQuery): any;
export declare class DashboardWidgetQueryTableDefinitionRequestLogQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryTableDefinitionRequestLogQueryComputeQuery | undefined;
    set internalValue(value: DashboardWidgetQueryTableDefinitionRequestLogQueryComputeQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export interface DashboardWidgetQueryTableDefinitionRequestLogQueryGroupBySortQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Widget sorting methods. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
    */
    readonly order: string;
}
export declare function dashboardWidgetQueryTableDefinitionRequestLogQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetQueryTableDefinitionRequestLogQueryGroupBySortQueryOutputReference | DashboardWidgetQueryTableDefinitionRequestLogQueryGroupBySortQuery): any;
export declare class DashboardWidgetQueryTableDefinitionRequestLogQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryTableDefinitionRequestLogQueryGroupBySortQuery | undefined;
    set internalValue(value: DashboardWidgetQueryTableDefinitionRequestLogQueryGroupBySortQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    get orderInput(): string | undefined;
}
export interface DashboardWidgetQueryTableDefinitionRequestLogQueryGroupBy {
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * The maximum number of items in the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * sort_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
    */
    readonly sortQuery?: DashboardWidgetQueryTableDefinitionRequestLogQueryGroupBySortQuery;
}
export declare function dashboardWidgetQueryTableDefinitionRequestLogQueryGroupByToTerraform(struct?: DashboardWidgetQueryTableDefinitionRequestLogQueryGroupBy | cdktf.IResolvable): any;
export declare class DashboardWidgetQueryTableDefinitionRequestLogQueryGroupByOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetQueryTableDefinitionRequestLogQueryGroupBy | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetQueryTableDefinitionRequestLogQueryGroupBy | cdktf.IResolvable | undefined);
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _sortQuery;
    get sortQuery(): DashboardWidgetQueryTableDefinitionRequestLogQueryGroupBySortQueryOutputReference;
    putSortQuery(value: DashboardWidgetQueryTableDefinitionRequestLogQueryGroupBySortQuery): void;
    resetSortQuery(): void;
    get sortQueryInput(): DashboardWidgetQueryTableDefinitionRequestLogQueryGroupBySortQuery | undefined;
}
export declare class DashboardWidgetQueryTableDefinitionRequestLogQueryGroupByList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetQueryTableDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetQueryTableDefinitionRequestLogQueryGroupByOutputReference;
}
export interface DashboardWidgetQueryTableDefinitionRequestLogQueryMultiCompute {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetQueryTableDefinitionRequestLogQueryMultiComputeToTerraform(struct?: DashboardWidgetQueryTableDefinitionRequestLogQueryMultiCompute | cdktf.IResolvable): any;
export declare class DashboardWidgetQueryTableDefinitionRequestLogQueryMultiComputeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetQueryTableDefinitionRequestLogQueryMultiCompute | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetQueryTableDefinitionRequestLogQueryMultiCompute | cdktf.IResolvable | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export declare class DashboardWidgetQueryTableDefinitionRequestLogQueryMultiComputeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetQueryTableDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetQueryTableDefinitionRequestLogQueryMultiComputeOutputReference;
}
export interface DashboardWidgetQueryTableDefinitionRequestLogQuery {
    /**
    * The name of the index to query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
    */
    readonly index: string;
    /**
    * The search query to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
    */
    readonly searchQuery?: string;
    /**
    * compute_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
    */
    readonly computeQuery?: DashboardWidgetQueryTableDefinitionRequestLogQueryComputeQuery;
    /**
    * group_by block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
    */
    readonly groupBy?: DashboardWidgetQueryTableDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable;
    /**
    * multi_compute block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
    */
    readonly multiCompute?: DashboardWidgetQueryTableDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetQueryTableDefinitionRequestLogQueryToTerraform(struct?: DashboardWidgetQueryTableDefinitionRequestLogQueryOutputReference | DashboardWidgetQueryTableDefinitionRequestLogQuery): any;
export declare class DashboardWidgetQueryTableDefinitionRequestLogQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryTableDefinitionRequestLogQuery | undefined;
    set internalValue(value: DashboardWidgetQueryTableDefinitionRequestLogQuery | undefined);
    private _index?;
    get index(): string;
    set index(value: string);
    get indexInput(): string | undefined;
    private _searchQuery?;
    get searchQuery(): string;
    set searchQuery(value: string);
    resetSearchQuery(): void;
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    get computeQuery(): DashboardWidgetQueryTableDefinitionRequestLogQueryComputeQueryOutputReference;
    putComputeQuery(value: DashboardWidgetQueryTableDefinitionRequestLogQueryComputeQuery): void;
    resetComputeQuery(): void;
    get computeQueryInput(): DashboardWidgetQueryTableDefinitionRequestLogQueryComputeQuery | undefined;
    private _groupBy;
    get groupBy(): DashboardWidgetQueryTableDefinitionRequestLogQueryGroupByList;
    putGroupBy(value: DashboardWidgetQueryTableDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable): void;
    resetGroupBy(): void;
    get groupByInput(): cdktf.IResolvable | DashboardWidgetQueryTableDefinitionRequestLogQueryGroupBy[] | undefined;
    private _multiCompute;
    get multiCompute(): DashboardWidgetQueryTableDefinitionRequestLogQueryMultiComputeList;
    putMultiCompute(value: DashboardWidgetQueryTableDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable): void;
    resetMultiCompute(): void;
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetQueryTableDefinitionRequestLogQueryMultiCompute[] | undefined;
}
export interface DashboardWidgetQueryTableDefinitionRequestProcessQuery {
    /**
    * A list of processes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#filter_by Dashboard#filter_by}
    */
    readonly filterBy?: string[];
    /**
    * The max number of items in the filter list.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * Your chosen metric.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
    */
    readonly metric: string;
    /**
    * Your chosen search term.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_by Dashboard#search_by}
    */
    readonly searchBy?: string;
}
export declare function dashboardWidgetQueryTableDefinitionRequestProcessQueryToTerraform(struct?: DashboardWidgetQueryTableDefinitionRequestProcessQueryOutputReference | DashboardWidgetQueryTableDefinitionRequestProcessQuery): any;
export declare class DashboardWidgetQueryTableDefinitionRequestProcessQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryTableDefinitionRequestProcessQuery | undefined;
    set internalValue(value: DashboardWidgetQueryTableDefinitionRequestProcessQuery | undefined);
    private _filterBy?;
    get filterBy(): string[];
    set filterBy(value: string[]);
    resetFilterBy(): void;
    get filterByInput(): string[] | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _metric?;
    get metric(): string;
    set metric(value: string);
    get metricInput(): string | undefined;
    private _searchBy?;
    get searchBy(): string;
    set searchBy(value: string);
    resetSearchBy(): void;
    get searchByInput(): string | undefined;
}
export interface DashboardWidgetQueryTableDefinitionRequestQueryApmDependencyStatsQuery {
    /**
    * The data source for APM Dependency Stats queries. Valid values are `apm_dependency_stats`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
    */
    readonly dataSource: string;
    /**
    * APM Environment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#env Dashboard#env}
    */
    readonly env: string;
    /**
    * Determines whether stats for upstream or downstream dependencies should be queried.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_upstream Dashboard#is_upstream}
    */
    readonly isUpstream?: boolean | cdktf.IResolvable;
    /**
    * The name of query for use in formulas.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
    */
    readonly name: string;
    /**
    * Name of operation on service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#operation_name Dashboard#operation_name}
    */
    readonly operationName: string;
    /**
    * The name of the second primary tag used within APM; required when `primary_tag_value` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_name Dashboard#primary_tag_name}
    */
    readonly primaryTagName?: string;
    /**
    * Filter APM data by the second primary tag. `primary_tag_name` must also be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_value Dashboard#primary_tag_value}
    */
    readonly primaryTagValue?: string;
    /**
    * APM resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#resource_name Dashboard#resource_name}
    */
    readonly resourceName: string;
    /**
    * APM service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service Dashboard#service}
    */
    readonly service: string;
    /**
    * APM statistic. Valid values are `avg_duration`, `avg_root_duration`, `avg_spans_per_trace`, `error_rate`, `pct_exec_time`, `pct_of_traces`, `total_traces_count`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#stat Dashboard#stat}
    */
    readonly stat: string;
}
export declare function dashboardWidgetQueryTableDefinitionRequestQueryApmDependencyStatsQueryToTerraform(struct?: DashboardWidgetQueryTableDefinitionRequestQueryApmDependencyStatsQueryOutputReference | DashboardWidgetQueryTableDefinitionRequestQueryApmDependencyStatsQuery): any;
export declare class DashboardWidgetQueryTableDefinitionRequestQueryApmDependencyStatsQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryTableDefinitionRequestQueryApmDependencyStatsQuery | undefined;
    set internalValue(value: DashboardWidgetQueryTableDefinitionRequestQueryApmDependencyStatsQuery | undefined);
    private _dataSource?;
    get dataSource(): string;
    set dataSource(value: string);
    get dataSourceInput(): string | undefined;
    private _env?;
    get env(): string;
    set env(value: string);
    get envInput(): string | undefined;
    private _isUpstream?;
    get isUpstream(): boolean | cdktf.IResolvable;
    set isUpstream(value: boolean | cdktf.IResolvable);
    resetIsUpstream(): void;
    get isUpstreamInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _operationName?;
    get operationName(): string;
    set operationName(value: string);
    get operationNameInput(): string | undefined;
    private _primaryTagName?;
    get primaryTagName(): string;
    set primaryTagName(value: string);
    resetPrimaryTagName(): void;
    get primaryTagNameInput(): string | undefined;
    private _primaryTagValue?;
    get primaryTagValue(): string;
    set primaryTagValue(value: string);
    resetPrimaryTagValue(): void;
    get primaryTagValueInput(): string | undefined;
    private _resourceName?;
    get resourceName(): string;
    set resourceName(value: string);
    get resourceNameInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _stat?;
    get stat(): string;
    set stat(value: string);
    get statInput(): string | undefined;
}
export interface DashboardWidgetQueryTableDefinitionRequestQueryApmResourceStatsQuery {
    /**
    * The data source for APM Resource Stats queries. Valid values are `apm_resource_stats`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
    */
    readonly dataSource: string;
    /**
    * APM Environment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#env Dashboard#env}
    */
    readonly env: string;
    /**
    * Array of fields to group results by.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
    */
    readonly groupBy?: string[];
    /**
    * The name of query for use in formulas.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
    */
    readonly name: string;
    /**
    * Name of operation on service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#operation_name Dashboard#operation_name}
    */
    readonly operationName?: string;
    /**
    * The name of the second primary tag used within APM; required when `primary_tag_value` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_name Dashboard#primary_tag_name}
    */
    readonly primaryTagName?: string;
    /**
    * Filter APM data by the second primary tag. `primary_tag_name` must also be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_value Dashboard#primary_tag_value}
    */
    readonly primaryTagValue?: string;
    /**
    * APM resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#resource_name Dashboard#resource_name}
    */
    readonly resourceName?: string;
    /**
    * APM service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service Dashboard#service}
    */
    readonly service: string;
    /**
    * APM statistic. Valid values are `errors`, `error_rate`, `hits`, `latency_avg`, `latency_distribution`, `latency_max`, `latency_p50`, `latency_p75`, `latency_p90`, `latency_p95`, `latency_p99`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#stat Dashboard#stat}
    */
    readonly stat: string;
}
export declare function dashboardWidgetQueryTableDefinitionRequestQueryApmResourceStatsQueryToTerraform(struct?: DashboardWidgetQueryTableDefinitionRequestQueryApmResourceStatsQueryOutputReference | DashboardWidgetQueryTableDefinitionRequestQueryApmResourceStatsQuery): any;
export declare class DashboardWidgetQueryTableDefinitionRequestQueryApmResourceStatsQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryTableDefinitionRequestQueryApmResourceStatsQuery | undefined;
    set internalValue(value: DashboardWidgetQueryTableDefinitionRequestQueryApmResourceStatsQuery | undefined);
    private _dataSource?;
    get dataSource(): string;
    set dataSource(value: string);
    get dataSourceInput(): string | undefined;
    private _env?;
    get env(): string;
    set env(value: string);
    get envInput(): string | undefined;
    private _groupBy?;
    get groupBy(): string[];
    set groupBy(value: string[]);
    resetGroupBy(): void;
    get groupByInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _operationName?;
    get operationName(): string;
    set operationName(value: string);
    resetOperationName(): void;
    get operationNameInput(): string | undefined;
    private _primaryTagName?;
    get primaryTagName(): string;
    set primaryTagName(value: string);
    resetPrimaryTagName(): void;
    get primaryTagNameInput(): string | undefined;
    private _primaryTagValue?;
    get primaryTagValue(): string;
    set primaryTagValue(value: string);
    resetPrimaryTagValue(): void;
    get primaryTagValueInput(): string | undefined;
    private _resourceName?;
    get resourceName(): string;
    set resourceName(value: string);
    resetResourceName(): void;
    get resourceNameInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _stat?;
    get stat(): string;
    set stat(value: string);
    get statInput(): string | undefined;
}
export interface DashboardWidgetQueryTableDefinitionRequestQueryEventQueryCompute {
    /**
    * The aggregation methods for event platform queries. Valid values are `count`, `cardinality`, `median`, `pc75`, `pc90`, `pc95`, `pc98`, `pc99`, `sum`, `min`, `max`, `avg`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * A time interval in milliseconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
    /**
    * The measurable attribute to compute.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
    */
    readonly metric?: string;
}
export declare function dashboardWidgetQueryTableDefinitionRequestQueryEventQueryComputeToTerraform(struct?: DashboardWidgetQueryTableDefinitionRequestQueryEventQueryCompute | cdktf.IResolvable): any;
export declare class DashboardWidgetQueryTableDefinitionRequestQueryEventQueryComputeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetQueryTableDefinitionRequestQueryEventQueryCompute | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetQueryTableDefinitionRequestQueryEventQueryCompute | cdktf.IResolvable | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
    private _metric?;
    get metric(): string;
    set metric(value: string);
    resetMetric(): void;
    get metricInput(): string | undefined;
}
export declare class DashboardWidgetQueryTableDefinitionRequestQueryEventQueryComputeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetQueryTableDefinitionRequestQueryEventQueryCompute[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetQueryTableDefinitionRequestQueryEventQueryComputeOutputReference;
}
export interface DashboardWidgetQueryTableDefinitionRequestQueryEventQueryGroupBySort {
    /**
    * The aggregation methods for the event platform queries. Valid values are `count`, `cardinality`, `median`, `pc75`, `pc90`, `pc95`, `pc98`, `pc99`, `sum`, `min`, `max`, `avg`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The metric used for sorting group by results.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
    */
    readonly metric?: string;
    /**
    * Direction of sort. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
    */
    readonly order?: string;
}
export declare function dashboardWidgetQueryTableDefinitionRequestQueryEventQueryGroupBySortToTerraform(struct?: DashboardWidgetQueryTableDefinitionRequestQueryEventQueryGroupBySortOutputReference | DashboardWidgetQueryTableDefinitionRequestQueryEventQueryGroupBySort): any;
export declare class DashboardWidgetQueryTableDefinitionRequestQueryEventQueryGroupBySortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryTableDefinitionRequestQueryEventQueryGroupBySort | undefined;
    set internalValue(value: DashboardWidgetQueryTableDefinitionRequestQueryEventQueryGroupBySort | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _metric?;
    get metric(): string;
    set metric(value: string);
    resetMetric(): void;
    get metricInput(): string | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    resetOrder(): void;
    get orderInput(): string | undefined;
}
export interface DashboardWidgetQueryTableDefinitionRequestQueryEventQueryGroupBy {
    /**
    * The event facet.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet: string;
    /**
    * The number of groups to return.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * sort block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort Dashboard#sort}
    */
    readonly sort?: DashboardWidgetQueryTableDefinitionRequestQueryEventQueryGroupBySort;
}
export declare function dashboardWidgetQueryTableDefinitionRequestQueryEventQueryGroupByToTerraform(struct?: DashboardWidgetQueryTableDefinitionRequestQueryEventQueryGroupBy | cdktf.IResolvable): any;
export declare class DashboardWidgetQueryTableDefinitionRequestQueryEventQueryGroupByOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetQueryTableDefinitionRequestQueryEventQueryGroupBy | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetQueryTableDefinitionRequestQueryEventQueryGroupBy | cdktf.IResolvable | undefined);
    private _facet?;
    get facet(): string;
    set facet(value: string);
    get facetInput(): string | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _sort;
    get sort(): DashboardWidgetQueryTableDefinitionRequestQueryEventQueryGroupBySortOutputReference;
    putSort(value: DashboardWidgetQueryTableDefinitionRequestQueryEventQueryGroupBySort): void;
    resetSort(): void;
    get sortInput(): DashboardWidgetQueryTableDefinitionRequestQueryEventQueryGroupBySort | undefined;
}
export declare class DashboardWidgetQueryTableDefinitionRequestQueryEventQueryGroupByList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetQueryTableDefinitionRequestQueryEventQueryGroupBy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetQueryTableDefinitionRequestQueryEventQueryGroupByOutputReference;
}
export interface DashboardWidgetQueryTableDefinitionRequestQueryEventQuerySearch {
    /**
    * The events search string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
    */
    readonly query: string;
}
export declare function dashboardWidgetQueryTableDefinitionRequestQueryEventQuerySearchToTerraform(struct?: DashboardWidgetQueryTableDefinitionRequestQueryEventQuerySearchOutputReference | DashboardWidgetQueryTableDefinitionRequestQueryEventQuerySearch): any;
export declare class DashboardWidgetQueryTableDefinitionRequestQueryEventQuerySearchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryTableDefinitionRequestQueryEventQuerySearch | undefined;
    set internalValue(value: DashboardWidgetQueryTableDefinitionRequestQueryEventQuerySearch | undefined);
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
}
export interface DashboardWidgetQueryTableDefinitionRequestQueryEventQuery {
    /**
    * The data source for event platform-based queries. Valid values are `logs`, `spans`, `network`, `rum`, `security_signals`, `profiles`, `audit`, `events`, `ci_tests`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
    */
    readonly dataSource: string;
    /**
    * An array of index names to query in the stream.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#indexes Dashboard#indexes}
    */
    readonly indexes?: string[];
    /**
    * The name of query for use in formulas.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
    */
    readonly name: string;
    /**
    * Storage location (private beta).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#storage Dashboard#storage}
    */
    readonly storage?: string;
    /**
    * compute block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute Dashboard#compute}
    */
    readonly compute: DashboardWidgetQueryTableDefinitionRequestQueryEventQueryCompute[] | cdktf.IResolvable;
    /**
    * group_by block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
    */
    readonly groupBy?: DashboardWidgetQueryTableDefinitionRequestQueryEventQueryGroupBy[] | cdktf.IResolvable;
    /**
    * search block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search Dashboard#search}
    */
    readonly search?: DashboardWidgetQueryTableDefinitionRequestQueryEventQuerySearch;
}
export declare function dashboardWidgetQueryTableDefinitionRequestQueryEventQueryToTerraform(struct?: DashboardWidgetQueryTableDefinitionRequestQueryEventQueryOutputReference | DashboardWidgetQueryTableDefinitionRequestQueryEventQuery): any;
export declare class DashboardWidgetQueryTableDefinitionRequestQueryEventQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryTableDefinitionRequestQueryEventQuery | undefined;
    set internalValue(value: DashboardWidgetQueryTableDefinitionRequestQueryEventQuery | undefined);
    private _dataSource?;
    get dataSource(): string;
    set dataSource(value: string);
    get dataSourceInput(): string | undefined;
    private _indexes?;
    get indexes(): string[];
    set indexes(value: string[]);
    resetIndexes(): void;
    get indexesInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _storage?;
    get storage(): string;
    set storage(value: string);
    resetStorage(): void;
    get storageInput(): string | undefined;
    private _compute;
    get compute(): DashboardWidgetQueryTableDefinitionRequestQueryEventQueryComputeList;
    putCompute(value: DashboardWidgetQueryTableDefinitionRequestQueryEventQueryCompute[] | cdktf.IResolvable): void;
    get computeInput(): cdktf.IResolvable | DashboardWidgetQueryTableDefinitionRequestQueryEventQueryCompute[] | undefined;
    private _groupBy;
    get groupBy(): DashboardWidgetQueryTableDefinitionRequestQueryEventQueryGroupByList;
    putGroupBy(value: DashboardWidgetQueryTableDefinitionRequestQueryEventQueryGroupBy[] | cdktf.IResolvable): void;
    resetGroupBy(): void;
    get groupByInput(): cdktf.IResolvable | DashboardWidgetQueryTableDefinitionRequestQueryEventQueryGroupBy[] | undefined;
    private _search;
    get search(): DashboardWidgetQueryTableDefinitionRequestQueryEventQuerySearchOutputReference;
    putSearch(value: DashboardWidgetQueryTableDefinitionRequestQueryEventQuerySearch): void;
    resetSearch(): void;
    get searchInput(): DashboardWidgetQueryTableDefinitionRequestQueryEventQuerySearch | undefined;
}
export interface DashboardWidgetQueryTableDefinitionRequestQueryMetricQuery {
    /**
    * The aggregation methods available for metrics queries. Valid values are `avg`, `min`, `max`, `sum`, `last`, `area`, `l2norm`, `percentile`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregator Dashboard#aggregator}
    */
    readonly aggregator?: string;
    /**
    * The data source for metrics queries.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
    */
    readonly dataSource?: string;
    /**
    * The name of the query for use in formulas.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
    */
    readonly name: string;
    /**
    * The metrics query definition.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
    */
    readonly query: string;
}
export declare function dashboardWidgetQueryTableDefinitionRequestQueryMetricQueryToTerraform(struct?: DashboardWidgetQueryTableDefinitionRequestQueryMetricQueryOutputReference | DashboardWidgetQueryTableDefinitionRequestQueryMetricQuery): any;
export declare class DashboardWidgetQueryTableDefinitionRequestQueryMetricQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryTableDefinitionRequestQueryMetricQuery | undefined;
    set internalValue(value: DashboardWidgetQueryTableDefinitionRequestQueryMetricQuery | undefined);
    private _aggregator?;
    get aggregator(): string;
    set aggregator(value: string);
    resetAggregator(): void;
    get aggregatorInput(): string | undefined;
    private _dataSource?;
    get dataSource(): string;
    set dataSource(value: string);
    resetDataSource(): void;
    get dataSourceInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
}
export interface DashboardWidgetQueryTableDefinitionRequestQueryProcessQuery {
    /**
    * The aggregation methods available for metrics queries. Valid values are `avg`, `min`, `max`, `sum`, `last`, `area`, `l2norm`, `percentile`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregator Dashboard#aggregator}
    */
    readonly aggregator?: string;
    /**
    * The data source for process queries. Valid values are `process`, `container`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
    */
    readonly dataSource: string;
    /**
    * Whether to normalize the CPU percentages.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_normalized_cpu Dashboard#is_normalized_cpu}
    */
    readonly isNormalizedCpu?: boolean | cdktf.IResolvable;
    /**
    * The number of hits to return.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * The process metric name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
    */
    readonly metric: string;
    /**
    * The name of query for use in formulas.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
    */
    readonly name: string;
    /**
    * The direction of the sort. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort Dashboard#sort}
    */
    readonly sort?: string;
    /**
    * An array of tags to filter by.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#tag_filters Dashboard#tag_filters}
    */
    readonly tagFilters?: string[];
    /**
    * The text to use as a filter.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#text_filter Dashboard#text_filter}
    */
    readonly textFilter?: string;
}
export declare function dashboardWidgetQueryTableDefinitionRequestQueryProcessQueryToTerraform(struct?: DashboardWidgetQueryTableDefinitionRequestQueryProcessQueryOutputReference | DashboardWidgetQueryTableDefinitionRequestQueryProcessQuery): any;
export declare class DashboardWidgetQueryTableDefinitionRequestQueryProcessQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryTableDefinitionRequestQueryProcessQuery | undefined;
    set internalValue(value: DashboardWidgetQueryTableDefinitionRequestQueryProcessQuery | undefined);
    private _aggregator?;
    get aggregator(): string;
    set aggregator(value: string);
    resetAggregator(): void;
    get aggregatorInput(): string | undefined;
    private _dataSource?;
    get dataSource(): string;
    set dataSource(value: string);
    get dataSourceInput(): string | undefined;
    private _isNormalizedCpu?;
    get isNormalizedCpu(): boolean | cdktf.IResolvable;
    set isNormalizedCpu(value: boolean | cdktf.IResolvable);
    resetIsNormalizedCpu(): void;
    get isNormalizedCpuInput(): boolean | cdktf.IResolvable | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _metric?;
    get metric(): string;
    set metric(value: string);
    get metricInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _sort?;
    get sort(): string;
    set sort(value: string);
    resetSort(): void;
    get sortInput(): string | undefined;
    private _tagFilters?;
    get tagFilters(): string[];
    set tagFilters(value: string[]);
    resetTagFilters(): void;
    get tagFiltersInput(): string[] | undefined;
    private _textFilter?;
    get textFilter(): string;
    set textFilter(value: string);
    resetTextFilter(): void;
    get textFilterInput(): string | undefined;
}
export interface DashboardWidgetQueryTableDefinitionRequestQuery {
    /**
    * apm_dependency_stats_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_dependency_stats_query Dashboard#apm_dependency_stats_query}
    */
    readonly apmDependencyStatsQuery?: DashboardWidgetQueryTableDefinitionRequestQueryApmDependencyStatsQuery;
    /**
    * apm_resource_stats_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_resource_stats_query Dashboard#apm_resource_stats_query}
    */
    readonly apmResourceStatsQuery?: DashboardWidgetQueryTableDefinitionRequestQueryApmResourceStatsQuery;
    /**
    * event_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#event_query Dashboard#event_query}
    */
    readonly eventQuery?: DashboardWidgetQueryTableDefinitionRequestQueryEventQuery;
    /**
    * metric_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric_query Dashboard#metric_query}
    */
    readonly metricQuery?: DashboardWidgetQueryTableDefinitionRequestQueryMetricQuery;
    /**
    * process_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#process_query Dashboard#process_query}
    */
    readonly processQuery?: DashboardWidgetQueryTableDefinitionRequestQueryProcessQuery;
}
export declare function dashboardWidgetQueryTableDefinitionRequestQueryToTerraform(struct?: DashboardWidgetQueryTableDefinitionRequestQuery | cdktf.IResolvable): any;
export declare class DashboardWidgetQueryTableDefinitionRequestQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetQueryTableDefinitionRequestQuery | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetQueryTableDefinitionRequestQuery | cdktf.IResolvable | undefined);
    private _apmDependencyStatsQuery;
    get apmDependencyStatsQuery(): DashboardWidgetQueryTableDefinitionRequestQueryApmDependencyStatsQueryOutputReference;
    putApmDependencyStatsQuery(value: DashboardWidgetQueryTableDefinitionRequestQueryApmDependencyStatsQuery): void;
    resetApmDependencyStatsQuery(): void;
    get apmDependencyStatsQueryInput(): DashboardWidgetQueryTableDefinitionRequestQueryApmDependencyStatsQuery | undefined;
    private _apmResourceStatsQuery;
    get apmResourceStatsQuery(): DashboardWidgetQueryTableDefinitionRequestQueryApmResourceStatsQueryOutputReference;
    putApmResourceStatsQuery(value: DashboardWidgetQueryTableDefinitionRequestQueryApmResourceStatsQuery): void;
    resetApmResourceStatsQuery(): void;
    get apmResourceStatsQueryInput(): DashboardWidgetQueryTableDefinitionRequestQueryApmResourceStatsQuery | undefined;
    private _eventQuery;
    get eventQuery(): DashboardWidgetQueryTableDefinitionRequestQueryEventQueryOutputReference;
    putEventQuery(value: DashboardWidgetQueryTableDefinitionRequestQueryEventQuery): void;
    resetEventQuery(): void;
    get eventQueryInput(): DashboardWidgetQueryTableDefinitionRequestQueryEventQuery | undefined;
    private _metricQuery;
    get metricQuery(): DashboardWidgetQueryTableDefinitionRequestQueryMetricQueryOutputReference;
    putMetricQuery(value: DashboardWidgetQueryTableDefinitionRequestQueryMetricQuery): void;
    resetMetricQuery(): void;
    get metricQueryInput(): DashboardWidgetQueryTableDefinitionRequestQueryMetricQuery | undefined;
    private _processQuery;
    get processQuery(): DashboardWidgetQueryTableDefinitionRequestQueryProcessQueryOutputReference;
    putProcessQuery(value: DashboardWidgetQueryTableDefinitionRequestQueryProcessQuery): void;
    resetProcessQuery(): void;
    get processQueryInput(): DashboardWidgetQueryTableDefinitionRequestQueryProcessQuery | undefined;
}
export declare class DashboardWidgetQueryTableDefinitionRequestQueryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetQueryTableDefinitionRequestQuery[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetQueryTableDefinitionRequestQueryOutputReference;
}
export interface DashboardWidgetQueryTableDefinitionRequestRumQueryComputeQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetQueryTableDefinitionRequestRumQueryComputeQueryToTerraform(struct?: DashboardWidgetQueryTableDefinitionRequestRumQueryComputeQueryOutputReference | DashboardWidgetQueryTableDefinitionRequestRumQueryComputeQuery): any;
export declare class DashboardWidgetQueryTableDefinitionRequestRumQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryTableDefinitionRequestRumQueryComputeQuery | undefined;
    set internalValue(value: DashboardWidgetQueryTableDefinitionRequestRumQueryComputeQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export interface DashboardWidgetQueryTableDefinitionRequestRumQueryGroupBySortQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Widget sorting methods. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
    */
    readonly order: string;
}
export declare function dashboardWidgetQueryTableDefinitionRequestRumQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetQueryTableDefinitionRequestRumQueryGroupBySortQueryOutputReference | DashboardWidgetQueryTableDefinitionRequestRumQueryGroupBySortQuery): any;
export declare class DashboardWidgetQueryTableDefinitionRequestRumQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryTableDefinitionRequestRumQueryGroupBySortQuery | undefined;
    set internalValue(value: DashboardWidgetQueryTableDefinitionRequestRumQueryGroupBySortQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    get orderInput(): string | undefined;
}
export interface DashboardWidgetQueryTableDefinitionRequestRumQueryGroupBy {
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * The maximum number of items in the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * sort_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
    */
    readonly sortQuery?: DashboardWidgetQueryTableDefinitionRequestRumQueryGroupBySortQuery;
}
export declare function dashboardWidgetQueryTableDefinitionRequestRumQueryGroupByToTerraform(struct?: DashboardWidgetQueryTableDefinitionRequestRumQueryGroupBy | cdktf.IResolvable): any;
export declare class DashboardWidgetQueryTableDefinitionRequestRumQueryGroupByOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetQueryTableDefinitionRequestRumQueryGroupBy | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetQueryTableDefinitionRequestRumQueryGroupBy | cdktf.IResolvable | undefined);
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _sortQuery;
    get sortQuery(): DashboardWidgetQueryTableDefinitionRequestRumQueryGroupBySortQueryOutputReference;
    putSortQuery(value: DashboardWidgetQueryTableDefinitionRequestRumQueryGroupBySortQuery): void;
    resetSortQuery(): void;
    get sortQueryInput(): DashboardWidgetQueryTableDefinitionRequestRumQueryGroupBySortQuery | undefined;
}
export declare class DashboardWidgetQueryTableDefinitionRequestRumQueryGroupByList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetQueryTableDefinitionRequestRumQueryGroupBy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetQueryTableDefinitionRequestRumQueryGroupByOutputReference;
}
export interface DashboardWidgetQueryTableDefinitionRequestRumQueryMultiCompute {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetQueryTableDefinitionRequestRumQueryMultiComputeToTerraform(struct?: DashboardWidgetQueryTableDefinitionRequestRumQueryMultiCompute | cdktf.IResolvable): any;
export declare class DashboardWidgetQueryTableDefinitionRequestRumQueryMultiComputeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetQueryTableDefinitionRequestRumQueryMultiCompute | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetQueryTableDefinitionRequestRumQueryMultiCompute | cdktf.IResolvable | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export declare class DashboardWidgetQueryTableDefinitionRequestRumQueryMultiComputeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetQueryTableDefinitionRequestRumQueryMultiCompute[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetQueryTableDefinitionRequestRumQueryMultiComputeOutputReference;
}
export interface DashboardWidgetQueryTableDefinitionRequestRumQuery {
    /**
    * The name of the index to query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
    */
    readonly index: string;
    /**
    * The search query to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
    */
    readonly searchQuery?: string;
    /**
    * compute_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
    */
    readonly computeQuery?: DashboardWidgetQueryTableDefinitionRequestRumQueryComputeQuery;
    /**
    * group_by block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
    */
    readonly groupBy?: DashboardWidgetQueryTableDefinitionRequestRumQueryGroupBy[] | cdktf.IResolvable;
    /**
    * multi_compute block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
    */
    readonly multiCompute?: DashboardWidgetQueryTableDefinitionRequestRumQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetQueryTableDefinitionRequestRumQueryToTerraform(struct?: DashboardWidgetQueryTableDefinitionRequestRumQueryOutputReference | DashboardWidgetQueryTableDefinitionRequestRumQuery): any;
export declare class DashboardWidgetQueryTableDefinitionRequestRumQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryTableDefinitionRequestRumQuery | undefined;
    set internalValue(value: DashboardWidgetQueryTableDefinitionRequestRumQuery | undefined);
    private _index?;
    get index(): string;
    set index(value: string);
    get indexInput(): string | undefined;
    private _searchQuery?;
    get searchQuery(): string;
    set searchQuery(value: string);
    resetSearchQuery(): void;
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    get computeQuery(): DashboardWidgetQueryTableDefinitionRequestRumQueryComputeQueryOutputReference;
    putComputeQuery(value: DashboardWidgetQueryTableDefinitionRequestRumQueryComputeQuery): void;
    resetComputeQuery(): void;
    get computeQueryInput(): DashboardWidgetQueryTableDefinitionRequestRumQueryComputeQuery | undefined;
    private _groupBy;
    get groupBy(): DashboardWidgetQueryTableDefinitionRequestRumQueryGroupByList;
    putGroupBy(value: DashboardWidgetQueryTableDefinitionRequestRumQueryGroupBy[] | cdktf.IResolvable): void;
    resetGroupBy(): void;
    get groupByInput(): cdktf.IResolvable | DashboardWidgetQueryTableDefinitionRequestRumQueryGroupBy[] | undefined;
    private _multiCompute;
    get multiCompute(): DashboardWidgetQueryTableDefinitionRequestRumQueryMultiComputeList;
    putMultiCompute(value: DashboardWidgetQueryTableDefinitionRequestRumQueryMultiCompute[] | cdktf.IResolvable): void;
    resetMultiCompute(): void;
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetQueryTableDefinitionRequestRumQueryMultiCompute[] | undefined;
}
export interface DashboardWidgetQueryTableDefinitionRequestSecurityQueryComputeQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetQueryTableDefinitionRequestSecurityQueryComputeQueryToTerraform(struct?: DashboardWidgetQueryTableDefinitionRequestSecurityQueryComputeQueryOutputReference | DashboardWidgetQueryTableDefinitionRequestSecurityQueryComputeQuery): any;
export declare class DashboardWidgetQueryTableDefinitionRequestSecurityQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryTableDefinitionRequestSecurityQueryComputeQuery | undefined;
    set internalValue(value: DashboardWidgetQueryTableDefinitionRequestSecurityQueryComputeQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export interface DashboardWidgetQueryTableDefinitionRequestSecurityQueryGroupBySortQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Widget sorting methods. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
    */
    readonly order: string;
}
export declare function dashboardWidgetQueryTableDefinitionRequestSecurityQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetQueryTableDefinitionRequestSecurityQueryGroupBySortQueryOutputReference | DashboardWidgetQueryTableDefinitionRequestSecurityQueryGroupBySortQuery): any;
export declare class DashboardWidgetQueryTableDefinitionRequestSecurityQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryTableDefinitionRequestSecurityQueryGroupBySortQuery | undefined;
    set internalValue(value: DashboardWidgetQueryTableDefinitionRequestSecurityQueryGroupBySortQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    get orderInput(): string | undefined;
}
export interface DashboardWidgetQueryTableDefinitionRequestSecurityQueryGroupBy {
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * The maximum number of items in the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * sort_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
    */
    readonly sortQuery?: DashboardWidgetQueryTableDefinitionRequestSecurityQueryGroupBySortQuery;
}
export declare function dashboardWidgetQueryTableDefinitionRequestSecurityQueryGroupByToTerraform(struct?: DashboardWidgetQueryTableDefinitionRequestSecurityQueryGroupBy | cdktf.IResolvable): any;
export declare class DashboardWidgetQueryTableDefinitionRequestSecurityQueryGroupByOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetQueryTableDefinitionRequestSecurityQueryGroupBy | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetQueryTableDefinitionRequestSecurityQueryGroupBy | cdktf.IResolvable | undefined);
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _sortQuery;
    get sortQuery(): DashboardWidgetQueryTableDefinitionRequestSecurityQueryGroupBySortQueryOutputReference;
    putSortQuery(value: DashboardWidgetQueryTableDefinitionRequestSecurityQueryGroupBySortQuery): void;
    resetSortQuery(): void;
    get sortQueryInput(): DashboardWidgetQueryTableDefinitionRequestSecurityQueryGroupBySortQuery | undefined;
}
export declare class DashboardWidgetQueryTableDefinitionRequestSecurityQueryGroupByList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetQueryTableDefinitionRequestSecurityQueryGroupBy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetQueryTableDefinitionRequestSecurityQueryGroupByOutputReference;
}
export interface DashboardWidgetQueryTableDefinitionRequestSecurityQueryMultiCompute {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetQueryTableDefinitionRequestSecurityQueryMultiComputeToTerraform(struct?: DashboardWidgetQueryTableDefinitionRequestSecurityQueryMultiCompute | cdktf.IResolvable): any;
export declare class DashboardWidgetQueryTableDefinitionRequestSecurityQueryMultiComputeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetQueryTableDefinitionRequestSecurityQueryMultiCompute | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetQueryTableDefinitionRequestSecurityQueryMultiCompute | cdktf.IResolvable | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export declare class DashboardWidgetQueryTableDefinitionRequestSecurityQueryMultiComputeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetQueryTableDefinitionRequestSecurityQueryMultiCompute[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetQueryTableDefinitionRequestSecurityQueryMultiComputeOutputReference;
}
export interface DashboardWidgetQueryTableDefinitionRequestSecurityQuery {
    /**
    * The name of the index to query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
    */
    readonly index: string;
    /**
    * The search query to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
    */
    readonly searchQuery?: string;
    /**
    * compute_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
    */
    readonly computeQuery?: DashboardWidgetQueryTableDefinitionRequestSecurityQueryComputeQuery;
    /**
    * group_by block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
    */
    readonly groupBy?: DashboardWidgetQueryTableDefinitionRequestSecurityQueryGroupBy[] | cdktf.IResolvable;
    /**
    * multi_compute block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
    */
    readonly multiCompute?: DashboardWidgetQueryTableDefinitionRequestSecurityQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetQueryTableDefinitionRequestSecurityQueryToTerraform(struct?: DashboardWidgetQueryTableDefinitionRequestSecurityQueryOutputReference | DashboardWidgetQueryTableDefinitionRequestSecurityQuery): any;
export declare class DashboardWidgetQueryTableDefinitionRequestSecurityQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryTableDefinitionRequestSecurityQuery | undefined;
    set internalValue(value: DashboardWidgetQueryTableDefinitionRequestSecurityQuery | undefined);
    private _index?;
    get index(): string;
    set index(value: string);
    get indexInput(): string | undefined;
    private _searchQuery?;
    get searchQuery(): string;
    set searchQuery(value: string);
    resetSearchQuery(): void;
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    get computeQuery(): DashboardWidgetQueryTableDefinitionRequestSecurityQueryComputeQueryOutputReference;
    putComputeQuery(value: DashboardWidgetQueryTableDefinitionRequestSecurityQueryComputeQuery): void;
    resetComputeQuery(): void;
    get computeQueryInput(): DashboardWidgetQueryTableDefinitionRequestSecurityQueryComputeQuery | undefined;
    private _groupBy;
    get groupBy(): DashboardWidgetQueryTableDefinitionRequestSecurityQueryGroupByList;
    putGroupBy(value: DashboardWidgetQueryTableDefinitionRequestSecurityQueryGroupBy[] | cdktf.IResolvable): void;
    resetGroupBy(): void;
    get groupByInput(): cdktf.IResolvable | DashboardWidgetQueryTableDefinitionRequestSecurityQueryGroupBy[] | undefined;
    private _multiCompute;
    get multiCompute(): DashboardWidgetQueryTableDefinitionRequestSecurityQueryMultiComputeList;
    putMultiCompute(value: DashboardWidgetQueryTableDefinitionRequestSecurityQueryMultiCompute[] | cdktf.IResolvable): void;
    resetMultiCompute(): void;
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetQueryTableDefinitionRequestSecurityQueryMultiCompute[] | undefined;
}
export interface DashboardWidgetQueryTableDefinitionRequest {
    /**
    * The aggregator to use for time aggregation. Valid values are `avg`, `last`, `max`, `min`, `sum`, `percentile`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregator Dashboard#aggregator}
    */
    readonly aggregator?: string;
    /**
    * The alias for the column name (defaults to metric name).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alias Dashboard#alias}
    */
    readonly alias?: string;
    /**
    * A list of display modes for each table cell. List items one of `number`, `bar`. Valid values are `number`, `bar`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#cell_display_mode Dashboard#cell_display_mode}
    */
    readonly cellDisplayMode?: string[];
    /**
    * The number of lines to show in the table.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * The sort order for the rows. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
    */
    readonly order?: string;
    /**
    * The metric query to use for this widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#q Dashboard#q}
    */
    readonly q?: string;
    /**
    * apm_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_query Dashboard#apm_query}
    */
    readonly apmQuery?: DashboardWidgetQueryTableDefinitionRequestApmQuery;
    /**
    * apm_stats_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_stats_query Dashboard#apm_stats_query}
    */
    readonly apmStatsQuery?: DashboardWidgetQueryTableDefinitionRequestApmStatsQuery;
    /**
    * conditional_formats block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#conditional_formats Dashboard#conditional_formats}
    */
    readonly conditionalFormats?: DashboardWidgetQueryTableDefinitionRequestConditionalFormats[] | cdktf.IResolvable;
    /**
    * formula block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#formula Dashboard#formula}
    */
    readonly formula?: DashboardWidgetQueryTableDefinitionRequestFormula[] | cdktf.IResolvable;
    /**
    * log_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#log_query Dashboard#log_query}
    */
    readonly logQuery?: DashboardWidgetQueryTableDefinitionRequestLogQuery;
    /**
    * process_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#process_query Dashboard#process_query}
    */
    readonly processQuery?: DashboardWidgetQueryTableDefinitionRequestProcessQuery;
    /**
    * query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
    */
    readonly query?: DashboardWidgetQueryTableDefinitionRequestQuery[] | cdktf.IResolvable;
    /**
    * rum_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#rum_query Dashboard#rum_query}
    */
    readonly rumQuery?: DashboardWidgetQueryTableDefinitionRequestRumQuery;
    /**
    * security_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#security_query Dashboard#security_query}
    */
    readonly securityQuery?: DashboardWidgetQueryTableDefinitionRequestSecurityQuery;
}
export declare function dashboardWidgetQueryTableDefinitionRequestToTerraform(struct?: DashboardWidgetQueryTableDefinitionRequest | cdktf.IResolvable): any;
export declare class DashboardWidgetQueryTableDefinitionRequestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetQueryTableDefinitionRequest | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetQueryTableDefinitionRequest | cdktf.IResolvable | undefined);
    private _aggregator?;
    get aggregator(): string;
    set aggregator(value: string);
    resetAggregator(): void;
    get aggregatorInput(): string | undefined;
    private _alias?;
    get alias(): string;
    set alias(value: string);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    private _cellDisplayMode?;
    get cellDisplayMode(): string[];
    set cellDisplayMode(value: string[]);
    resetCellDisplayMode(): void;
    get cellDisplayModeInput(): string[] | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    resetOrder(): void;
    get orderInput(): string | undefined;
    private _q?;
    get q(): string;
    set q(value: string);
    resetQ(): void;
    get qInput(): string | undefined;
    private _apmQuery;
    get apmQuery(): DashboardWidgetQueryTableDefinitionRequestApmQueryOutputReference;
    putApmQuery(value: DashboardWidgetQueryTableDefinitionRequestApmQuery): void;
    resetApmQuery(): void;
    get apmQueryInput(): DashboardWidgetQueryTableDefinitionRequestApmQuery | undefined;
    private _apmStatsQuery;
    get apmStatsQuery(): DashboardWidgetQueryTableDefinitionRequestApmStatsQueryOutputReference;
    putApmStatsQuery(value: DashboardWidgetQueryTableDefinitionRequestApmStatsQuery): void;
    resetApmStatsQuery(): void;
    get apmStatsQueryInput(): DashboardWidgetQueryTableDefinitionRequestApmStatsQuery | undefined;
    private _conditionalFormats;
    get conditionalFormats(): DashboardWidgetQueryTableDefinitionRequestConditionalFormatsList;
    putConditionalFormats(value: DashboardWidgetQueryTableDefinitionRequestConditionalFormats[] | cdktf.IResolvable): void;
    resetConditionalFormats(): void;
    get conditionalFormatsInput(): cdktf.IResolvable | DashboardWidgetQueryTableDefinitionRequestConditionalFormats[] | undefined;
    private _formula;
    get formula(): DashboardWidgetQueryTableDefinitionRequestFormulaList;
    putFormula(value: DashboardWidgetQueryTableDefinitionRequestFormula[] | cdktf.IResolvable): void;
    resetFormula(): void;
    get formulaInput(): cdktf.IResolvable | DashboardWidgetQueryTableDefinitionRequestFormula[] | undefined;
    private _logQuery;
    get logQuery(): DashboardWidgetQueryTableDefinitionRequestLogQueryOutputReference;
    putLogQuery(value: DashboardWidgetQueryTableDefinitionRequestLogQuery): void;
    resetLogQuery(): void;
    get logQueryInput(): DashboardWidgetQueryTableDefinitionRequestLogQuery | undefined;
    private _processQuery;
    get processQuery(): DashboardWidgetQueryTableDefinitionRequestProcessQueryOutputReference;
    putProcessQuery(value: DashboardWidgetQueryTableDefinitionRequestProcessQuery): void;
    resetProcessQuery(): void;
    get processQueryInput(): DashboardWidgetQueryTableDefinitionRequestProcessQuery | undefined;
    private _query;
    get query(): DashboardWidgetQueryTableDefinitionRequestQueryList;
    putQuery(value: DashboardWidgetQueryTableDefinitionRequestQuery[] | cdktf.IResolvable): void;
    resetQuery(): void;
    get queryInput(): cdktf.IResolvable | DashboardWidgetQueryTableDefinitionRequestQuery[] | undefined;
    private _rumQuery;
    get rumQuery(): DashboardWidgetQueryTableDefinitionRequestRumQueryOutputReference;
    putRumQuery(value: DashboardWidgetQueryTableDefinitionRequestRumQuery): void;
    resetRumQuery(): void;
    get rumQueryInput(): DashboardWidgetQueryTableDefinitionRequestRumQuery | undefined;
    private _securityQuery;
    get securityQuery(): DashboardWidgetQueryTableDefinitionRequestSecurityQueryOutputReference;
    putSecurityQuery(value: DashboardWidgetQueryTableDefinitionRequestSecurityQuery): void;
    resetSecurityQuery(): void;
    get securityQueryInput(): DashboardWidgetQueryTableDefinitionRequestSecurityQuery | undefined;
}
export declare class DashboardWidgetQueryTableDefinitionRequestList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetQueryTableDefinitionRequest[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetQueryTableDefinitionRequestOutputReference;
}
export interface DashboardWidgetQueryTableDefinition {
    /**
    * Controls the display of the search bar. Valid values are `always`, `never`, `auto`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#has_search_bar Dashboard#has_search_bar}
    */
    readonly hasSearchBar?: string;
    /**
    * The timeframe to use when displaying the widget. Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
    */
    readonly liveSpan?: string;
    /**
    * The title of the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
    */
    readonly title?: string;
    /**
    * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
    */
    readonly titleAlign?: string;
    /**
    * The size of the widget's title (defaults to 16).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
    */
    readonly titleSize?: string;
    /**
    * custom_link block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_link Dashboard#custom_link}
    */
    readonly customLink?: DashboardWidgetQueryTableDefinitionCustomLink[] | cdktf.IResolvable;
    /**
    * request block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#request Dashboard#request}
    */
    readonly request?: DashboardWidgetQueryTableDefinitionRequest[] | cdktf.IResolvable;
}
export declare function dashboardWidgetQueryTableDefinitionToTerraform(struct?: DashboardWidgetQueryTableDefinitionOutputReference | DashboardWidgetQueryTableDefinition): any;
export declare class DashboardWidgetQueryTableDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryTableDefinition | undefined;
    set internalValue(value: DashboardWidgetQueryTableDefinition | undefined);
    private _hasSearchBar?;
    get hasSearchBar(): string;
    set hasSearchBar(value: string);
    resetHasSearchBar(): void;
    get hasSearchBarInput(): string | undefined;
    private _liveSpan?;
    get liveSpan(): string;
    set liveSpan(value: string);
    resetLiveSpan(): void;
    get liveSpanInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
    private _titleAlign?;
    get titleAlign(): string;
    set titleAlign(value: string);
    resetTitleAlign(): void;
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    get titleSize(): string;
    set titleSize(value: string);
    resetTitleSize(): void;
    get titleSizeInput(): string | undefined;
    private _customLink;
    get customLink(): DashboardWidgetQueryTableDefinitionCustomLinkList;
    putCustomLink(value: DashboardWidgetQueryTableDefinitionCustomLink[] | cdktf.IResolvable): void;
    resetCustomLink(): void;
    get customLinkInput(): cdktf.IResolvable | DashboardWidgetQueryTableDefinitionCustomLink[] | undefined;
    private _request;
    get request(): DashboardWidgetQueryTableDefinitionRequestList;
    putRequest(value: DashboardWidgetQueryTableDefinitionRequest[] | cdktf.IResolvable): void;
    resetRequest(): void;
    get requestInput(): cdktf.IResolvable | DashboardWidgetQueryTableDefinitionRequest[] | undefined;
}
export interface DashboardWidgetQueryValueDefinitionCustomLink {
    /**
    * The flag for toggling context menu link visibility.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_hidden Dashboard#is_hidden}
    */
    readonly isHidden?: boolean | cdktf.IResolvable;
    /**
    * The label for the custom link URL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#label Dashboard#label}
    */
    readonly label?: string;
    /**
    * The URL of the custom link.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#link Dashboard#link}
    */
    readonly link?: string;
    /**
    * The label id that refers to a context menu link item. When override_label is provided, the client request omits the label field.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#override_label Dashboard#override_label}
    */
    readonly overrideLabel?: string;
}
export declare function dashboardWidgetQueryValueDefinitionCustomLinkToTerraform(struct?: DashboardWidgetQueryValueDefinitionCustomLink | cdktf.IResolvable): any;
export declare class DashboardWidgetQueryValueDefinitionCustomLinkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetQueryValueDefinitionCustomLink | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionCustomLink | cdktf.IResolvable | undefined);
    private _isHidden?;
    get isHidden(): boolean | cdktf.IResolvable;
    set isHidden(value: boolean | cdktf.IResolvable);
    resetIsHidden(): void;
    get isHiddenInput(): boolean | cdktf.IResolvable | undefined;
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _link?;
    get link(): string;
    set link(value: string);
    resetLink(): void;
    get linkInput(): string | undefined;
    private _overrideLabel?;
    get overrideLabel(): string;
    set overrideLabel(value: string);
    resetOverrideLabel(): void;
    get overrideLabelInput(): string | undefined;
}
export declare class DashboardWidgetQueryValueDefinitionCustomLinkList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetQueryValueDefinitionCustomLink[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetQueryValueDefinitionCustomLinkOutputReference;
}
export interface DashboardWidgetQueryValueDefinitionRequestApmQueryComputeQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetQueryValueDefinitionRequestApmQueryComputeQueryToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestApmQueryComputeQueryOutputReference | DashboardWidgetQueryValueDefinitionRequestApmQueryComputeQuery): any;
export declare class DashboardWidgetQueryValueDefinitionRequestApmQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestApmQueryComputeQuery | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestApmQueryComputeQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export interface DashboardWidgetQueryValueDefinitionRequestApmQueryGroupBySortQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Widget sorting methods. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
    */
    readonly order: string;
}
export declare function dashboardWidgetQueryValueDefinitionRequestApmQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestApmQueryGroupBySortQueryOutputReference | DashboardWidgetQueryValueDefinitionRequestApmQueryGroupBySortQuery): any;
export declare class DashboardWidgetQueryValueDefinitionRequestApmQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestApmQueryGroupBySortQuery | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestApmQueryGroupBySortQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    get orderInput(): string | undefined;
}
export interface DashboardWidgetQueryValueDefinitionRequestApmQueryGroupBy {
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * The maximum number of items in the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * sort_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
    */
    readonly sortQuery?: DashboardWidgetQueryValueDefinitionRequestApmQueryGroupBySortQuery;
}
export declare function dashboardWidgetQueryValueDefinitionRequestApmQueryGroupByToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestApmQueryGroupBy | cdktf.IResolvable): any;
export declare class DashboardWidgetQueryValueDefinitionRequestApmQueryGroupByOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestApmQueryGroupBy | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestApmQueryGroupBy | cdktf.IResolvable | undefined);
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _sortQuery;
    get sortQuery(): DashboardWidgetQueryValueDefinitionRequestApmQueryGroupBySortQueryOutputReference;
    putSortQuery(value: DashboardWidgetQueryValueDefinitionRequestApmQueryGroupBySortQuery): void;
    resetSortQuery(): void;
    get sortQueryInput(): DashboardWidgetQueryValueDefinitionRequestApmQueryGroupBySortQuery | undefined;
}
export declare class DashboardWidgetQueryValueDefinitionRequestApmQueryGroupByList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetQueryValueDefinitionRequestApmQueryGroupBy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetQueryValueDefinitionRequestApmQueryGroupByOutputReference;
}
export interface DashboardWidgetQueryValueDefinitionRequestApmQueryMultiCompute {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetQueryValueDefinitionRequestApmQueryMultiComputeToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestApmQueryMultiCompute | cdktf.IResolvable): any;
export declare class DashboardWidgetQueryValueDefinitionRequestApmQueryMultiComputeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestApmQueryMultiCompute | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestApmQueryMultiCompute | cdktf.IResolvable | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export declare class DashboardWidgetQueryValueDefinitionRequestApmQueryMultiComputeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetQueryValueDefinitionRequestApmQueryMultiCompute[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetQueryValueDefinitionRequestApmQueryMultiComputeOutputReference;
}
export interface DashboardWidgetQueryValueDefinitionRequestApmQuery {
    /**
    * The name of the index to query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
    */
    readonly index: string;
    /**
    * The search query to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
    */
    readonly searchQuery?: string;
    /**
    * compute_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
    */
    readonly computeQuery?: DashboardWidgetQueryValueDefinitionRequestApmQueryComputeQuery;
    /**
    * group_by block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
    */
    readonly groupBy?: DashboardWidgetQueryValueDefinitionRequestApmQueryGroupBy[] | cdktf.IResolvable;
    /**
    * multi_compute block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
    */
    readonly multiCompute?: DashboardWidgetQueryValueDefinitionRequestApmQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetQueryValueDefinitionRequestApmQueryToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestApmQueryOutputReference | DashboardWidgetQueryValueDefinitionRequestApmQuery): any;
export declare class DashboardWidgetQueryValueDefinitionRequestApmQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestApmQuery | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestApmQuery | undefined);
    private _index?;
    get index(): string;
    set index(value: string);
    get indexInput(): string | undefined;
    private _searchQuery?;
    get searchQuery(): string;
    set searchQuery(value: string);
    resetSearchQuery(): void;
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    get computeQuery(): DashboardWidgetQueryValueDefinitionRequestApmQueryComputeQueryOutputReference;
    putComputeQuery(value: DashboardWidgetQueryValueDefinitionRequestApmQueryComputeQuery): void;
    resetComputeQuery(): void;
    get computeQueryInput(): DashboardWidgetQueryValueDefinitionRequestApmQueryComputeQuery | undefined;
    private _groupBy;
    get groupBy(): DashboardWidgetQueryValueDefinitionRequestApmQueryGroupByList;
    putGroupBy(value: DashboardWidgetQueryValueDefinitionRequestApmQueryGroupBy[] | cdktf.IResolvable): void;
    resetGroupBy(): void;
    get groupByInput(): cdktf.IResolvable | DashboardWidgetQueryValueDefinitionRequestApmQueryGroupBy[] | undefined;
    private _multiCompute;
    get multiCompute(): DashboardWidgetQueryValueDefinitionRequestApmQueryMultiComputeList;
    putMultiCompute(value: DashboardWidgetQueryValueDefinitionRequestApmQueryMultiCompute[] | cdktf.IResolvable): void;
    resetMultiCompute(): void;
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetQueryValueDefinitionRequestApmQueryMultiCompute[] | undefined;
}
export interface DashboardWidgetQueryValueDefinitionRequestAuditQueryComputeQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetQueryValueDefinitionRequestAuditQueryComputeQueryToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestAuditQueryComputeQueryOutputReference | DashboardWidgetQueryValueDefinitionRequestAuditQueryComputeQuery): any;
export declare class DashboardWidgetQueryValueDefinitionRequestAuditQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestAuditQueryComputeQuery | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestAuditQueryComputeQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export interface DashboardWidgetQueryValueDefinitionRequestAuditQueryGroupBySortQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Widget sorting methods. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
    */
    readonly order: string;
}
export declare function dashboardWidgetQueryValueDefinitionRequestAuditQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestAuditQueryGroupBySortQueryOutputReference | DashboardWidgetQueryValueDefinitionRequestAuditQueryGroupBySortQuery): any;
export declare class DashboardWidgetQueryValueDefinitionRequestAuditQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestAuditQueryGroupBySortQuery | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestAuditQueryGroupBySortQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    get orderInput(): string | undefined;
}
export interface DashboardWidgetQueryValueDefinitionRequestAuditQueryGroupBy {
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * The maximum number of items in the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * sort_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
    */
    readonly sortQuery?: DashboardWidgetQueryValueDefinitionRequestAuditQueryGroupBySortQuery;
}
export declare function dashboardWidgetQueryValueDefinitionRequestAuditQueryGroupByToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestAuditQueryGroupBy | cdktf.IResolvable): any;
export declare class DashboardWidgetQueryValueDefinitionRequestAuditQueryGroupByOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestAuditQueryGroupBy | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestAuditQueryGroupBy | cdktf.IResolvable | undefined);
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _sortQuery;
    get sortQuery(): DashboardWidgetQueryValueDefinitionRequestAuditQueryGroupBySortQueryOutputReference;
    putSortQuery(value: DashboardWidgetQueryValueDefinitionRequestAuditQueryGroupBySortQuery): void;
    resetSortQuery(): void;
    get sortQueryInput(): DashboardWidgetQueryValueDefinitionRequestAuditQueryGroupBySortQuery | undefined;
}
export declare class DashboardWidgetQueryValueDefinitionRequestAuditQueryGroupByList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetQueryValueDefinitionRequestAuditQueryGroupBy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetQueryValueDefinitionRequestAuditQueryGroupByOutputReference;
}
export interface DashboardWidgetQueryValueDefinitionRequestAuditQueryMultiCompute {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetQueryValueDefinitionRequestAuditQueryMultiComputeToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestAuditQueryMultiCompute | cdktf.IResolvable): any;
export declare class DashboardWidgetQueryValueDefinitionRequestAuditQueryMultiComputeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestAuditQueryMultiCompute | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestAuditQueryMultiCompute | cdktf.IResolvable | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export declare class DashboardWidgetQueryValueDefinitionRequestAuditQueryMultiComputeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetQueryValueDefinitionRequestAuditQueryMultiCompute[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetQueryValueDefinitionRequestAuditQueryMultiComputeOutputReference;
}
export interface DashboardWidgetQueryValueDefinitionRequestAuditQuery {
    /**
    * The name of the index to query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
    */
    readonly index: string;
    /**
    * The search query to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
    */
    readonly searchQuery?: string;
    /**
    * compute_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
    */
    readonly computeQuery?: DashboardWidgetQueryValueDefinitionRequestAuditQueryComputeQuery;
    /**
    * group_by block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
    */
    readonly groupBy?: DashboardWidgetQueryValueDefinitionRequestAuditQueryGroupBy[] | cdktf.IResolvable;
    /**
    * multi_compute block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
    */
    readonly multiCompute?: DashboardWidgetQueryValueDefinitionRequestAuditQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetQueryValueDefinitionRequestAuditQueryToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestAuditQueryOutputReference | DashboardWidgetQueryValueDefinitionRequestAuditQuery): any;
export declare class DashboardWidgetQueryValueDefinitionRequestAuditQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestAuditQuery | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestAuditQuery | undefined);
    private _index?;
    get index(): string;
    set index(value: string);
    get indexInput(): string | undefined;
    private _searchQuery?;
    get searchQuery(): string;
    set searchQuery(value: string);
    resetSearchQuery(): void;
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    get computeQuery(): DashboardWidgetQueryValueDefinitionRequestAuditQueryComputeQueryOutputReference;
    putComputeQuery(value: DashboardWidgetQueryValueDefinitionRequestAuditQueryComputeQuery): void;
    resetComputeQuery(): void;
    get computeQueryInput(): DashboardWidgetQueryValueDefinitionRequestAuditQueryComputeQuery | undefined;
    private _groupBy;
    get groupBy(): DashboardWidgetQueryValueDefinitionRequestAuditQueryGroupByList;
    putGroupBy(value: DashboardWidgetQueryValueDefinitionRequestAuditQueryGroupBy[] | cdktf.IResolvable): void;
    resetGroupBy(): void;
    get groupByInput(): cdktf.IResolvable | DashboardWidgetQueryValueDefinitionRequestAuditQueryGroupBy[] | undefined;
    private _multiCompute;
    get multiCompute(): DashboardWidgetQueryValueDefinitionRequestAuditQueryMultiComputeList;
    putMultiCompute(value: DashboardWidgetQueryValueDefinitionRequestAuditQueryMultiCompute[] | cdktf.IResolvable): void;
    resetMultiCompute(): void;
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetQueryValueDefinitionRequestAuditQueryMultiCompute[] | undefined;
}
export interface DashboardWidgetQueryValueDefinitionRequestConditionalFormats {
    /**
    * The comparator to use. Valid values are `>`, `>=`, `<`, `<=`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#comparator Dashboard#comparator}
    */
    readonly comparator: string;
    /**
    * The color palette to apply to the background, same values available as palette.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_bg_color Dashboard#custom_bg_color}
    */
    readonly customBgColor?: string;
    /**
    * The color palette to apply to the foreground, same values available as palette.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_fg_color Dashboard#custom_fg_color}
    */
    readonly customFgColor?: string;
    /**
    * Setting this to True hides values.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#hide_value Dashboard#hide_value}
    */
    readonly hideValue?: boolean | cdktf.IResolvable;
    /**
    * Displays an image as the background.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#image_url Dashboard#image_url}
    */
    readonly imageUrl?: string;
    /**
    * The metric from the request to correlate with this conditional format.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
    */
    readonly metric?: string;
    /**
    * The color palette to apply. Valid values are `blue`, `custom_bg`, `custom_image`, `custom_text`, `gray_on_white`, `grey`, `green`, `orange`, `red`, `red_on_white`, `white_on_gray`, `white_on_green`, `green_on_white`, `white_on_red`, `white_on_yellow`, `yellow_on_white`, `black_on_light_yellow`, `black_on_light_green`, `black_on_light_red`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
    */
    readonly palette: string;
    /**
    * Defines the displayed timeframe.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#timeframe Dashboard#timeframe}
    */
    readonly timeframe?: string;
    /**
    * A value for the comparator.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#value Dashboard#value}
    */
    readonly value: number;
}
export declare function dashboardWidgetQueryValueDefinitionRequestConditionalFormatsToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestConditionalFormats | cdktf.IResolvable): any;
export declare class DashboardWidgetQueryValueDefinitionRequestConditionalFormatsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestConditionalFormats | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestConditionalFormats | cdktf.IResolvable | undefined);
    private _comparator?;
    get comparator(): string;
    set comparator(value: string);
    get comparatorInput(): string | undefined;
    private _customBgColor?;
    get customBgColor(): string;
    set customBgColor(value: string);
    resetCustomBgColor(): void;
    get customBgColorInput(): string | undefined;
    private _customFgColor?;
    get customFgColor(): string;
    set customFgColor(value: string);
    resetCustomFgColor(): void;
    get customFgColorInput(): string | undefined;
    private _hideValue?;
    get hideValue(): boolean | cdktf.IResolvable;
    set hideValue(value: boolean | cdktf.IResolvable);
    resetHideValue(): void;
    get hideValueInput(): boolean | cdktf.IResolvable | undefined;
    private _imageUrl?;
    get imageUrl(): string;
    set imageUrl(value: string);
    resetImageUrl(): void;
    get imageUrlInput(): string | undefined;
    private _metric?;
    get metric(): string;
    set metric(value: string);
    resetMetric(): void;
    get metricInput(): string | undefined;
    private _palette?;
    get palette(): string;
    set palette(value: string);
    get paletteInput(): string | undefined;
    private _timeframe?;
    get timeframe(): string;
    set timeframe(value: string);
    resetTimeframe(): void;
    get timeframeInput(): string | undefined;
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
}
export declare class DashboardWidgetQueryValueDefinitionRequestConditionalFormatsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetQueryValueDefinitionRequestConditionalFormats[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetQueryValueDefinitionRequestConditionalFormatsOutputReference;
}
export interface DashboardWidgetQueryValueDefinitionRequestFormulaConditionalFormats {
    /**
    * The comparator to use. Valid values are `>`, `>=`, `<`, `<=`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#comparator Dashboard#comparator}
    */
    readonly comparator: string;
    /**
    * The color palette to apply to the background, same values available as palette.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_bg_color Dashboard#custom_bg_color}
    */
    readonly customBgColor?: string;
    /**
    * The color palette to apply to the foreground, same values available as palette.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_fg_color Dashboard#custom_fg_color}
    */
    readonly customFgColor?: string;
    /**
    * Setting this to True hides values.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#hide_value Dashboard#hide_value}
    */
    readonly hideValue?: boolean | cdktf.IResolvable;
    /**
    * Displays an image as the background.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#image_url Dashboard#image_url}
    */
    readonly imageUrl?: string;
    /**
    * The metric from the request to correlate with this conditional format.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
    */
    readonly metric?: string;
    /**
    * The color palette to apply. Valid values are `blue`, `custom_bg`, `custom_image`, `custom_text`, `gray_on_white`, `grey`, `green`, `orange`, `red`, `red_on_white`, `white_on_gray`, `white_on_green`, `green_on_white`, `white_on_red`, `white_on_yellow`, `yellow_on_white`, `black_on_light_yellow`, `black_on_light_green`, `black_on_light_red`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
    */
    readonly palette: string;
    /**
    * Defines the displayed timeframe.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#timeframe Dashboard#timeframe}
    */
    readonly timeframe?: string;
    /**
    * A value for the comparator.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#value Dashboard#value}
    */
    readonly value: number;
}
export declare function dashboardWidgetQueryValueDefinitionRequestFormulaConditionalFormatsToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestFormulaConditionalFormats | cdktf.IResolvable): any;
export declare class DashboardWidgetQueryValueDefinitionRequestFormulaConditionalFormatsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestFormulaConditionalFormats | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestFormulaConditionalFormats | cdktf.IResolvable | undefined);
    private _comparator?;
    get comparator(): string;
    set comparator(value: string);
    get comparatorInput(): string | undefined;
    private _customBgColor?;
    get customBgColor(): string;
    set customBgColor(value: string);
    resetCustomBgColor(): void;
    get customBgColorInput(): string | undefined;
    private _customFgColor?;
    get customFgColor(): string;
    set customFgColor(value: string);
    resetCustomFgColor(): void;
    get customFgColorInput(): string | undefined;
    private _hideValue?;
    get hideValue(): boolean | cdktf.IResolvable;
    set hideValue(value: boolean | cdktf.IResolvable);
    resetHideValue(): void;
    get hideValueInput(): boolean | cdktf.IResolvable | undefined;
    private _imageUrl?;
    get imageUrl(): string;
    set imageUrl(value: string);
    resetImageUrl(): void;
    get imageUrlInput(): string | undefined;
    private _metric?;
    get metric(): string;
    set metric(value: string);
    resetMetric(): void;
    get metricInput(): string | undefined;
    private _palette?;
    get palette(): string;
    set palette(value: string);
    get paletteInput(): string | undefined;
    private _timeframe?;
    get timeframe(): string;
    set timeframe(value: string);
    resetTimeframe(): void;
    get timeframeInput(): string | undefined;
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
}
export declare class DashboardWidgetQueryValueDefinitionRequestFormulaConditionalFormatsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetQueryValueDefinitionRequestFormulaConditionalFormats[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetQueryValueDefinitionRequestFormulaConditionalFormatsOutputReference;
}
export interface DashboardWidgetQueryValueDefinitionRequestFormulaLimit {
    /**
    * The number of results to return
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#count Dashboard#count}
    */
    readonly count?: number;
    /**
    * The direction of the sort. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
    */
    readonly order?: string;
}
export declare function dashboardWidgetQueryValueDefinitionRequestFormulaLimitToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestFormulaLimitOutputReference | DashboardWidgetQueryValueDefinitionRequestFormulaLimit): any;
export declare class DashboardWidgetQueryValueDefinitionRequestFormulaLimitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestFormulaLimit | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestFormulaLimit | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    resetCount(): void;
    get countInput(): number | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    resetOrder(): void;
    get orderInput(): string | undefined;
}
export interface DashboardWidgetQueryValueDefinitionRequestFormulaStyle {
    /**
    * The color palette used to display the formula. A guide to the available color palettes can be found at https://docs.datadoghq.com/dashboards/guide/widget_colors
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette Dashboard#palette}
    */
    readonly palette?: string;
    /**
    * Index specifying which color to use within the palette.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#palette_index Dashboard#palette_index}
    */
    readonly paletteIndex?: number;
}
export declare function dashboardWidgetQueryValueDefinitionRequestFormulaStyleToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestFormulaStyleOutputReference | DashboardWidgetQueryValueDefinitionRequestFormulaStyle): any;
export declare class DashboardWidgetQueryValueDefinitionRequestFormulaStyleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestFormulaStyle | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestFormulaStyle | undefined);
    private _palette?;
    get palette(): string;
    set palette(value: string);
    resetPalette(): void;
    get paletteInput(): string | undefined;
    private _paletteIndex?;
    get paletteIndex(): number;
    set paletteIndex(value: number);
    resetPaletteIndex(): void;
    get paletteIndexInput(): number | undefined;
}
export interface DashboardWidgetQueryValueDefinitionRequestFormula {
    /**
    * An expression alias.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alias Dashboard#alias}
    */
    readonly alias?: string;
    /**
    * A list of display modes for each table cell. Valid values are `number`, `bar`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#cell_display_mode Dashboard#cell_display_mode}
    */
    readonly cellDisplayMode?: string;
    /**
    * A string expression built from queries, formulas, and functions.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#formula_expression Dashboard#formula_expression}
    */
    readonly formulaExpression: string;
    /**
    * conditional_formats block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#conditional_formats Dashboard#conditional_formats}
    */
    readonly conditionalFormats?: DashboardWidgetQueryValueDefinitionRequestFormulaConditionalFormats[] | cdktf.IResolvable;
    /**
    * limit block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: DashboardWidgetQueryValueDefinitionRequestFormulaLimit;
    /**
    * style block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#style Dashboard#style}
    */
    readonly style?: DashboardWidgetQueryValueDefinitionRequestFormulaStyle;
}
export declare function dashboardWidgetQueryValueDefinitionRequestFormulaToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestFormula | cdktf.IResolvable): any;
export declare class DashboardWidgetQueryValueDefinitionRequestFormulaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestFormula | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestFormula | cdktf.IResolvable | undefined);
    private _alias?;
    get alias(): string;
    set alias(value: string);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    private _cellDisplayMode?;
    get cellDisplayMode(): string;
    set cellDisplayMode(value: string);
    resetCellDisplayMode(): void;
    get cellDisplayModeInput(): string | undefined;
    private _formulaExpression?;
    get formulaExpression(): string;
    set formulaExpression(value: string);
    get formulaExpressionInput(): string | undefined;
    private _conditionalFormats;
    get conditionalFormats(): DashboardWidgetQueryValueDefinitionRequestFormulaConditionalFormatsList;
    putConditionalFormats(value: DashboardWidgetQueryValueDefinitionRequestFormulaConditionalFormats[] | cdktf.IResolvable): void;
    resetConditionalFormats(): void;
    get conditionalFormatsInput(): cdktf.IResolvable | DashboardWidgetQueryValueDefinitionRequestFormulaConditionalFormats[] | undefined;
    private _limit;
    get limit(): DashboardWidgetQueryValueDefinitionRequestFormulaLimitOutputReference;
    putLimit(value: DashboardWidgetQueryValueDefinitionRequestFormulaLimit): void;
    resetLimit(): void;
    get limitInput(): DashboardWidgetQueryValueDefinitionRequestFormulaLimit | undefined;
    private _style;
    get style(): DashboardWidgetQueryValueDefinitionRequestFormulaStyleOutputReference;
    putStyle(value: DashboardWidgetQueryValueDefinitionRequestFormulaStyle): void;
    resetStyle(): void;
    get styleInput(): DashboardWidgetQueryValueDefinitionRequestFormulaStyle | undefined;
}
export declare class DashboardWidgetQueryValueDefinitionRequestFormulaList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetQueryValueDefinitionRequestFormula[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetQueryValueDefinitionRequestFormulaOutputReference;
}
export interface DashboardWidgetQueryValueDefinitionRequestLogQueryComputeQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetQueryValueDefinitionRequestLogQueryComputeQueryToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestLogQueryComputeQueryOutputReference | DashboardWidgetQueryValueDefinitionRequestLogQueryComputeQuery): any;
export declare class DashboardWidgetQueryValueDefinitionRequestLogQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestLogQueryComputeQuery | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestLogQueryComputeQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export interface DashboardWidgetQueryValueDefinitionRequestLogQueryGroupBySortQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Widget sorting methods. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
    */
    readonly order: string;
}
export declare function dashboardWidgetQueryValueDefinitionRequestLogQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestLogQueryGroupBySortQueryOutputReference | DashboardWidgetQueryValueDefinitionRequestLogQueryGroupBySortQuery): any;
export declare class DashboardWidgetQueryValueDefinitionRequestLogQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestLogQueryGroupBySortQuery | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestLogQueryGroupBySortQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    get orderInput(): string | undefined;
}
export interface DashboardWidgetQueryValueDefinitionRequestLogQueryGroupBy {
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * The maximum number of items in the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * sort_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
    */
    readonly sortQuery?: DashboardWidgetQueryValueDefinitionRequestLogQueryGroupBySortQuery;
}
export declare function dashboardWidgetQueryValueDefinitionRequestLogQueryGroupByToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestLogQueryGroupBy | cdktf.IResolvable): any;
export declare class DashboardWidgetQueryValueDefinitionRequestLogQueryGroupByOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestLogQueryGroupBy | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestLogQueryGroupBy | cdktf.IResolvable | undefined);
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _sortQuery;
    get sortQuery(): DashboardWidgetQueryValueDefinitionRequestLogQueryGroupBySortQueryOutputReference;
    putSortQuery(value: DashboardWidgetQueryValueDefinitionRequestLogQueryGroupBySortQuery): void;
    resetSortQuery(): void;
    get sortQueryInput(): DashboardWidgetQueryValueDefinitionRequestLogQueryGroupBySortQuery | undefined;
}
export declare class DashboardWidgetQueryValueDefinitionRequestLogQueryGroupByList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetQueryValueDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetQueryValueDefinitionRequestLogQueryGroupByOutputReference;
}
export interface DashboardWidgetQueryValueDefinitionRequestLogQueryMultiCompute {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetQueryValueDefinitionRequestLogQueryMultiComputeToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestLogQueryMultiCompute | cdktf.IResolvable): any;
export declare class DashboardWidgetQueryValueDefinitionRequestLogQueryMultiComputeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestLogQueryMultiCompute | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestLogQueryMultiCompute | cdktf.IResolvable | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export declare class DashboardWidgetQueryValueDefinitionRequestLogQueryMultiComputeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetQueryValueDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetQueryValueDefinitionRequestLogQueryMultiComputeOutputReference;
}
export interface DashboardWidgetQueryValueDefinitionRequestLogQuery {
    /**
    * The name of the index to query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
    */
    readonly index: string;
    /**
    * The search query to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
    */
    readonly searchQuery?: string;
    /**
    * compute_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
    */
    readonly computeQuery?: DashboardWidgetQueryValueDefinitionRequestLogQueryComputeQuery;
    /**
    * group_by block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
    */
    readonly groupBy?: DashboardWidgetQueryValueDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable;
    /**
    * multi_compute block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
    */
    readonly multiCompute?: DashboardWidgetQueryValueDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetQueryValueDefinitionRequestLogQueryToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestLogQueryOutputReference | DashboardWidgetQueryValueDefinitionRequestLogQuery): any;
export declare class DashboardWidgetQueryValueDefinitionRequestLogQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestLogQuery | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestLogQuery | undefined);
    private _index?;
    get index(): string;
    set index(value: string);
    get indexInput(): string | undefined;
    private _searchQuery?;
    get searchQuery(): string;
    set searchQuery(value: string);
    resetSearchQuery(): void;
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    get computeQuery(): DashboardWidgetQueryValueDefinitionRequestLogQueryComputeQueryOutputReference;
    putComputeQuery(value: DashboardWidgetQueryValueDefinitionRequestLogQueryComputeQuery): void;
    resetComputeQuery(): void;
    get computeQueryInput(): DashboardWidgetQueryValueDefinitionRequestLogQueryComputeQuery | undefined;
    private _groupBy;
    get groupBy(): DashboardWidgetQueryValueDefinitionRequestLogQueryGroupByList;
    putGroupBy(value: DashboardWidgetQueryValueDefinitionRequestLogQueryGroupBy[] | cdktf.IResolvable): void;
    resetGroupBy(): void;
    get groupByInput(): cdktf.IResolvable | DashboardWidgetQueryValueDefinitionRequestLogQueryGroupBy[] | undefined;
    private _multiCompute;
    get multiCompute(): DashboardWidgetQueryValueDefinitionRequestLogQueryMultiComputeList;
    putMultiCompute(value: DashboardWidgetQueryValueDefinitionRequestLogQueryMultiCompute[] | cdktf.IResolvable): void;
    resetMultiCompute(): void;
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetQueryValueDefinitionRequestLogQueryMultiCompute[] | undefined;
}
export interface DashboardWidgetQueryValueDefinitionRequestProcessQuery {
    /**
    * A list of processes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#filter_by Dashboard#filter_by}
    */
    readonly filterBy?: string[];
    /**
    * The max number of items in the filter list.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * Your chosen metric.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
    */
    readonly metric: string;
    /**
    * Your chosen search term.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_by Dashboard#search_by}
    */
    readonly searchBy?: string;
}
export declare function dashboardWidgetQueryValueDefinitionRequestProcessQueryToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestProcessQueryOutputReference | DashboardWidgetQueryValueDefinitionRequestProcessQuery): any;
export declare class DashboardWidgetQueryValueDefinitionRequestProcessQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestProcessQuery | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestProcessQuery | undefined);
    private _filterBy?;
    get filterBy(): string[];
    set filterBy(value: string[]);
    resetFilterBy(): void;
    get filterByInput(): string[] | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _metric?;
    get metric(): string;
    set metric(value: string);
    get metricInput(): string | undefined;
    private _searchBy?;
    get searchBy(): string;
    set searchBy(value: string);
    resetSearchBy(): void;
    get searchByInput(): string | undefined;
}
export interface DashboardWidgetQueryValueDefinitionRequestQueryApmDependencyStatsQuery {
    /**
    * The data source for APM Dependency Stats queries. Valid values are `apm_dependency_stats`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
    */
    readonly dataSource: string;
    /**
    * APM Environment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#env Dashboard#env}
    */
    readonly env: string;
    /**
    * Determines whether stats for upstream or downstream dependencies should be queried.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_upstream Dashboard#is_upstream}
    */
    readonly isUpstream?: boolean | cdktf.IResolvable;
    /**
    * The name of query for use in formulas.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
    */
    readonly name: string;
    /**
    * Name of operation on service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#operation_name Dashboard#operation_name}
    */
    readonly operationName: string;
    /**
    * The name of the second primary tag used within APM; required when `primary_tag_value` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_name Dashboard#primary_tag_name}
    */
    readonly primaryTagName?: string;
    /**
    * Filter APM data by the second primary tag. `primary_tag_name` must also be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_value Dashboard#primary_tag_value}
    */
    readonly primaryTagValue?: string;
    /**
    * APM resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#resource_name Dashboard#resource_name}
    */
    readonly resourceName: string;
    /**
    * APM service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service Dashboard#service}
    */
    readonly service: string;
    /**
    * APM statistic. Valid values are `avg_duration`, `avg_root_duration`, `avg_spans_per_trace`, `error_rate`, `pct_exec_time`, `pct_of_traces`, `total_traces_count`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#stat Dashboard#stat}
    */
    readonly stat: string;
}
export declare function dashboardWidgetQueryValueDefinitionRequestQueryApmDependencyStatsQueryToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestQueryApmDependencyStatsQueryOutputReference | DashboardWidgetQueryValueDefinitionRequestQueryApmDependencyStatsQuery): any;
export declare class DashboardWidgetQueryValueDefinitionRequestQueryApmDependencyStatsQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestQueryApmDependencyStatsQuery | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestQueryApmDependencyStatsQuery | undefined);
    private _dataSource?;
    get dataSource(): string;
    set dataSource(value: string);
    get dataSourceInput(): string | undefined;
    private _env?;
    get env(): string;
    set env(value: string);
    get envInput(): string | undefined;
    private _isUpstream?;
    get isUpstream(): boolean | cdktf.IResolvable;
    set isUpstream(value: boolean | cdktf.IResolvable);
    resetIsUpstream(): void;
    get isUpstreamInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _operationName?;
    get operationName(): string;
    set operationName(value: string);
    get operationNameInput(): string | undefined;
    private _primaryTagName?;
    get primaryTagName(): string;
    set primaryTagName(value: string);
    resetPrimaryTagName(): void;
    get primaryTagNameInput(): string | undefined;
    private _primaryTagValue?;
    get primaryTagValue(): string;
    set primaryTagValue(value: string);
    resetPrimaryTagValue(): void;
    get primaryTagValueInput(): string | undefined;
    private _resourceName?;
    get resourceName(): string;
    set resourceName(value: string);
    get resourceNameInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _stat?;
    get stat(): string;
    set stat(value: string);
    get statInput(): string | undefined;
}
export interface DashboardWidgetQueryValueDefinitionRequestQueryApmResourceStatsQuery {
    /**
    * The data source for APM Resource Stats queries. Valid values are `apm_resource_stats`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
    */
    readonly dataSource: string;
    /**
    * APM Environment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#env Dashboard#env}
    */
    readonly env: string;
    /**
    * Array of fields to group results by.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
    */
    readonly groupBy?: string[];
    /**
    * The name of query for use in formulas.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
    */
    readonly name: string;
    /**
    * Name of operation on service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#operation_name Dashboard#operation_name}
    */
    readonly operationName?: string;
    /**
    * The name of the second primary tag used within APM; required when `primary_tag_value` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_name Dashboard#primary_tag_name}
    */
    readonly primaryTagName?: string;
    /**
    * Filter APM data by the second primary tag. `primary_tag_name` must also be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_value Dashboard#primary_tag_value}
    */
    readonly primaryTagValue?: string;
    /**
    * APM resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#resource_name Dashboard#resource_name}
    */
    readonly resourceName?: string;
    /**
    * APM service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service Dashboard#service}
    */
    readonly service: string;
    /**
    * APM statistic. Valid values are `errors`, `error_rate`, `hits`, `latency_avg`, `latency_distribution`, `latency_max`, `latency_p50`, `latency_p75`, `latency_p90`, `latency_p95`, `latency_p99`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#stat Dashboard#stat}
    */
    readonly stat: string;
}
export declare function dashboardWidgetQueryValueDefinitionRequestQueryApmResourceStatsQueryToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestQueryApmResourceStatsQueryOutputReference | DashboardWidgetQueryValueDefinitionRequestQueryApmResourceStatsQuery): any;
export declare class DashboardWidgetQueryValueDefinitionRequestQueryApmResourceStatsQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestQueryApmResourceStatsQuery | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestQueryApmResourceStatsQuery | undefined);
    private _dataSource?;
    get dataSource(): string;
    set dataSource(value: string);
    get dataSourceInput(): string | undefined;
    private _env?;
    get env(): string;
    set env(value: string);
    get envInput(): string | undefined;
    private _groupBy?;
    get groupBy(): string[];
    set groupBy(value: string[]);
    resetGroupBy(): void;
    get groupByInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _operationName?;
    get operationName(): string;
    set operationName(value: string);
    resetOperationName(): void;
    get operationNameInput(): string | undefined;
    private _primaryTagName?;
    get primaryTagName(): string;
    set primaryTagName(value: string);
    resetPrimaryTagName(): void;
    get primaryTagNameInput(): string | undefined;
    private _primaryTagValue?;
    get primaryTagValue(): string;
    set primaryTagValue(value: string);
    resetPrimaryTagValue(): void;
    get primaryTagValueInput(): string | undefined;
    private _resourceName?;
    get resourceName(): string;
    set resourceName(value: string);
    resetResourceName(): void;
    get resourceNameInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _stat?;
    get stat(): string;
    set stat(value: string);
    get statInput(): string | undefined;
}
export interface DashboardWidgetQueryValueDefinitionRequestQueryEventQueryCompute {
    /**
    * The aggregation methods for event platform queries. Valid values are `count`, `cardinality`, `median`, `pc75`, `pc90`, `pc95`, `pc98`, `pc99`, `sum`, `min`, `max`, `avg`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * A time interval in milliseconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
    /**
    * The measurable attribute to compute.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
    */
    readonly metric?: string;
}
export declare function dashboardWidgetQueryValueDefinitionRequestQueryEventQueryComputeToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestQueryEventQueryCompute | cdktf.IResolvable): any;
export declare class DashboardWidgetQueryValueDefinitionRequestQueryEventQueryComputeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestQueryEventQueryCompute | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestQueryEventQueryCompute | cdktf.IResolvable | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
    private _metric?;
    get metric(): string;
    set metric(value: string);
    resetMetric(): void;
    get metricInput(): string | undefined;
}
export declare class DashboardWidgetQueryValueDefinitionRequestQueryEventQueryComputeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetQueryValueDefinitionRequestQueryEventQueryCompute[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetQueryValueDefinitionRequestQueryEventQueryComputeOutputReference;
}
export interface DashboardWidgetQueryValueDefinitionRequestQueryEventQueryGroupBySort {
    /**
    * The aggregation methods for the event platform queries. Valid values are `count`, `cardinality`, `median`, `pc75`, `pc90`, `pc95`, `pc98`, `pc99`, `sum`, `min`, `max`, `avg`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The metric used for sorting group by results.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
    */
    readonly metric?: string;
    /**
    * Direction of sort. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
    */
    readonly order?: string;
}
export declare function dashboardWidgetQueryValueDefinitionRequestQueryEventQueryGroupBySortToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestQueryEventQueryGroupBySortOutputReference | DashboardWidgetQueryValueDefinitionRequestQueryEventQueryGroupBySort): any;
export declare class DashboardWidgetQueryValueDefinitionRequestQueryEventQueryGroupBySortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestQueryEventQueryGroupBySort | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestQueryEventQueryGroupBySort | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _metric?;
    get metric(): string;
    set metric(value: string);
    resetMetric(): void;
    get metricInput(): string | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    resetOrder(): void;
    get orderInput(): string | undefined;
}
export interface DashboardWidgetQueryValueDefinitionRequestQueryEventQueryGroupBy {
    /**
    * The event facet.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet: string;
    /**
    * The number of groups to return.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * sort block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort Dashboard#sort}
    */
    readonly sort?: DashboardWidgetQueryValueDefinitionRequestQueryEventQueryGroupBySort;
}
export declare function dashboardWidgetQueryValueDefinitionRequestQueryEventQueryGroupByToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestQueryEventQueryGroupBy | cdktf.IResolvable): any;
export declare class DashboardWidgetQueryValueDefinitionRequestQueryEventQueryGroupByOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestQueryEventQueryGroupBy | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestQueryEventQueryGroupBy | cdktf.IResolvable | undefined);
    private _facet?;
    get facet(): string;
    set facet(value: string);
    get facetInput(): string | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _sort;
    get sort(): DashboardWidgetQueryValueDefinitionRequestQueryEventQueryGroupBySortOutputReference;
    putSort(value: DashboardWidgetQueryValueDefinitionRequestQueryEventQueryGroupBySort): void;
    resetSort(): void;
    get sortInput(): DashboardWidgetQueryValueDefinitionRequestQueryEventQueryGroupBySort | undefined;
}
export declare class DashboardWidgetQueryValueDefinitionRequestQueryEventQueryGroupByList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetQueryValueDefinitionRequestQueryEventQueryGroupBy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetQueryValueDefinitionRequestQueryEventQueryGroupByOutputReference;
}
export interface DashboardWidgetQueryValueDefinitionRequestQueryEventQuerySearch {
    /**
    * The events search string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
    */
    readonly query: string;
}
export declare function dashboardWidgetQueryValueDefinitionRequestQueryEventQuerySearchToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestQueryEventQuerySearchOutputReference | DashboardWidgetQueryValueDefinitionRequestQueryEventQuerySearch): any;
export declare class DashboardWidgetQueryValueDefinitionRequestQueryEventQuerySearchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestQueryEventQuerySearch | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestQueryEventQuerySearch | undefined);
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
}
export interface DashboardWidgetQueryValueDefinitionRequestQueryEventQuery {
    /**
    * The data source for event platform-based queries. Valid values are `logs`, `spans`, `network`, `rum`, `security_signals`, `profiles`, `audit`, `events`, `ci_tests`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
    */
    readonly dataSource: string;
    /**
    * An array of index names to query in the stream.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#indexes Dashboard#indexes}
    */
    readonly indexes?: string[];
    /**
    * The name of query for use in formulas.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
    */
    readonly name: string;
    /**
    * Storage location (private beta).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#storage Dashboard#storage}
    */
    readonly storage?: string;
    /**
    * compute block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute Dashboard#compute}
    */
    readonly compute: DashboardWidgetQueryValueDefinitionRequestQueryEventQueryCompute[] | cdktf.IResolvable;
    /**
    * group_by block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
    */
    readonly groupBy?: DashboardWidgetQueryValueDefinitionRequestQueryEventQueryGroupBy[] | cdktf.IResolvable;
    /**
    * search block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search Dashboard#search}
    */
    readonly search?: DashboardWidgetQueryValueDefinitionRequestQueryEventQuerySearch;
}
export declare function dashboardWidgetQueryValueDefinitionRequestQueryEventQueryToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestQueryEventQueryOutputReference | DashboardWidgetQueryValueDefinitionRequestQueryEventQuery): any;
export declare class DashboardWidgetQueryValueDefinitionRequestQueryEventQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestQueryEventQuery | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestQueryEventQuery | undefined);
    private _dataSource?;
    get dataSource(): string;
    set dataSource(value: string);
    get dataSourceInput(): string | undefined;
    private _indexes?;
    get indexes(): string[];
    set indexes(value: string[]);
    resetIndexes(): void;
    get indexesInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _storage?;
    get storage(): string;
    set storage(value: string);
    resetStorage(): void;
    get storageInput(): string | undefined;
    private _compute;
    get compute(): DashboardWidgetQueryValueDefinitionRequestQueryEventQueryComputeList;
    putCompute(value: DashboardWidgetQueryValueDefinitionRequestQueryEventQueryCompute[] | cdktf.IResolvable): void;
    get computeInput(): cdktf.IResolvable | DashboardWidgetQueryValueDefinitionRequestQueryEventQueryCompute[] | undefined;
    private _groupBy;
    get groupBy(): DashboardWidgetQueryValueDefinitionRequestQueryEventQueryGroupByList;
    putGroupBy(value: DashboardWidgetQueryValueDefinitionRequestQueryEventQueryGroupBy[] | cdktf.IResolvable): void;
    resetGroupBy(): void;
    get groupByInput(): cdktf.IResolvable | DashboardWidgetQueryValueDefinitionRequestQueryEventQueryGroupBy[] | undefined;
    private _search;
    get search(): DashboardWidgetQueryValueDefinitionRequestQueryEventQuerySearchOutputReference;
    putSearch(value: DashboardWidgetQueryValueDefinitionRequestQueryEventQuerySearch): void;
    resetSearch(): void;
    get searchInput(): DashboardWidgetQueryValueDefinitionRequestQueryEventQuerySearch | undefined;
}
export interface DashboardWidgetQueryValueDefinitionRequestQueryMetricQuery {
    /**
    * The aggregation methods available for metrics queries. Valid values are `avg`, `min`, `max`, `sum`, `last`, `area`, `l2norm`, `percentile`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregator Dashboard#aggregator}
    */
    readonly aggregator?: string;
    /**
    * The data source for metrics queries.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
    */
    readonly dataSource?: string;
    /**
    * The name of the query for use in formulas.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
    */
    readonly name: string;
    /**
    * The metrics query definition.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
    */
    readonly query: string;
}
export declare function dashboardWidgetQueryValueDefinitionRequestQueryMetricQueryToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestQueryMetricQueryOutputReference | DashboardWidgetQueryValueDefinitionRequestQueryMetricQuery): any;
export declare class DashboardWidgetQueryValueDefinitionRequestQueryMetricQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestQueryMetricQuery | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestQueryMetricQuery | undefined);
    private _aggregator?;
    get aggregator(): string;
    set aggregator(value: string);
    resetAggregator(): void;
    get aggregatorInput(): string | undefined;
    private _dataSource?;
    get dataSource(): string;
    set dataSource(value: string);
    resetDataSource(): void;
    get dataSourceInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
}
export interface DashboardWidgetQueryValueDefinitionRequestQueryProcessQuery {
    /**
    * The aggregation methods available for metrics queries. Valid values are `avg`, `min`, `max`, `sum`, `last`, `area`, `l2norm`, `percentile`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregator Dashboard#aggregator}
    */
    readonly aggregator?: string;
    /**
    * The data source for process queries. Valid values are `process`, `container`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
    */
    readonly dataSource: string;
    /**
    * Whether to normalize the CPU percentages.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_normalized_cpu Dashboard#is_normalized_cpu}
    */
    readonly isNormalizedCpu?: boolean | cdktf.IResolvable;
    /**
    * The number of hits to return.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * The process metric name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
    */
    readonly metric: string;
    /**
    * The name of query for use in formulas.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
    */
    readonly name: string;
    /**
    * The direction of the sort. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort Dashboard#sort}
    */
    readonly sort?: string;
    /**
    * An array of tags to filter by.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#tag_filters Dashboard#tag_filters}
    */
    readonly tagFilters?: string[];
    /**
    * The text to use as a filter.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#text_filter Dashboard#text_filter}
    */
    readonly textFilter?: string;
}
export declare function dashboardWidgetQueryValueDefinitionRequestQueryProcessQueryToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestQueryProcessQueryOutputReference | DashboardWidgetQueryValueDefinitionRequestQueryProcessQuery): any;
export declare class DashboardWidgetQueryValueDefinitionRequestQueryProcessQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestQueryProcessQuery | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestQueryProcessQuery | undefined);
    private _aggregator?;
    get aggregator(): string;
    set aggregator(value: string);
    resetAggregator(): void;
    get aggregatorInput(): string | undefined;
    private _dataSource?;
    get dataSource(): string;
    set dataSource(value: string);
    get dataSourceInput(): string | undefined;
    private _isNormalizedCpu?;
    get isNormalizedCpu(): boolean | cdktf.IResolvable;
    set isNormalizedCpu(value: boolean | cdktf.IResolvable);
    resetIsNormalizedCpu(): void;
    get isNormalizedCpuInput(): boolean | cdktf.IResolvable | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _metric?;
    get metric(): string;
    set metric(value: string);
    get metricInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _sort?;
    get sort(): string;
    set sort(value: string);
    resetSort(): void;
    get sortInput(): string | undefined;
    private _tagFilters?;
    get tagFilters(): string[];
    set tagFilters(value: string[]);
    resetTagFilters(): void;
    get tagFiltersInput(): string[] | undefined;
    private _textFilter?;
    get textFilter(): string;
    set textFilter(value: string);
    resetTextFilter(): void;
    get textFilterInput(): string | undefined;
}
export interface DashboardWidgetQueryValueDefinitionRequestQuery {
    /**
    * apm_dependency_stats_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_dependency_stats_query Dashboard#apm_dependency_stats_query}
    */
    readonly apmDependencyStatsQuery?: DashboardWidgetQueryValueDefinitionRequestQueryApmDependencyStatsQuery;
    /**
    * apm_resource_stats_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_resource_stats_query Dashboard#apm_resource_stats_query}
    */
    readonly apmResourceStatsQuery?: DashboardWidgetQueryValueDefinitionRequestQueryApmResourceStatsQuery;
    /**
    * event_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#event_query Dashboard#event_query}
    */
    readonly eventQuery?: DashboardWidgetQueryValueDefinitionRequestQueryEventQuery;
    /**
    * metric_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric_query Dashboard#metric_query}
    */
    readonly metricQuery?: DashboardWidgetQueryValueDefinitionRequestQueryMetricQuery;
    /**
    * process_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#process_query Dashboard#process_query}
    */
    readonly processQuery?: DashboardWidgetQueryValueDefinitionRequestQueryProcessQuery;
}
export declare function dashboardWidgetQueryValueDefinitionRequestQueryToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestQuery | cdktf.IResolvable): any;
export declare class DashboardWidgetQueryValueDefinitionRequestQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestQuery | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestQuery | cdktf.IResolvable | undefined);
    private _apmDependencyStatsQuery;
    get apmDependencyStatsQuery(): DashboardWidgetQueryValueDefinitionRequestQueryApmDependencyStatsQueryOutputReference;
    putApmDependencyStatsQuery(value: DashboardWidgetQueryValueDefinitionRequestQueryApmDependencyStatsQuery): void;
    resetApmDependencyStatsQuery(): void;
    get apmDependencyStatsQueryInput(): DashboardWidgetQueryValueDefinitionRequestQueryApmDependencyStatsQuery | undefined;
    private _apmResourceStatsQuery;
    get apmResourceStatsQuery(): DashboardWidgetQueryValueDefinitionRequestQueryApmResourceStatsQueryOutputReference;
    putApmResourceStatsQuery(value: DashboardWidgetQueryValueDefinitionRequestQueryApmResourceStatsQuery): void;
    resetApmResourceStatsQuery(): void;
    get apmResourceStatsQueryInput(): DashboardWidgetQueryValueDefinitionRequestQueryApmResourceStatsQuery | undefined;
    private _eventQuery;
    get eventQuery(): DashboardWidgetQueryValueDefinitionRequestQueryEventQueryOutputReference;
    putEventQuery(value: DashboardWidgetQueryValueDefinitionRequestQueryEventQuery): void;
    resetEventQuery(): void;
    get eventQueryInput(): DashboardWidgetQueryValueDefinitionRequestQueryEventQuery | undefined;
    private _metricQuery;
    get metricQuery(): DashboardWidgetQueryValueDefinitionRequestQueryMetricQueryOutputReference;
    putMetricQuery(value: DashboardWidgetQueryValueDefinitionRequestQueryMetricQuery): void;
    resetMetricQuery(): void;
    get metricQueryInput(): DashboardWidgetQueryValueDefinitionRequestQueryMetricQuery | undefined;
    private _processQuery;
    get processQuery(): DashboardWidgetQueryValueDefinitionRequestQueryProcessQueryOutputReference;
    putProcessQuery(value: DashboardWidgetQueryValueDefinitionRequestQueryProcessQuery): void;
    resetProcessQuery(): void;
    get processQueryInput(): DashboardWidgetQueryValueDefinitionRequestQueryProcessQuery | undefined;
}
export declare class DashboardWidgetQueryValueDefinitionRequestQueryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetQueryValueDefinitionRequestQuery[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetQueryValueDefinitionRequestQueryOutputReference;
}
export interface DashboardWidgetQueryValueDefinitionRequestRumQueryComputeQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetQueryValueDefinitionRequestRumQueryComputeQueryToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestRumQueryComputeQueryOutputReference | DashboardWidgetQueryValueDefinitionRequestRumQueryComputeQuery): any;
export declare class DashboardWidgetQueryValueDefinitionRequestRumQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestRumQueryComputeQuery | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestRumQueryComputeQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export interface DashboardWidgetQueryValueDefinitionRequestRumQueryGroupBySortQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Widget sorting methods. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
    */
    readonly order: string;
}
export declare function dashboardWidgetQueryValueDefinitionRequestRumQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestRumQueryGroupBySortQueryOutputReference | DashboardWidgetQueryValueDefinitionRequestRumQueryGroupBySortQuery): any;
export declare class DashboardWidgetQueryValueDefinitionRequestRumQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestRumQueryGroupBySortQuery | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestRumQueryGroupBySortQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    get orderInput(): string | undefined;
}
export interface DashboardWidgetQueryValueDefinitionRequestRumQueryGroupBy {
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * The maximum number of items in the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * sort_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
    */
    readonly sortQuery?: DashboardWidgetQueryValueDefinitionRequestRumQueryGroupBySortQuery;
}
export declare function dashboardWidgetQueryValueDefinitionRequestRumQueryGroupByToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestRumQueryGroupBy | cdktf.IResolvable): any;
export declare class DashboardWidgetQueryValueDefinitionRequestRumQueryGroupByOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestRumQueryGroupBy | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestRumQueryGroupBy | cdktf.IResolvable | undefined);
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _sortQuery;
    get sortQuery(): DashboardWidgetQueryValueDefinitionRequestRumQueryGroupBySortQueryOutputReference;
    putSortQuery(value: DashboardWidgetQueryValueDefinitionRequestRumQueryGroupBySortQuery): void;
    resetSortQuery(): void;
    get sortQueryInput(): DashboardWidgetQueryValueDefinitionRequestRumQueryGroupBySortQuery | undefined;
}
export declare class DashboardWidgetQueryValueDefinitionRequestRumQueryGroupByList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetQueryValueDefinitionRequestRumQueryGroupBy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetQueryValueDefinitionRequestRumQueryGroupByOutputReference;
}
export interface DashboardWidgetQueryValueDefinitionRequestRumQueryMultiCompute {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetQueryValueDefinitionRequestRumQueryMultiComputeToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestRumQueryMultiCompute | cdktf.IResolvable): any;
export declare class DashboardWidgetQueryValueDefinitionRequestRumQueryMultiComputeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestRumQueryMultiCompute | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestRumQueryMultiCompute | cdktf.IResolvable | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export declare class DashboardWidgetQueryValueDefinitionRequestRumQueryMultiComputeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetQueryValueDefinitionRequestRumQueryMultiCompute[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetQueryValueDefinitionRequestRumQueryMultiComputeOutputReference;
}
export interface DashboardWidgetQueryValueDefinitionRequestRumQuery {
    /**
    * The name of the index to query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
    */
    readonly index: string;
    /**
    * The search query to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
    */
    readonly searchQuery?: string;
    /**
    * compute_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
    */
    readonly computeQuery?: DashboardWidgetQueryValueDefinitionRequestRumQueryComputeQuery;
    /**
    * group_by block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
    */
    readonly groupBy?: DashboardWidgetQueryValueDefinitionRequestRumQueryGroupBy[] | cdktf.IResolvable;
    /**
    * multi_compute block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
    */
    readonly multiCompute?: DashboardWidgetQueryValueDefinitionRequestRumQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetQueryValueDefinitionRequestRumQueryToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestRumQueryOutputReference | DashboardWidgetQueryValueDefinitionRequestRumQuery): any;
export declare class DashboardWidgetQueryValueDefinitionRequestRumQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestRumQuery | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestRumQuery | undefined);
    private _index?;
    get index(): string;
    set index(value: string);
    get indexInput(): string | undefined;
    private _searchQuery?;
    get searchQuery(): string;
    set searchQuery(value: string);
    resetSearchQuery(): void;
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    get computeQuery(): DashboardWidgetQueryValueDefinitionRequestRumQueryComputeQueryOutputReference;
    putComputeQuery(value: DashboardWidgetQueryValueDefinitionRequestRumQueryComputeQuery): void;
    resetComputeQuery(): void;
    get computeQueryInput(): DashboardWidgetQueryValueDefinitionRequestRumQueryComputeQuery | undefined;
    private _groupBy;
    get groupBy(): DashboardWidgetQueryValueDefinitionRequestRumQueryGroupByList;
    putGroupBy(value: DashboardWidgetQueryValueDefinitionRequestRumQueryGroupBy[] | cdktf.IResolvable): void;
    resetGroupBy(): void;
    get groupByInput(): cdktf.IResolvable | DashboardWidgetQueryValueDefinitionRequestRumQueryGroupBy[] | undefined;
    private _multiCompute;
    get multiCompute(): DashboardWidgetQueryValueDefinitionRequestRumQueryMultiComputeList;
    putMultiCompute(value: DashboardWidgetQueryValueDefinitionRequestRumQueryMultiCompute[] | cdktf.IResolvable): void;
    resetMultiCompute(): void;
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetQueryValueDefinitionRequestRumQueryMultiCompute[] | undefined;
}
export interface DashboardWidgetQueryValueDefinitionRequestSecurityQueryComputeQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetQueryValueDefinitionRequestSecurityQueryComputeQueryToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestSecurityQueryComputeQueryOutputReference | DashboardWidgetQueryValueDefinitionRequestSecurityQueryComputeQuery): any;
export declare class DashboardWidgetQueryValueDefinitionRequestSecurityQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestSecurityQueryComputeQuery | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestSecurityQueryComputeQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export interface DashboardWidgetQueryValueDefinitionRequestSecurityQueryGroupBySortQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Widget sorting methods. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
    */
    readonly order: string;
}
export declare function dashboardWidgetQueryValueDefinitionRequestSecurityQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestSecurityQueryGroupBySortQueryOutputReference | DashboardWidgetQueryValueDefinitionRequestSecurityQueryGroupBySortQuery): any;
export declare class DashboardWidgetQueryValueDefinitionRequestSecurityQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestSecurityQueryGroupBySortQuery | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestSecurityQueryGroupBySortQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    get orderInput(): string | undefined;
}
export interface DashboardWidgetQueryValueDefinitionRequestSecurityQueryGroupBy {
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * The maximum number of items in the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * sort_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
    */
    readonly sortQuery?: DashboardWidgetQueryValueDefinitionRequestSecurityQueryGroupBySortQuery;
}
export declare function dashboardWidgetQueryValueDefinitionRequestSecurityQueryGroupByToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestSecurityQueryGroupBy | cdktf.IResolvable): any;
export declare class DashboardWidgetQueryValueDefinitionRequestSecurityQueryGroupByOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestSecurityQueryGroupBy | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestSecurityQueryGroupBy | cdktf.IResolvable | undefined);
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _sortQuery;
    get sortQuery(): DashboardWidgetQueryValueDefinitionRequestSecurityQueryGroupBySortQueryOutputReference;
    putSortQuery(value: DashboardWidgetQueryValueDefinitionRequestSecurityQueryGroupBySortQuery): void;
    resetSortQuery(): void;
    get sortQueryInput(): DashboardWidgetQueryValueDefinitionRequestSecurityQueryGroupBySortQuery | undefined;
}
export declare class DashboardWidgetQueryValueDefinitionRequestSecurityQueryGroupByList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetQueryValueDefinitionRequestSecurityQueryGroupBy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetQueryValueDefinitionRequestSecurityQueryGroupByOutputReference;
}
export interface DashboardWidgetQueryValueDefinitionRequestSecurityQueryMultiCompute {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetQueryValueDefinitionRequestSecurityQueryMultiComputeToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestSecurityQueryMultiCompute | cdktf.IResolvable): any;
export declare class DashboardWidgetQueryValueDefinitionRequestSecurityQueryMultiComputeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestSecurityQueryMultiCompute | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestSecurityQueryMultiCompute | cdktf.IResolvable | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export declare class DashboardWidgetQueryValueDefinitionRequestSecurityQueryMultiComputeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetQueryValueDefinitionRequestSecurityQueryMultiCompute[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetQueryValueDefinitionRequestSecurityQueryMultiComputeOutputReference;
}
export interface DashboardWidgetQueryValueDefinitionRequestSecurityQuery {
    /**
    * The name of the index to query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
    */
    readonly index: string;
    /**
    * The search query to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
    */
    readonly searchQuery?: string;
    /**
    * compute_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
    */
    readonly computeQuery?: DashboardWidgetQueryValueDefinitionRequestSecurityQueryComputeQuery;
    /**
    * group_by block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
    */
    readonly groupBy?: DashboardWidgetQueryValueDefinitionRequestSecurityQueryGroupBy[] | cdktf.IResolvable;
    /**
    * multi_compute block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
    */
    readonly multiCompute?: DashboardWidgetQueryValueDefinitionRequestSecurityQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetQueryValueDefinitionRequestSecurityQueryToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequestSecurityQueryOutputReference | DashboardWidgetQueryValueDefinitionRequestSecurityQuery): any;
export declare class DashboardWidgetQueryValueDefinitionRequestSecurityQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequestSecurityQuery | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequestSecurityQuery | undefined);
    private _index?;
    get index(): string;
    set index(value: string);
    get indexInput(): string | undefined;
    private _searchQuery?;
    get searchQuery(): string;
    set searchQuery(value: string);
    resetSearchQuery(): void;
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    get computeQuery(): DashboardWidgetQueryValueDefinitionRequestSecurityQueryComputeQueryOutputReference;
    putComputeQuery(value: DashboardWidgetQueryValueDefinitionRequestSecurityQueryComputeQuery): void;
    resetComputeQuery(): void;
    get computeQueryInput(): DashboardWidgetQueryValueDefinitionRequestSecurityQueryComputeQuery | undefined;
    private _groupBy;
    get groupBy(): DashboardWidgetQueryValueDefinitionRequestSecurityQueryGroupByList;
    putGroupBy(value: DashboardWidgetQueryValueDefinitionRequestSecurityQueryGroupBy[] | cdktf.IResolvable): void;
    resetGroupBy(): void;
    get groupByInput(): cdktf.IResolvable | DashboardWidgetQueryValueDefinitionRequestSecurityQueryGroupBy[] | undefined;
    private _multiCompute;
    get multiCompute(): DashboardWidgetQueryValueDefinitionRequestSecurityQueryMultiComputeList;
    putMultiCompute(value: DashboardWidgetQueryValueDefinitionRequestSecurityQueryMultiCompute[] | cdktf.IResolvable): void;
    resetMultiCompute(): void;
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetQueryValueDefinitionRequestSecurityQueryMultiCompute[] | undefined;
}
export interface DashboardWidgetQueryValueDefinitionRequest {
    /**
    * The aggregator to use for time aggregation. Valid values are `avg`, `last`, `max`, `min`, `sum`, `percentile`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregator Dashboard#aggregator}
    */
    readonly aggregator?: string;
    /**
    * The metric query to use for this widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#q Dashboard#q}
    */
    readonly q?: string;
    /**
    * apm_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_query Dashboard#apm_query}
    */
    readonly apmQuery?: DashboardWidgetQueryValueDefinitionRequestApmQuery;
    /**
    * audit_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#audit_query Dashboard#audit_query}
    */
    readonly auditQuery?: DashboardWidgetQueryValueDefinitionRequestAuditQuery;
    /**
    * conditional_formats block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#conditional_formats Dashboard#conditional_formats}
    */
    readonly conditionalFormats?: DashboardWidgetQueryValueDefinitionRequestConditionalFormats[] | cdktf.IResolvable;
    /**
    * formula block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#formula Dashboard#formula}
    */
    readonly formula?: DashboardWidgetQueryValueDefinitionRequestFormula[] | cdktf.IResolvable;
    /**
    * log_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#log_query Dashboard#log_query}
    */
    readonly logQuery?: DashboardWidgetQueryValueDefinitionRequestLogQuery;
    /**
    * process_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#process_query Dashboard#process_query}
    */
    readonly processQuery?: DashboardWidgetQueryValueDefinitionRequestProcessQuery;
    /**
    * query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
    */
    readonly query?: DashboardWidgetQueryValueDefinitionRequestQuery[] | cdktf.IResolvable;
    /**
    * rum_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#rum_query Dashboard#rum_query}
    */
    readonly rumQuery?: DashboardWidgetQueryValueDefinitionRequestRumQuery;
    /**
    * security_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#security_query Dashboard#security_query}
    */
    readonly securityQuery?: DashboardWidgetQueryValueDefinitionRequestSecurityQuery;
}
export declare function dashboardWidgetQueryValueDefinitionRequestToTerraform(struct?: DashboardWidgetQueryValueDefinitionRequest | cdktf.IResolvable): any;
export declare class DashboardWidgetQueryValueDefinitionRequestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetQueryValueDefinitionRequest | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionRequest | cdktf.IResolvable | undefined);
    private _aggregator?;
    get aggregator(): string;
    set aggregator(value: string);
    resetAggregator(): void;
    get aggregatorInput(): string | undefined;
    private _q?;
    get q(): string;
    set q(value: string);
    resetQ(): void;
    get qInput(): string | undefined;
    private _apmQuery;
    get apmQuery(): DashboardWidgetQueryValueDefinitionRequestApmQueryOutputReference;
    putApmQuery(value: DashboardWidgetQueryValueDefinitionRequestApmQuery): void;
    resetApmQuery(): void;
    get apmQueryInput(): DashboardWidgetQueryValueDefinitionRequestApmQuery | undefined;
    private _auditQuery;
    get auditQuery(): DashboardWidgetQueryValueDefinitionRequestAuditQueryOutputReference;
    putAuditQuery(value: DashboardWidgetQueryValueDefinitionRequestAuditQuery): void;
    resetAuditQuery(): void;
    get auditQueryInput(): DashboardWidgetQueryValueDefinitionRequestAuditQuery | undefined;
    private _conditionalFormats;
    get conditionalFormats(): DashboardWidgetQueryValueDefinitionRequestConditionalFormatsList;
    putConditionalFormats(value: DashboardWidgetQueryValueDefinitionRequestConditionalFormats[] | cdktf.IResolvable): void;
    resetConditionalFormats(): void;
    get conditionalFormatsInput(): cdktf.IResolvable | DashboardWidgetQueryValueDefinitionRequestConditionalFormats[] | undefined;
    private _formula;
    get formula(): DashboardWidgetQueryValueDefinitionRequestFormulaList;
    putFormula(value: DashboardWidgetQueryValueDefinitionRequestFormula[] | cdktf.IResolvable): void;
    resetFormula(): void;
    get formulaInput(): cdktf.IResolvable | DashboardWidgetQueryValueDefinitionRequestFormula[] | undefined;
    private _logQuery;
    get logQuery(): DashboardWidgetQueryValueDefinitionRequestLogQueryOutputReference;
    putLogQuery(value: DashboardWidgetQueryValueDefinitionRequestLogQuery): void;
    resetLogQuery(): void;
    get logQueryInput(): DashboardWidgetQueryValueDefinitionRequestLogQuery | undefined;
    private _processQuery;
    get processQuery(): DashboardWidgetQueryValueDefinitionRequestProcessQueryOutputReference;
    putProcessQuery(value: DashboardWidgetQueryValueDefinitionRequestProcessQuery): void;
    resetProcessQuery(): void;
    get processQueryInput(): DashboardWidgetQueryValueDefinitionRequestProcessQuery | undefined;
    private _query;
    get query(): DashboardWidgetQueryValueDefinitionRequestQueryList;
    putQuery(value: DashboardWidgetQueryValueDefinitionRequestQuery[] | cdktf.IResolvable): void;
    resetQuery(): void;
    get queryInput(): cdktf.IResolvable | DashboardWidgetQueryValueDefinitionRequestQuery[] | undefined;
    private _rumQuery;
    get rumQuery(): DashboardWidgetQueryValueDefinitionRequestRumQueryOutputReference;
    putRumQuery(value: DashboardWidgetQueryValueDefinitionRequestRumQuery): void;
    resetRumQuery(): void;
    get rumQueryInput(): DashboardWidgetQueryValueDefinitionRequestRumQuery | undefined;
    private _securityQuery;
    get securityQuery(): DashboardWidgetQueryValueDefinitionRequestSecurityQueryOutputReference;
    putSecurityQuery(value: DashboardWidgetQueryValueDefinitionRequestSecurityQuery): void;
    resetSecurityQuery(): void;
    get securityQueryInput(): DashboardWidgetQueryValueDefinitionRequestSecurityQuery | undefined;
}
export declare class DashboardWidgetQueryValueDefinitionRequestList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetQueryValueDefinitionRequest[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetQueryValueDefinitionRequestOutputReference;
}
export interface DashboardWidgetQueryValueDefinitionTimeseriesBackgroundYaxis {
    /**
    * Always include zero or fit the axis to the data range.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#include_zero Dashboard#include_zero}
    */
    readonly includeZero?: boolean | cdktf.IResolvable;
    /**
    * The label of the axis to display on the graph.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#label Dashboard#label}
    */
    readonly label?: string;
    /**
    * Specify the maximum value to show on the Y-axis.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#max Dashboard#max}
    */
    readonly max?: string;
    /**
    * Specify the minimum value to show on the Y-axis.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#min Dashboard#min}
    */
    readonly min?: string;
    /**
    * Specify the scale type, options: `linear`, `log`, `pow`, `sqrt`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#scale Dashboard#scale}
    */
    readonly scale?: string;
}
export declare function dashboardWidgetQueryValueDefinitionTimeseriesBackgroundYaxisToTerraform(struct?: DashboardWidgetQueryValueDefinitionTimeseriesBackgroundYaxisOutputReference | DashboardWidgetQueryValueDefinitionTimeseriesBackgroundYaxis): any;
export declare class DashboardWidgetQueryValueDefinitionTimeseriesBackgroundYaxisOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryValueDefinitionTimeseriesBackgroundYaxis | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionTimeseriesBackgroundYaxis | undefined);
    private _includeZero?;
    get includeZero(): boolean | cdktf.IResolvable;
    set includeZero(value: boolean | cdktf.IResolvable);
    resetIncludeZero(): void;
    get includeZeroInput(): boolean | cdktf.IResolvable | undefined;
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _max?;
    get max(): string;
    set max(value: string);
    resetMax(): void;
    get maxInput(): string | undefined;
    private _min?;
    get min(): string;
    set min(value: string);
    resetMin(): void;
    get minInput(): string | undefined;
    private _scale?;
    get scale(): string;
    set scale(value: string);
    resetScale(): void;
    get scaleInput(): string | undefined;
}
export interface DashboardWidgetQueryValueDefinitionTimeseriesBackground {
    /**
    * Whether the Timeseries is made using an area or bars. Valid values are `bars`, `area`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#type Dashboard#type}
    */
    readonly type: string;
    /**
    * yaxis block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#yaxis Dashboard#yaxis}
    */
    readonly yaxis?: DashboardWidgetQueryValueDefinitionTimeseriesBackgroundYaxis;
}
export declare function dashboardWidgetQueryValueDefinitionTimeseriesBackgroundToTerraform(struct?: DashboardWidgetQueryValueDefinitionTimeseriesBackgroundOutputReference | DashboardWidgetQueryValueDefinitionTimeseriesBackground): any;
export declare class DashboardWidgetQueryValueDefinitionTimeseriesBackgroundOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryValueDefinitionTimeseriesBackground | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinitionTimeseriesBackground | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _yaxis;
    get yaxis(): DashboardWidgetQueryValueDefinitionTimeseriesBackgroundYaxisOutputReference;
    putYaxis(value: DashboardWidgetQueryValueDefinitionTimeseriesBackgroundYaxis): void;
    resetYaxis(): void;
    get yaxisInput(): DashboardWidgetQueryValueDefinitionTimeseriesBackgroundYaxis | undefined;
}
export interface DashboardWidgetQueryValueDefinition {
    /**
    * A Boolean indicating whether to automatically scale the tile.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#autoscale Dashboard#autoscale}
    */
    readonly autoscale?: boolean | cdktf.IResolvable;
    /**
    * The unit for the value displayed in the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_unit Dashboard#custom_unit}
    */
    readonly customUnit?: string;
    /**
    * The timeframe to use when displaying the widget. Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#live_span Dashboard#live_span}
    */
    readonly liveSpan?: string;
    /**
    * The precision to use when displaying the tile.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#precision Dashboard#precision}
    */
    readonly precision?: number;
    /**
    * The alignment of the widget's text. Valid values are `center`, `left`, `right`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#text_align Dashboard#text_align}
    */
    readonly textAlign?: string;
    /**
    * The title of the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
    */
    readonly title?: string;
    /**
    * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_align Dashboard#title_align}
    */
    readonly titleAlign?: string;
    /**
    * The size of the widget's title (defaults to 16).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title_size Dashboard#title_size}
    */
    readonly titleSize?: string;
    /**
    * custom_link block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#custom_link Dashboard#custom_link}
    */
    readonly customLink?: DashboardWidgetQueryValueDefinitionCustomLink[] | cdktf.IResolvable;
    /**
    * request block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#request Dashboard#request}
    */
    readonly request?: DashboardWidgetQueryValueDefinitionRequest[] | cdktf.IResolvable;
    /**
    * timeseries_background block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#timeseries_background Dashboard#timeseries_background}
    */
    readonly timeseriesBackground?: DashboardWidgetQueryValueDefinitionTimeseriesBackground;
}
export declare function dashboardWidgetQueryValueDefinitionToTerraform(struct?: DashboardWidgetQueryValueDefinitionOutputReference | DashboardWidgetQueryValueDefinition): any;
export declare class DashboardWidgetQueryValueDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetQueryValueDefinition | undefined;
    set internalValue(value: DashboardWidgetQueryValueDefinition | undefined);
    private _autoscale?;
    get autoscale(): boolean | cdktf.IResolvable;
    set autoscale(value: boolean | cdktf.IResolvable);
    resetAutoscale(): void;
    get autoscaleInput(): boolean | cdktf.IResolvable | undefined;
    private _customUnit?;
    get customUnit(): string;
    set customUnit(value: string);
    resetCustomUnit(): void;
    get customUnitInput(): string | undefined;
    private _liveSpan?;
    get liveSpan(): string;
    set liveSpan(value: string);
    resetLiveSpan(): void;
    get liveSpanInput(): string | undefined;
    private _precision?;
    get precision(): number;
    set precision(value: number);
    resetPrecision(): void;
    get precisionInput(): number | undefined;
    private _textAlign?;
    get textAlign(): string;
    set textAlign(value: string);
    resetTextAlign(): void;
    get textAlignInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
    private _titleAlign?;
    get titleAlign(): string;
    set titleAlign(value: string);
    resetTitleAlign(): void;
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    get titleSize(): string;
    set titleSize(value: string);
    resetTitleSize(): void;
    get titleSizeInput(): string | undefined;
    private _customLink;
    get customLink(): DashboardWidgetQueryValueDefinitionCustomLinkList;
    putCustomLink(value: DashboardWidgetQueryValueDefinitionCustomLink[] | cdktf.IResolvable): void;
    resetCustomLink(): void;
    get customLinkInput(): cdktf.IResolvable | DashboardWidgetQueryValueDefinitionCustomLink[] | undefined;
    private _request;
    get request(): DashboardWidgetQueryValueDefinitionRequestList;
    putRequest(value: DashboardWidgetQueryValueDefinitionRequest[] | cdktf.IResolvable): void;
    resetRequest(): void;
    get requestInput(): cdktf.IResolvable | DashboardWidgetQueryValueDefinitionRequest[] | undefined;
    private _timeseriesBackground;
    get timeseriesBackground(): DashboardWidgetQueryValueDefinitionTimeseriesBackgroundOutputReference;
    putTimeseriesBackground(value: DashboardWidgetQueryValueDefinitionTimeseriesBackground): void;
    resetTimeseriesBackground(): void;
    get timeseriesBackgroundInput(): DashboardWidgetQueryValueDefinitionTimeseriesBackground | undefined;
}
export interface DashboardWidgetScatterplotDefinitionCustomLink {
    /**
    * The flag for toggling context menu link visibility.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_hidden Dashboard#is_hidden}
    */
    readonly isHidden?: boolean | cdktf.IResolvable;
    /**
    * The label for the custom link URL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#label Dashboard#label}
    */
    readonly label?: string;
    /**
    * The URL of the custom link.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#link Dashboard#link}
    */
    readonly link?: string;
    /**
    * The label id that refers to a context menu link item. When override_label is provided, the client request omits the label field.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#override_label Dashboard#override_label}
    */
    readonly overrideLabel?: string;
}
export declare function dashboardWidgetScatterplotDefinitionCustomLinkToTerraform(struct?: DashboardWidgetScatterplotDefinitionCustomLink | cdktf.IResolvable): any;
export declare class DashboardWidgetScatterplotDefinitionCustomLinkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetScatterplotDefinitionCustomLink | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetScatterplotDefinitionCustomLink | cdktf.IResolvable | undefined);
    private _isHidden?;
    get isHidden(): boolean | cdktf.IResolvable;
    set isHidden(value: boolean | cdktf.IResolvable);
    resetIsHidden(): void;
    get isHiddenInput(): boolean | cdktf.IResolvable | undefined;
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _link?;
    get link(): string;
    set link(value: string);
    resetLink(): void;
    get linkInput(): string | undefined;
    private _overrideLabel?;
    get overrideLabel(): string;
    set overrideLabel(value: string);
    resetOverrideLabel(): void;
    get overrideLabelInput(): string | undefined;
}
export declare class DashboardWidgetScatterplotDefinitionCustomLinkList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetScatterplotDefinitionCustomLink[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetScatterplotDefinitionCustomLinkOutputReference;
}
export interface DashboardWidgetScatterplotDefinitionRequestScatterplotTableFormula {
    /**
    * An expression alias.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#alias Dashboard#alias}
    */
    readonly alias?: string;
    /**
    * Dimension of the Scatterplot. Valid values are `x`, `y`, `radius`, `color`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#dimension Dashboard#dimension}
    */
    readonly dimension: string;
    /**
    * A string expression built from queries, formulas, and functions.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#formula_expression Dashboard#formula_expression}
    */
    readonly formulaExpression: string;
}
export declare function dashboardWidgetScatterplotDefinitionRequestScatterplotTableFormulaToTerraform(struct?: DashboardWidgetScatterplotDefinitionRequestScatterplotTableFormula | cdktf.IResolvable): any;
export declare class DashboardWidgetScatterplotDefinitionRequestScatterplotTableFormulaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetScatterplotDefinitionRequestScatterplotTableFormula | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetScatterplotDefinitionRequestScatterplotTableFormula | cdktf.IResolvable | undefined);
    private _alias?;
    get alias(): string;
    set alias(value: string);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    private _dimension?;
    get dimension(): string;
    set dimension(value: string);
    get dimensionInput(): string | undefined;
    private _formulaExpression?;
    get formulaExpression(): string;
    set formulaExpression(value: string);
    get formulaExpressionInput(): string | undefined;
}
export declare class DashboardWidgetScatterplotDefinitionRequestScatterplotTableFormulaList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetScatterplotDefinitionRequestScatterplotTableFormula[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetScatterplotDefinitionRequestScatterplotTableFormulaOutputReference;
}
export interface DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryApmDependencyStatsQuery {
    /**
    * The data source for APM Dependency Stats queries. Valid values are `apm_dependency_stats`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
    */
    readonly dataSource: string;
    /**
    * APM Environment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#env Dashboard#env}
    */
    readonly env: string;
    /**
    * Determines whether stats for upstream or downstream dependencies should be queried.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_upstream Dashboard#is_upstream}
    */
    readonly isUpstream?: boolean | cdktf.IResolvable;
    /**
    * The name of query for use in formulas.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
    */
    readonly name: string;
    /**
    * Name of operation on service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#operation_name Dashboard#operation_name}
    */
    readonly operationName: string;
    /**
    * The name of the second primary tag used within APM; required when `primary_tag_value` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_name Dashboard#primary_tag_name}
    */
    readonly primaryTagName?: string;
    /**
    * Filter APM data by the second primary tag. `primary_tag_name` must also be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_value Dashboard#primary_tag_value}
    */
    readonly primaryTagValue?: string;
    /**
    * APM resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#resource_name Dashboard#resource_name}
    */
    readonly resourceName: string;
    /**
    * APM service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service Dashboard#service}
    */
    readonly service: string;
    /**
    * APM statistic. Valid values are `avg_duration`, `avg_root_duration`, `avg_spans_per_trace`, `error_rate`, `pct_exec_time`, `pct_of_traces`, `total_traces_count`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#stat Dashboard#stat}
    */
    readonly stat: string;
}
export declare function dashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryApmDependencyStatsQueryToTerraform(struct?: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryApmDependencyStatsQueryOutputReference | DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryApmDependencyStatsQuery): any;
export declare class DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryApmDependencyStatsQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryApmDependencyStatsQuery | undefined;
    set internalValue(value: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryApmDependencyStatsQuery | undefined);
    private _dataSource?;
    get dataSource(): string;
    set dataSource(value: string);
    get dataSourceInput(): string | undefined;
    private _env?;
    get env(): string;
    set env(value: string);
    get envInput(): string | undefined;
    private _isUpstream?;
    get isUpstream(): boolean | cdktf.IResolvable;
    set isUpstream(value: boolean | cdktf.IResolvable);
    resetIsUpstream(): void;
    get isUpstreamInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _operationName?;
    get operationName(): string;
    set operationName(value: string);
    get operationNameInput(): string | undefined;
    private _primaryTagName?;
    get primaryTagName(): string;
    set primaryTagName(value: string);
    resetPrimaryTagName(): void;
    get primaryTagNameInput(): string | undefined;
    private _primaryTagValue?;
    get primaryTagValue(): string;
    set primaryTagValue(value: string);
    resetPrimaryTagValue(): void;
    get primaryTagValueInput(): string | undefined;
    private _resourceName?;
    get resourceName(): string;
    set resourceName(value: string);
    get resourceNameInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _stat?;
    get stat(): string;
    set stat(value: string);
    get statInput(): string | undefined;
}
export interface DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryApmResourceStatsQuery {
    /**
    * The data source for APM Resource Stats queries. Valid values are `apm_resource_stats`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
    */
    readonly dataSource: string;
    /**
    * APM Environment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#env Dashboard#env}
    */
    readonly env: string;
    /**
    * Array of fields to group results by.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
    */
    readonly groupBy?: string[];
    /**
    * The name of query for use in formulas.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
    */
    readonly name: string;
    /**
    * Name of operation on service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#operation_name Dashboard#operation_name}
    */
    readonly operationName?: string;
    /**
    * The name of the second primary tag used within APM; required when `primary_tag_value` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_name Dashboard#primary_tag_name}
    */
    readonly primaryTagName?: string;
    /**
    * Filter APM data by the second primary tag. `primary_tag_name` must also be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#primary_tag_value Dashboard#primary_tag_value}
    */
    readonly primaryTagValue?: string;
    /**
    * APM resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#resource_name Dashboard#resource_name}
    */
    readonly resourceName?: string;
    /**
    * APM service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#service Dashboard#service}
    */
    readonly service: string;
    /**
    * APM statistic. Valid values are `errors`, `error_rate`, `hits`, `latency_avg`, `latency_distribution`, `latency_max`, `latency_p50`, `latency_p75`, `latency_p90`, `latency_p95`, `latency_p99`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#stat Dashboard#stat}
    */
    readonly stat: string;
}
export declare function dashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryApmResourceStatsQueryToTerraform(struct?: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryApmResourceStatsQueryOutputReference | DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryApmResourceStatsQuery): any;
export declare class DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryApmResourceStatsQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryApmResourceStatsQuery | undefined;
    set internalValue(value: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryApmResourceStatsQuery | undefined);
    private _dataSource?;
    get dataSource(): string;
    set dataSource(value: string);
    get dataSourceInput(): string | undefined;
    private _env?;
    get env(): string;
    set env(value: string);
    get envInput(): string | undefined;
    private _groupBy?;
    get groupBy(): string[];
    set groupBy(value: string[]);
    resetGroupBy(): void;
    get groupByInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _operationName?;
    get operationName(): string;
    set operationName(value: string);
    resetOperationName(): void;
    get operationNameInput(): string | undefined;
    private _primaryTagName?;
    get primaryTagName(): string;
    set primaryTagName(value: string);
    resetPrimaryTagName(): void;
    get primaryTagNameInput(): string | undefined;
    private _primaryTagValue?;
    get primaryTagValue(): string;
    set primaryTagValue(value: string);
    resetPrimaryTagValue(): void;
    get primaryTagValueInput(): string | undefined;
    private _resourceName?;
    get resourceName(): string;
    set resourceName(value: string);
    resetResourceName(): void;
    get resourceNameInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _stat?;
    get stat(): string;
    set stat(value: string);
    get statInput(): string | undefined;
}
export interface DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryCompute {
    /**
    * The aggregation methods for event platform queries. Valid values are `count`, `cardinality`, `median`, `pc75`, `pc90`, `pc95`, `pc98`, `pc99`, `sum`, `min`, `max`, `avg`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * A time interval in milliseconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
    /**
    * The measurable attribute to compute.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
    */
    readonly metric?: string;
}
export declare function dashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryComputeToTerraform(struct?: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryCompute | cdktf.IResolvable): any;
export declare class DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryComputeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryCompute | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryCompute | cdktf.IResolvable | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
    private _metric?;
    get metric(): string;
    set metric(value: string);
    resetMetric(): void;
    get metricInput(): string | undefined;
}
export declare class DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryComputeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryCompute[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryComputeOutputReference;
}
export interface DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryGroupBySort {
    /**
    * The aggregation methods for the event platform queries. Valid values are `count`, `cardinality`, `median`, `pc75`, `pc90`, `pc95`, `pc98`, `pc99`, `sum`, `min`, `max`, `avg`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The metric used for sorting group by results.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
    */
    readonly metric?: string;
    /**
    * Direction of sort. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
    */
    readonly order?: string;
}
export declare function dashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryGroupBySortToTerraform(struct?: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryGroupBySortOutputReference | DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryGroupBySort): any;
export declare class DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryGroupBySortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryGroupBySort | undefined;
    set internalValue(value: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryGroupBySort | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _metric?;
    get metric(): string;
    set metric(value: string);
    resetMetric(): void;
    get metricInput(): string | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    resetOrder(): void;
    get orderInput(): string | undefined;
}
export interface DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryGroupBy {
    /**
    * The event facet.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet: string;
    /**
    * The number of groups to return.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * sort block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort Dashboard#sort}
    */
    readonly sort?: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryGroupBySort;
}
export declare function dashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryGroupByToTerraform(struct?: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryGroupBy | cdktf.IResolvable): any;
export declare class DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryGroupByOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryGroupBy | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryGroupBy | cdktf.IResolvable | undefined);
    private _facet?;
    get facet(): string;
    set facet(value: string);
    get facetInput(): string | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _sort;
    get sort(): DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryGroupBySortOutputReference;
    putSort(value: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryGroupBySort): void;
    resetSort(): void;
    get sortInput(): DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryGroupBySort | undefined;
}
export declare class DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryGroupByList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryGroupBy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryGroupByOutputReference;
}
export interface DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQuerySearch {
    /**
    * The events search string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
    */
    readonly query: string;
}
export declare function dashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQuerySearchToTerraform(struct?: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQuerySearchOutputReference | DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQuerySearch): any;
export declare class DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQuerySearchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQuerySearch | undefined;
    set internalValue(value: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQuerySearch | undefined);
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
}
export interface DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQuery {
    /**
    * The data source for event platform-based queries. Valid values are `logs`, `spans`, `network`, `rum`, `security_signals`, `profiles`, `audit`, `events`, `ci_tests`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
    */
    readonly dataSource: string;
    /**
    * An array of index names to query in the stream.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#indexes Dashboard#indexes}
    */
    readonly indexes?: string[];
    /**
    * The name of query for use in formulas.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
    */
    readonly name: string;
    /**
    * Storage location (private beta).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#storage Dashboard#storage}
    */
    readonly storage?: string;
    /**
    * compute block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute Dashboard#compute}
    */
    readonly compute: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryCompute[] | cdktf.IResolvable;
    /**
    * group_by block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
    */
    readonly groupBy?: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryGroupBy[] | cdktf.IResolvable;
    /**
    * search block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search Dashboard#search}
    */
    readonly search?: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQuerySearch;
}
export declare function dashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryToTerraform(struct?: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryOutputReference | DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQuery): any;
export declare class DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQuery | undefined;
    set internalValue(value: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQuery | undefined);
    private _dataSource?;
    get dataSource(): string;
    set dataSource(value: string);
    get dataSourceInput(): string | undefined;
    private _indexes?;
    get indexes(): string[];
    set indexes(value: string[]);
    resetIndexes(): void;
    get indexesInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _storage?;
    get storage(): string;
    set storage(value: string);
    resetStorage(): void;
    get storageInput(): string | undefined;
    private _compute;
    get compute(): DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryComputeList;
    putCompute(value: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryCompute[] | cdktf.IResolvable): void;
    get computeInput(): cdktf.IResolvable | DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryCompute[] | undefined;
    private _groupBy;
    get groupBy(): DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryGroupByList;
    putGroupBy(value: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryGroupBy[] | cdktf.IResolvable): void;
    resetGroupBy(): void;
    get groupByInput(): cdktf.IResolvable | DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryGroupBy[] | undefined;
    private _search;
    get search(): DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQuerySearchOutputReference;
    putSearch(value: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQuerySearch): void;
    resetSearch(): void;
    get searchInput(): DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQuerySearch | undefined;
}
export interface DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryMetricQuery {
    /**
    * The aggregation methods available for metrics queries. Valid values are `avg`, `min`, `max`, `sum`, `last`, `area`, `l2norm`, `percentile`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregator Dashboard#aggregator}
    */
    readonly aggregator?: string;
    /**
    * The data source for metrics queries.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
    */
    readonly dataSource?: string;
    /**
    * The name of the query for use in formulas.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
    */
    readonly name: string;
    /**
    * The metrics query definition.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
    */
    readonly query: string;
}
export declare function dashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryMetricQueryToTerraform(struct?: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryMetricQueryOutputReference | DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryMetricQuery): any;
export declare class DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryMetricQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryMetricQuery | undefined;
    set internalValue(value: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryMetricQuery | undefined);
    private _aggregator?;
    get aggregator(): string;
    set aggregator(value: string);
    resetAggregator(): void;
    get aggregatorInput(): string | undefined;
    private _dataSource?;
    get dataSource(): string;
    set dataSource(value: string);
    resetDataSource(): void;
    get dataSourceInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
}
export interface DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryProcessQuery {
    /**
    * The aggregation methods available for metrics queries. Valid values are `avg`, `min`, `max`, `sum`, `last`, `area`, `l2norm`, `percentile`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregator Dashboard#aggregator}
    */
    readonly aggregator?: string;
    /**
    * The data source for process queries. Valid values are `process`, `container`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#data_source Dashboard#data_source}
    */
    readonly dataSource: string;
    /**
    * Whether to normalize the CPU percentages.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_normalized_cpu Dashboard#is_normalized_cpu}
    */
    readonly isNormalizedCpu?: boolean | cdktf.IResolvable;
    /**
    * The number of hits to return.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * The process metric name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
    */
    readonly metric: string;
    /**
    * The name of query for use in formulas.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#name Dashboard#name}
    */
    readonly name: string;
    /**
    * The direction of the sort. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort Dashboard#sort}
    */
    readonly sort?: string;
    /**
    * An array of tags to filter by.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#tag_filters Dashboard#tag_filters}
    */
    readonly tagFilters?: string[];
    /**
    * The text to use as a filter.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#text_filter Dashboard#text_filter}
    */
    readonly textFilter?: string;
}
export declare function dashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryProcessQueryToTerraform(struct?: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryProcessQueryOutputReference | DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryProcessQuery): any;
export declare class DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryProcessQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryProcessQuery | undefined;
    set internalValue(value: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryProcessQuery | undefined);
    private _aggregator?;
    get aggregator(): string;
    set aggregator(value: string);
    resetAggregator(): void;
    get aggregatorInput(): string | undefined;
    private _dataSource?;
    get dataSource(): string;
    set dataSource(value: string);
    get dataSourceInput(): string | undefined;
    private _isNormalizedCpu?;
    get isNormalizedCpu(): boolean | cdktf.IResolvable;
    set isNormalizedCpu(value: boolean | cdktf.IResolvable);
    resetIsNormalizedCpu(): void;
    get isNormalizedCpuInput(): boolean | cdktf.IResolvable | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _metric?;
    get metric(): string;
    set metric(value: string);
    get metricInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _sort?;
    get sort(): string;
    set sort(value: string);
    resetSort(): void;
    get sortInput(): string | undefined;
    private _tagFilters?;
    get tagFilters(): string[];
    set tagFilters(value: string[]);
    resetTagFilters(): void;
    get tagFiltersInput(): string[] | undefined;
    private _textFilter?;
    get textFilter(): string;
    set textFilter(value: string);
    resetTextFilter(): void;
    get textFilterInput(): string | undefined;
}
export interface DashboardWidgetScatterplotDefinitionRequestScatterplotTableQuery {
    /**
    * apm_dependency_stats_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_dependency_stats_query Dashboard#apm_dependency_stats_query}
    */
    readonly apmDependencyStatsQuery?: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryApmDependencyStatsQuery;
    /**
    * apm_resource_stats_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_resource_stats_query Dashboard#apm_resource_stats_query}
    */
    readonly apmResourceStatsQuery?: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryApmResourceStatsQuery;
    /**
    * event_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#event_query Dashboard#event_query}
    */
    readonly eventQuery?: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQuery;
    /**
    * metric_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric_query Dashboard#metric_query}
    */
    readonly metricQuery?: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryMetricQuery;
    /**
    * process_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#process_query Dashboard#process_query}
    */
    readonly processQuery?: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryProcessQuery;
}
export declare function dashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryToTerraform(struct?: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQuery | cdktf.IResolvable): any;
export declare class DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetScatterplotDefinitionRequestScatterplotTableQuery | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQuery | cdktf.IResolvable | undefined);
    private _apmDependencyStatsQuery;
    get apmDependencyStatsQuery(): DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryApmDependencyStatsQueryOutputReference;
    putApmDependencyStatsQuery(value: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryApmDependencyStatsQuery): void;
    resetApmDependencyStatsQuery(): void;
    get apmDependencyStatsQueryInput(): DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryApmDependencyStatsQuery | undefined;
    private _apmResourceStatsQuery;
    get apmResourceStatsQuery(): DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryApmResourceStatsQueryOutputReference;
    putApmResourceStatsQuery(value: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryApmResourceStatsQuery): void;
    resetApmResourceStatsQuery(): void;
    get apmResourceStatsQueryInput(): DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryApmResourceStatsQuery | undefined;
    private _eventQuery;
    get eventQuery(): DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQueryOutputReference;
    putEventQuery(value: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQuery): void;
    resetEventQuery(): void;
    get eventQueryInput(): DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryEventQuery | undefined;
    private _metricQuery;
    get metricQuery(): DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryMetricQueryOutputReference;
    putMetricQuery(value: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryMetricQuery): void;
    resetMetricQuery(): void;
    get metricQueryInput(): DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryMetricQuery | undefined;
    private _processQuery;
    get processQuery(): DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryProcessQueryOutputReference;
    putProcessQuery(value: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryProcessQuery): void;
    resetProcessQuery(): void;
    get processQueryInput(): DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryProcessQuery | undefined;
}
export declare class DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQuery[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryOutputReference;
}
export interface DashboardWidgetScatterplotDefinitionRequestScatterplotTable {
    /**
    * formula block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#formula Dashboard#formula}
    */
    readonly formula?: DashboardWidgetScatterplotDefinitionRequestScatterplotTableFormula[] | cdktf.IResolvable;
    /**
    * query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#query Dashboard#query}
    */
    readonly query?: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQuery[] | cdktf.IResolvable;
}
export declare function dashboardWidgetScatterplotDefinitionRequestScatterplotTableToTerraform(struct?: DashboardWidgetScatterplotDefinitionRequestScatterplotTable | cdktf.IResolvable): any;
export declare class DashboardWidgetScatterplotDefinitionRequestScatterplotTableOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetScatterplotDefinitionRequestScatterplotTable | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetScatterplotDefinitionRequestScatterplotTable | cdktf.IResolvable | undefined);
    private _formula;
    get formula(): DashboardWidgetScatterplotDefinitionRequestScatterplotTableFormulaList;
    putFormula(value: DashboardWidgetScatterplotDefinitionRequestScatterplotTableFormula[] | cdktf.IResolvable): void;
    resetFormula(): void;
    get formulaInput(): cdktf.IResolvable | DashboardWidgetScatterplotDefinitionRequestScatterplotTableFormula[] | undefined;
    private _query;
    get query(): DashboardWidgetScatterplotDefinitionRequestScatterplotTableQueryList;
    putQuery(value: DashboardWidgetScatterplotDefinitionRequestScatterplotTableQuery[] | cdktf.IResolvable): void;
    resetQuery(): void;
    get queryInput(): cdktf.IResolvable | DashboardWidgetScatterplotDefinitionRequestScatterplotTableQuery[] | undefined;
}
export declare class DashboardWidgetScatterplotDefinitionRequestScatterplotTableList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetScatterplotDefinitionRequestScatterplotTable[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetScatterplotDefinitionRequestScatterplotTableOutputReference;
}
export interface DashboardWidgetScatterplotDefinitionRequestXApmQueryComputeQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetScatterplotDefinitionRequestXApmQueryComputeQueryToTerraform(struct?: DashboardWidgetScatterplotDefinitionRequestXApmQueryComputeQueryOutputReference | DashboardWidgetScatterplotDefinitionRequestXApmQueryComputeQuery): any;
export declare class DashboardWidgetScatterplotDefinitionRequestXApmQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetScatterplotDefinitionRequestXApmQueryComputeQuery | undefined;
    set internalValue(value: DashboardWidgetScatterplotDefinitionRequestXApmQueryComputeQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export interface DashboardWidgetScatterplotDefinitionRequestXApmQueryGroupBySortQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Widget sorting methods. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
    */
    readonly order: string;
}
export declare function dashboardWidgetScatterplotDefinitionRequestXApmQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetScatterplotDefinitionRequestXApmQueryGroupBySortQueryOutputReference | DashboardWidgetScatterplotDefinitionRequestXApmQueryGroupBySortQuery): any;
export declare class DashboardWidgetScatterplotDefinitionRequestXApmQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetScatterplotDefinitionRequestXApmQueryGroupBySortQuery | undefined;
    set internalValue(value: DashboardWidgetScatterplotDefinitionRequestXApmQueryGroupBySortQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    get orderInput(): string | undefined;
}
export interface DashboardWidgetScatterplotDefinitionRequestXApmQueryGroupBy {
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * The maximum number of items in the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * sort_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
    */
    readonly sortQuery?: DashboardWidgetScatterplotDefinitionRequestXApmQueryGroupBySortQuery;
}
export declare function dashboardWidgetScatterplotDefinitionRequestXApmQueryGroupByToTerraform(struct?: DashboardWidgetScatterplotDefinitionRequestXApmQueryGroupBy | cdktf.IResolvable): any;
export declare class DashboardWidgetScatterplotDefinitionRequestXApmQueryGroupByOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetScatterplotDefinitionRequestXApmQueryGroupBy | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetScatterplotDefinitionRequestXApmQueryGroupBy | cdktf.IResolvable | undefined);
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _sortQuery;
    get sortQuery(): DashboardWidgetScatterplotDefinitionRequestXApmQueryGroupBySortQueryOutputReference;
    putSortQuery(value: DashboardWidgetScatterplotDefinitionRequestXApmQueryGroupBySortQuery): void;
    resetSortQuery(): void;
    get sortQueryInput(): DashboardWidgetScatterplotDefinitionRequestXApmQueryGroupBySortQuery | undefined;
}
export declare class DashboardWidgetScatterplotDefinitionRequestXApmQueryGroupByList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetScatterplotDefinitionRequestXApmQueryGroupBy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetScatterplotDefinitionRequestXApmQueryGroupByOutputReference;
}
export interface DashboardWidgetScatterplotDefinitionRequestXApmQueryMultiCompute {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetScatterplotDefinitionRequestXApmQueryMultiComputeToTerraform(struct?: DashboardWidgetScatterplotDefinitionRequestXApmQueryMultiCompute | cdktf.IResolvable): any;
export declare class DashboardWidgetScatterplotDefinitionRequestXApmQueryMultiComputeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetScatterplotDefinitionRequestXApmQueryMultiCompute | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetScatterplotDefinitionRequestXApmQueryMultiCompute | cdktf.IResolvable | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export declare class DashboardWidgetScatterplotDefinitionRequestXApmQueryMultiComputeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetScatterplotDefinitionRequestXApmQueryMultiCompute[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetScatterplotDefinitionRequestXApmQueryMultiComputeOutputReference;
}
export interface DashboardWidgetScatterplotDefinitionRequestXApmQuery {
    /**
    * The name of the index to query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
    */
    readonly index: string;
    /**
    * The search query to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
    */
    readonly searchQuery?: string;
    /**
    * compute_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
    */
    readonly computeQuery?: DashboardWidgetScatterplotDefinitionRequestXApmQueryComputeQuery;
    /**
    * group_by block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
    */
    readonly groupBy?: DashboardWidgetScatterplotDefinitionRequestXApmQueryGroupBy[] | cdktf.IResolvable;
    /**
    * multi_compute block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
    */
    readonly multiCompute?: DashboardWidgetScatterplotDefinitionRequestXApmQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetScatterplotDefinitionRequestXApmQueryToTerraform(struct?: DashboardWidgetScatterplotDefinitionRequestXApmQueryOutputReference | DashboardWidgetScatterplotDefinitionRequestXApmQuery): any;
export declare class DashboardWidgetScatterplotDefinitionRequestXApmQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetScatterplotDefinitionRequestXApmQuery | undefined;
    set internalValue(value: DashboardWidgetScatterplotDefinitionRequestXApmQuery | undefined);
    private _index?;
    get index(): string;
    set index(value: string);
    get indexInput(): string | undefined;
    private _searchQuery?;
    get searchQuery(): string;
    set searchQuery(value: string);
    resetSearchQuery(): void;
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    get computeQuery(): DashboardWidgetScatterplotDefinitionRequestXApmQueryComputeQueryOutputReference;
    putComputeQuery(value: DashboardWidgetScatterplotDefinitionRequestXApmQueryComputeQuery): void;
    resetComputeQuery(): void;
    get computeQueryInput(): DashboardWidgetScatterplotDefinitionRequestXApmQueryComputeQuery | undefined;
    private _groupBy;
    get groupBy(): DashboardWidgetScatterplotDefinitionRequestXApmQueryGroupByList;
    putGroupBy(value: DashboardWidgetScatterplotDefinitionRequestXApmQueryGroupBy[] | cdktf.IResolvable): void;
    resetGroupBy(): void;
    get groupByInput(): cdktf.IResolvable | DashboardWidgetScatterplotDefinitionRequestXApmQueryGroupBy[] | undefined;
    private _multiCompute;
    get multiCompute(): DashboardWidgetScatterplotDefinitionRequestXApmQueryMultiComputeList;
    putMultiCompute(value: DashboardWidgetScatterplotDefinitionRequestXApmQueryMultiCompute[] | cdktf.IResolvable): void;
    resetMultiCompute(): void;
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetScatterplotDefinitionRequestXApmQueryMultiCompute[] | undefined;
}
export interface DashboardWidgetScatterplotDefinitionRequestXLogQueryComputeQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetScatterplotDefinitionRequestXLogQueryComputeQueryToTerraform(struct?: DashboardWidgetScatterplotDefinitionRequestXLogQueryComputeQueryOutputReference | DashboardWidgetScatterplotDefinitionRequestXLogQueryComputeQuery): any;
export declare class DashboardWidgetScatterplotDefinitionRequestXLogQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetScatterplotDefinitionRequestXLogQueryComputeQuery | undefined;
    set internalValue(value: DashboardWidgetScatterplotDefinitionRequestXLogQueryComputeQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export interface DashboardWidgetScatterplotDefinitionRequestXLogQueryGroupBySortQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Widget sorting methods. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
    */
    readonly order: string;
}
export declare function dashboardWidgetScatterplotDefinitionRequestXLogQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetScatterplotDefinitionRequestXLogQueryGroupBySortQueryOutputReference | DashboardWidgetScatterplotDefinitionRequestXLogQueryGroupBySortQuery): any;
export declare class DashboardWidgetScatterplotDefinitionRequestXLogQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetScatterplotDefinitionRequestXLogQueryGroupBySortQuery | undefined;
    set internalValue(value: DashboardWidgetScatterplotDefinitionRequestXLogQueryGroupBySortQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    get orderInput(): string | undefined;
}
export interface DashboardWidgetScatterplotDefinitionRequestXLogQueryGroupBy {
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * The maximum number of items in the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * sort_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
    */
    readonly sortQuery?: DashboardWidgetScatterplotDefinitionRequestXLogQueryGroupBySortQuery;
}
export declare function dashboardWidgetScatterplotDefinitionRequestXLogQueryGroupByToTerraform(struct?: DashboardWidgetScatterplotDefinitionRequestXLogQueryGroupBy | cdktf.IResolvable): any;
export declare class DashboardWidgetScatterplotDefinitionRequestXLogQueryGroupByOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetScatterplotDefinitionRequestXLogQueryGroupBy | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetScatterplotDefinitionRequestXLogQueryGroupBy | cdktf.IResolvable | undefined);
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _sortQuery;
    get sortQuery(): DashboardWidgetScatterplotDefinitionRequestXLogQueryGroupBySortQueryOutputReference;
    putSortQuery(value: DashboardWidgetScatterplotDefinitionRequestXLogQueryGroupBySortQuery): void;
    resetSortQuery(): void;
    get sortQueryInput(): DashboardWidgetScatterplotDefinitionRequestXLogQueryGroupBySortQuery | undefined;
}
export declare class DashboardWidgetScatterplotDefinitionRequestXLogQueryGroupByList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetScatterplotDefinitionRequestXLogQueryGroupBy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetScatterplotDefinitionRequestXLogQueryGroupByOutputReference;
}
export interface DashboardWidgetScatterplotDefinitionRequestXLogQueryMultiCompute {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetScatterplotDefinitionRequestXLogQueryMultiComputeToTerraform(struct?: DashboardWidgetScatterplotDefinitionRequestXLogQueryMultiCompute | cdktf.IResolvable): any;
export declare class DashboardWidgetScatterplotDefinitionRequestXLogQueryMultiComputeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetScatterplotDefinitionRequestXLogQueryMultiCompute | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetScatterplotDefinitionRequestXLogQueryMultiCompute | cdktf.IResolvable | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export declare class DashboardWidgetScatterplotDefinitionRequestXLogQueryMultiComputeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetScatterplotDefinitionRequestXLogQueryMultiCompute[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetScatterplotDefinitionRequestXLogQueryMultiComputeOutputReference;
}
export interface DashboardWidgetScatterplotDefinitionRequestXLogQuery {
    /**
    * The name of the index to query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
    */
    readonly index: string;
    /**
    * The search query to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
    */
    readonly searchQuery?: string;
    /**
    * compute_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
    */
    readonly computeQuery?: DashboardWidgetScatterplotDefinitionRequestXLogQueryComputeQuery;
    /**
    * group_by block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
    */
    readonly groupBy?: DashboardWidgetScatterplotDefinitionRequestXLogQueryGroupBy[] | cdktf.IResolvable;
    /**
    * multi_compute block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
    */
    readonly multiCompute?: DashboardWidgetScatterplotDefinitionRequestXLogQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetScatterplotDefinitionRequestXLogQueryToTerraform(struct?: DashboardWidgetScatterplotDefinitionRequestXLogQueryOutputReference | DashboardWidgetScatterplotDefinitionRequestXLogQuery): any;
export declare class DashboardWidgetScatterplotDefinitionRequestXLogQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetScatterplotDefinitionRequestXLogQuery | undefined;
    set internalValue(value: DashboardWidgetScatterplotDefinitionRequestXLogQuery | undefined);
    private _index?;
    get index(): string;
    set index(value: string);
    get indexInput(): string | undefined;
    private _searchQuery?;
    get searchQuery(): string;
    set searchQuery(value: string);
    resetSearchQuery(): void;
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    get computeQuery(): DashboardWidgetScatterplotDefinitionRequestXLogQueryComputeQueryOutputReference;
    putComputeQuery(value: DashboardWidgetScatterplotDefinitionRequestXLogQueryComputeQuery): void;
    resetComputeQuery(): void;
    get computeQueryInput(): DashboardWidgetScatterplotDefinitionRequestXLogQueryComputeQuery | undefined;
    private _groupBy;
    get groupBy(): DashboardWidgetScatterplotDefinitionRequestXLogQueryGroupByList;
    putGroupBy(value: DashboardWidgetScatterplotDefinitionRequestXLogQueryGroupBy[] | cdktf.IResolvable): void;
    resetGroupBy(): void;
    get groupByInput(): cdktf.IResolvable | DashboardWidgetScatterplotDefinitionRequestXLogQueryGroupBy[] | undefined;
    private _multiCompute;
    get multiCompute(): DashboardWidgetScatterplotDefinitionRequestXLogQueryMultiComputeList;
    putMultiCompute(value: DashboardWidgetScatterplotDefinitionRequestXLogQueryMultiCompute[] | cdktf.IResolvable): void;
    resetMultiCompute(): void;
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetScatterplotDefinitionRequestXLogQueryMultiCompute[] | undefined;
}
export interface DashboardWidgetScatterplotDefinitionRequestXProcessQuery {
    /**
    * A list of processes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#filter_by Dashboard#filter_by}
    */
    readonly filterBy?: string[];
    /**
    * The max number of items in the filter list.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * Your chosen metric.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#metric Dashboard#metric}
    */
    readonly metric: string;
    /**
    * Your chosen search term.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_by Dashboard#search_by}
    */
    readonly searchBy?: string;
}
export declare function dashboardWidgetScatterplotDefinitionRequestXProcessQueryToTerraform(struct?: DashboardWidgetScatterplotDefinitionRequestXProcessQueryOutputReference | DashboardWidgetScatterplotDefinitionRequestXProcessQuery): any;
export declare class DashboardWidgetScatterplotDefinitionRequestXProcessQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetScatterplotDefinitionRequestXProcessQuery | undefined;
    set internalValue(value: DashboardWidgetScatterplotDefinitionRequestXProcessQuery | undefined);
    private _filterBy?;
    get filterBy(): string[];
    set filterBy(value: string[]);
    resetFilterBy(): void;
    get filterByInput(): string[] | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _metric?;
    get metric(): string;
    set metric(value: string);
    get metricInput(): string | undefined;
    private _searchBy?;
    get searchBy(): string;
    set searchBy(value: string);
    resetSearchBy(): void;
    get searchByInput(): string | undefined;
}
export interface DashboardWidgetScatterplotDefinitionRequestXRumQueryComputeQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetScatterplotDefinitionRequestXRumQueryComputeQueryToTerraform(struct?: DashboardWidgetScatterplotDefinitionRequestXRumQueryComputeQueryOutputReference | DashboardWidgetScatterplotDefinitionRequestXRumQueryComputeQuery): any;
export declare class DashboardWidgetScatterplotDefinitionRequestXRumQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetScatterplotDefinitionRequestXRumQueryComputeQuery | undefined;
    set internalValue(value: DashboardWidgetScatterplotDefinitionRequestXRumQueryComputeQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export interface DashboardWidgetScatterplotDefinitionRequestXRumQueryGroupBySortQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Widget sorting methods. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
    */
    readonly order: string;
}
export declare function dashboardWidgetScatterplotDefinitionRequestXRumQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetScatterplotDefinitionRequestXRumQueryGroupBySortQueryOutputReference | DashboardWidgetScatterplotDefinitionRequestXRumQueryGroupBySortQuery): any;
export declare class DashboardWidgetScatterplotDefinitionRequestXRumQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetScatterplotDefinitionRequestXRumQueryGroupBySortQuery | undefined;
    set internalValue(value: DashboardWidgetScatterplotDefinitionRequestXRumQueryGroupBySortQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    get orderInput(): string | undefined;
}
export interface DashboardWidgetScatterplotDefinitionRequestXRumQueryGroupBy {
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * The maximum number of items in the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * sort_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
    */
    readonly sortQuery?: DashboardWidgetScatterplotDefinitionRequestXRumQueryGroupBySortQuery;
}
export declare function dashboardWidgetScatterplotDefinitionRequestXRumQueryGroupByToTerraform(struct?: DashboardWidgetScatterplotDefinitionRequestXRumQueryGroupBy | cdktf.IResolvable): any;
export declare class DashboardWidgetScatterplotDefinitionRequestXRumQueryGroupByOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetScatterplotDefinitionRequestXRumQueryGroupBy | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetScatterplotDefinitionRequestXRumQueryGroupBy | cdktf.IResolvable | undefined);
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _sortQuery;
    get sortQuery(): DashboardWidgetScatterplotDefinitionRequestXRumQueryGroupBySortQueryOutputReference;
    putSortQuery(value: DashboardWidgetScatterplotDefinitionRequestXRumQueryGroupBySortQuery): void;
    resetSortQuery(): void;
    get sortQueryInput(): DashboardWidgetScatterplotDefinitionRequestXRumQueryGroupBySortQuery | undefined;
}
export declare class DashboardWidgetScatterplotDefinitionRequestXRumQueryGroupByList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetScatterplotDefinitionRequestXRumQueryGroupBy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetScatterplotDefinitionRequestXRumQueryGroupByOutputReference;
}
export interface DashboardWidgetScatterplotDefinitionRequestXRumQueryMultiCompute {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetScatterplotDefinitionRequestXRumQueryMultiComputeToTerraform(struct?: DashboardWidgetScatterplotDefinitionRequestXRumQueryMultiCompute | cdktf.IResolvable): any;
export declare class DashboardWidgetScatterplotDefinitionRequestXRumQueryMultiComputeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetScatterplotDefinitionRequestXRumQueryMultiCompute | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetScatterplotDefinitionRequestXRumQueryMultiCompute | cdktf.IResolvable | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export declare class DashboardWidgetScatterplotDefinitionRequestXRumQueryMultiComputeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetScatterplotDefinitionRequestXRumQueryMultiCompute[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetScatterplotDefinitionRequestXRumQueryMultiComputeOutputReference;
}
export interface DashboardWidgetScatterplotDefinitionRequestXRumQuery {
    /**
    * The name of the index to query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
    */
    readonly index: string;
    /**
    * The search query to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
    */
    readonly searchQuery?: string;
    /**
    * compute_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
    */
    readonly computeQuery?: DashboardWidgetScatterplotDefinitionRequestXRumQueryComputeQuery;
    /**
    * group_by block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
    */
    readonly groupBy?: DashboardWidgetScatterplotDefinitionRequestXRumQueryGroupBy[] | cdktf.IResolvable;
    /**
    * multi_compute block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
    */
    readonly multiCompute?: DashboardWidgetScatterplotDefinitionRequestXRumQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetScatterplotDefinitionRequestXRumQueryToTerraform(struct?: DashboardWidgetScatterplotDefinitionRequestXRumQueryOutputReference | DashboardWidgetScatterplotDefinitionRequestXRumQuery): any;
export declare class DashboardWidgetScatterplotDefinitionRequestXRumQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetScatterplotDefinitionRequestXRumQuery | undefined;
    set internalValue(value: DashboardWidgetScatterplotDefinitionRequestXRumQuery | undefined);
    private _index?;
    get index(): string;
    set index(value: string);
    get indexInput(): string | undefined;
    private _searchQuery?;
    get searchQuery(): string;
    set searchQuery(value: string);
    resetSearchQuery(): void;
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    get computeQuery(): DashboardWidgetScatterplotDefinitionRequestXRumQueryComputeQueryOutputReference;
    putComputeQuery(value: DashboardWidgetScatterplotDefinitionRequestXRumQueryComputeQuery): void;
    resetComputeQuery(): void;
    get computeQueryInput(): DashboardWidgetScatterplotDefinitionRequestXRumQueryComputeQuery | undefined;
    private _groupBy;
    get groupBy(): DashboardWidgetScatterplotDefinitionRequestXRumQueryGroupByList;
    putGroupBy(value: DashboardWidgetScatterplotDefinitionRequestXRumQueryGroupBy[] | cdktf.IResolvable): void;
    resetGroupBy(): void;
    get groupByInput(): cdktf.IResolvable | DashboardWidgetScatterplotDefinitionRequestXRumQueryGroupBy[] | undefined;
    private _multiCompute;
    get multiCompute(): DashboardWidgetScatterplotDefinitionRequestXRumQueryMultiComputeList;
    putMultiCompute(value: DashboardWidgetScatterplotDefinitionRequestXRumQueryMultiCompute[] | cdktf.IResolvable): void;
    resetMultiCompute(): void;
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetScatterplotDefinitionRequestXRumQueryMultiCompute[] | undefined;
}
export interface DashboardWidgetScatterplotDefinitionRequestXSecurityQueryComputeQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetScatterplotDefinitionRequestXSecurityQueryComputeQueryToTerraform(struct?: DashboardWidgetScatterplotDefinitionRequestXSecurityQueryComputeQueryOutputReference | DashboardWidgetScatterplotDefinitionRequestXSecurityQueryComputeQuery): any;
export declare class DashboardWidgetScatterplotDefinitionRequestXSecurityQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetScatterplotDefinitionRequestXSecurityQueryComputeQuery | undefined;
    set internalValue(value: DashboardWidgetScatterplotDefinitionRequestXSecurityQueryComputeQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export interface DashboardWidgetScatterplotDefinitionRequestXSecurityQueryGroupBySortQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Widget sorting methods. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
    */
    readonly order: string;
}
export declare function dashboardWidgetScatterplotDefinitionRequestXSecurityQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetScatterplotDefinitionRequestXSecurityQueryGroupBySortQueryOutputReference | DashboardWidgetScatterplotDefinitionRequestXSecurityQueryGroupBySortQuery): any;
export declare class DashboardWidgetScatterplotDefinitionRequestXSecurityQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetScatterplotDefinitionRequestXSecurityQueryGroupBySortQuery | undefined;
    set internalValue(value: DashboardWidgetScatterplotDefinitionRequestXSecurityQueryGroupBySortQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    get orderInput(): string | undefined;
}
export interface DashboardWidgetScatterplotDefinitionRequestXSecurityQueryGroupBy {
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * The maximum number of items in the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * sort_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
    */
    readonly sortQuery?: DashboardWidgetScatterplotDefinitionRequestXSecurityQueryGroupBySortQuery;
}
export declare function dashboardWidgetScatterplotDefinitionRequestXSecurityQueryGroupByToTerraform(struct?: DashboardWidgetScatterplotDefinitionRequestXSecurityQueryGroupBy | cdktf.IResolvable): any;
export declare class DashboardWidgetScatterplotDefinitionRequestXSecurityQueryGroupByOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetScatterplotDefinitionRequestXSecurityQueryGroupBy | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetScatterplotDefinitionRequestXSecurityQueryGroupBy | cdktf.IResolvable | undefined);
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _sortQuery;
    get sortQuery(): DashboardWidgetScatterplotDefinitionRequestXSecurityQueryGroupBySortQueryOutputReference;
    putSortQuery(value: DashboardWidgetScatterplotDefinitionRequestXSecurityQueryGroupBySortQuery): void;
    resetSortQuery(): void;
    get sortQueryInput(): DashboardWidgetScatterplotDefinitionRequestXSecurityQueryGroupBySortQuery | undefined;
}
export declare class DashboardWidgetScatterplotDefinitionRequestXSecurityQueryGroupByList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetScatterplotDefinitionRequestXSecurityQueryGroupBy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetScatterplotDefinitionRequestXSecurityQueryGroupByOutputReference;
}
export interface DashboardWidgetScatterplotDefinitionRequestXSecurityQueryMultiCompute {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetScatterplotDefinitionRequestXSecurityQueryMultiComputeToTerraform(struct?: DashboardWidgetScatterplotDefinitionRequestXSecurityQueryMultiCompute | cdktf.IResolvable): any;
export declare class DashboardWidgetScatterplotDefinitionRequestXSecurityQueryMultiComputeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetScatterplotDefinitionRequestXSecurityQueryMultiCompute | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetScatterplotDefinitionRequestXSecurityQueryMultiCompute | cdktf.IResolvable | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export declare class DashboardWidgetScatterplotDefinitionRequestXSecurityQueryMultiComputeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetScatterplotDefinitionRequestXSecurityQueryMultiCompute[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetScatterplotDefinitionRequestXSecurityQueryMultiComputeOutputReference;
}
export interface DashboardWidgetScatterplotDefinitionRequestXSecurityQuery {
    /**
    * The name of the index to query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#index Dashboard#index}
    */
    readonly index: string;
    /**
    * The search query to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#search_query Dashboard#search_query}
    */
    readonly searchQuery?: string;
    /**
    * compute_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#compute_query Dashboard#compute_query}
    */
    readonly computeQuery?: DashboardWidgetScatterplotDefinitionRequestXSecurityQueryComputeQuery;
    /**
    * group_by block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#group_by Dashboard#group_by}
    */
    readonly groupBy?: DashboardWidgetScatterplotDefinitionRequestXSecurityQueryGroupBy[] | cdktf.IResolvable;
    /**
    * multi_compute block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#multi_compute Dashboard#multi_compute}
    */
    readonly multiCompute?: DashboardWidgetScatterplotDefinitionRequestXSecurityQueryMultiCompute[] | cdktf.IResolvable;
}
export declare function dashboardWidgetScatterplotDefinitionRequestXSecurityQueryToTerraform(struct?: DashboardWidgetScatterplotDefinitionRequestXSecurityQueryOutputReference | DashboardWidgetScatterplotDefinitionRequestXSecurityQuery): any;
export declare class DashboardWidgetScatterplotDefinitionRequestXSecurityQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetScatterplotDefinitionRequestXSecurityQuery | undefined;
    set internalValue(value: DashboardWidgetScatterplotDefinitionRequestXSecurityQuery | undefined);
    private _index?;
    get index(): string;
    set index(value: string);
    get indexInput(): string | undefined;
    private _searchQuery?;
    get searchQuery(): string;
    set searchQuery(value: string);
    resetSearchQuery(): void;
    get searchQueryInput(): string | undefined;
    private _computeQuery;
    get computeQuery(): DashboardWidgetScatterplotDefinitionRequestXSecurityQueryComputeQueryOutputReference;
    putComputeQuery(value: DashboardWidgetScatterplotDefinitionRequestXSecurityQueryComputeQuery): void;
    resetComputeQuery(): void;
    get computeQueryInput(): DashboardWidgetScatterplotDefinitionRequestXSecurityQueryComputeQuery | undefined;
    private _groupBy;
    get groupBy(): DashboardWidgetScatterplotDefinitionRequestXSecurityQueryGroupByList;
    putGroupBy(value: DashboardWidgetScatterplotDefinitionRequestXSecurityQueryGroupBy[] | cdktf.IResolvable): void;
    resetGroupBy(): void;
    get groupByInput(): cdktf.IResolvable | DashboardWidgetScatterplotDefinitionRequestXSecurityQueryGroupBy[] | undefined;
    private _multiCompute;
    get multiCompute(): DashboardWidgetScatterplotDefinitionRequestXSecurityQueryMultiComputeList;
    putMultiCompute(value: DashboardWidgetScatterplotDefinitionRequestXSecurityQueryMultiCompute[] | cdktf.IResolvable): void;
    resetMultiCompute(): void;
    get multiComputeInput(): cdktf.IResolvable | DashboardWidgetScatterplotDefinitionRequestXSecurityQueryMultiCompute[] | undefined;
}
export interface DashboardWidgetScatterplotDefinitionRequestX {
    /**
    * Aggregator used for the request. Valid values are `avg`, `last`, `max`, `min`, `sum`, `percentile`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregator Dashboard#aggregator}
    */
    readonly aggregator?: string;
    /**
    * The metric query to use for this widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#q Dashboard#q}
    */
    readonly q?: string;
    /**
    * apm_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#apm_query Dashboard#apm_query}
    */
    readonly apmQuery?: DashboardWidgetScatterplotDefinitionRequestXApmQuery;
    /**
    * log_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#log_query Dashboard#log_query}
    */
    readonly logQuery?: DashboardWidgetScatterplotDefinitionRequestXLogQuery;
    /**
    * process_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#process_query Dashboard#process_query}
    */
    readonly processQuery?: DashboardWidgetScatterplotDefinitionRequestXProcessQuery;
    /**
    * rum_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#rum_query Dashboard#rum_query}
    */
    readonly rumQuery?: DashboardWidgetScatterplotDefinitionRequestXRumQuery;
    /**
    * security_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#security_query Dashboard#security_query}
    */
    readonly securityQuery?: DashboardWidgetScatterplotDefinitionRequestXSecurityQuery;
}
export declare function dashboardWidgetScatterplotDefinitionRequestXToTerraform(struct?: DashboardWidgetScatterplotDefinitionRequestX | cdktf.IResolvable): any;
export declare class DashboardWidgetScatterplotDefinitionRequestXOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetScatterplotDefinitionRequestX | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetScatterplotDefinitionRequestX | cdktf.IResolvable | undefined);
    private _aggregator?;
    get aggregator(): string;
    set aggregator(value: string);
    resetAggregator(): void;
    get aggregatorInput(): string | undefined;
    private _q?;
    get q(): string;
    set q(value: string);
    resetQ(): void;
    get qInput(): string | undefined;
    private _apmQuery;
    get apmQuery(): DashboardWidgetScatterplotDefinitionRequestXApmQueryOutputReference;
    putApmQuery(value: DashboardWidgetScatterplotDefinitionRequestXApmQuery): void;
    resetApmQuery(): void;
    get apmQueryInput(): DashboardWidgetScatterplotDefinitionRequestXApmQuery | undefined;
    private _logQuery;
    get logQuery(): DashboardWidgetScatterplotDefinitionRequestXLogQueryOutputReference;
    putLogQuery(value: DashboardWidgetScatterplotDefinitionRequestXLogQuery): void;
    resetLogQuery(): void;
    get logQueryInput(): DashboardWidgetScatterplotDefinitionRequestXLogQuery | undefined;
    private _processQuery;
    get processQuery(): DashboardWidgetScatterplotDefinitionRequestXProcessQueryOutputReference;
    putProcessQuery(value: DashboardWidgetScatterplotDefinitionRequestXProcessQuery): void;
    resetProcessQuery(): void;
    get processQueryInput(): DashboardWidgetScatterplotDefinitionRequestXProcessQuery | undefined;
    private _rumQuery;
    get rumQuery(): DashboardWidgetScatterplotDefinitionRequestXRumQueryOutputReference;
    putRumQuery(value: DashboardWidgetScatterplotDefinitionRequestXRumQuery): void;
    resetRumQuery(): void;
    get rumQueryInput(): DashboardWidgetScatterplotDefinitionRequestXRumQuery | undefined;
    private _securityQuery;
    get securityQuery(): DashboardWidgetScatterplotDefinitionRequestXSecurityQueryOutputReference;
    putSecurityQuery(value: DashboardWidgetScatterplotDefinitionRequestXSecurityQuery): void;
    resetSecurityQuery(): void;
    get securityQueryInput(): DashboardWidgetScatterplotDefinitionRequestXSecurityQuery | undefined;
}
export declare class DashboardWidgetScatterplotDefinitionRequestXList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetScatterplotDefinitionRequestX[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetScatterplotDefinitionRequestXOutputReference;
}
export interface DashboardWidgetScatterplotDefinitionRequestYApmQueryComputeQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Define the time interval in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#interval Dashboard#interval}
    */
    readonly interval?: number;
}
export declare function dashboardWidgetScatterplotDefinitionRequestYApmQueryComputeQueryToTerraform(struct?: DashboardWidgetScatterplotDefinitionRequestYApmQueryComputeQueryOutputReference | DashboardWidgetScatterplotDefinitionRequestYApmQueryComputeQuery): any;
export declare class DashboardWidgetScatterplotDefinitionRequestYApmQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetScatterplotDefinitionRequestYApmQueryComputeQuery | undefined;
    set internalValue(value: DashboardWidgetScatterplotDefinitionRequestYApmQueryComputeQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
}
export interface DashboardWidgetScatterplotDefinitionRequestYApmQueryGroupBySortQuery {
    /**
    * The aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#aggregation Dashboard#aggregation}
    */
    readonly aggregation: string;
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * Widget sorting methods. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#order Dashboard#order}
    */
    readonly order: string;
}
export declare function dashboardWidgetScatterplotDefinitionRequestYApmQueryGroupBySortQueryToTerraform(struct?: DashboardWidgetScatterplotDefinitionRequestYApmQueryGroupBySortQueryOutputReference | DashboardWidgetScatterplotDefinitionRequestYApmQueryGroupBySortQuery): any;
export declare class DashboardWidgetScatterplotDefinitionRequestYApmQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DashboardWidgetScatterplotDefinitionRequestYApmQueryGroupBySortQuery | undefined;
    set internalValue(value: DashboardWidgetScatterplotDefinitionRequestYApmQueryGroupBySortQuery | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    get orderInput(): string | undefined;
}
export interface DashboardWidgetScatterplotDefinitionRequestYApmQueryGroupBy {
    /**
    * The facet name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#facet Dashboard#facet}
    */
    readonly facet?: string;
    /**
    * The maximum number of items in the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#limit Dashboard#limit}
    */
    readonly limit?: number;
    /**
    * sort_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#sort_query Dashboard#sort_query}
    */
    readonly sortQuery?: DashboardWidgetScatterplotDefinitionRequestYApmQueryGroupBySortQuery;
}
export declare function dashboardWidgetScatterplotDefinitionRequestYApmQueryGroupByToTerraform(struct?: DashboardWidgetScatterplotDefinitionRequestYApmQueryGroupBy | cdktf.IResolvable): any;
export declare class DashboardWidgetScatterplotDefinitionRequestYApmQueryGroupByOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DashboardWidgetScatterplotDefinitionRequestYApmQueryGroupBy | cdktf.IResolvable | undefined;
    set internalValue(value: DashboardWidgetScatterplotDefinitionRequestYApmQueryGroupBy | cdktf.IResolvable | undefined);
    private _facet?;
    get facet(): string;
    set facet(value: string);
    resetFacet(): void;
    get facetInput(): string | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _sortQuery;
    get sortQuery(): DashboardWidgetScatterplotDefinitionRequestYApmQueryGroupBySortQueryOutputReference;
    putSortQuery(value: DashboardWidgetScatterplotDefinitionRequestYApmQueryGroupBySortQuery): void;
    resetSortQuery(): void;
    get sortQueryInput(): DashboardWidgetScatterplotDefinitionRequestYApmQueryGroupBySortQuery | undefined;
}
export declare class DashboardWidgetScatterplotDefinitionRequestYApmQueryGroupByList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DashboardWidgetScatterplotDefinitionRequestYApmQueryGroupBy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DashboardWidgetScatterplotDefinitionRequestYApmQueryGroupByOutputReference;
}
