import { DashboardTemplateVariable, DashboardTemplateVariableList, DashboardTemplateVariablePreset, DashboardTemplateVariablePresetList, DashboardWidget, DashboardWidgetList } from './index-structs';
export * from './index-structs';
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DashboardConfig extends cdktf.TerraformMetaArguments {
    /**
    * A list of dashboard lists this dashboard belongs to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#dashboard_lists Dashboard#dashboard_lists}
    */
    readonly dashboardLists?: number[];
    /**
    * The description of the dashboard.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#description Dashboard#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#id Dashboard#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Whether this dashboard is read-only. **Deprecated.** Prefer using `restricted_roles` to define which roles are required to edit the dashboard.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#is_read_only Dashboard#is_read_only}
    */
    readonly isReadOnly?: boolean | cdktf.IResolvable;
    /**
    * The layout type of the dashboard. Valid values are `ordered`, `free`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#layout_type Dashboard#layout_type}
    */
    readonly layoutType: string;
    /**
    * The list of handles for the users to notify when changes are made to this dashboard.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#notify_list Dashboard#notify_list}
    */
    readonly notifyList?: string[];
    /**
    * The reflow type of a new dashboard layout. Set this only when layout type is `ordered`. If set to `fixed`, the dashboard expects all widgets to have a layout, and if it's set to `auto`, widgets should not have layouts. Valid values are `auto`, `fixed`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#reflow_type Dashboard#reflow_type}
    */
    readonly reflowType?: string;
    /**
    * UUIDs of roles whose associated users are authorized to edit the dashboard.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#restricted_roles Dashboard#restricted_roles}
    */
    readonly restrictedRoles?: string[];
    /**
    * The title of the dashboard.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#title Dashboard#title}
    */
    readonly title: string;
    /**
    * The URL of the dashboard.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#url Dashboard#url}
    */
    readonly url?: string;
    /**
    * template_variable block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#template_variable Dashboard#template_variable}
    */
    readonly templateVariable?: DashboardTemplateVariable[] | cdktf.IResolvable;
    /**
    * template_variable_preset block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#template_variable_preset Dashboard#template_variable_preset}
    */
    readonly templateVariablePreset?: DashboardTemplateVariablePreset[] | cdktf.IResolvable;
    /**
    * widget block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard#widget Dashboard#widget}
    */
    readonly widget?: DashboardWidget[] | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/dashboard datadog_dashboard}
*/
export declare class Dashboard extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_dashboard";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/dashboard datadog_dashboard} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DashboardConfig
    */
    constructor(scope: Construct, id: string, config: DashboardConfig);
    private _dashboardLists?;
    get dashboardLists(): number[];
    set dashboardLists(value: number[]);
    resetDashboardLists(): void;
    get dashboardListsInput(): number[] | undefined;
    get dashboardListsRemoved(): number[];
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _isReadOnly?;
    get isReadOnly(): boolean | cdktf.IResolvable;
    set isReadOnly(value: boolean | cdktf.IResolvable);
    resetIsReadOnly(): void;
    get isReadOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _layoutType?;
    get layoutType(): string;
    set layoutType(value: string);
    get layoutTypeInput(): string | undefined;
    private _notifyList?;
    get notifyList(): string[];
    set notifyList(value: string[]);
    resetNotifyList(): void;
    get notifyListInput(): string[] | undefined;
    private _reflowType?;
    get reflowType(): string;
    set reflowType(value: string);
    resetReflowType(): void;
    get reflowTypeInput(): string | undefined;
    private _restrictedRoles?;
    get restrictedRoles(): string[];
    set restrictedRoles(value: string[]);
    resetRestrictedRoles(): void;
    get restrictedRolesInput(): string[] | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    resetUrl(): void;
    get urlInput(): string | undefined;
    private _templateVariable;
    get templateVariable(): DashboardTemplateVariableList;
    putTemplateVariable(value: DashboardTemplateVariable[] | cdktf.IResolvable): void;
    resetTemplateVariable(): void;
    get templateVariableInput(): cdktf.IResolvable | DashboardTemplateVariable[] | undefined;
    private _templateVariablePreset;
    get templateVariablePreset(): DashboardTemplateVariablePresetList;
    putTemplateVariablePreset(value: DashboardTemplateVariablePreset[] | cdktf.IResolvable): void;
    resetTemplateVariablePreset(): void;
    get templateVariablePresetInput(): cdktf.IResolvable | DashboardTemplateVariablePreset[] | undefined;
    private _widget;
    get widget(): DashboardWidgetList;
    putWidget(value: DashboardWidget[] | cdktf.IResolvable): void;
    resetWidget(): void;
    get widgetInput(): cdktf.IResolvable | DashboardWidget[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
