"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Dashboard = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// generated from terraform resource schema
const index_structs_1 = require("./index-structs");
__exportStar(require("./index-structs"), exports);
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/dashboard datadog_dashboard}
*/
class Dashboard extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/dashboard datadog_dashboard} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DashboardConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'datadog_dashboard',
            terraformGeneratorMetadata: {
                providerName: 'datadog',
                providerVersion: '3.21.0',
                providerVersionConstraint: '~> 3.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // template_variable - computed: false, optional: true, required: false
        this._templateVariable = new index_structs_1.DashboardTemplateVariableList(this, "template_variable", false);
        // template_variable_preset - computed: false, optional: true, required: false
        this._templateVariablePreset = new index_structs_1.DashboardTemplateVariablePresetList(this, "template_variable_preset", false);
        // widget - computed: false, optional: true, required: false
        this._widget = new index_structs_1.DashboardWidgetList(this, "widget", false);
        this._dashboardLists = config.dashboardLists;
        this._description = config.description;
        this._id = config.id;
        this._isReadOnly = config.isReadOnly;
        this._layoutType = config.layoutType;
        this._notifyList = config.notifyList;
        this._reflowType = config.reflowType;
        this._restrictedRoles = config.restrictedRoles;
        this._title = config.title;
        this._url = config.url;
        this._templateVariable.internalValue = config.templateVariable;
        this._templateVariablePreset.internalValue = config.templateVariablePreset;
        this._widget.internalValue = config.widget;
    }
    get dashboardLists() {
        return cdktf.Token.asNumberList(cdktf.Fn.tolist(this.getNumberListAttribute('dashboard_lists')));
    }
    set dashboardLists(value) {
        this._dashboardLists = value;
    }
    resetDashboardLists() {
        this._dashboardLists = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dashboardListsInput() {
        return this._dashboardLists;
    }
    // dashboard_lists_removed - computed: true, optional: false, required: false
    get dashboardListsRemoved() {
        return cdktf.Token.asNumberList(cdktf.Fn.tolist(this.getNumberListAttribute('dashboard_lists_removed')));
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get isReadOnly() {
        return this.getBooleanAttribute('is_read_only');
    }
    set isReadOnly(value) {
        this._isReadOnly = value;
    }
    resetIsReadOnly() {
        this._isReadOnly = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get isReadOnlyInput() {
        return this._isReadOnly;
    }
    get layoutType() {
        return this.getStringAttribute('layout_type');
    }
    set layoutType(value) {
        this._layoutType = value;
    }
    // Temporarily expose input value. Use with caution.
    get layoutTypeInput() {
        return this._layoutType;
    }
    get notifyList() {
        return cdktf.Fn.tolist(this.getListAttribute('notify_list'));
    }
    set notifyList(value) {
        this._notifyList = value;
    }
    resetNotifyList() {
        this._notifyList = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get notifyListInput() {
        return this._notifyList;
    }
    get reflowType() {
        return this.getStringAttribute('reflow_type');
    }
    set reflowType(value) {
        this._reflowType = value;
    }
    resetReflowType() {
        this._reflowType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get reflowTypeInput() {
        return this._reflowType;
    }
    get restrictedRoles() {
        return cdktf.Fn.tolist(this.getListAttribute('restricted_roles'));
    }
    set restrictedRoles(value) {
        this._restrictedRoles = value;
    }
    resetRestrictedRoles() {
        this._restrictedRoles = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get restrictedRolesInput() {
        return this._restrictedRoles;
    }
    get title() {
        return this.getStringAttribute('title');
    }
    set title(value) {
        this._title = value;
    }
    // Temporarily expose input value. Use with caution.
    get titleInput() {
        return this._title;
    }
    get url() {
        return this.getStringAttribute('url');
    }
    set url(value) {
        this._url = value;
    }
    resetUrl() {
        this._url = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get urlInput() {
        return this._url;
    }
    get templateVariable() {
        return this._templateVariable;
    }
    putTemplateVariable(value) {
        this._templateVariable.internalValue = value;
    }
    resetTemplateVariable() {
        this._templateVariable.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get templateVariableInput() {
        return this._templateVariable.internalValue;
    }
    get templateVariablePreset() {
        return this._templateVariablePreset;
    }
    putTemplateVariablePreset(value) {
        this._templateVariablePreset.internalValue = value;
    }
    resetTemplateVariablePreset() {
        this._templateVariablePreset.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get templateVariablePresetInput() {
        return this._templateVariablePreset.internalValue;
    }
    get widget() {
        return this._widget;
    }
    putWidget(value) {
        this._widget.internalValue = value;
    }
    resetWidget() {
        this._widget.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get widgetInput() {
        return this._widget.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            dashboard_lists: cdktf.listMapper(cdktf.numberToTerraform, false)(this._dashboardLists),
            description: cdktf.stringToTerraform(this._description),
            id: cdktf.stringToTerraform(this._id),
            is_read_only: cdktf.booleanToTerraform(this._isReadOnly),
            layout_type: cdktf.stringToTerraform(this._layoutType),
            notify_list: cdktf.listMapper(cdktf.stringToTerraform, false)(this._notifyList),
            reflow_type: cdktf.stringToTerraform(this._reflowType),
            restricted_roles: cdktf.listMapper(cdktf.stringToTerraform, false)(this._restrictedRoles),
            title: cdktf.stringToTerraform(this._title),
            url: cdktf.stringToTerraform(this._url),
            template_variable: cdktf.listMapper(index_structs_1.dashboardTemplateVariableToTerraform, true)(this._templateVariable.internalValue),
            template_variable_preset: cdktf.listMapper(index_structs_1.dashboardTemplateVariablePresetToTerraform, true)(this._templateVariablePreset.internalValue),
            widget: cdktf.listMapper(index_structs_1.dashboardWidgetToTerraform, true)(this._widget.internalValue),
        };
    }
}
exports.Dashboard = Dashboard;
_a = JSII_RTTI_SYMBOL_1;
Dashboard[_a] = { fqn: "@cdktf/provider-datadog.dashboard.Dashboard", version: "5.0.1" };
// =================
// STATIC PROPERTIES
// =================
Dashboard.tfResourceType = "datadog_dashboard";
//# sourceMappingURL=data:application/json;base64,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