import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatadogApiKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Id for API Key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/api_key#id DataDatadogApiKey#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name for API Key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/api_key#name DataDatadogApiKey#name}
    */
    readonly name?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/d/api_key datadog_api_key}
*/
export declare class DataDatadogApiKey extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "datadog_api_key";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/d/api_key datadog_api_key} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatadogApiKeyConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataDatadogApiKeyConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get key(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
