import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatadogApplicationKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Id for Application Key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/application_key#id DataDatadogApplicationKey#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name for Application Key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/application_key#name DataDatadogApplicationKey#name}
    */
    readonly name?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/d/application_key datadog_application_key}
*/
export declare class DataDatadogApplicationKey extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "datadog_application_key";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/d/application_key datadog_application_key} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatadogApplicationKeyConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataDatadogApplicationKeyConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get key(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
