import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatadogDashboardListConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/dashboard_list#id DataDatadogDashboardList#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A dashboard list name to limit the search.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/dashboard_list#name DataDatadogDashboardList#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/d/dashboard_list datadog_dashboard_list}
*/
export declare class DataDatadogDashboardList extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "datadog_dashboard_list";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/d/dashboard_list datadog_dashboard_list} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatadogDashboardListConfig
    */
    constructor(scope: Construct, id: string, config: DataDatadogDashboardListConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
