import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatadogDashboardConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/dashboard#id DataDatadogDashboard#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The dashboard name to search for. Must only match one dashboard.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/dashboard#name DataDatadogDashboard#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/d/dashboard datadog_dashboard}
*/
export declare class DataDatadogDashboard extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "datadog_dashboard";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/d/dashboard datadog_dashboard} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatadogDashboardConfig
    */
    constructor(scope: Construct, id: string, config: DataDatadogDashboardConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get title(): string;
    get url(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
