import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatadogIpRangesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/ip_ranges#id DataDatadogIpRanges#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/d/ip_ranges datadog_ip_ranges}
*/
export declare class DataDatadogIpRanges extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "datadog_ip_ranges";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/d/ip_ranges datadog_ip_ranges} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatadogIpRangesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataDatadogIpRangesConfig);
    get agentsIpv4(): string[];
    get agentsIpv6(): string[];
    get apiIpv4(): string[];
    get apiIpv6(): string[];
    get apmIpv4(): string[];
    get apmIpv6(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get logsIpv4(): string[];
    get logsIpv6(): string[];
    get processIpv4(): string[];
    get processIpv6(): string[];
    get syntheticsIpv4(): string[];
    private _syntheticsIpv4ByLocation;
    get syntheticsIpv4ByLocation(): cdktf.StringMap;
    get syntheticsIpv6(): string[];
    private _syntheticsIpv6ByLocation;
    get syntheticsIpv6ByLocation(): cdktf.StringMap;
    get webhooksIpv4(): string[];
    get webhooksIpv6(): string[];
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
