import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatadogLogsIndexesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/logs_indexes#id DataDatadogLogsIndexes#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
export interface DataDatadogLogsIndexesLogsIndexesExclusionFilterFilter {
}
export declare function dataDatadogLogsIndexesLogsIndexesExclusionFilterFilterToTerraform(struct?: DataDatadogLogsIndexesLogsIndexesExclusionFilterFilter): any;
export declare class DataDatadogLogsIndexesLogsIndexesExclusionFilterFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatadogLogsIndexesLogsIndexesExclusionFilterFilter | undefined;
    set internalValue(value: DataDatadogLogsIndexesLogsIndexesExclusionFilterFilter | undefined);
    get query(): string;
    get sampleRate(): number;
}
export declare class DataDatadogLogsIndexesLogsIndexesExclusionFilterFilterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatadogLogsIndexesLogsIndexesExclusionFilterFilterOutputReference;
}
export interface DataDatadogLogsIndexesLogsIndexesExclusionFilter {
}
export declare function dataDatadogLogsIndexesLogsIndexesExclusionFilterToTerraform(struct?: DataDatadogLogsIndexesLogsIndexesExclusionFilter): any;
export declare class DataDatadogLogsIndexesLogsIndexesExclusionFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatadogLogsIndexesLogsIndexesExclusionFilter | undefined;
    set internalValue(value: DataDatadogLogsIndexesLogsIndexesExclusionFilter | undefined);
    private _filter;
    get filter(): DataDatadogLogsIndexesLogsIndexesExclusionFilterFilterList;
    get isEnabled(): cdktf.IResolvable;
    get name(): string;
}
export declare class DataDatadogLogsIndexesLogsIndexesExclusionFilterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatadogLogsIndexesLogsIndexesExclusionFilterOutputReference;
}
export interface DataDatadogLogsIndexesLogsIndexesFilter {
}
export declare function dataDatadogLogsIndexesLogsIndexesFilterToTerraform(struct?: DataDatadogLogsIndexesLogsIndexesFilter): any;
export declare class DataDatadogLogsIndexesLogsIndexesFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatadogLogsIndexesLogsIndexesFilter | undefined;
    set internalValue(value: DataDatadogLogsIndexesLogsIndexesFilter | undefined);
    get query(): string;
}
export declare class DataDatadogLogsIndexesLogsIndexesFilterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatadogLogsIndexesLogsIndexesFilterOutputReference;
}
export interface DataDatadogLogsIndexesLogsIndexes {
}
export declare function dataDatadogLogsIndexesLogsIndexesToTerraform(struct?: DataDatadogLogsIndexesLogsIndexes): any;
export declare class DataDatadogLogsIndexesLogsIndexesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatadogLogsIndexesLogsIndexes | undefined;
    set internalValue(value: DataDatadogLogsIndexesLogsIndexes | undefined);
    get dailyLimit(): number;
    private _exclusionFilter;
    get exclusionFilter(): DataDatadogLogsIndexesLogsIndexesExclusionFilterList;
    private _filter;
    get filter(): DataDatadogLogsIndexesLogsIndexesFilterList;
    get name(): string;
    get retentionDays(): number;
}
export declare class DataDatadogLogsIndexesLogsIndexesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatadogLogsIndexesLogsIndexesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/d/logs_indexes datadog_logs_indexes}
*/
export declare class DataDatadogLogsIndexes extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "datadog_logs_indexes";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/d/logs_indexes datadog_logs_indexes} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatadogLogsIndexesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataDatadogLogsIndexesConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _logsIndexes;
    get logsIndexes(): DataDatadogLogsIndexesLogsIndexesList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
