import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatadogLogsPipelinesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/logs_pipelines#id DataDatadogLogsPipelines#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Filter parameter for retrieved pipelines
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/logs_pipelines#is_read_only DataDatadogLogsPipelines#is_read_only}
    */
    readonly isReadOnly?: string;
}
export interface DataDatadogLogsPipelinesLogsPipelinesFilter {
}
export declare function dataDatadogLogsPipelinesLogsPipelinesFilterToTerraform(struct?: DataDatadogLogsPipelinesLogsPipelinesFilter): any;
export declare class DataDatadogLogsPipelinesLogsPipelinesFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatadogLogsPipelinesLogsPipelinesFilter | undefined;
    set internalValue(value: DataDatadogLogsPipelinesLogsPipelinesFilter | undefined);
    get query(): string;
}
export declare class DataDatadogLogsPipelinesLogsPipelinesFilterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatadogLogsPipelinesLogsPipelinesFilterOutputReference;
}
export interface DataDatadogLogsPipelinesLogsPipelines {
}
export declare function dataDatadogLogsPipelinesLogsPipelinesToTerraform(struct?: DataDatadogLogsPipelinesLogsPipelines): any;
export declare class DataDatadogLogsPipelinesLogsPipelinesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatadogLogsPipelinesLogsPipelines | undefined;
    set internalValue(value: DataDatadogLogsPipelinesLogsPipelines | undefined);
    private _filter;
    get filter(): DataDatadogLogsPipelinesLogsPipelinesFilterList;
    get id(): string;
    get isEnabled(): cdktf.IResolvable;
    get isReadOnly(): cdktf.IResolvable;
    get name(): string;
    get type(): string;
}
export declare class DataDatadogLogsPipelinesLogsPipelinesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatadogLogsPipelinesLogsPipelinesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/d/logs_pipelines datadog_logs_pipelines}
*/
export declare class DataDatadogLogsPipelines extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "datadog_logs_pipelines";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/d/logs_pipelines datadog_logs_pipelines} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatadogLogsPipelinesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataDatadogLogsPipelinesConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _isReadOnly?;
    get isReadOnly(): string;
    set isReadOnly(value: string);
    resetIsReadOnly(): void;
    get isReadOnlyInput(): string | undefined;
    private _logsPipelines;
    get logsPipelines(): DataDatadogLogsPipelinesLogsPipelinesList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
