import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatadogMonitorConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/monitor#id DataDatadogMonitor#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A list of monitor tags to limit the search. This filters on the tags set on the monitor itself.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/monitor#monitor_tags_filter DataDatadogMonitor#monitor_tags_filter}
    */
    readonly monitorTagsFilter?: string[];
    /**
    * A monitor name to limit the search.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/monitor#name_filter DataDatadogMonitor#name_filter}
    */
    readonly nameFilter?: string;
    /**
    * A list of tags to limit the search. This filters on the monitor scope.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/monitor#tags_filter DataDatadogMonitor#tags_filter}
    */
    readonly tagsFilter?: string[];
}
export interface DataDatadogMonitorMonitorThresholdWindows {
}
export declare function dataDatadogMonitorMonitorThresholdWindowsToTerraform(struct?: DataDatadogMonitorMonitorThresholdWindows): any;
export declare class DataDatadogMonitorMonitorThresholdWindowsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatadogMonitorMonitorThresholdWindows | undefined;
    set internalValue(value: DataDatadogMonitorMonitorThresholdWindows | undefined);
    get recoveryWindow(): string;
    get triggerWindow(): string;
}
export declare class DataDatadogMonitorMonitorThresholdWindowsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatadogMonitorMonitorThresholdWindowsOutputReference;
}
export interface DataDatadogMonitorMonitorThresholds {
}
export declare function dataDatadogMonitorMonitorThresholdsToTerraform(struct?: DataDatadogMonitorMonitorThresholds): any;
export declare class DataDatadogMonitorMonitorThresholdsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatadogMonitorMonitorThresholds | undefined;
    set internalValue(value: DataDatadogMonitorMonitorThresholds | undefined);
    get critical(): string;
    get criticalRecovery(): string;
    get ok(): string;
    get unknown(): string;
    get warning(): string;
    get warningRecovery(): string;
}
export declare class DataDatadogMonitorMonitorThresholdsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatadogMonitorMonitorThresholdsOutputReference;
}
export interface DataDatadogMonitorSchedulingOptionsEvaluationWindow {
}
export declare function dataDatadogMonitorSchedulingOptionsEvaluationWindowToTerraform(struct?: DataDatadogMonitorSchedulingOptionsEvaluationWindow): any;
export declare class DataDatadogMonitorSchedulingOptionsEvaluationWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatadogMonitorSchedulingOptionsEvaluationWindow | undefined;
    set internalValue(value: DataDatadogMonitorSchedulingOptionsEvaluationWindow | undefined);
    get dayStarts(): string;
    get hourStarts(): number;
    get monthStarts(): number;
}
export declare class DataDatadogMonitorSchedulingOptionsEvaluationWindowList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatadogMonitorSchedulingOptionsEvaluationWindowOutputReference;
}
export interface DataDatadogMonitorSchedulingOptions {
}
export declare function dataDatadogMonitorSchedulingOptionsToTerraform(struct?: DataDatadogMonitorSchedulingOptions): any;
export declare class DataDatadogMonitorSchedulingOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatadogMonitorSchedulingOptions | undefined;
    set internalValue(value: DataDatadogMonitorSchedulingOptions | undefined);
    private _evaluationWindow;
    get evaluationWindow(): DataDatadogMonitorSchedulingOptionsEvaluationWindowList;
}
export declare class DataDatadogMonitorSchedulingOptionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatadogMonitorSchedulingOptionsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/d/monitor datadog_monitor}
*/
export declare class DataDatadogMonitor extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "datadog_monitor";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/d/monitor datadog_monitor} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatadogMonitorConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataDatadogMonitorConfig);
    get enableLogsSample(): cdktf.IResolvable;
    get enableSamples(): cdktf.IResolvable;
    get escalationMessage(): string;
    get evaluationDelay(): number;
    get groupRetentionDuration(): string;
    get groupbySimpleMonitor(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get includeTags(): cdktf.IResolvable;
    get locked(): cdktf.IResolvable;
    get message(): string;
    private _monitorTagsFilter?;
    get monitorTagsFilter(): string[];
    set monitorTagsFilter(value: string[]);
    resetMonitorTagsFilter(): void;
    get monitorTagsFilterInput(): string[] | undefined;
    private _monitorThresholdWindows;
    get monitorThresholdWindows(): DataDatadogMonitorMonitorThresholdWindowsList;
    private _monitorThresholds;
    get monitorThresholds(): DataDatadogMonitorMonitorThresholdsList;
    get name(): string;
    private _nameFilter?;
    get nameFilter(): string;
    set nameFilter(value: string);
    resetNameFilter(): void;
    get nameFilterInput(): string | undefined;
    get newGroupDelay(): number;
    get newHostDelay(): number;
    get noDataTimeframe(): number;
    get notificationPresetName(): string;
    get notifyAudit(): cdktf.IResolvable;
    get notifyBy(): string[];
    get notifyNoData(): cdktf.IResolvable;
    get onMissingData(): string;
    get query(): string;
    get renotifyInterval(): number;
    get renotifyOccurrences(): number;
    get renotifyStatuses(): string[];
    get requireFullWindow(): cdktf.IResolvable;
    get restrictedRoles(): string[];
    private _schedulingOptions;
    get schedulingOptions(): DataDatadogMonitorSchedulingOptionsList;
    get tags(): string[];
    private _tagsFilter?;
    get tagsFilter(): string[];
    set tagsFilter(value: string[]);
    resetTagsFilter(): void;
    get tagsFilterInput(): string[] | undefined;
    get timeoutH(): number;
    get type(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
