import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatadogMonitorsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/monitors#id DataDatadogMonitors#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A list of monitor tags to limit the search. This filters on the tags set on the monitor itself.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/monitors#monitor_tags_filter DataDatadogMonitors#monitor_tags_filter}
    */
    readonly monitorTagsFilter?: string[];
    /**
    * A monitor name to limit the search.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/monitors#name_filter DataDatadogMonitors#name_filter}
    */
    readonly nameFilter?: string;
    /**
    * A list of tags to limit the search. This filters on the monitor scope.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/monitors#tags_filter DataDatadogMonitors#tags_filter}
    */
    readonly tagsFilter?: string[];
}
export interface DataDatadogMonitorsMonitors {
}
export declare function dataDatadogMonitorsMonitorsToTerraform(struct?: DataDatadogMonitorsMonitors): any;
export declare class DataDatadogMonitorsMonitorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatadogMonitorsMonitors | undefined;
    set internalValue(value: DataDatadogMonitorsMonitors | undefined);
    get id(): number;
    get name(): string;
    get type(): string;
}
export declare class DataDatadogMonitorsMonitorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatadogMonitorsMonitorsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/d/monitors datadog_monitors}
*/
export declare class DataDatadogMonitors extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "datadog_monitors";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/d/monitors datadog_monitors} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatadogMonitorsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataDatadogMonitorsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _monitorTagsFilter?;
    get monitorTagsFilter(): string[];
    set monitorTagsFilter(value: string[]);
    resetMonitorTagsFilter(): void;
    get monitorTagsFilterInput(): string[] | undefined;
    private _monitors;
    get monitors(): DataDatadogMonitorsMonitorsList;
    private _nameFilter?;
    get nameFilter(): string;
    set nameFilter(value: string);
    resetNameFilter(): void;
    get nameFilterInput(): string | undefined;
    private _tagsFilter?;
    get tagsFilter(): string[];
    set tagsFilter(value: string[]);
    resetTagsFilter(): void;
    get tagsFilterInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
