import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatadogRumApplicationConfig extends cdktf.TerraformMetaArguments {
    /**
    * ID of the RUM application. Cannot be used with name and type filters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/rum_application#id DataDatadogRumApplication#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name used to search for a RUM application
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/rum_application#name_filter DataDatadogRumApplication#name_filter}
    */
    readonly nameFilter?: string;
    /**
    * The type used to search for a RUM application
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/rum_application#type_filter DataDatadogRumApplication#type_filter}
    */
    readonly typeFilter?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/d/rum_application datadog_rum_application}
*/
export declare class DataDatadogRumApplication extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "datadog_rum_application";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/d/rum_application datadog_rum_application} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatadogRumApplicationConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataDatadogRumApplicationConfig);
    get clientToken(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _nameFilter?;
    get nameFilter(): string;
    set nameFilter(value: string);
    resetNameFilter(): void;
    get nameFilterInput(): string | undefined;
    get type(): string;
    private _typeFilter?;
    get typeFilter(): string;
    set typeFilter(value: string);
    resetTypeFilter(): void;
    get typeFilterInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
