import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatadogSecurityMonitoringRulesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Limit the search to default rules
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/security_monitoring_rules#default_only_filter DataDatadogSecurityMonitoringRules#default_only_filter}
    */
    readonly defaultOnlyFilter?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/security_monitoring_rules#id DataDatadogSecurityMonitoringRules#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A rule name to limit the search
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/security_monitoring_rules#name_filter DataDatadogSecurityMonitoringRules#name_filter}
    */
    readonly nameFilter?: string;
    /**
    * A list of tags to limit the search
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/security_monitoring_rules#tags_filter DataDatadogSecurityMonitoringRules#tags_filter}
    */
    readonly tagsFilter?: string[];
    /**
    * Limit the search to user rules
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/security_monitoring_rules#user_only_filter DataDatadogSecurityMonitoringRules#user_only_filter}
    */
    readonly userOnlyFilter?: boolean | cdktf.IResolvable;
}
export interface DataDatadogSecurityMonitoringRulesRulesCase {
}
export declare function dataDatadogSecurityMonitoringRulesRulesCaseToTerraform(struct?: DataDatadogSecurityMonitoringRulesRulesCase): any;
export declare class DataDatadogSecurityMonitoringRulesRulesCaseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatadogSecurityMonitoringRulesRulesCase | undefined;
    set internalValue(value: DataDatadogSecurityMonitoringRulesRulesCase | undefined);
    get condition(): string;
    get name(): string;
    get notifications(): string[];
    get status(): string;
}
export declare class DataDatadogSecurityMonitoringRulesRulesCaseList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatadogSecurityMonitoringRulesRulesCaseOutputReference;
}
export interface DataDatadogSecurityMonitoringRulesRulesFilter {
}
export declare function dataDatadogSecurityMonitoringRulesRulesFilterToTerraform(struct?: DataDatadogSecurityMonitoringRulesRulesFilter): any;
export declare class DataDatadogSecurityMonitoringRulesRulesFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatadogSecurityMonitoringRulesRulesFilter | undefined;
    set internalValue(value: DataDatadogSecurityMonitoringRulesRulesFilter | undefined);
    get action(): string;
    get query(): string;
}
export declare class DataDatadogSecurityMonitoringRulesRulesFilterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatadogSecurityMonitoringRulesRulesFilterOutputReference;
}
export interface DataDatadogSecurityMonitoringRulesRulesOptionsImpossibleTravelOptions {
}
export declare function dataDatadogSecurityMonitoringRulesRulesOptionsImpossibleTravelOptionsToTerraform(struct?: DataDatadogSecurityMonitoringRulesRulesOptionsImpossibleTravelOptions): any;
export declare class DataDatadogSecurityMonitoringRulesRulesOptionsImpossibleTravelOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatadogSecurityMonitoringRulesRulesOptionsImpossibleTravelOptions | undefined;
    set internalValue(value: DataDatadogSecurityMonitoringRulesRulesOptionsImpossibleTravelOptions | undefined);
    get baselineUserLocations(): cdktf.IResolvable;
}
export declare class DataDatadogSecurityMonitoringRulesRulesOptionsImpossibleTravelOptionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatadogSecurityMonitoringRulesRulesOptionsImpossibleTravelOptionsOutputReference;
}
export interface DataDatadogSecurityMonitoringRulesRulesOptionsNewValueOptions {
}
export declare function dataDatadogSecurityMonitoringRulesRulesOptionsNewValueOptionsToTerraform(struct?: DataDatadogSecurityMonitoringRulesRulesOptionsNewValueOptions): any;
export declare class DataDatadogSecurityMonitoringRulesRulesOptionsNewValueOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatadogSecurityMonitoringRulesRulesOptionsNewValueOptions | undefined;
    set internalValue(value: DataDatadogSecurityMonitoringRulesRulesOptionsNewValueOptions | undefined);
    get forgetAfter(): number;
    get learningDuration(): number;
    get learningMethod(): string;
    get learningThreshold(): number;
}
export declare class DataDatadogSecurityMonitoringRulesRulesOptionsNewValueOptionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatadogSecurityMonitoringRulesRulesOptionsNewValueOptionsOutputReference;
}
export interface DataDatadogSecurityMonitoringRulesRulesOptions {
}
export declare function dataDatadogSecurityMonitoringRulesRulesOptionsToTerraform(struct?: DataDatadogSecurityMonitoringRulesRulesOptions): any;
export declare class DataDatadogSecurityMonitoringRulesRulesOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatadogSecurityMonitoringRulesRulesOptions | undefined;
    set internalValue(value: DataDatadogSecurityMonitoringRulesRulesOptions | undefined);
    get decreaseCriticalityBasedOnEnv(): cdktf.IResolvable;
    get detectionMethod(): string;
    get evaluationWindow(): number;
    private _impossibleTravelOptions;
    get impossibleTravelOptions(): DataDatadogSecurityMonitoringRulesRulesOptionsImpossibleTravelOptionsList;
    get keepAlive(): number;
    get maxSignalDuration(): number;
    private _newValueOptions;
    get newValueOptions(): DataDatadogSecurityMonitoringRulesRulesOptionsNewValueOptionsList;
}
export declare class DataDatadogSecurityMonitoringRulesRulesOptionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatadogSecurityMonitoringRulesRulesOptionsOutputReference;
}
export interface DataDatadogSecurityMonitoringRulesRulesQueryAgentRule {
}
export declare function dataDatadogSecurityMonitoringRulesRulesQueryAgentRuleToTerraform(struct?: DataDatadogSecurityMonitoringRulesRulesQueryAgentRule): any;
export declare class DataDatadogSecurityMonitoringRulesRulesQueryAgentRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatadogSecurityMonitoringRulesRulesQueryAgentRule | undefined;
    set internalValue(value: DataDatadogSecurityMonitoringRulesRulesQueryAgentRule | undefined);
    get agentRuleId(): string;
    get expression(): string;
}
export declare class DataDatadogSecurityMonitoringRulesRulesQueryAgentRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatadogSecurityMonitoringRulesRulesQueryAgentRuleOutputReference;
}
export interface DataDatadogSecurityMonitoringRulesRulesQuery {
}
export declare function dataDatadogSecurityMonitoringRulesRulesQueryToTerraform(struct?: DataDatadogSecurityMonitoringRulesRulesQuery): any;
export declare class DataDatadogSecurityMonitoringRulesRulesQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatadogSecurityMonitoringRulesRulesQuery | undefined;
    set internalValue(value: DataDatadogSecurityMonitoringRulesRulesQuery | undefined);
    private _agentRule;
    get agentRule(): DataDatadogSecurityMonitoringRulesRulesQueryAgentRuleList;
    get aggregation(): string;
    get distinctFields(): string[];
    get groupByFields(): string[];
    get metric(): string;
    get metrics(): string[];
    get name(): string;
    get query(): string;
}
export declare class DataDatadogSecurityMonitoringRulesRulesQueryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatadogSecurityMonitoringRulesRulesQueryOutputReference;
}
export interface DataDatadogSecurityMonitoringRulesRulesSignalQuery {
}
export declare function dataDatadogSecurityMonitoringRulesRulesSignalQueryToTerraform(struct?: DataDatadogSecurityMonitoringRulesRulesSignalQuery): any;
export declare class DataDatadogSecurityMonitoringRulesRulesSignalQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatadogSecurityMonitoringRulesRulesSignalQuery | undefined;
    set internalValue(value: DataDatadogSecurityMonitoringRulesRulesSignalQuery | undefined);
    get aggregation(): string;
    get correlatedByFields(): string[];
    get correlatedQueryIndex(): string;
    get defaultRuleId(): string;
    get name(): string;
    get ruleId(): string;
}
export declare class DataDatadogSecurityMonitoringRulesRulesSignalQueryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatadogSecurityMonitoringRulesRulesSignalQueryOutputReference;
}
export interface DataDatadogSecurityMonitoringRulesRules {
}
export declare function dataDatadogSecurityMonitoringRulesRulesToTerraform(struct?: DataDatadogSecurityMonitoringRulesRules): any;
export declare class DataDatadogSecurityMonitoringRulesRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatadogSecurityMonitoringRulesRules | undefined;
    set internalValue(value: DataDatadogSecurityMonitoringRulesRules | undefined);
    private _case;
    get case(): DataDatadogSecurityMonitoringRulesRulesCaseList;
    get enabled(): cdktf.IResolvable;
    private _filter;
    get filter(): DataDatadogSecurityMonitoringRulesRulesFilterList;
    get hasExtendedTitle(): cdktf.IResolvable;
    get message(): string;
    get name(): string;
    private _options;
    get options(): DataDatadogSecurityMonitoringRulesRulesOptionsList;
    private _query;
    get query(): DataDatadogSecurityMonitoringRulesRulesQueryList;
    private _signalQuery;
    get signalQuery(): DataDatadogSecurityMonitoringRulesRulesSignalQueryList;
    get tags(): string[];
    get type(): string;
}
export declare class DataDatadogSecurityMonitoringRulesRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatadogSecurityMonitoringRulesRulesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/d/security_monitoring_rules datadog_security_monitoring_rules}
*/
export declare class DataDatadogSecurityMonitoringRules extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "datadog_security_monitoring_rules";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/d/security_monitoring_rules datadog_security_monitoring_rules} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatadogSecurityMonitoringRulesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataDatadogSecurityMonitoringRulesConfig);
    private _defaultOnlyFilter?;
    get defaultOnlyFilter(): boolean | cdktf.IResolvable;
    set defaultOnlyFilter(value: boolean | cdktf.IResolvable);
    resetDefaultOnlyFilter(): void;
    get defaultOnlyFilterInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _nameFilter?;
    get nameFilter(): string;
    set nameFilter(value: string);
    resetNameFilter(): void;
    get nameFilterInput(): string | undefined;
    get ruleIds(): string[];
    private _rules;
    get rules(): DataDatadogSecurityMonitoringRulesRulesList;
    private _tagsFilter?;
    get tagsFilter(): string[];
    set tagsFilter(value: string[]);
    resetTagsFilter(): void;
    get tagsFilterInput(): string[] | undefined;
    private _userOnlyFilter?;
    get userOnlyFilter(): boolean | cdktf.IResolvable;
    set userOnlyFilter(value: boolean | cdktf.IResolvable);
    resetUserOnlyFilter(): void;
    get userOnlyFilterInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
