import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatadogServiceLevelObjectiveConfig extends cdktf.TerraformMetaArguments {
    /**
    * A SLO ID to limit the search.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/service_level_objective#id DataDatadogServiceLevelObjective#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Filter results based on SLO numerator and denominator.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/service_level_objective#metrics_query DataDatadogServiceLevelObjective#metrics_query}
    */
    readonly metricsQuery?: string;
    /**
    * Filter results based on SLO names.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/service_level_objective#name_query DataDatadogServiceLevelObjective#name_query}
    */
    readonly nameQuery?: string;
    /**
    * Filter results based on a single SLO tag.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/service_level_objective#tags_query DataDatadogServiceLevelObjective#tags_query}
    */
    readonly tagsQuery?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/d/service_level_objective datadog_service_level_objective}
*/
export declare class DataDatadogServiceLevelObjective extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "datadog_service_level_objective";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/d/service_level_objective datadog_service_level_objective} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatadogServiceLevelObjectiveConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataDatadogServiceLevelObjectiveConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metricsQuery?;
    get metricsQuery(): string;
    set metricsQuery(value: string);
    resetMetricsQuery(): void;
    get metricsQueryInput(): string | undefined;
    get name(): string;
    private _nameQuery?;
    get nameQuery(): string;
    set nameQuery(value: string);
    resetNameQuery(): void;
    get nameQueryInput(): string | undefined;
    private _tagsQuery?;
    get tagsQuery(): string;
    set tagsQuery(value: string);
    resetTagsQuery(): void;
    get tagsQueryInput(): string | undefined;
    get type(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
