import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatadogServiceLevelObjectivesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/service_level_objectives#id DataDatadogServiceLevelObjectives#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * An array of SLO IDs to limit the search.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/service_level_objectives#ids DataDatadogServiceLevelObjectives#ids}
    */
    readonly ids?: string[];
    /**
    * Filter results based on SLO numerator and denominator.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/service_level_objectives#metrics_query DataDatadogServiceLevelObjectives#metrics_query}
    */
    readonly metricsQuery?: string;
    /**
    * Filter results based on SLO names.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/service_level_objectives#name_query DataDatadogServiceLevelObjectives#name_query}
    */
    readonly nameQuery?: string;
    /**
    * Filter results based on a single SLO tag.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/service_level_objectives#tags_query DataDatadogServiceLevelObjectives#tags_query}
    */
    readonly tagsQuery?: string;
}
export interface DataDatadogServiceLevelObjectivesSlos {
}
export declare function dataDatadogServiceLevelObjectivesSlosToTerraform(struct?: DataDatadogServiceLevelObjectivesSlos): any;
export declare class DataDatadogServiceLevelObjectivesSlosOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDatadogServiceLevelObjectivesSlos | undefined;
    set internalValue(value: DataDatadogServiceLevelObjectivesSlos | undefined);
    get id(): string;
    get name(): string;
    get type(): string;
}
export declare class DataDatadogServiceLevelObjectivesSlosList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDatadogServiceLevelObjectivesSlosOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/d/service_level_objectives datadog_service_level_objectives}
*/
export declare class DataDatadogServiceLevelObjectives extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "datadog_service_level_objectives";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/d/service_level_objectives datadog_service_level_objectives} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatadogServiceLevelObjectivesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataDatadogServiceLevelObjectivesConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ids?;
    get ids(): string[];
    set ids(value: string[]);
    resetIds(): void;
    get idsInput(): string[] | undefined;
    private _metricsQuery?;
    get metricsQuery(): string;
    set metricsQuery(value: string);
    resetMetricsQuery(): void;
    get metricsQueryInput(): string | undefined;
    private _nameQuery?;
    get nameQuery(): string;
    set nameQuery(value: string);
    resetNameQuery(): void;
    get nameQueryInput(): string | undefined;
    private _slos;
    get slos(): DataDatadogServiceLevelObjectivesSlosList;
    private _tagsQuery?;
    get tagsQuery(): string;
    set tagsQuery(value: string);
    resetTagsQuery(): void;
    get tagsQueryInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
