import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatadogSyntheticsGlobalVariableConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/synthetics_global_variable#id DataDatadogSyntheticsGlobalVariable#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The synthetics global variable name to search for. Must only match one global variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/synthetics_global_variable#name DataDatadogSyntheticsGlobalVariable#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/d/synthetics_global_variable datadog_synthetics_global_variable}
*/
export declare class DataDatadogSyntheticsGlobalVariable extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "datadog_synthetics_global_variable";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/d/synthetics_global_variable datadog_synthetics_global_variable} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatadogSyntheticsGlobalVariableConfig
    */
    constructor(scope: Construct, id: string, config: DataDatadogSyntheticsGlobalVariableConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get tags(): string[];
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
