import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatadogSyntheticsTestConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/synthetics_test#id DataDatadogSyntheticsTest#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The synthetic test id to search for
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/synthetics_test#test_id DataDatadogSyntheticsTest#test_id}
    */
    readonly testId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/d/synthetics_test datadog_synthetics_test}
*/
export declare class DataDatadogSyntheticsTest extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "datadog_synthetics_test";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/d/synthetics_test datadog_synthetics_test} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatadogSyntheticsTestConfig
    */
    constructor(scope: Construct, id: string, config: DataDatadogSyntheticsTestConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    get tags(): string[];
    private _testId?;
    get testId(): string;
    set testId(value: string);
    get testIdInput(): string | undefined;
    get url(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
