import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatadogUserConfig extends cdktf.TerraformMetaArguments {
    /**
    * Filter all users by the given string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/user#filter DataDatadogUser#filter}
    */
    readonly filter: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/user#id DataDatadogUser#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/d/user datadog_user}
*/
export declare class DataDatadogUser extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "datadog_user";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/d/user datadog_user} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatadogUserConfig
    */
    constructor(scope: Construct, id: string, config: DataDatadogUserConfig);
    get email(): string;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    get filterInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
