import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DowntimeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optionally specify an end date when this downtime should expire. Accepts a Unix timestamp in UTC.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/downtime#end Downtime#end}
    */
    readonly end?: number;
    /**
    * String representing date and time to end the downtime in RFC3339 format.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/downtime#end_date Downtime#end_date}
    */
    readonly endDate?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/downtime#id Downtime#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * An optional message to provide when creating the downtime, can include notification handles
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/downtime#message Downtime#message}
    */
    readonly message?: string;
    /**
    * When specified, this downtime will only apply to this monitor
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/downtime#monitor_id Downtime#monitor_id}
    */
    readonly monitorId?: number;
    /**
    * A list of monitor tags (up to 32) to base the scheduled downtime on. Only monitors that have all selected tags are silenced
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/downtime#monitor_tags Downtime#monitor_tags}
    */
    readonly monitorTags?: string[];
    /**
    * When true the first recovery notification during the downtime will be muted
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/downtime#mute_first_recovery_notification Downtime#mute_first_recovery_notification}
    */
    readonly muteFirstRecoveryNotification?: boolean | cdktf.IResolvable;
    /**
    * specify the group scope to which this downtime applies. For everything use '*'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/downtime#scope Downtime#scope}
    */
    readonly scope: string[];
    /**
    * Specify when this downtime should start. Accepts a Unix timestamp in UTC.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/downtime#start Downtime#start}
    */
    readonly start?: number;
    /**
    * String representing date and time to start the downtime in RFC3339 format.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/downtime#start_date Downtime#start_date}
    */
    readonly startDate?: string;
    /**
    * The timezone for the downtime, default UTC. Follows IANA timezone database identifiers.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/downtime#timezone Downtime#timezone}
    */
    readonly timezone?: string;
    /**
    * recurrence block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/downtime#recurrence Downtime#recurrence}
    */
    readonly recurrence?: DowntimeRecurrence;
}
export interface DowntimeRecurrence {
    /**
    * How often to repeat as an integer. For example to repeat every 3 days, select a `type` of `days` and a `period` of `3`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/downtime#period Downtime#period}
    */
    readonly period?: number;
    /**
    * The RRULE standard for defining recurring events. For example, to have a recurring event on the first day of each month, use `FREQ=MONTHLY;INTERVAL=1`. Most common rrule options from the iCalendar Spec are supported. Attributes specifying the duration in RRULE are not supported (for example, `DTSTART`, `DTEND`, `DURATION`). Only applicable when `type` is `rrule`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/downtime#rrule Downtime#rrule}
    */
    readonly rrule?: string;
    /**
    * One of `days`, `weeks`, `months`, `years`, or `rrule`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/downtime#type Downtime#type}
    */
    readonly type: string;
    /**
    * The date at which the recurrence should end as a POSIX timestamp. `until_occurrences` and `until_date` are mutually exclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/downtime#until_date Downtime#until_date}
    */
    readonly untilDate?: number;
    /**
    * How many times the downtime will be rescheduled. `until_occurrences` and `until_date` are mutually exclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/downtime#until_occurrences Downtime#until_occurrences}
    */
    readonly untilOccurrences?: number;
    /**
    * A list of week days to repeat on. Choose from: `Mon`, `Tue`, `Wed`, `Thu`, `Fri`, `Sat` or `Sun`. Only applicable when `type` is `weeks`. First letter must be capitalized.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/downtime#week_days Downtime#week_days}
    */
    readonly weekDays?: string[];
}
export declare function downtimeRecurrenceToTerraform(struct?: DowntimeRecurrenceOutputReference | DowntimeRecurrence): any;
export declare class DowntimeRecurrenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DowntimeRecurrence | undefined;
    set internalValue(value: DowntimeRecurrence | undefined);
    private _period?;
    get period(): number;
    set period(value: number);
    resetPeriod(): void;
    get periodInput(): number | undefined;
    private _rrule?;
    get rrule(): string;
    set rrule(value: string);
    resetRrule(): void;
    get rruleInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _untilDate?;
    get untilDate(): number;
    set untilDate(value: number);
    resetUntilDate(): void;
    get untilDateInput(): number | undefined;
    private _untilOccurrences?;
    get untilOccurrences(): number;
    set untilOccurrences(value: number);
    resetUntilOccurrences(): void;
    get untilOccurrencesInput(): number | undefined;
    private _weekDays?;
    get weekDays(): string[];
    set weekDays(value: string[]);
    resetWeekDays(): void;
    get weekDaysInput(): string[] | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/downtime datadog_downtime}
*/
export declare class Downtime extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_downtime";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/downtime datadog_downtime} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DowntimeConfig
    */
    constructor(scope: Construct, id: string, config: DowntimeConfig);
    get active(): cdktf.IResolvable;
    get activeChildId(): number;
    get disabled(): cdktf.IResolvable;
    private _end?;
    get end(): number;
    set end(value: number);
    resetEnd(): void;
    get endInput(): number | undefined;
    private _endDate?;
    get endDate(): string;
    set endDate(value: string);
    resetEndDate(): void;
    get endDateInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _message?;
    get message(): string;
    set message(value: string);
    resetMessage(): void;
    get messageInput(): string | undefined;
    private _monitorId?;
    get monitorId(): number;
    set monitorId(value: number);
    resetMonitorId(): void;
    get monitorIdInput(): number | undefined;
    private _monitorTags?;
    get monitorTags(): string[];
    set monitorTags(value: string[]);
    resetMonitorTags(): void;
    get monitorTagsInput(): string[] | undefined;
    private _muteFirstRecoveryNotification?;
    get muteFirstRecoveryNotification(): boolean | cdktf.IResolvable;
    set muteFirstRecoveryNotification(value: boolean | cdktf.IResolvable);
    resetMuteFirstRecoveryNotification(): void;
    get muteFirstRecoveryNotificationInput(): boolean | cdktf.IResolvable | undefined;
    private _scope?;
    get scope(): string[];
    set scope(value: string[]);
    get scopeInput(): string[] | undefined;
    private _start?;
    get start(): number;
    set start(value: number);
    resetStart(): void;
    get startInput(): number | undefined;
    private _startDate?;
    get startDate(): string;
    set startDate(value: string);
    resetStartDate(): void;
    get startDateInput(): string | undefined;
    private _timezone?;
    get timezone(): string;
    set timezone(value: string);
    resetTimezone(): void;
    get timezoneInput(): string | undefined;
    private _recurrence;
    get recurrence(): DowntimeRecurrenceOutputReference;
    putRecurrence(value: DowntimeRecurrence): void;
    resetRecurrence(): void;
    get recurrenceInput(): DowntimeRecurrence | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
