import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IntegrationAwsLambdaArnConfig extends cdktf.TerraformMetaArguments {
    /**
    * Your AWS Account ID without dashes. If your account is a GovCloud or China account, specify the `access_key_id` here.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws_lambda_arn#account_id IntegrationAwsLambdaArn#account_id}
    */
    readonly accountId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws_lambda_arn#id IntegrationAwsLambdaArn#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The ARN of the Datadog forwarder Lambda.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws_lambda_arn#lambda_arn IntegrationAwsLambdaArn#lambda_arn}
    */
    readonly lambdaArn: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws_lambda_arn datadog_integration_aws_lambda_arn}
*/
export declare class IntegrationAwsLambdaArn extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_integration_aws_lambda_arn";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws_lambda_arn datadog_integration_aws_lambda_arn} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IntegrationAwsLambdaArnConfig
    */
    constructor(scope: Construct, id: string, config: IntegrationAwsLambdaArnConfig);
    private _accountId?;
    get accountId(): string;
    set accountId(value: string);
    get accountIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _lambdaArn?;
    get lambdaArn(): string;
    set lambdaArn(value: string);
    get lambdaArnInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
