import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IntegrationAwsTagFilterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Your AWS Account ID without dashes. If your account is a GovCloud or China account, specify the `access_key_id` here.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws_tag_filter#account_id IntegrationAwsTagFilter#account_id}
    */
    readonly accountId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws_tag_filter#id IntegrationAwsTagFilter#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The namespace associated with the tag filter entry. Valid values are `elb`, `application_elb`, `sqs`, `rds`, `custom`, `network_elb`, `lambda`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws_tag_filter#namespace IntegrationAwsTagFilter#namespace}
    */
    readonly namespace: string;
    /**
    * The tag filter string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws_tag_filter#tag_filter_str IntegrationAwsTagFilter#tag_filter_str}
    */
    readonly tagFilterStr: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws_tag_filter datadog_integration_aws_tag_filter}
*/
export declare class IntegrationAwsTagFilter extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_integration_aws_tag_filter";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws_tag_filter datadog_integration_aws_tag_filter} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IntegrationAwsTagFilterConfig
    */
    constructor(scope: Construct, id: string, config: IntegrationAwsTagFilterConfig);
    private _accountId?;
    get accountId(): string;
    set accountId(value: string);
    get accountIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    get namespaceInput(): string | undefined;
    private _tagFilterStr?;
    get tagFilterStr(): string;
    set tagFilterStr(value: string);
    get tagFilterStrInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
