import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IntegrationAwsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Your AWS access key ID. Only required if your AWS account is a GovCloud or China account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws#access_key_id IntegrationAws#access_key_id}
    */
    readonly accessKeyId?: string;
    /**
    * Your AWS Account ID without dashes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws#account_id IntegrationAws#account_id}
    */
    readonly accountId?: string;
    /**
    * Enables or disables metric collection for specific AWS namespaces for this AWS account only. A list of namespaces can be found at the [available namespace rules API endpoint](https://docs.datadoghq.com/api/v1/aws-integration/#list-namespace-rules).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws#account_specific_namespace_rules IntegrationAws#account_specific_namespace_rules}
    */
    readonly accountSpecificNamespaceRules?: {
        [key: string]: (boolean | cdktf.IResolvable);
    };
    /**
    * Whether Datadog collects cloud security posture management resources from your AWS account. This includes additional resources not covered under the general resource_collection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws#cspm_resource_collection_enabled IntegrationAws#cspm_resource_collection_enabled}
    */
    readonly cspmResourceCollectionEnabled?: string;
    /**
    * An array of AWS regions to exclude from metrics collection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws#excluded_regions IntegrationAws#excluded_regions}
    */
    readonly excludedRegions?: string[];
    /**
    * Array of EC2 tags (in the form `key:value`) defines a filter that Datadog uses when collecting metrics from EC2. Wildcards, such as `?` (for single characters) and `*` (for multiple characters) can also be used. Only hosts that match one of the defined tags will be imported into Datadog. The rest will be ignored. Host matching a given tag can also be excluded by adding `!` before the tag. e.x. `env:production,instance-type:c1.*,!region:us-east-1`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws#filter_tags IntegrationAws#filter_tags}
    */
    readonly filterTags?: string[];
    /**
    * Array of tags (in the form `key:value`) to add to all hosts and metrics reporting through this integration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws#host_tags IntegrationAws#host_tags}
    */
    readonly hostTags?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws#id IntegrationAws#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Whether Datadog collects metrics for this AWS account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws#metrics_collection_enabled IntegrationAws#metrics_collection_enabled}
    */
    readonly metricsCollectionEnabled?: string;
    /**
    * Whether Datadog collects a standard set of resources from your AWS account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws#resource_collection_enabled IntegrationAws#resource_collection_enabled}
    */
    readonly resourceCollectionEnabled?: string;
    /**
    * Your Datadog role delegation name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws#role_name IntegrationAws#role_name}
    */
    readonly roleName?: string;
    /**
    * Your AWS secret access key. Only required if your AWS account is a GovCloud or China account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws#secret_access_key IntegrationAws#secret_access_key}
    */
    readonly secretAccessKey?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws datadog_integration_aws}
*/
export declare class IntegrationAws extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_integration_aws";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/integration_aws datadog_integration_aws} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IntegrationAwsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: IntegrationAwsConfig);
    private _accessKeyId?;
    get accessKeyId(): string;
    set accessKeyId(value: string);
    resetAccessKeyId(): void;
    get accessKeyIdInput(): string | undefined;
    private _accountId?;
    get accountId(): string;
    set accountId(value: string);
    resetAccountId(): void;
    get accountIdInput(): string | undefined;
    private _accountSpecificNamespaceRules?;
    get accountSpecificNamespaceRules(): {
        [key: string]: (boolean | cdktf.IResolvable);
    };
    set accountSpecificNamespaceRules(value: {
        [key: string]: (boolean | cdktf.IResolvable);
    });
    resetAccountSpecificNamespaceRules(): void;
    get accountSpecificNamespaceRulesInput(): {
        [key: string]: boolean | cdktf.IResolvable;
    } | undefined;
    private _cspmResourceCollectionEnabled?;
    get cspmResourceCollectionEnabled(): string;
    set cspmResourceCollectionEnabled(value: string);
    resetCspmResourceCollectionEnabled(): void;
    get cspmResourceCollectionEnabledInput(): string | undefined;
    private _excludedRegions?;
    get excludedRegions(): string[];
    set excludedRegions(value: string[]);
    resetExcludedRegions(): void;
    get excludedRegionsInput(): string[] | undefined;
    get externalId(): string;
    private _filterTags?;
    get filterTags(): string[];
    set filterTags(value: string[]);
    resetFilterTags(): void;
    get filterTagsInput(): string[] | undefined;
    private _hostTags?;
    get hostTags(): string[];
    set hostTags(value: string[]);
    resetHostTags(): void;
    get hostTagsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metricsCollectionEnabled?;
    get metricsCollectionEnabled(): string;
    set metricsCollectionEnabled(value: string);
    resetMetricsCollectionEnabled(): void;
    get metricsCollectionEnabledInput(): string | undefined;
    private _resourceCollectionEnabled?;
    get resourceCollectionEnabled(): string;
    set resourceCollectionEnabled(value: string);
    resetResourceCollectionEnabled(): void;
    get resourceCollectionEnabledInput(): string | undefined;
    private _roleName?;
    get roleName(): string;
    set roleName(value: string);
    resetRoleName(): void;
    get roleNameInput(): string | undefined;
    private _secretAccessKey?;
    get secretAccessKey(): string;
    set secretAccessKey(value: string);
    resetSecretAccessKey(): void;
    get secretAccessKeyInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
