import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IntegrationAzureConfig extends cdktf.TerraformMetaArguments {
    /**
    * Silence monitors for expected Azure VM shutdowns.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_azure#automute IntegrationAzure#automute}
    */
    readonly automute?: boolean | cdktf.IResolvable;
    /**
    * Your Azure web application ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_azure#client_id IntegrationAzure#client_id}
    */
    readonly clientId: string;
    /**
    * (Required for Initial Creation) Your Azure web application secret key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_azure#client_secret IntegrationAzure#client_secret}
    */
    readonly clientSecret: string;
    /**
    * String of host tag(s) (in the form `key:value,key:value`) defines a filter that Datadog will use when collecting metrics from Azure. Limit the Azure instances that are pulled into Datadog by using tags. Only hosts that match one of the defined tags are imported into Datadog. e.x. `env:production,deploymentgroup:red`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_azure#host_filters IntegrationAzure#host_filters}
    */
    readonly hostFilters?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_azure#id IntegrationAzure#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Your Azure Active Directory ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_azure#tenant_name IntegrationAzure#tenant_name}
    */
    readonly tenantName: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/integration_azure datadog_integration_azure}
*/
export declare class IntegrationAzure extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_integration_azure";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/integration_azure datadog_integration_azure} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IntegrationAzureConfig
    */
    constructor(scope: Construct, id: string, config: IntegrationAzureConfig);
    private _automute?;
    get automute(): boolean | cdktf.IResolvable;
    set automute(value: boolean | cdktf.IResolvable);
    resetAutomute(): void;
    get automuteInput(): boolean | cdktf.IResolvable | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    get clientSecretInput(): string | undefined;
    private _hostFilters?;
    get hostFilters(): string;
    set hostFilters(value: string);
    resetHostFilters(): void;
    get hostFiltersInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _tenantName?;
    get tenantName(): string;
    set tenantName(value: string);
    get tenantNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
