import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IntegrationGcpConfig extends cdktf.TerraformMetaArguments {
    /**
    * Silence monitors for expected GCE instance shutdowns.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_gcp#automute IntegrationGcp#automute}
    */
    readonly automute?: boolean | cdktf.IResolvable;
    /**
    * Your email found in your JSON service account key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_gcp#client_email IntegrationGcp#client_email}
    */
    readonly clientEmail: string;
    /**
    * Your ID found in your JSON service account key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_gcp#client_id IntegrationGcp#client_id}
    */
    readonly clientId: string;
    /**
    * Whether Datadog collects cloud security posture management resources from your GCP project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_gcp#cspm_resource_collection_enabled IntegrationGcp#cspm_resource_collection_enabled}
    */
    readonly cspmResourceCollectionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Limit the GCE instances that are pulled into Datadog by using tags. Only hosts that match one of the defined tags are imported into Datadog.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_gcp#host_filters IntegrationGcp#host_filters}
    */
    readonly hostFilters?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_gcp#id IntegrationGcp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Your private key name found in your JSON service account key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_gcp#private_key IntegrationGcp#private_key}
    */
    readonly privateKey: string;
    /**
    * Your private key ID found in your JSON service account key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_gcp#private_key_id IntegrationGcp#private_key_id}
    */
    readonly privateKeyId: string;
    /**
    * Your Google Cloud project ID found in your JSON service account key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_gcp#project_id IntegrationGcp#project_id}
    */
    readonly projectId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/integration_gcp datadog_integration_gcp}
*/
export declare class IntegrationGcp extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_integration_gcp";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/integration_gcp datadog_integration_gcp} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IntegrationGcpConfig
    */
    constructor(scope: Construct, id: string, config: IntegrationGcpConfig);
    private _automute?;
    get automute(): boolean | cdktf.IResolvable;
    set automute(value: boolean | cdktf.IResolvable);
    resetAutomute(): void;
    get automuteInput(): boolean | cdktf.IResolvable | undefined;
    private _clientEmail?;
    get clientEmail(): string;
    set clientEmail(value: string);
    get clientEmailInput(): string | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _cspmResourceCollectionEnabled?;
    get cspmResourceCollectionEnabled(): boolean | cdktf.IResolvable;
    set cspmResourceCollectionEnabled(value: boolean | cdktf.IResolvable);
    resetCspmResourceCollectionEnabled(): void;
    get cspmResourceCollectionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _hostFilters?;
    get hostFilters(): string;
    set hostFilters(value: string);
    resetHostFilters(): void;
    get hostFiltersInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _privateKey?;
    get privateKey(): string;
    set privateKey(value: string);
    get privateKeyInput(): string | undefined;
    private _privateKeyId?;
    get privateKeyId(): string;
    set privateKeyId(value: string);
    get privateKeyIdInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
