import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IntegrationOpsgenieServiceObjectConfig extends cdktf.TerraformMetaArguments {
    /**
    * The custom url for a custom region.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_opsgenie_service_object#custom_url IntegrationOpsgenieServiceObject#custom_url}
    */
    readonly customUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_opsgenie_service_object#id IntegrationOpsgenieServiceObject#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name for the Opsgenie service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_opsgenie_service_object#name IntegrationOpsgenieServiceObject#name}
    */
    readonly name: string;
    /**
    * The Opsgenie API key for the Opsgenie service. Note: Since the Datadog API never returns Opsgenie API keys, it is impossible to detect [drifts](https://www.hashicorp.com/blog/detecting-and-managing-drift-with-terraform). The best way to solve a drift is to manually mark the Service Object resource with [terraform taint](https://www.terraform.io/docs/commands/taint.html) to have it destroyed and recreated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_opsgenie_service_object#opsgenie_api_key IntegrationOpsgenieServiceObject#opsgenie_api_key}
    */
    readonly opsgenieApiKey: string;
    /**
    * The region for the Opsgenie service. Valid values are `us`, `eu`, `custom`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_opsgenie_service_object#region IntegrationOpsgenieServiceObject#region}
    */
    readonly region: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/integration_opsgenie_service_object datadog_integration_opsgenie_service_object}
*/
export declare class IntegrationOpsgenieServiceObject extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_integration_opsgenie_service_object";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/integration_opsgenie_service_object datadog_integration_opsgenie_service_object} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IntegrationOpsgenieServiceObjectConfig
    */
    constructor(scope: Construct, id: string, config: IntegrationOpsgenieServiceObjectConfig);
    private _customUrl?;
    get customUrl(): string;
    set customUrl(value: string);
    resetCustomUrl(): void;
    get customUrlInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _opsgenieApiKey?;
    get opsgenieApiKey(): string;
    set opsgenieApiKey(value: string);
    get opsgenieApiKeyInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    get regionInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
