import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IntegrationPagerdutyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Your PagerDuty API token.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_pagerduty#api_token IntegrationPagerduty#api_token}
    */
    readonly apiToken?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_pagerduty#id IntegrationPagerduty#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Array of your schedule URLs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_pagerduty#schedules IntegrationPagerduty#schedules}
    */
    readonly schedules?: string[];
    /**
    * Your PagerDuty account’s personalized subdomain name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_pagerduty#subdomain IntegrationPagerduty#subdomain}
    */
    readonly subdomain: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/integration_pagerduty datadog_integration_pagerduty}
*/
export declare class IntegrationPagerduty extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_integration_pagerduty";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/integration_pagerduty datadog_integration_pagerduty} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IntegrationPagerdutyConfig
    */
    constructor(scope: Construct, id: string, config: IntegrationPagerdutyConfig);
    private _apiToken?;
    get apiToken(): string;
    set apiToken(value: string);
    resetApiToken(): void;
    get apiTokenInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _schedules?;
    get schedules(): string[];
    set schedules(value: string[]);
    resetSchedules(): void;
    get schedulesInput(): string[] | undefined;
    private _subdomain?;
    get subdomain(): string;
    set subdomain(value: string);
    get subdomainInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
