import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IntegrationSlackChannelConfig extends cdktf.TerraformMetaArguments {
    /**
    * Slack account name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_slack_channel#account_name IntegrationSlackChannel#account_name}
    */
    readonly accountName: string;
    /**
    * Slack channel name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_slack_channel#channel_name IntegrationSlackChannel#channel_name}
    */
    readonly channelName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_slack_channel#id IntegrationSlackChannel#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * display block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_slack_channel#display IntegrationSlackChannel#display}
    */
    readonly display: IntegrationSlackChannelDisplay;
}
export interface IntegrationSlackChannelDisplay {
    /**
    * Show the main body of the alert event.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_slack_channel#message IntegrationSlackChannel#message}
    */
    readonly message?: boolean | cdktf.IResolvable;
    /**
    * Show the list of @-handles in the alert event.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_slack_channel#notified IntegrationSlackChannel#notified}
    */
    readonly notified?: boolean | cdktf.IResolvable;
    /**
    * Show the alert event's snapshot image.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_slack_channel#snapshot IntegrationSlackChannel#snapshot}
    */
    readonly snapshot?: boolean | cdktf.IResolvable;
    /**
    * Show the scopes on which the monitor alerted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_slack_channel#tags IntegrationSlackChannel#tags}
    */
    readonly tags?: boolean | cdktf.IResolvable;
}
export declare function integrationSlackChannelDisplayToTerraform(struct?: IntegrationSlackChannelDisplayOutputReference | IntegrationSlackChannelDisplay): any;
export declare class IntegrationSlackChannelDisplayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IntegrationSlackChannelDisplay | undefined;
    set internalValue(value: IntegrationSlackChannelDisplay | undefined);
    private _message?;
    get message(): boolean | cdktf.IResolvable;
    set message(value: boolean | cdktf.IResolvable);
    resetMessage(): void;
    get messageInput(): boolean | cdktf.IResolvable | undefined;
    private _notified?;
    get notified(): boolean | cdktf.IResolvable;
    set notified(value: boolean | cdktf.IResolvable);
    resetNotified(): void;
    get notifiedInput(): boolean | cdktf.IResolvable | undefined;
    private _snapshot?;
    get snapshot(): boolean | cdktf.IResolvable;
    set snapshot(value: boolean | cdktf.IResolvable);
    resetSnapshot(): void;
    get snapshotInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): boolean | cdktf.IResolvable;
    set tags(value: boolean | cdktf.IResolvable);
    resetTags(): void;
    get tagsInput(): boolean | cdktf.IResolvable | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/integration_slack_channel datadog_integration_slack_channel}
*/
export declare class IntegrationSlackChannel extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_integration_slack_channel";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/integration_slack_channel datadog_integration_slack_channel} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IntegrationSlackChannelConfig
    */
    constructor(scope: Construct, id: string, config: IntegrationSlackChannelConfig);
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    private _channelName?;
    get channelName(): string;
    set channelName(value: string);
    get channelNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _display;
    get display(): IntegrationSlackChannelDisplayOutputReference;
    putDisplay(value: IntegrationSlackChannelDisplay): void;
    get displayInput(): IntegrationSlackChannelDisplay | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
