import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LogsArchiveOrderConfig extends cdktf.TerraformMetaArguments {
    /**
    * The archive IDs list. The order of archive IDs in this attribute defines the overall archive order for logs. If `archive_ids` is empty or not specified, it will import the actual archive order, and create the resource. Otherwise, it will try to update the order.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive_order#archive_ids LogsArchiveOrder#archive_ids}
    */
    readonly archiveIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive_order#id LogsArchiveOrder#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive_order datadog_logs_archive_order}
*/
export declare class LogsArchiveOrder extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_logs_archive_order";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive_order datadog_logs_archive_order} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LogsArchiveOrderConfig = {}
    */
    constructor(scope: Construct, id: string, config?: LogsArchiveOrderConfig);
    private _archiveIds?;
    get archiveIds(): string[];
    set archiveIds(value: string[]);
    resetArchiveIds(): void;
    get archiveIdsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
