import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LogsArchiveConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#id LogsArchive#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * To store the tags in the archive, set the value `true`. If it is set to `false`, the tags will be dropped when the logs are sent to the archive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#include_tags LogsArchive#include_tags}
    */
    readonly includeTags?: boolean | cdktf.IResolvable;
    /**
    * Your archive name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#name LogsArchive#name}
    */
    readonly name: string;
    /**
    * The archive query/filter. Logs matching this query are included in the archive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#query LogsArchive#query}
    */
    readonly query: string;
    /**
    * To limit the rehydration scan size for the archive, set a value in GB.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#rehydration_max_scan_size_in_gb LogsArchive#rehydration_max_scan_size_in_gb}
    */
    readonly rehydrationMaxScanSizeInGb?: number;
    /**
    * An array of tags to add to rehydrated logs from an archive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#rehydration_tags LogsArchive#rehydration_tags}
    */
    readonly rehydrationTags?: string[];
    /**
    * azure_archive block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#azure_archive LogsArchive#azure_archive}
    */
    readonly azureArchive?: LogsArchiveAzureArchive;
    /**
    * gcs_archive block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#gcs_archive LogsArchive#gcs_archive}
    */
    readonly gcsArchive?: LogsArchiveGcsArchive;
    /**
    * s3_archive block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#s3_archive LogsArchive#s3_archive}
    */
    readonly s3Archive?: LogsArchiveS3Archive;
}
export interface LogsArchiveAzureArchive {
    /**
    * Your client id.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#client_id LogsArchive#client_id}
    */
    readonly clientId: string;
    /**
    * The container where the archive is stored.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#container LogsArchive#container}
    */
    readonly container: string;
    /**
    * The path where the archive is stored.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#path LogsArchive#path}
    */
    readonly path?: string;
    /**
    * The associated storage account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#storage_account LogsArchive#storage_account}
    */
    readonly storageAccount: string;
    /**
    * Your tenant id.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#tenant_id LogsArchive#tenant_id}
    */
    readonly tenantId: string;
}
export declare function logsArchiveAzureArchiveToTerraform(struct?: LogsArchiveAzureArchiveOutputReference | LogsArchiveAzureArchive): any;
export declare class LogsArchiveAzureArchiveOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogsArchiveAzureArchive | undefined;
    set internalValue(value: LogsArchiveAzureArchive | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _container?;
    get container(): string;
    set container(value: string);
    get containerInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _storageAccount?;
    get storageAccount(): string;
    set storageAccount(value: string);
    get storageAccountInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    get tenantIdInput(): string | undefined;
}
export interface LogsArchiveGcsArchive {
    /**
    * Name of your GCS bucket.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#bucket LogsArchive#bucket}
    */
    readonly bucket: string;
    /**
    * Your client email.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#client_email LogsArchive#client_email}
    */
    readonly clientEmail: string;
    /**
    * Path where the archive is stored.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#path LogsArchive#path}
    */
    readonly path?: string;
    /**
    * Your project id.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#project_id LogsArchive#project_id}
    */
    readonly projectId: string;
}
export declare function logsArchiveGcsArchiveToTerraform(struct?: LogsArchiveGcsArchiveOutputReference | LogsArchiveGcsArchive): any;
export declare class LogsArchiveGcsArchiveOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogsArchiveGcsArchive | undefined;
    set internalValue(value: LogsArchiveGcsArchive | undefined);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _clientEmail?;
    get clientEmail(): string;
    set clientEmail(value: string);
    get clientEmailInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
}
export interface LogsArchiveS3Archive {
    /**
    * Your AWS account id.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#account_id LogsArchive#account_id}
    */
    readonly accountId: string;
    /**
    * Name of your s3 bucket.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#bucket LogsArchive#bucket}
    */
    readonly bucket: string;
    /**
    * Path where the archive is stored.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#path LogsArchive#path}
    */
    readonly path?: string;
    /**
    * Your AWS role name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive#role_name LogsArchive#role_name}
    */
    readonly roleName: string;
}
export declare function logsArchiveS3ArchiveToTerraform(struct?: LogsArchiveS3ArchiveOutputReference | LogsArchiveS3Archive): any;
export declare class LogsArchiveS3ArchiveOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogsArchiveS3Archive | undefined;
    set internalValue(value: LogsArchiveS3Archive | undefined);
    private _accountId?;
    get accountId(): string;
    set accountId(value: string);
    get accountIdInput(): string | undefined;
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _roleName?;
    get roleName(): string;
    set roleName(value: string);
    get roleNameInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive datadog_logs_archive}
*/
export declare class LogsArchive extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_logs_archive";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/logs_archive datadog_logs_archive} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LogsArchiveConfig
    */
    constructor(scope: Construct, id: string, config: LogsArchiveConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _includeTags?;
    get includeTags(): boolean | cdktf.IResolvable;
    set includeTags(value: boolean | cdktf.IResolvable);
    resetIncludeTags(): void;
    get includeTagsInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
    private _rehydrationMaxScanSizeInGb?;
    get rehydrationMaxScanSizeInGb(): number;
    set rehydrationMaxScanSizeInGb(value: number);
    resetRehydrationMaxScanSizeInGb(): void;
    get rehydrationMaxScanSizeInGbInput(): number | undefined;
    private _rehydrationTags?;
    get rehydrationTags(): string[];
    set rehydrationTags(value: string[]);
    resetRehydrationTags(): void;
    get rehydrationTagsInput(): string[] | undefined;
    private _azureArchive;
    get azureArchive(): LogsArchiveAzureArchiveOutputReference;
    putAzureArchive(value: LogsArchiveAzureArchive): void;
    resetAzureArchive(): void;
    get azureArchiveInput(): LogsArchiveAzureArchive | undefined;
    private _gcsArchive;
    get gcsArchive(): LogsArchiveGcsArchiveOutputReference;
    putGcsArchive(value: LogsArchiveGcsArchive): void;
    resetGcsArchive(): void;
    get gcsArchiveInput(): LogsArchiveGcsArchive | undefined;
    private _s3Archive;
    get s3Archive(): LogsArchiveS3ArchiveOutputReference;
    putS3Archive(value: LogsArchiveS3Archive): void;
    resetS3Archive(): void;
    get s3ArchiveInput(): LogsArchiveS3Archive | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
