import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LogsCustomPipelineConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#id LogsCustomPipeline#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#is_enabled LogsCustomPipeline#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#name LogsCustomPipeline#name}
    */
    readonly name: string;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#filter LogsCustomPipeline#filter}
    */
    readonly filter: LogsCustomPipelineFilter[] | cdktf.IResolvable;
    /**
    * processor block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#processor LogsCustomPipeline#processor}
    */
    readonly processor?: LogsCustomPipelineProcessor[] | cdktf.IResolvable;
}
export interface LogsCustomPipelineFilter {
    /**
    * Filter criteria of the category.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#query LogsCustomPipeline#query}
    */
    readonly query: string;
}
export declare function logsCustomPipelineFilterToTerraform(struct?: LogsCustomPipelineFilter | cdktf.IResolvable): any;
export declare class LogsCustomPipelineFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LogsCustomPipelineFilter | cdktf.IResolvable | undefined;
    set internalValue(value: LogsCustomPipelineFilter | cdktf.IResolvable | undefined);
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
}
export declare class LogsCustomPipelineFilterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LogsCustomPipelineFilter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LogsCustomPipelineFilterOutputReference;
}
export interface LogsCustomPipelineProcessorArithmeticProcessor {
    /**
    * Arithmetic operation between one or more log attributes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#expression LogsCustomPipeline#expression}
    */
    readonly expression: string;
    /**
    * Boolean value to enable your pipeline.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#is_enabled LogsCustomPipeline#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * If true, it replaces all missing attributes of expression by 0, false skips the operation if an attribute is missing.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#is_replace_missing LogsCustomPipeline#is_replace_missing}
    */
    readonly isReplaceMissing?: boolean | cdktf.IResolvable;
    /**
    * Your pipeline name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#name LogsCustomPipeline#name}
    */
    readonly name?: string;
    /**
    * Name of the attribute that contains the result of the arithmetic operation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#target LogsCustomPipeline#target}
    */
    readonly target: string;
}
export declare function logsCustomPipelineProcessorArithmeticProcessorToTerraform(struct?: LogsCustomPipelineProcessorArithmeticProcessorOutputReference | LogsCustomPipelineProcessorArithmeticProcessor): any;
export declare class LogsCustomPipelineProcessorArithmeticProcessorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogsCustomPipelineProcessorArithmeticProcessor | undefined;
    set internalValue(value: LogsCustomPipelineProcessorArithmeticProcessor | undefined);
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _isReplaceMissing?;
    get isReplaceMissing(): boolean | cdktf.IResolvable;
    set isReplaceMissing(value: boolean | cdktf.IResolvable);
    resetIsReplaceMissing(): void;
    get isReplaceMissingInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _target?;
    get target(): string;
    set target(value: string);
    get targetInput(): string | undefined;
}
export interface LogsCustomPipelineProcessorAttributeRemapper {
    /**
    * If the processor is enabled or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#is_enabled LogsCustomPipeline#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Name of the processor
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#name LogsCustomPipeline#name}
    */
    readonly name?: string;
    /**
    * Override the target element if already set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#override_on_conflict LogsCustomPipeline#override_on_conflict}
    */
    readonly overrideOnConflict?: boolean | cdktf.IResolvable;
    /**
    * Remove or preserve the remapped source element.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#preserve_source LogsCustomPipeline#preserve_source}
    */
    readonly preserveSource?: boolean | cdktf.IResolvable;
    /**
    * Defines where the sources are from (log `attribute` or `tag`).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#source_type LogsCustomPipeline#source_type}
    */
    readonly sourceType: string;
    /**
    * List of source attributes or tags.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#sources LogsCustomPipeline#sources}
    */
    readonly sources: string[];
    /**
    * Final attribute or tag name to remap the sources.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#target LogsCustomPipeline#target}
    */
    readonly target: string;
    /**
    * If the `target_type` of the remapper is `attribute`, try to cast the value to a new specific type. If the cast is not possible, the original type is kept. `string`, `integer`, or `double` are the possible types. If the `target_type` is `tag`, this parameter may not be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#target_format LogsCustomPipeline#target_format}
    */
    readonly targetFormat?: string;
    /**
    * Defines if the target is a log `attribute` or `tag`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#target_type LogsCustomPipeline#target_type}
    */
    readonly targetType: string;
}
export declare function logsCustomPipelineProcessorAttributeRemapperToTerraform(struct?: LogsCustomPipelineProcessorAttributeRemapperOutputReference | LogsCustomPipelineProcessorAttributeRemapper): any;
export declare class LogsCustomPipelineProcessorAttributeRemapperOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogsCustomPipelineProcessorAttributeRemapper | undefined;
    set internalValue(value: LogsCustomPipelineProcessorAttributeRemapper | undefined);
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _overrideOnConflict?;
    get overrideOnConflict(): boolean | cdktf.IResolvable;
    set overrideOnConflict(value: boolean | cdktf.IResolvable);
    resetOverrideOnConflict(): void;
    get overrideOnConflictInput(): boolean | cdktf.IResolvable | undefined;
    private _preserveSource?;
    get preserveSource(): boolean | cdktf.IResolvable;
    set preserveSource(value: boolean | cdktf.IResolvable);
    resetPreserveSource(): void;
    get preserveSourceInput(): boolean | cdktf.IResolvable | undefined;
    private _sourceType?;
    get sourceType(): string;
    set sourceType(value: string);
    get sourceTypeInput(): string | undefined;
    private _sources?;
    get sources(): string[];
    set sources(value: string[]);
    get sourcesInput(): string[] | undefined;
    private _target?;
    get target(): string;
    set target(value: string);
    get targetInput(): string | undefined;
    private _targetFormat?;
    get targetFormat(): string;
    set targetFormat(value: string);
    resetTargetFormat(): void;
    get targetFormatInput(): string | undefined;
    private _targetType?;
    get targetType(): string;
    set targetType(value: string);
    get targetTypeInput(): string | undefined;
}
export interface LogsCustomPipelineProcessorCategoryProcessorCategoryFilter {
    /**
    * Filter criteria of the category.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#query LogsCustomPipeline#query}
    */
    readonly query: string;
}
export declare function logsCustomPipelineProcessorCategoryProcessorCategoryFilterToTerraform(struct?: LogsCustomPipelineProcessorCategoryProcessorCategoryFilterOutputReference | LogsCustomPipelineProcessorCategoryProcessorCategoryFilter): any;
export declare class LogsCustomPipelineProcessorCategoryProcessorCategoryFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogsCustomPipelineProcessorCategoryProcessorCategoryFilter | undefined;
    set internalValue(value: LogsCustomPipelineProcessorCategoryProcessorCategoryFilter | undefined);
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
}
export interface LogsCustomPipelineProcessorCategoryProcessorCategory {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#name LogsCustomPipeline#name}
    */
    readonly name: string;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#filter LogsCustomPipeline#filter}
    */
    readonly filter: LogsCustomPipelineProcessorCategoryProcessorCategoryFilter;
}
export declare function logsCustomPipelineProcessorCategoryProcessorCategoryToTerraform(struct?: LogsCustomPipelineProcessorCategoryProcessorCategory | cdktf.IResolvable): any;
export declare class LogsCustomPipelineProcessorCategoryProcessorCategoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LogsCustomPipelineProcessorCategoryProcessorCategory | cdktf.IResolvable | undefined;
    set internalValue(value: LogsCustomPipelineProcessorCategoryProcessorCategory | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _filter;
    get filter(): LogsCustomPipelineProcessorCategoryProcessorCategoryFilterOutputReference;
    putFilter(value: LogsCustomPipelineProcessorCategoryProcessorCategoryFilter): void;
    get filterInput(): LogsCustomPipelineProcessorCategoryProcessorCategoryFilter | undefined;
}
export declare class LogsCustomPipelineProcessorCategoryProcessorCategoryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LogsCustomPipelineProcessorCategoryProcessorCategory[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LogsCustomPipelineProcessorCategoryProcessorCategoryOutputReference;
}
export interface LogsCustomPipelineProcessorCategoryProcessor {
    /**
    * If the processor is enabled or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#is_enabled LogsCustomPipeline#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Name of the category
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#name LogsCustomPipeline#name}
    */
    readonly name?: string;
    /**
    * Name of the target attribute whose value is defined by the matching category.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#target LogsCustomPipeline#target}
    */
    readonly target: string;
    /**
    * category block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#category LogsCustomPipeline#category}
    */
    readonly category: LogsCustomPipelineProcessorCategoryProcessorCategory[] | cdktf.IResolvable;
}
export declare function logsCustomPipelineProcessorCategoryProcessorToTerraform(struct?: LogsCustomPipelineProcessorCategoryProcessorOutputReference | LogsCustomPipelineProcessorCategoryProcessor): any;
export declare class LogsCustomPipelineProcessorCategoryProcessorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogsCustomPipelineProcessorCategoryProcessor | undefined;
    set internalValue(value: LogsCustomPipelineProcessorCategoryProcessor | undefined);
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _target?;
    get target(): string;
    set target(value: string);
    get targetInput(): string | undefined;
    private _category;
    get category(): LogsCustomPipelineProcessorCategoryProcessorCategoryList;
    putCategory(value: LogsCustomPipelineProcessorCategoryProcessorCategory[] | cdktf.IResolvable): void;
    get categoryInput(): cdktf.IResolvable | LogsCustomPipelineProcessorCategoryProcessorCategory[] | undefined;
}
export interface LogsCustomPipelineProcessorDateRemapper {
    /**
    * If the processor is enabled or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#is_enabled LogsCustomPipeline#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Name of the processor.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#name LogsCustomPipeline#name}
    */
    readonly name?: string;
    /**
    * List of source attributes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#sources LogsCustomPipeline#sources}
    */
    readonly sources: string[];
}
export declare function logsCustomPipelineProcessorDateRemapperToTerraform(struct?: LogsCustomPipelineProcessorDateRemapperOutputReference | LogsCustomPipelineProcessorDateRemapper): any;
export declare class LogsCustomPipelineProcessorDateRemapperOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogsCustomPipelineProcessorDateRemapper | undefined;
    set internalValue(value: LogsCustomPipelineProcessorDateRemapper | undefined);
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _sources?;
    get sources(): string[];
    set sources(value: string[]);
    get sourcesInput(): string[] | undefined;
}
export interface LogsCustomPipelineProcessorGeoIpParser {
    /**
    * If the processor is enabled or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#is_enabled LogsCustomPipeline#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Name of the processor.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#name LogsCustomPipeline#name}
    */
    readonly name?: string;
    /**
    * List of source attributes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#sources LogsCustomPipeline#sources}
    */
    readonly sources: string[];
    /**
    * Name of the parent attribute that contains all the extracted details from the sources.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#target LogsCustomPipeline#target}
    */
    readonly target: string;
}
export declare function logsCustomPipelineProcessorGeoIpParserToTerraform(struct?: LogsCustomPipelineProcessorGeoIpParserOutputReference | LogsCustomPipelineProcessorGeoIpParser): any;
export declare class LogsCustomPipelineProcessorGeoIpParserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogsCustomPipelineProcessorGeoIpParser | undefined;
    set internalValue(value: LogsCustomPipelineProcessorGeoIpParser | undefined);
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _sources?;
    get sources(): string[];
    set sources(value: string[]);
    get sourcesInput(): string[] | undefined;
    private _target?;
    get target(): string;
    set target(value: string);
    get targetInput(): string | undefined;
}
export interface LogsCustomPipelineProcessorGrokParserGrok {
    /**
    * Match rules for your grok parser.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#match_rules LogsCustomPipeline#match_rules}
    */
    readonly matchRules: string;
    /**
    * Support rules for your grok parser.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#support_rules LogsCustomPipeline#support_rules}
    */
    readonly supportRules: string;
}
export declare function logsCustomPipelineProcessorGrokParserGrokToTerraform(struct?: LogsCustomPipelineProcessorGrokParserGrokOutputReference | LogsCustomPipelineProcessorGrokParserGrok): any;
export declare class LogsCustomPipelineProcessorGrokParserGrokOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogsCustomPipelineProcessorGrokParserGrok | undefined;
    set internalValue(value: LogsCustomPipelineProcessorGrokParserGrok | undefined);
    private _matchRules?;
    get matchRules(): string;
    set matchRules(value: string);
    get matchRulesInput(): string | undefined;
    private _supportRules?;
    get supportRules(): string;
    set supportRules(value: string);
    get supportRulesInput(): string | undefined;
}
export interface LogsCustomPipelineProcessorGrokParser {
    /**
    * If the processor is enabled or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#is_enabled LogsCustomPipeline#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Name of the processor
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#name LogsCustomPipeline#name}
    */
    readonly name?: string;
    /**
    * List of sample logs for this parser. It can save up to 5 samples. Each sample takes up to 5000 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#samples LogsCustomPipeline#samples}
    */
    readonly samples?: string[];
    /**
    * Name of the log attribute to parse.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#source LogsCustomPipeline#source}
    */
    readonly source: string;
    /**
    * grok block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#grok LogsCustomPipeline#grok}
    */
    readonly grok: LogsCustomPipelineProcessorGrokParserGrok;
}
export declare function logsCustomPipelineProcessorGrokParserToTerraform(struct?: LogsCustomPipelineProcessorGrokParserOutputReference | LogsCustomPipelineProcessorGrokParser): any;
export declare class LogsCustomPipelineProcessorGrokParserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogsCustomPipelineProcessorGrokParser | undefined;
    set internalValue(value: LogsCustomPipelineProcessorGrokParser | undefined);
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _samples?;
    get samples(): string[];
    set samples(value: string[]);
    resetSamples(): void;
    get samplesInput(): string[] | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    get sourceInput(): string | undefined;
    private _grok;
    get grok(): LogsCustomPipelineProcessorGrokParserGrokOutputReference;
    putGrok(value: LogsCustomPipelineProcessorGrokParserGrok): void;
    get grokInput(): LogsCustomPipelineProcessorGrokParserGrok | undefined;
}
export interface LogsCustomPipelineProcessorLookupProcessor {
    /**
    * Default lookup value to use if there is no entry in the lookup table for the value of the source attribute.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#default_lookup LogsCustomPipeline#default_lookup}
    */
    readonly defaultLookup?: string;
    /**
    * If the processor is enabled or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#is_enabled LogsCustomPipeline#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * List of entries of the lookup table using `key,value` format.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#lookup_table LogsCustomPipeline#lookup_table}
    */
    readonly lookupTable: string[];
    /**
    * Name of the processor
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#name LogsCustomPipeline#name}
    */
    readonly name?: string;
    /**
    * Name of the source attribute used to do the lookup.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#source LogsCustomPipeline#source}
    */
    readonly source: string;
    /**
    * Name of the attribute that contains the result of the lookup.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#target LogsCustomPipeline#target}
    */
    readonly target: string;
}
export declare function logsCustomPipelineProcessorLookupProcessorToTerraform(struct?: LogsCustomPipelineProcessorLookupProcessorOutputReference | LogsCustomPipelineProcessorLookupProcessor): any;
export declare class LogsCustomPipelineProcessorLookupProcessorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogsCustomPipelineProcessorLookupProcessor | undefined;
    set internalValue(value: LogsCustomPipelineProcessorLookupProcessor | undefined);
    private _defaultLookup?;
    get defaultLookup(): string;
    set defaultLookup(value: string);
    resetDefaultLookup(): void;
    get defaultLookupInput(): string | undefined;
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _lookupTable?;
    get lookupTable(): string[];
    set lookupTable(value: string[]);
    get lookupTableInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    get sourceInput(): string | undefined;
    private _target?;
    get target(): string;
    set target(value: string);
    get targetInput(): string | undefined;
}
export interface LogsCustomPipelineProcessorMessageRemapper {
    /**
    * If the processor is enabled or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#is_enabled LogsCustomPipeline#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Name of the processor.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#name LogsCustomPipeline#name}
    */
    readonly name?: string;
    /**
    * List of source attributes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#sources LogsCustomPipeline#sources}
    */
    readonly sources: string[];
}
export declare function logsCustomPipelineProcessorMessageRemapperToTerraform(struct?: LogsCustomPipelineProcessorMessageRemapperOutputReference | LogsCustomPipelineProcessorMessageRemapper): any;
export declare class LogsCustomPipelineProcessorMessageRemapperOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogsCustomPipelineProcessorMessageRemapper | undefined;
    set internalValue(value: LogsCustomPipelineProcessorMessageRemapper | undefined);
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _sources?;
    get sources(): string[];
    set sources(value: string[]);
    get sourcesInput(): string[] | undefined;
}
export interface LogsCustomPipelineProcessorPipelineFilter {
    /**
    * Filter criteria of the category.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#query LogsCustomPipeline#query}
    */
    readonly query: string;
}
export declare function logsCustomPipelineProcessorPipelineFilterToTerraform(struct?: LogsCustomPipelineProcessorPipelineFilter | cdktf.IResolvable): any;
export declare class LogsCustomPipelineProcessorPipelineFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LogsCustomPipelineProcessorPipelineFilter | cdktf.IResolvable | undefined;
    set internalValue(value: LogsCustomPipelineProcessorPipelineFilter | cdktf.IResolvable | undefined);
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
}
export declare class LogsCustomPipelineProcessorPipelineFilterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LogsCustomPipelineProcessorPipelineFilter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LogsCustomPipelineProcessorPipelineFilterOutputReference;
}
export interface LogsCustomPipelineProcessorPipelineProcessorArithmeticProcessor {
    /**
    * Arithmetic operation between one or more log attributes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#expression LogsCustomPipeline#expression}
    */
    readonly expression: string;
    /**
    * Boolean value to enable your pipeline.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#is_enabled LogsCustomPipeline#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * If true, it replaces all missing attributes of expression by 0, false skips the operation if an attribute is missing.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#is_replace_missing LogsCustomPipeline#is_replace_missing}
    */
    readonly isReplaceMissing?: boolean | cdktf.IResolvable;
    /**
    * Your pipeline name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#name LogsCustomPipeline#name}
    */
    readonly name?: string;
    /**
    * Name of the attribute that contains the result of the arithmetic operation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#target LogsCustomPipeline#target}
    */
    readonly target: string;
}
export declare function logsCustomPipelineProcessorPipelineProcessorArithmeticProcessorToTerraform(struct?: LogsCustomPipelineProcessorPipelineProcessorArithmeticProcessorOutputReference | LogsCustomPipelineProcessorPipelineProcessorArithmeticProcessor): any;
export declare class LogsCustomPipelineProcessorPipelineProcessorArithmeticProcessorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogsCustomPipelineProcessorPipelineProcessorArithmeticProcessor | undefined;
    set internalValue(value: LogsCustomPipelineProcessorPipelineProcessorArithmeticProcessor | undefined);
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _isReplaceMissing?;
    get isReplaceMissing(): boolean | cdktf.IResolvable;
    set isReplaceMissing(value: boolean | cdktf.IResolvable);
    resetIsReplaceMissing(): void;
    get isReplaceMissingInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _target?;
    get target(): string;
    set target(value: string);
    get targetInput(): string | undefined;
}
export interface LogsCustomPipelineProcessorPipelineProcessorAttributeRemapper {
    /**
    * If the processor is enabled or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#is_enabled LogsCustomPipeline#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Name of the processor
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#name LogsCustomPipeline#name}
    */
    readonly name?: string;
    /**
    * Override the target element if already set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#override_on_conflict LogsCustomPipeline#override_on_conflict}
    */
    readonly overrideOnConflict?: boolean | cdktf.IResolvable;
    /**
    * Remove or preserve the remapped source element.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#preserve_source LogsCustomPipeline#preserve_source}
    */
    readonly preserveSource?: boolean | cdktf.IResolvable;
    /**
    * Defines where the sources are from (log `attribute` or `tag`).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#source_type LogsCustomPipeline#source_type}
    */
    readonly sourceType: string;
    /**
    * List of source attributes or tags.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#sources LogsCustomPipeline#sources}
    */
    readonly sources: string[];
    /**
    * Final attribute or tag name to remap the sources.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#target LogsCustomPipeline#target}
    */
    readonly target: string;
    /**
    * If the `target_type` of the remapper is `attribute`, try to cast the value to a new specific type. If the cast is not possible, the original type is kept. `string`, `integer`, or `double` are the possible types. If the `target_type` is `tag`, this parameter may not be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#target_format LogsCustomPipeline#target_format}
    */
    readonly targetFormat?: string;
    /**
    * Defines if the target is a log `attribute` or `tag`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#target_type LogsCustomPipeline#target_type}
    */
    readonly targetType: string;
}
export declare function logsCustomPipelineProcessorPipelineProcessorAttributeRemapperToTerraform(struct?: LogsCustomPipelineProcessorPipelineProcessorAttributeRemapperOutputReference | LogsCustomPipelineProcessorPipelineProcessorAttributeRemapper): any;
export declare class LogsCustomPipelineProcessorPipelineProcessorAttributeRemapperOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogsCustomPipelineProcessorPipelineProcessorAttributeRemapper | undefined;
    set internalValue(value: LogsCustomPipelineProcessorPipelineProcessorAttributeRemapper | undefined);
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _overrideOnConflict?;
    get overrideOnConflict(): boolean | cdktf.IResolvable;
    set overrideOnConflict(value: boolean | cdktf.IResolvable);
    resetOverrideOnConflict(): void;
    get overrideOnConflictInput(): boolean | cdktf.IResolvable | undefined;
    private _preserveSource?;
    get preserveSource(): boolean | cdktf.IResolvable;
    set preserveSource(value: boolean | cdktf.IResolvable);
    resetPreserveSource(): void;
    get preserveSourceInput(): boolean | cdktf.IResolvable | undefined;
    private _sourceType?;
    get sourceType(): string;
    set sourceType(value: string);
    get sourceTypeInput(): string | undefined;
    private _sources?;
    get sources(): string[];
    set sources(value: string[]);
    get sourcesInput(): string[] | undefined;
    private _target?;
    get target(): string;
    set target(value: string);
    get targetInput(): string | undefined;
    private _targetFormat?;
    get targetFormat(): string;
    set targetFormat(value: string);
    resetTargetFormat(): void;
    get targetFormatInput(): string | undefined;
    private _targetType?;
    get targetType(): string;
    set targetType(value: string);
    get targetTypeInput(): string | undefined;
}
export interface LogsCustomPipelineProcessorPipelineProcessorCategoryProcessorCategoryFilter {
    /**
    * Filter criteria of the category.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#query LogsCustomPipeline#query}
    */
    readonly query: string;
}
export declare function logsCustomPipelineProcessorPipelineProcessorCategoryProcessorCategoryFilterToTerraform(struct?: LogsCustomPipelineProcessorPipelineProcessorCategoryProcessorCategoryFilterOutputReference | LogsCustomPipelineProcessorPipelineProcessorCategoryProcessorCategoryFilter): any;
export declare class LogsCustomPipelineProcessorPipelineProcessorCategoryProcessorCategoryFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogsCustomPipelineProcessorPipelineProcessorCategoryProcessorCategoryFilter | undefined;
    set internalValue(value: LogsCustomPipelineProcessorPipelineProcessorCategoryProcessorCategoryFilter | undefined);
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
}
export interface LogsCustomPipelineProcessorPipelineProcessorCategoryProcessorCategory {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#name LogsCustomPipeline#name}
    */
    readonly name: string;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#filter LogsCustomPipeline#filter}
    */
    readonly filter: LogsCustomPipelineProcessorPipelineProcessorCategoryProcessorCategoryFilter;
}
export declare function logsCustomPipelineProcessorPipelineProcessorCategoryProcessorCategoryToTerraform(struct?: LogsCustomPipelineProcessorPipelineProcessorCategoryProcessorCategory | cdktf.IResolvable): any;
export declare class LogsCustomPipelineProcessorPipelineProcessorCategoryProcessorCategoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LogsCustomPipelineProcessorPipelineProcessorCategoryProcessorCategory | cdktf.IResolvable | undefined;
    set internalValue(value: LogsCustomPipelineProcessorPipelineProcessorCategoryProcessorCategory | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _filter;
    get filter(): LogsCustomPipelineProcessorPipelineProcessorCategoryProcessorCategoryFilterOutputReference;
    putFilter(value: LogsCustomPipelineProcessorPipelineProcessorCategoryProcessorCategoryFilter): void;
    get filterInput(): LogsCustomPipelineProcessorPipelineProcessorCategoryProcessorCategoryFilter | undefined;
}
export declare class LogsCustomPipelineProcessorPipelineProcessorCategoryProcessorCategoryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LogsCustomPipelineProcessorPipelineProcessorCategoryProcessorCategory[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LogsCustomPipelineProcessorPipelineProcessorCategoryProcessorCategoryOutputReference;
}
export interface LogsCustomPipelineProcessorPipelineProcessorCategoryProcessor {
    /**
    * If the processor is enabled or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#is_enabled LogsCustomPipeline#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Name of the category
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#name LogsCustomPipeline#name}
    */
    readonly name?: string;
    /**
    * Name of the target attribute whose value is defined by the matching category.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#target LogsCustomPipeline#target}
    */
    readonly target: string;
    /**
    * category block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#category LogsCustomPipeline#category}
    */
    readonly category: LogsCustomPipelineProcessorPipelineProcessorCategoryProcessorCategory[] | cdktf.IResolvable;
}
export declare function logsCustomPipelineProcessorPipelineProcessorCategoryProcessorToTerraform(struct?: LogsCustomPipelineProcessorPipelineProcessorCategoryProcessorOutputReference | LogsCustomPipelineProcessorPipelineProcessorCategoryProcessor): any;
export declare class LogsCustomPipelineProcessorPipelineProcessorCategoryProcessorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogsCustomPipelineProcessorPipelineProcessorCategoryProcessor | undefined;
    set internalValue(value: LogsCustomPipelineProcessorPipelineProcessorCategoryProcessor | undefined);
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _target?;
    get target(): string;
    set target(value: string);
    get targetInput(): string | undefined;
    private _category;
    get category(): LogsCustomPipelineProcessorPipelineProcessorCategoryProcessorCategoryList;
    putCategory(value: LogsCustomPipelineProcessorPipelineProcessorCategoryProcessorCategory[] | cdktf.IResolvable): void;
    get categoryInput(): cdktf.IResolvable | LogsCustomPipelineProcessorPipelineProcessorCategoryProcessorCategory[] | undefined;
}
export interface LogsCustomPipelineProcessorPipelineProcessorDateRemapper {
    /**
    * If the processor is enabled or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#is_enabled LogsCustomPipeline#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Name of the processor.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#name LogsCustomPipeline#name}
    */
    readonly name?: string;
    /**
    * List of source attributes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#sources LogsCustomPipeline#sources}
    */
    readonly sources: string[];
}
export declare function logsCustomPipelineProcessorPipelineProcessorDateRemapperToTerraform(struct?: LogsCustomPipelineProcessorPipelineProcessorDateRemapperOutputReference | LogsCustomPipelineProcessorPipelineProcessorDateRemapper): any;
export declare class LogsCustomPipelineProcessorPipelineProcessorDateRemapperOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogsCustomPipelineProcessorPipelineProcessorDateRemapper | undefined;
    set internalValue(value: LogsCustomPipelineProcessorPipelineProcessorDateRemapper | undefined);
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _sources?;
    get sources(): string[];
    set sources(value: string[]);
    get sourcesInput(): string[] | undefined;
}
export interface LogsCustomPipelineProcessorPipelineProcessorGeoIpParser {
    /**
    * If the processor is enabled or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#is_enabled LogsCustomPipeline#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Name of the processor.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#name LogsCustomPipeline#name}
    */
    readonly name?: string;
    /**
    * List of source attributes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#sources LogsCustomPipeline#sources}
    */
    readonly sources: string[];
    /**
    * Name of the parent attribute that contains all the extracted details from the sources.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#target LogsCustomPipeline#target}
    */
    readonly target: string;
}
export declare function logsCustomPipelineProcessorPipelineProcessorGeoIpParserToTerraform(struct?: LogsCustomPipelineProcessorPipelineProcessorGeoIpParserOutputReference | LogsCustomPipelineProcessorPipelineProcessorGeoIpParser): any;
export declare class LogsCustomPipelineProcessorPipelineProcessorGeoIpParserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogsCustomPipelineProcessorPipelineProcessorGeoIpParser | undefined;
    set internalValue(value: LogsCustomPipelineProcessorPipelineProcessorGeoIpParser | undefined);
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _sources?;
    get sources(): string[];
    set sources(value: string[]);
    get sourcesInput(): string[] | undefined;
    private _target?;
    get target(): string;
    set target(value: string);
    get targetInput(): string | undefined;
}
export interface LogsCustomPipelineProcessorPipelineProcessorGrokParserGrok {
    /**
    * Match rules for your grok parser.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#match_rules LogsCustomPipeline#match_rules}
    */
    readonly matchRules: string;
    /**
    * Support rules for your grok parser.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#support_rules LogsCustomPipeline#support_rules}
    */
    readonly supportRules: string;
}
export declare function logsCustomPipelineProcessorPipelineProcessorGrokParserGrokToTerraform(struct?: LogsCustomPipelineProcessorPipelineProcessorGrokParserGrokOutputReference | LogsCustomPipelineProcessorPipelineProcessorGrokParserGrok): any;
export declare class LogsCustomPipelineProcessorPipelineProcessorGrokParserGrokOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogsCustomPipelineProcessorPipelineProcessorGrokParserGrok | undefined;
    set internalValue(value: LogsCustomPipelineProcessorPipelineProcessorGrokParserGrok | undefined);
    private _matchRules?;
    get matchRules(): string;
    set matchRules(value: string);
    get matchRulesInput(): string | undefined;
    private _supportRules?;
    get supportRules(): string;
    set supportRules(value: string);
    get supportRulesInput(): string | undefined;
}
export interface LogsCustomPipelineProcessorPipelineProcessorGrokParser {
    /**
    * If the processor is enabled or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#is_enabled LogsCustomPipeline#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Name of the processor
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#name LogsCustomPipeline#name}
    */
    readonly name?: string;
    /**
    * List of sample logs for this parser. It can save up to 5 samples. Each sample takes up to 5000 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#samples LogsCustomPipeline#samples}
    */
    readonly samples?: string[];
    /**
    * Name of the log attribute to parse.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#source LogsCustomPipeline#source}
    */
    readonly source: string;
    /**
    * grok block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#grok LogsCustomPipeline#grok}
    */
    readonly grok: LogsCustomPipelineProcessorPipelineProcessorGrokParserGrok;
}
export declare function logsCustomPipelineProcessorPipelineProcessorGrokParserToTerraform(struct?: LogsCustomPipelineProcessorPipelineProcessorGrokParserOutputReference | LogsCustomPipelineProcessorPipelineProcessorGrokParser): any;
export declare class LogsCustomPipelineProcessorPipelineProcessorGrokParserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogsCustomPipelineProcessorPipelineProcessorGrokParser | undefined;
    set internalValue(value: LogsCustomPipelineProcessorPipelineProcessorGrokParser | undefined);
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _samples?;
    get samples(): string[];
    set samples(value: string[]);
    resetSamples(): void;
    get samplesInput(): string[] | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    get sourceInput(): string | undefined;
    private _grok;
    get grok(): LogsCustomPipelineProcessorPipelineProcessorGrokParserGrokOutputReference;
    putGrok(value: LogsCustomPipelineProcessorPipelineProcessorGrokParserGrok): void;
    get grokInput(): LogsCustomPipelineProcessorPipelineProcessorGrokParserGrok | undefined;
}
export interface LogsCustomPipelineProcessorPipelineProcessorLookupProcessor {
    /**
    * Default lookup value to use if there is no entry in the lookup table for the value of the source attribute.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#default_lookup LogsCustomPipeline#default_lookup}
    */
    readonly defaultLookup?: string;
    /**
    * If the processor is enabled or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#is_enabled LogsCustomPipeline#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * List of entries of the lookup table using `key,value` format.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#lookup_table LogsCustomPipeline#lookup_table}
    */
    readonly lookupTable: string[];
    /**
    * Name of the processor
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#name LogsCustomPipeline#name}
    */
    readonly name?: string;
    /**
    * Name of the source attribute used to do the lookup.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#source LogsCustomPipeline#source}
    */
    readonly source: string;
    /**
    * Name of the attribute that contains the result of the lookup.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#target LogsCustomPipeline#target}
    */
    readonly target: string;
}
export declare function logsCustomPipelineProcessorPipelineProcessorLookupProcessorToTerraform(struct?: LogsCustomPipelineProcessorPipelineProcessorLookupProcessorOutputReference | LogsCustomPipelineProcessorPipelineProcessorLookupProcessor): any;
export declare class LogsCustomPipelineProcessorPipelineProcessorLookupProcessorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogsCustomPipelineProcessorPipelineProcessorLookupProcessor | undefined;
    set internalValue(value: LogsCustomPipelineProcessorPipelineProcessorLookupProcessor | undefined);
    private _defaultLookup?;
    get defaultLookup(): string;
    set defaultLookup(value: string);
    resetDefaultLookup(): void;
    get defaultLookupInput(): string | undefined;
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _lookupTable?;
    get lookupTable(): string[];
    set lookupTable(value: string[]);
    get lookupTableInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    get sourceInput(): string | undefined;
    private _target?;
    get target(): string;
    set target(value: string);
    get targetInput(): string | undefined;
}
export interface LogsCustomPipelineProcessorPipelineProcessorMessageRemapper {
    /**
    * If the processor is enabled or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#is_enabled LogsCustomPipeline#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Name of the processor.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#name LogsCustomPipeline#name}
    */
    readonly name?: string;
    /**
    * List of source attributes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#sources LogsCustomPipeline#sources}
    */
    readonly sources: string[];
}
export declare function logsCustomPipelineProcessorPipelineProcessorMessageRemapperToTerraform(struct?: LogsCustomPipelineProcessorPipelineProcessorMessageRemapperOutputReference | LogsCustomPipelineProcessorPipelineProcessorMessageRemapper): any;
export declare class LogsCustomPipelineProcessorPipelineProcessorMessageRemapperOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogsCustomPipelineProcessorPipelineProcessorMessageRemapper | undefined;
    set internalValue(value: LogsCustomPipelineProcessorPipelineProcessorMessageRemapper | undefined);
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _sources?;
    get sources(): string[];
    set sources(value: string[]);
    get sourcesInput(): string[] | undefined;
}
export interface LogsCustomPipelineProcessorPipelineProcessorServiceRemapper {
    /**
    * If the processor is enabled or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#is_enabled LogsCustomPipeline#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Name of the processor.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#name LogsCustomPipeline#name}
    */
    readonly name?: string;
    /**
    * List of source attributes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#sources LogsCustomPipeline#sources}
    */
    readonly sources: string[];
}
export declare function logsCustomPipelineProcessorPipelineProcessorServiceRemapperToTerraform(struct?: LogsCustomPipelineProcessorPipelineProcessorServiceRemapperOutputReference | LogsCustomPipelineProcessorPipelineProcessorServiceRemapper): any;
export declare class LogsCustomPipelineProcessorPipelineProcessorServiceRemapperOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogsCustomPipelineProcessorPipelineProcessorServiceRemapper | undefined;
    set internalValue(value: LogsCustomPipelineProcessorPipelineProcessorServiceRemapper | undefined);
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _sources?;
    get sources(): string[];
    set sources(value: string[]);
    get sourcesInput(): string[] | undefined;
}
export interface LogsCustomPipelineProcessorPipelineProcessorStatusRemapper {
    /**
    * If the processor is enabled or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#is_enabled LogsCustomPipeline#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Name of the processor.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#name LogsCustomPipeline#name}
    */
    readonly name?: string;
    /**
    * List of source attributes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#sources LogsCustomPipeline#sources}
    */
    readonly sources: string[];
}
export declare function logsCustomPipelineProcessorPipelineProcessorStatusRemapperToTerraform(struct?: LogsCustomPipelineProcessorPipelineProcessorStatusRemapperOutputReference | LogsCustomPipelineProcessorPipelineProcessorStatusRemapper): any;
export declare class LogsCustomPipelineProcessorPipelineProcessorStatusRemapperOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogsCustomPipelineProcessorPipelineProcessorStatusRemapper | undefined;
    set internalValue(value: LogsCustomPipelineProcessorPipelineProcessorStatusRemapper | undefined);
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _sources?;
    get sources(): string[];
    set sources(value: string[]);
    get sourcesInput(): string[] | undefined;
}
export interface LogsCustomPipelineProcessorPipelineProcessorStringBuilderProcessor {
    /**
    * If the processor is enabled or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#is_enabled LogsCustomPipeline#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * If it replaces all missing attributes of template by an empty string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#is_replace_missing LogsCustomPipeline#is_replace_missing}
    */
    readonly isReplaceMissing?: boolean | cdktf.IResolvable;
    /**
    * The name of the processor.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#name LogsCustomPipeline#name}
    */
    readonly name?: string;
    /**
    * The name of the attribute that contains the result of the template.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#target LogsCustomPipeline#target}
    */
    readonly target: string;
    /**
    * The formula with one or more attributes and raw text.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#template LogsCustomPipeline#template}
    */
    readonly template: string;
}
export declare function logsCustomPipelineProcessorPipelineProcessorStringBuilderProcessorToTerraform(struct?: LogsCustomPipelineProcessorPipelineProcessorStringBuilderProcessorOutputReference | LogsCustomPipelineProcessorPipelineProcessorStringBuilderProcessor): any;
export declare class LogsCustomPipelineProcessorPipelineProcessorStringBuilderProcessorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogsCustomPipelineProcessorPipelineProcessorStringBuilderProcessor | undefined;
    set internalValue(value: LogsCustomPipelineProcessorPipelineProcessorStringBuilderProcessor | undefined);
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _isReplaceMissing?;
    get isReplaceMissing(): boolean | cdktf.IResolvable;
    set isReplaceMissing(value: boolean | cdktf.IResolvable);
    resetIsReplaceMissing(): void;
    get isReplaceMissingInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _target?;
    get target(): string;
    set target(value: string);
    get targetInput(): string | undefined;
    private _template?;
    get template(): string;
    set template(value: string);
    get templateInput(): string | undefined;
}
export interface LogsCustomPipelineProcessorPipelineProcessorTraceIdRemapper {
    /**
    * If the processor is enabled or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#is_enabled LogsCustomPipeline#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Name of the processor.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#name LogsCustomPipeline#name}
    */
    readonly name?: string;
    /**
    * List of source attributes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#sources LogsCustomPipeline#sources}
    */
    readonly sources: string[];
}
export declare function logsCustomPipelineProcessorPipelineProcessorTraceIdRemapperToTerraform(struct?: LogsCustomPipelineProcessorPipelineProcessorTraceIdRemapperOutputReference | LogsCustomPipelineProcessorPipelineProcessorTraceIdRemapper): any;
export declare class LogsCustomPipelineProcessorPipelineProcessorTraceIdRemapperOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogsCustomPipelineProcessorPipelineProcessorTraceIdRemapper | undefined;
    set internalValue(value: LogsCustomPipelineProcessorPipelineProcessorTraceIdRemapper | undefined);
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _sources?;
    get sources(): string[];
    set sources(value: string[]);
    get sourcesInput(): string[] | undefined;
}
export interface LogsCustomPipelineProcessorPipelineProcessorUrlParser {
    /**
    * If the processor is enabled or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#is_enabled LogsCustomPipeline#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Name of the processor
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#name LogsCustomPipeline#name}
    */
    readonly name?: string;
    /**
    * Normalize the ending slashes or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#normalize_ending_slashes LogsCustomPipeline#normalize_ending_slashes}
    */
    readonly normalizeEndingSlashes?: boolean | cdktf.IResolvable;
    /**
    * List of source attributes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#sources LogsCustomPipeline#sources}
    */
    readonly sources: string[];
    /**
    * Name of the parent attribute that contains all the extracted details from the sources.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#target LogsCustomPipeline#target}
    */
    readonly target: string;
}
export declare function logsCustomPipelineProcessorPipelineProcessorUrlParserToTerraform(struct?: LogsCustomPipelineProcessorPipelineProcessorUrlParserOutputReference | LogsCustomPipelineProcessorPipelineProcessorUrlParser): any;
export declare class LogsCustomPipelineProcessorPipelineProcessorUrlParserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogsCustomPipelineProcessorPipelineProcessorUrlParser | undefined;
    set internalValue(value: LogsCustomPipelineProcessorPipelineProcessorUrlParser | undefined);
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _normalizeEndingSlashes?;
    get normalizeEndingSlashes(): boolean | cdktf.IResolvable;
    set normalizeEndingSlashes(value: boolean | cdktf.IResolvable);
    resetNormalizeEndingSlashes(): void;
    get normalizeEndingSlashesInput(): boolean | cdktf.IResolvable | undefined;
    private _sources?;
    get sources(): string[];
    set sources(value: string[]);
    get sourcesInput(): string[] | undefined;
    private _target?;
    get target(): string;
    set target(value: string);
    get targetInput(): string | undefined;
}
export interface LogsCustomPipelineProcessorPipelineProcessorUserAgentParser {
    /**
    * If the processor is enabled or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#is_enabled LogsCustomPipeline#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * If the source attribute is URL encoded or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#is_encoded LogsCustomPipeline#is_encoded}
    */
    readonly isEncoded?: boolean | cdktf.IResolvable;
    /**
    * Name of the processor
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#name LogsCustomPipeline#name}
    */
    readonly name?: string;
    /**
    * List of source attributes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#sources LogsCustomPipeline#sources}
    */
    readonly sources: string[];
    /**
    * Name of the parent attribute that contains all the extracted details from the sources.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#target LogsCustomPipeline#target}
    */
    readonly target: string;
}
export declare function logsCustomPipelineProcessorPipelineProcessorUserAgentParserToTerraform(struct?: LogsCustomPipelineProcessorPipelineProcessorUserAgentParserOutputReference | LogsCustomPipelineProcessorPipelineProcessorUserAgentParser): any;
export declare class LogsCustomPipelineProcessorPipelineProcessorUserAgentParserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogsCustomPipelineProcessorPipelineProcessorUserAgentParser | undefined;
    set internalValue(value: LogsCustomPipelineProcessorPipelineProcessorUserAgentParser | undefined);
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _isEncoded?;
    get isEncoded(): boolean | cdktf.IResolvable;
    set isEncoded(value: boolean | cdktf.IResolvable);
    resetIsEncoded(): void;
    get isEncodedInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _sources?;
    get sources(): string[];
    set sources(value: string[]);
    get sourcesInput(): string[] | undefined;
    private _target?;
    get target(): string;
    set target(value: string);
    get targetInput(): string | undefined;
}
export interface LogsCustomPipelineProcessorPipelineProcessor {
    /**
    * arithmetic_processor block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#arithmetic_processor LogsCustomPipeline#arithmetic_processor}
    */
    readonly arithmeticProcessor?: LogsCustomPipelineProcessorPipelineProcessorArithmeticProcessor;
    /**
    * attribute_remapper block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#attribute_remapper LogsCustomPipeline#attribute_remapper}
    */
    readonly attributeRemapper?: LogsCustomPipelineProcessorPipelineProcessorAttributeRemapper;
    /**
    * category_processor block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#category_processor LogsCustomPipeline#category_processor}
    */
    readonly categoryProcessor?: LogsCustomPipelineProcessorPipelineProcessorCategoryProcessor;
    /**
    * date_remapper block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#date_remapper LogsCustomPipeline#date_remapper}
    */
    readonly dateRemapper?: LogsCustomPipelineProcessorPipelineProcessorDateRemapper;
    /**
    * geo_ip_parser block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#geo_ip_parser LogsCustomPipeline#geo_ip_parser}
    */
    readonly geoIpParser?: LogsCustomPipelineProcessorPipelineProcessorGeoIpParser;
    /**
    * grok_parser block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#grok_parser LogsCustomPipeline#grok_parser}
    */
    readonly grokParser?: LogsCustomPipelineProcessorPipelineProcessorGrokParser;
    /**
    * lookup_processor block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#lookup_processor LogsCustomPipeline#lookup_processor}
    */
    readonly lookupProcessor?: LogsCustomPipelineProcessorPipelineProcessorLookupProcessor;
    /**
    * message_remapper block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#message_remapper LogsCustomPipeline#message_remapper}
    */
    readonly messageRemapper?: LogsCustomPipelineProcessorPipelineProcessorMessageRemapper;
    /**
    * service_remapper block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#service_remapper LogsCustomPipeline#service_remapper}
    */
    readonly serviceRemapper?: LogsCustomPipelineProcessorPipelineProcessorServiceRemapper;
    /**
    * status_remapper block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#status_remapper LogsCustomPipeline#status_remapper}
    */
    readonly statusRemapper?: LogsCustomPipelineProcessorPipelineProcessorStatusRemapper;
    /**
    * string_builder_processor block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#string_builder_processor LogsCustomPipeline#string_builder_processor}
    */
    readonly stringBuilderProcessor?: LogsCustomPipelineProcessorPipelineProcessorStringBuilderProcessor;
    /**
    * trace_id_remapper block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#trace_id_remapper LogsCustomPipeline#trace_id_remapper}
    */
    readonly traceIdRemapper?: LogsCustomPipelineProcessorPipelineProcessorTraceIdRemapper;
    /**
    * url_parser block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#url_parser LogsCustomPipeline#url_parser}
    */
    readonly urlParser?: LogsCustomPipelineProcessorPipelineProcessorUrlParser;
    /**
    * user_agent_parser block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#user_agent_parser LogsCustomPipeline#user_agent_parser}
    */
    readonly userAgentParser?: LogsCustomPipelineProcessorPipelineProcessorUserAgentParser;
}
export declare function logsCustomPipelineProcessorPipelineProcessorToTerraform(struct?: LogsCustomPipelineProcessorPipelineProcessor | cdktf.IResolvable): any;
export declare class LogsCustomPipelineProcessorPipelineProcessorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LogsCustomPipelineProcessorPipelineProcessor | cdktf.IResolvable | undefined;
    set internalValue(value: LogsCustomPipelineProcessorPipelineProcessor | cdktf.IResolvable | undefined);
    private _arithmeticProcessor;
    get arithmeticProcessor(): LogsCustomPipelineProcessorPipelineProcessorArithmeticProcessorOutputReference;
    putArithmeticProcessor(value: LogsCustomPipelineProcessorPipelineProcessorArithmeticProcessor): void;
    resetArithmeticProcessor(): void;
    get arithmeticProcessorInput(): LogsCustomPipelineProcessorPipelineProcessorArithmeticProcessor | undefined;
    private _attributeRemapper;
    get attributeRemapper(): LogsCustomPipelineProcessorPipelineProcessorAttributeRemapperOutputReference;
    putAttributeRemapper(value: LogsCustomPipelineProcessorPipelineProcessorAttributeRemapper): void;
    resetAttributeRemapper(): void;
    get attributeRemapperInput(): LogsCustomPipelineProcessorPipelineProcessorAttributeRemapper | undefined;
    private _categoryProcessor;
    get categoryProcessor(): LogsCustomPipelineProcessorPipelineProcessorCategoryProcessorOutputReference;
    putCategoryProcessor(value: LogsCustomPipelineProcessorPipelineProcessorCategoryProcessor): void;
    resetCategoryProcessor(): void;
    get categoryProcessorInput(): LogsCustomPipelineProcessorPipelineProcessorCategoryProcessor | undefined;
    private _dateRemapper;
    get dateRemapper(): LogsCustomPipelineProcessorPipelineProcessorDateRemapperOutputReference;
    putDateRemapper(value: LogsCustomPipelineProcessorPipelineProcessorDateRemapper): void;
    resetDateRemapper(): void;
    get dateRemapperInput(): LogsCustomPipelineProcessorPipelineProcessorDateRemapper | undefined;
    private _geoIpParser;
    get geoIpParser(): LogsCustomPipelineProcessorPipelineProcessorGeoIpParserOutputReference;
    putGeoIpParser(value: LogsCustomPipelineProcessorPipelineProcessorGeoIpParser): void;
    resetGeoIpParser(): void;
    get geoIpParserInput(): LogsCustomPipelineProcessorPipelineProcessorGeoIpParser | undefined;
    private _grokParser;
    get grokParser(): LogsCustomPipelineProcessorPipelineProcessorGrokParserOutputReference;
    putGrokParser(value: LogsCustomPipelineProcessorPipelineProcessorGrokParser): void;
    resetGrokParser(): void;
    get grokParserInput(): LogsCustomPipelineProcessorPipelineProcessorGrokParser | undefined;
    private _lookupProcessor;
    get lookupProcessor(): LogsCustomPipelineProcessorPipelineProcessorLookupProcessorOutputReference;
    putLookupProcessor(value: LogsCustomPipelineProcessorPipelineProcessorLookupProcessor): void;
    resetLookupProcessor(): void;
    get lookupProcessorInput(): LogsCustomPipelineProcessorPipelineProcessorLookupProcessor | undefined;
    private _messageRemapper;
    get messageRemapper(): LogsCustomPipelineProcessorPipelineProcessorMessageRemapperOutputReference;
    putMessageRemapper(value: LogsCustomPipelineProcessorPipelineProcessorMessageRemapper): void;
    resetMessageRemapper(): void;
    get messageRemapperInput(): LogsCustomPipelineProcessorPipelineProcessorMessageRemapper | undefined;
    private _serviceRemapper;
    get serviceRemapper(): LogsCustomPipelineProcessorPipelineProcessorServiceRemapperOutputReference;
    putServiceRemapper(value: LogsCustomPipelineProcessorPipelineProcessorServiceRemapper): void;
    resetServiceRemapper(): void;
    get serviceRemapperInput(): LogsCustomPipelineProcessorPipelineProcessorServiceRemapper | undefined;
    private _statusRemapper;
    get statusRemapper(): LogsCustomPipelineProcessorPipelineProcessorStatusRemapperOutputReference;
    putStatusRemapper(value: LogsCustomPipelineProcessorPipelineProcessorStatusRemapper): void;
    resetStatusRemapper(): void;
    get statusRemapperInput(): LogsCustomPipelineProcessorPipelineProcessorStatusRemapper | undefined;
    private _stringBuilderProcessor;
    get stringBuilderProcessor(): LogsCustomPipelineProcessorPipelineProcessorStringBuilderProcessorOutputReference;
    putStringBuilderProcessor(value: LogsCustomPipelineProcessorPipelineProcessorStringBuilderProcessor): void;
    resetStringBuilderProcessor(): void;
    get stringBuilderProcessorInput(): LogsCustomPipelineProcessorPipelineProcessorStringBuilderProcessor | undefined;
    private _traceIdRemapper;
    get traceIdRemapper(): LogsCustomPipelineProcessorPipelineProcessorTraceIdRemapperOutputReference;
    putTraceIdRemapper(value: LogsCustomPipelineProcessorPipelineProcessorTraceIdRemapper): void;
    resetTraceIdRemapper(): void;
    get traceIdRemapperInput(): LogsCustomPipelineProcessorPipelineProcessorTraceIdRemapper | undefined;
    private _urlParser;
    get urlParser(): LogsCustomPipelineProcessorPipelineProcessorUrlParserOutputReference;
    putUrlParser(value: LogsCustomPipelineProcessorPipelineProcessorUrlParser): void;
    resetUrlParser(): void;
    get urlParserInput(): LogsCustomPipelineProcessorPipelineProcessorUrlParser | undefined;
    private _userAgentParser;
    get userAgentParser(): LogsCustomPipelineProcessorPipelineProcessorUserAgentParserOutputReference;
    putUserAgentParser(value: LogsCustomPipelineProcessorPipelineProcessorUserAgentParser): void;
    resetUserAgentParser(): void;
    get userAgentParserInput(): LogsCustomPipelineProcessorPipelineProcessorUserAgentParser | undefined;
}
export declare class LogsCustomPipelineProcessorPipelineProcessorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LogsCustomPipelineProcessorPipelineProcessor[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LogsCustomPipelineProcessorPipelineProcessorOutputReference;
}
export interface LogsCustomPipelineProcessorPipeline {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#is_enabled LogsCustomPipeline#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#name LogsCustomPipeline#name}
    */
    readonly name: string;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#filter LogsCustomPipeline#filter}
    */
    readonly filter: LogsCustomPipelineProcessorPipelineFilter[] | cdktf.IResolvable;
    /**
    * processor block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#processor LogsCustomPipeline#processor}
    */
    readonly processor?: LogsCustomPipelineProcessorPipelineProcessor[] | cdktf.IResolvable;
}
export declare function logsCustomPipelineProcessorPipelineToTerraform(struct?: LogsCustomPipelineProcessorPipelineOutputReference | LogsCustomPipelineProcessorPipeline): any;
export declare class LogsCustomPipelineProcessorPipelineOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogsCustomPipelineProcessorPipeline | undefined;
    set internalValue(value: LogsCustomPipelineProcessorPipeline | undefined);
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _filter;
    get filter(): LogsCustomPipelineProcessorPipelineFilterList;
    putFilter(value: LogsCustomPipelineProcessorPipelineFilter[] | cdktf.IResolvable): void;
    get filterInput(): cdktf.IResolvable | LogsCustomPipelineProcessorPipelineFilter[] | undefined;
    private _processor;
    get processor(): LogsCustomPipelineProcessorPipelineProcessorList;
    putProcessor(value: LogsCustomPipelineProcessorPipelineProcessor[] | cdktf.IResolvable): void;
    resetProcessor(): void;
    get processorInput(): cdktf.IResolvable | LogsCustomPipelineProcessorPipelineProcessor[] | undefined;
}
export interface LogsCustomPipelineProcessorServiceRemapper {
    /**
    * If the processor is enabled or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#is_enabled LogsCustomPipeline#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Name of the processor.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#name LogsCustomPipeline#name}
    */
    readonly name?: string;
    /**
    * List of source attributes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#sources LogsCustomPipeline#sources}
    */
    readonly sources: string[];
}
export declare function logsCustomPipelineProcessorServiceRemapperToTerraform(struct?: LogsCustomPipelineProcessorServiceRemapperOutputReference | LogsCustomPipelineProcessorServiceRemapper): any;
export declare class LogsCustomPipelineProcessorServiceRemapperOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogsCustomPipelineProcessorServiceRemapper | undefined;
    set internalValue(value: LogsCustomPipelineProcessorServiceRemapper | undefined);
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _sources?;
    get sources(): string[];
    set sources(value: string[]);
    get sourcesInput(): string[] | undefined;
}
export interface LogsCustomPipelineProcessorStatusRemapper {
    /**
    * If the processor is enabled or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#is_enabled LogsCustomPipeline#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Name of the processor.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#name LogsCustomPipeline#name}
    */
    readonly name?: string;
    /**
    * List of source attributes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#sources LogsCustomPipeline#sources}
    */
    readonly sources: string[];
}
export declare function logsCustomPipelineProcessorStatusRemapperToTerraform(struct?: LogsCustomPipelineProcessorStatusRemapperOutputReference | LogsCustomPipelineProcessorStatusRemapper): any;
export declare class LogsCustomPipelineProcessorStatusRemapperOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogsCustomPipelineProcessorStatusRemapper | undefined;
    set internalValue(value: LogsCustomPipelineProcessorStatusRemapper | undefined);
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _sources?;
    get sources(): string[];
    set sources(value: string[]);
    get sourcesInput(): string[] | undefined;
}
export interface LogsCustomPipelineProcessorStringBuilderProcessor {
    /**
    * If the processor is enabled or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#is_enabled LogsCustomPipeline#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * If it replaces all missing attributes of template by an empty string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#is_replace_missing LogsCustomPipeline#is_replace_missing}
    */
    readonly isReplaceMissing?: boolean | cdktf.IResolvable;
    /**
    * The name of the processor.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#name LogsCustomPipeline#name}
    */
    readonly name?: string;
    /**
    * The name of the attribute that contains the result of the template.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#target LogsCustomPipeline#target}
    */
    readonly target: string;
    /**
    * The formula with one or more attributes and raw text.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#template LogsCustomPipeline#template}
    */
    readonly template: string;
}
export declare function logsCustomPipelineProcessorStringBuilderProcessorToTerraform(struct?: LogsCustomPipelineProcessorStringBuilderProcessorOutputReference | LogsCustomPipelineProcessorStringBuilderProcessor): any;
export declare class LogsCustomPipelineProcessorStringBuilderProcessorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogsCustomPipelineProcessorStringBuilderProcessor | undefined;
    set internalValue(value: LogsCustomPipelineProcessorStringBuilderProcessor | undefined);
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _isReplaceMissing?;
    get isReplaceMissing(): boolean | cdktf.IResolvable;
    set isReplaceMissing(value: boolean | cdktf.IResolvable);
    resetIsReplaceMissing(): void;
    get isReplaceMissingInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _target?;
    get target(): string;
    set target(value: string);
    get targetInput(): string | undefined;
    private _template?;
    get template(): string;
    set template(value: string);
    get templateInput(): string | undefined;
}
export interface LogsCustomPipelineProcessorTraceIdRemapper {
    /**
    * If the processor is enabled or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#is_enabled LogsCustomPipeline#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Name of the processor.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#name LogsCustomPipeline#name}
    */
    readonly name?: string;
    /**
    * List of source attributes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#sources LogsCustomPipeline#sources}
    */
    readonly sources: string[];
}
export declare function logsCustomPipelineProcessorTraceIdRemapperToTerraform(struct?: LogsCustomPipelineProcessorTraceIdRemapperOutputReference | LogsCustomPipelineProcessorTraceIdRemapper): any;
export declare class LogsCustomPipelineProcessorTraceIdRemapperOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogsCustomPipelineProcessorTraceIdRemapper | undefined;
    set internalValue(value: LogsCustomPipelineProcessorTraceIdRemapper | undefined);
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _sources?;
    get sources(): string[];
    set sources(value: string[]);
    get sourcesInput(): string[] | undefined;
}
export interface LogsCustomPipelineProcessorUrlParser {
    /**
    * If the processor is enabled or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#is_enabled LogsCustomPipeline#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * Name of the processor
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#name LogsCustomPipeline#name}
    */
    readonly name?: string;
    /**
    * Normalize the ending slashes or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#normalize_ending_slashes LogsCustomPipeline#normalize_ending_slashes}
    */
    readonly normalizeEndingSlashes?: boolean | cdktf.IResolvable;
    /**
    * List of source attributes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#sources LogsCustomPipeline#sources}
    */
    readonly sources: string[];
    /**
    * Name of the parent attribute that contains all the extracted details from the sources.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#target LogsCustomPipeline#target}
    */
    readonly target: string;
}
export declare function logsCustomPipelineProcessorUrlParserToTerraform(struct?: LogsCustomPipelineProcessorUrlParserOutputReference | LogsCustomPipelineProcessorUrlParser): any;
export declare class LogsCustomPipelineProcessorUrlParserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogsCustomPipelineProcessorUrlParser | undefined;
    set internalValue(value: LogsCustomPipelineProcessorUrlParser | undefined);
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _normalizeEndingSlashes?;
    get normalizeEndingSlashes(): boolean | cdktf.IResolvable;
    set normalizeEndingSlashes(value: boolean | cdktf.IResolvable);
    resetNormalizeEndingSlashes(): void;
    get normalizeEndingSlashesInput(): boolean | cdktf.IResolvable | undefined;
    private _sources?;
    get sources(): string[];
    set sources(value: string[]);
    get sourcesInput(): string[] | undefined;
    private _target?;
    get target(): string;
    set target(value: string);
    get targetInput(): string | undefined;
}
export interface LogsCustomPipelineProcessorUserAgentParser {
    /**
    * If the processor is enabled or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#is_enabled LogsCustomPipeline#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * If the source attribute is URL encoded or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#is_encoded LogsCustomPipeline#is_encoded}
    */
    readonly isEncoded?: boolean | cdktf.IResolvable;
    /**
    * Name of the processor
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#name LogsCustomPipeline#name}
    */
    readonly name?: string;
    /**
    * List of source attributes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#sources LogsCustomPipeline#sources}
    */
    readonly sources: string[];
    /**
    * Name of the parent attribute that contains all the extracted details from the sources.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#target LogsCustomPipeline#target}
    */
    readonly target: string;
}
export declare function logsCustomPipelineProcessorUserAgentParserToTerraform(struct?: LogsCustomPipelineProcessorUserAgentParserOutputReference | LogsCustomPipelineProcessorUserAgentParser): any;
export declare class LogsCustomPipelineProcessorUserAgentParserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogsCustomPipelineProcessorUserAgentParser | undefined;
    set internalValue(value: LogsCustomPipelineProcessorUserAgentParser | undefined);
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _isEncoded?;
    get isEncoded(): boolean | cdktf.IResolvable;
    set isEncoded(value: boolean | cdktf.IResolvable);
    resetIsEncoded(): void;
    get isEncodedInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _sources?;
    get sources(): string[];
    set sources(value: string[]);
    get sourcesInput(): string[] | undefined;
    private _target?;
    get target(): string;
    set target(value: string);
    get targetInput(): string | undefined;
}
export interface LogsCustomPipelineProcessor {
    /**
    * arithmetic_processor block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#arithmetic_processor LogsCustomPipeline#arithmetic_processor}
    */
    readonly arithmeticProcessor?: LogsCustomPipelineProcessorArithmeticProcessor;
    /**
    * attribute_remapper block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#attribute_remapper LogsCustomPipeline#attribute_remapper}
    */
    readonly attributeRemapper?: LogsCustomPipelineProcessorAttributeRemapper;
    /**
    * category_processor block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#category_processor LogsCustomPipeline#category_processor}
    */
    readonly categoryProcessor?: LogsCustomPipelineProcessorCategoryProcessor;
    /**
    * date_remapper block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#date_remapper LogsCustomPipeline#date_remapper}
    */
    readonly dateRemapper?: LogsCustomPipelineProcessorDateRemapper;
    /**
    * geo_ip_parser block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#geo_ip_parser LogsCustomPipeline#geo_ip_parser}
    */
    readonly geoIpParser?: LogsCustomPipelineProcessorGeoIpParser;
    /**
    * grok_parser block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#grok_parser LogsCustomPipeline#grok_parser}
    */
    readonly grokParser?: LogsCustomPipelineProcessorGrokParser;
    /**
    * lookup_processor block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#lookup_processor LogsCustomPipeline#lookup_processor}
    */
    readonly lookupProcessor?: LogsCustomPipelineProcessorLookupProcessor;
    /**
    * message_remapper block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#message_remapper LogsCustomPipeline#message_remapper}
    */
    readonly messageRemapper?: LogsCustomPipelineProcessorMessageRemapper;
    /**
    * pipeline block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#pipeline LogsCustomPipeline#pipeline}
    */
    readonly pipeline?: LogsCustomPipelineProcessorPipeline;
    /**
    * service_remapper block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#service_remapper LogsCustomPipeline#service_remapper}
    */
    readonly serviceRemapper?: LogsCustomPipelineProcessorServiceRemapper;
    /**
    * status_remapper block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#status_remapper LogsCustomPipeline#status_remapper}
    */
    readonly statusRemapper?: LogsCustomPipelineProcessorStatusRemapper;
    /**
    * string_builder_processor block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#string_builder_processor LogsCustomPipeline#string_builder_processor}
    */
    readonly stringBuilderProcessor?: LogsCustomPipelineProcessorStringBuilderProcessor;
    /**
    * trace_id_remapper block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#trace_id_remapper LogsCustomPipeline#trace_id_remapper}
    */
    readonly traceIdRemapper?: LogsCustomPipelineProcessorTraceIdRemapper;
    /**
    * url_parser block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#url_parser LogsCustomPipeline#url_parser}
    */
    readonly urlParser?: LogsCustomPipelineProcessorUrlParser;
    /**
    * user_agent_parser block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline#user_agent_parser LogsCustomPipeline#user_agent_parser}
    */
    readonly userAgentParser?: LogsCustomPipelineProcessorUserAgentParser;
}
export declare function logsCustomPipelineProcessorToTerraform(struct?: LogsCustomPipelineProcessor | cdktf.IResolvable): any;
export declare class LogsCustomPipelineProcessorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LogsCustomPipelineProcessor | cdktf.IResolvable | undefined;
    set internalValue(value: LogsCustomPipelineProcessor | cdktf.IResolvable | undefined);
    private _arithmeticProcessor;
    get arithmeticProcessor(): LogsCustomPipelineProcessorArithmeticProcessorOutputReference;
    putArithmeticProcessor(value: LogsCustomPipelineProcessorArithmeticProcessor): void;
    resetArithmeticProcessor(): void;
    get arithmeticProcessorInput(): LogsCustomPipelineProcessorArithmeticProcessor | undefined;
    private _attributeRemapper;
    get attributeRemapper(): LogsCustomPipelineProcessorAttributeRemapperOutputReference;
    putAttributeRemapper(value: LogsCustomPipelineProcessorAttributeRemapper): void;
    resetAttributeRemapper(): void;
    get attributeRemapperInput(): LogsCustomPipelineProcessorAttributeRemapper | undefined;
    private _categoryProcessor;
    get categoryProcessor(): LogsCustomPipelineProcessorCategoryProcessorOutputReference;
    putCategoryProcessor(value: LogsCustomPipelineProcessorCategoryProcessor): void;
    resetCategoryProcessor(): void;
    get categoryProcessorInput(): LogsCustomPipelineProcessorCategoryProcessor | undefined;
    private _dateRemapper;
    get dateRemapper(): LogsCustomPipelineProcessorDateRemapperOutputReference;
    putDateRemapper(value: LogsCustomPipelineProcessorDateRemapper): void;
    resetDateRemapper(): void;
    get dateRemapperInput(): LogsCustomPipelineProcessorDateRemapper | undefined;
    private _geoIpParser;
    get geoIpParser(): LogsCustomPipelineProcessorGeoIpParserOutputReference;
    putGeoIpParser(value: LogsCustomPipelineProcessorGeoIpParser): void;
    resetGeoIpParser(): void;
    get geoIpParserInput(): LogsCustomPipelineProcessorGeoIpParser | undefined;
    private _grokParser;
    get grokParser(): LogsCustomPipelineProcessorGrokParserOutputReference;
    putGrokParser(value: LogsCustomPipelineProcessorGrokParser): void;
    resetGrokParser(): void;
    get grokParserInput(): LogsCustomPipelineProcessorGrokParser | undefined;
    private _lookupProcessor;
    get lookupProcessor(): LogsCustomPipelineProcessorLookupProcessorOutputReference;
    putLookupProcessor(value: LogsCustomPipelineProcessorLookupProcessor): void;
    resetLookupProcessor(): void;
    get lookupProcessorInput(): LogsCustomPipelineProcessorLookupProcessor | undefined;
    private _messageRemapper;
    get messageRemapper(): LogsCustomPipelineProcessorMessageRemapperOutputReference;
    putMessageRemapper(value: LogsCustomPipelineProcessorMessageRemapper): void;
    resetMessageRemapper(): void;
    get messageRemapperInput(): LogsCustomPipelineProcessorMessageRemapper | undefined;
    private _pipeline;
    get pipeline(): LogsCustomPipelineProcessorPipelineOutputReference;
    putPipeline(value: LogsCustomPipelineProcessorPipeline): void;
    resetPipeline(): void;
    get pipelineInput(): LogsCustomPipelineProcessorPipeline | undefined;
    private _serviceRemapper;
    get serviceRemapper(): LogsCustomPipelineProcessorServiceRemapperOutputReference;
    putServiceRemapper(value: LogsCustomPipelineProcessorServiceRemapper): void;
    resetServiceRemapper(): void;
    get serviceRemapperInput(): LogsCustomPipelineProcessorServiceRemapper | undefined;
    private _statusRemapper;
    get statusRemapper(): LogsCustomPipelineProcessorStatusRemapperOutputReference;
    putStatusRemapper(value: LogsCustomPipelineProcessorStatusRemapper): void;
    resetStatusRemapper(): void;
    get statusRemapperInput(): LogsCustomPipelineProcessorStatusRemapper | undefined;
    private _stringBuilderProcessor;
    get stringBuilderProcessor(): LogsCustomPipelineProcessorStringBuilderProcessorOutputReference;
    putStringBuilderProcessor(value: LogsCustomPipelineProcessorStringBuilderProcessor): void;
    resetStringBuilderProcessor(): void;
    get stringBuilderProcessorInput(): LogsCustomPipelineProcessorStringBuilderProcessor | undefined;
    private _traceIdRemapper;
    get traceIdRemapper(): LogsCustomPipelineProcessorTraceIdRemapperOutputReference;
    putTraceIdRemapper(value: LogsCustomPipelineProcessorTraceIdRemapper): void;
    resetTraceIdRemapper(): void;
    get traceIdRemapperInput(): LogsCustomPipelineProcessorTraceIdRemapper | undefined;
    private _urlParser;
    get urlParser(): LogsCustomPipelineProcessorUrlParserOutputReference;
    putUrlParser(value: LogsCustomPipelineProcessorUrlParser): void;
    resetUrlParser(): void;
    get urlParserInput(): LogsCustomPipelineProcessorUrlParser | undefined;
    private _userAgentParser;
    get userAgentParser(): LogsCustomPipelineProcessorUserAgentParserOutputReference;
    putUserAgentParser(value: LogsCustomPipelineProcessorUserAgentParser): void;
    resetUserAgentParser(): void;
    get userAgentParserInput(): LogsCustomPipelineProcessorUserAgentParser | undefined;
}
export declare class LogsCustomPipelineProcessorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LogsCustomPipelineProcessor[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LogsCustomPipelineProcessorOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline datadog_logs_custom_pipeline}
*/
export declare class LogsCustomPipeline extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_logs_custom_pipeline";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline datadog_logs_custom_pipeline} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LogsCustomPipelineConfig
    */
    constructor(scope: Construct, id: string, config: LogsCustomPipelineConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _filter;
    get filter(): LogsCustomPipelineFilterList;
    putFilter(value: LogsCustomPipelineFilter[] | cdktf.IResolvable): void;
    get filterInput(): cdktf.IResolvable | LogsCustomPipelineFilter[] | undefined;
    private _processor;
    get processor(): LogsCustomPipelineProcessorList;
    putProcessor(value: LogsCustomPipelineProcessor[] | cdktf.IResolvable): void;
    resetProcessor(): void;
    get processorInput(): cdktf.IResolvable | LogsCustomPipelineProcessor[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
