import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LogsIndexConfig extends cdktf.TerraformMetaArguments {
    /**
    * The number of log events you can send in this index per day before you are rate-limited.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_index#daily_limit LogsIndex#daily_limit}
    */
    readonly dailyLimit?: number;
    /**
    * If true, sets the daily_limit value to null and the index is not limited on a daily basis (any specified daily_limit value in the request is ignored). If false or omitted, the index's current daily_limit is maintained.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_index#disable_daily_limit LogsIndex#disable_daily_limit}
    */
    readonly disableDailyLimit?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_index#id LogsIndex#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the index.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_index#name LogsIndex#name}
    */
    readonly name: string;
    /**
    * The number of days before logs are deleted from this index.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_index#retention_days LogsIndex#retention_days}
    */
    readonly retentionDays?: number;
    /**
    * exclusion_filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_index#exclusion_filter LogsIndex#exclusion_filter}
    */
    readonly exclusionFilter?: LogsIndexExclusionFilter[] | cdktf.IResolvable;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_index#filter LogsIndex#filter}
    */
    readonly filter: LogsIndexFilter;
}
export interface LogsIndexExclusionFilterFilter {
    /**
    * Only logs matching the filter criteria and the query of the parent index will be considered for this exclusion filter.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_index#query LogsIndex#query}
    */
    readonly query?: string;
    /**
    * The fraction of logs excluded by the exclusion filter, when active.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_index#sample_rate LogsIndex#sample_rate}
    */
    readonly sampleRate?: number;
}
export declare function logsIndexExclusionFilterFilterToTerraform(struct?: LogsIndexExclusionFilterFilter | cdktf.IResolvable): any;
export declare class LogsIndexExclusionFilterFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LogsIndexExclusionFilterFilter | cdktf.IResolvable | undefined;
    set internalValue(value: LogsIndexExclusionFilterFilter | cdktf.IResolvable | undefined);
    private _query?;
    get query(): string;
    set query(value: string);
    resetQuery(): void;
    get queryInput(): string | undefined;
    private _sampleRate?;
    get sampleRate(): number;
    set sampleRate(value: number);
    resetSampleRate(): void;
    get sampleRateInput(): number | undefined;
}
export declare class LogsIndexExclusionFilterFilterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LogsIndexExclusionFilterFilter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LogsIndexExclusionFilterFilterOutputReference;
}
export interface LogsIndexExclusionFilter {
    /**
    * A boolean stating if the exclusion is active or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_index#is_enabled LogsIndex#is_enabled}
    */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
    * The name of the exclusion filter.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_index#name LogsIndex#name}
    */
    readonly name?: string;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_index#filter LogsIndex#filter}
    */
    readonly filter?: LogsIndexExclusionFilterFilter[] | cdktf.IResolvable;
}
export declare function logsIndexExclusionFilterToTerraform(struct?: LogsIndexExclusionFilter | cdktf.IResolvable): any;
export declare class LogsIndexExclusionFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LogsIndexExclusionFilter | cdktf.IResolvable | undefined;
    set internalValue(value: LogsIndexExclusionFilter | cdktf.IResolvable | undefined);
    private _isEnabled?;
    get isEnabled(): boolean | cdktf.IResolvable;
    set isEnabled(value: boolean | cdktf.IResolvable);
    resetIsEnabled(): void;
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _filter;
    get filter(): LogsIndexExclusionFilterFilterList;
    putFilter(value: LogsIndexExclusionFilterFilter[] | cdktf.IResolvable): void;
    resetFilter(): void;
    get filterInput(): cdktf.IResolvable | LogsIndexExclusionFilterFilter[] | undefined;
}
export declare class LogsIndexExclusionFilterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LogsIndexExclusionFilter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LogsIndexExclusionFilterOutputReference;
}
export interface LogsIndexFilter {
    /**
    * Logs filter criteria. Only logs matching this filter criteria are considered for this index.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_index#query LogsIndex#query}
    */
    readonly query: string;
}
export declare function logsIndexFilterToTerraform(struct?: LogsIndexFilterOutputReference | LogsIndexFilter): any;
export declare class LogsIndexFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogsIndexFilter | undefined;
    set internalValue(value: LogsIndexFilter | undefined);
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/logs_index datadog_logs_index}
*/
export declare class LogsIndex extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_logs_index";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/logs_index datadog_logs_index} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LogsIndexConfig
    */
    constructor(scope: Construct, id: string, config: LogsIndexConfig);
    private _dailyLimit?;
    get dailyLimit(): number;
    set dailyLimit(value: number);
    resetDailyLimit(): void;
    get dailyLimitInput(): number | undefined;
    private _disableDailyLimit?;
    get disableDailyLimit(): boolean | cdktf.IResolvable;
    set disableDailyLimit(value: boolean | cdktf.IResolvable);
    resetDisableDailyLimit(): void;
    get disableDailyLimitInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _retentionDays?;
    get retentionDays(): number;
    set retentionDays(value: number);
    resetRetentionDays(): void;
    get retentionDaysInput(): number | undefined;
    private _exclusionFilter;
    get exclusionFilter(): LogsIndexExclusionFilterList;
    putExclusionFilter(value: LogsIndexExclusionFilter[] | cdktf.IResolvable): void;
    resetExclusionFilter(): void;
    get exclusionFilterInput(): cdktf.IResolvable | LogsIndexExclusionFilter[] | undefined;
    private _filter;
    get filter(): LogsIndexFilterOutputReference;
    putFilter(value: LogsIndexFilter): void;
    get filterInput(): LogsIndexFilter | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
