import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LogsMetricConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_metric#id LogsMetric#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the log-based metric. This field can't be updated after creation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_metric#name LogsMetric#name}
    */
    readonly name: string;
    /**
    * compute block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_metric#compute LogsMetric#compute}
    */
    readonly compute: LogsMetricCompute;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_metric#filter LogsMetric#filter}
    */
    readonly filter: LogsMetricFilter;
    /**
    * group_by block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_metric#group_by LogsMetric#group_by}
    */
    readonly groupBy?: LogsMetricGroupBy[] | cdktf.IResolvable;
}
export interface LogsMetricCompute {
    /**
    * The type of aggregation to use. This field can't be updated after creation. Valid values are `count`, `distribution`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_metric#aggregation_type LogsMetric#aggregation_type}
    */
    readonly aggregationType: string;
    /**
    * Toggle to include/exclude percentiles for a distribution metric. Defaults to false. Can only be applied to metrics that have an `aggregation_type` of distribution.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_metric#include_percentiles LogsMetric#include_percentiles}
    */
    readonly includePercentiles?: boolean | cdktf.IResolvable;
    /**
    * The path to the value the log-based metric will aggregate on (only used if the aggregation type is a "distribution"). This field can't be updated after creation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_metric#path LogsMetric#path}
    */
    readonly path?: string;
}
export declare function logsMetricComputeToTerraform(struct?: LogsMetricComputeOutputReference | LogsMetricCompute): any;
export declare class LogsMetricComputeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogsMetricCompute | undefined;
    set internalValue(value: LogsMetricCompute | undefined);
    private _aggregationType?;
    get aggregationType(): string;
    set aggregationType(value: string);
    get aggregationTypeInput(): string | undefined;
    private _includePercentiles?;
    get includePercentiles(): boolean | cdktf.IResolvable;
    set includePercentiles(value: boolean | cdktf.IResolvable);
    resetIncludePercentiles(): void;
    get includePercentilesInput(): boolean | cdktf.IResolvable | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
}
export interface LogsMetricFilter {
    /**
    * The search query - following the log search syntax.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_metric#query LogsMetric#query}
    */
    readonly query: string;
}
export declare function logsMetricFilterToTerraform(struct?: LogsMetricFilterOutputReference | LogsMetricFilter): any;
export declare class LogsMetricFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogsMetricFilter | undefined;
    set internalValue(value: LogsMetricFilter | undefined);
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
}
export interface LogsMetricGroupBy {
    /**
    * The path to the value the log-based metric will be aggregated over.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_metric#path LogsMetric#path}
    */
    readonly path: string;
    /**
    * Name of the tag that gets created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_metric#tag_name LogsMetric#tag_name}
    */
    readonly tagName: string;
}
export declare function logsMetricGroupByToTerraform(struct?: LogsMetricGroupBy | cdktf.IResolvable): any;
export declare class LogsMetricGroupByOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LogsMetricGroupBy | cdktf.IResolvable | undefined;
    set internalValue(value: LogsMetricGroupBy | cdktf.IResolvable | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _tagName?;
    get tagName(): string;
    set tagName(value: string);
    get tagNameInput(): string | undefined;
}
export declare class LogsMetricGroupByList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LogsMetricGroupBy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LogsMetricGroupByOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/logs_metric datadog_logs_metric}
*/
export declare class LogsMetric extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_logs_metric";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/logs_metric datadog_logs_metric} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LogsMetricConfig
    */
    constructor(scope: Construct, id: string, config: LogsMetricConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _compute;
    get compute(): LogsMetricComputeOutputReference;
    putCompute(value: LogsMetricCompute): void;
    get computeInput(): LogsMetricCompute | undefined;
    private _filter;
    get filter(): LogsMetricFilterOutputReference;
    putFilter(value: LogsMetricFilter): void;
    get filterInput(): LogsMetricFilter | undefined;
    private _groupBy;
    get groupBy(): LogsMetricGroupByList;
    putGroupBy(value: LogsMetricGroupBy[] | cdktf.IResolvable): void;
    resetGroupBy(): void;
    get groupByInput(): cdktf.IResolvable | LogsMetricGroupBy[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
