import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LogsPipelineOrderConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_pipeline_order#id LogsPipelineOrder#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name attribute in the resource `datadog_logs_pipeline_order` needs to be unique. It's recommended to use the same value as the resource name. No related field is available in [Logs Pipeline API](https://docs.datadoghq.com/api/v1/logs-pipelines/#get-pipeline-order).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_pipeline_order#name LogsPipelineOrder#name}
    */
    readonly name: string;
    /**
    * The pipeline IDs list. The order of pipeline IDs in this attribute defines the overall pipeline order for logs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_pipeline_order#pipelines LogsPipelineOrder#pipelines}
    */
    readonly pipelines: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/logs_pipeline_order datadog_logs_pipeline_order}
*/
export declare class LogsPipelineOrder extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_logs_pipeline_order";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/logs_pipeline_order datadog_logs_pipeline_order} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LogsPipelineOrderConfig
    */
    constructor(scope: Construct, id: string, config: LogsPipelineOrderConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _pipelines?;
    get pipelines(): string[];
    set pipelines(value: string[]);
    get pipelinesInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
