import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MetricMetadataConfig extends cdktf.TerraformMetaArguments {
    /**
    * A description of the metric.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/metric_metadata#description MetricMetadata#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/metric_metadata#id MetricMetadata#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the metric.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/metric_metadata#metric MetricMetadata#metric}
    */
    readonly metric: string;
    /**
    * Per unit of the metric such as `second` in `bytes per second`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/metric_metadata#per_unit MetricMetadata#per_unit}
    */
    readonly perUnit?: string;
    /**
    * A short name of the metric.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/metric_metadata#short_name MetricMetadata#short_name}
    */
    readonly shortName?: string;
    /**
    * If applicable, statsd flush interval in seconds for the metric.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/metric_metadata#statsd_interval MetricMetadata#statsd_interval}
    */
    readonly statsdInterval?: number;
    /**
    * Metric type such as `gauge` or `rate`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/metric_metadata#type MetricMetadata#type}
    */
    readonly type?: string;
    /**
    * Primary unit of the metric such as `byte` or `operation`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/metric_metadata#unit MetricMetadata#unit}
    */
    readonly unit?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/metric_metadata datadog_metric_metadata}
*/
export declare class MetricMetadata extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_metric_metadata";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/metric_metadata datadog_metric_metadata} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MetricMetadataConfig
    */
    constructor(scope: Construct, id: string, config: MetricMetadataConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metric?;
    get metric(): string;
    set metric(value: string);
    get metricInput(): string | undefined;
    private _perUnit?;
    get perUnit(): string;
    set perUnit(value: string);
    resetPerUnit(): void;
    get perUnitInput(): string | undefined;
    private _shortName?;
    get shortName(): string;
    set shortName(value: string);
    resetShortName(): void;
    get shortNameInput(): string | undefined;
    private _statsdInterval?;
    get statsdInterval(): number;
    set statsdInterval(value: number);
    resetStatsdInterval(): void;
    get statsdIntervalInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _unit?;
    get unit(): string;
    set unit(value: string);
    resetUnit(): void;
    get unitInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
