import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MetricTagConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/metric_tag_configuration#id MetricTagConfiguration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Toggle to include/exclude percentiles for a distribution metric. Defaults to false. Can only be applied to metrics that have a `metric_type` of distribution.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/metric_tag_configuration#include_percentiles MetricTagConfiguration#include_percentiles}
    */
    readonly includePercentiles?: boolean | cdktf.IResolvable;
    /**
    * The metric name for this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/metric_tag_configuration#metric_name MetricTagConfiguration#metric_name}
    */
    readonly metricName: string;
    /**
    * The metric's type. This field can't be updated after creation. Valid values are `gauge`, `count`, `rate`, `distribution`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/metric_tag_configuration#metric_type MetricTagConfiguration#metric_type}
    */
    readonly metricType: string;
    /**
    * A list of tag keys that will be queryable for your metric.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/metric_tag_configuration#tags MetricTagConfiguration#tags}
    */
    readonly tags: string[];
    /**
    * aggregations block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/metric_tag_configuration#aggregations MetricTagConfiguration#aggregations}
    */
    readonly aggregations?: MetricTagConfigurationAggregations[] | cdktf.IResolvable;
}
export interface MetricTagConfigurationAggregations {
    /**
    * A space aggregation for use in query. Valid values are `avg`, `max`, `min`, `sum`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/metric_tag_configuration#space MetricTagConfiguration#space}
    */
    readonly space: string;
    /**
    * A time aggregation for use in query. Valid values are `avg`, `count`, `max`, `min`, `sum`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/metric_tag_configuration#time MetricTagConfiguration#time}
    */
    readonly time: string;
}
export declare function metricTagConfigurationAggregationsToTerraform(struct?: MetricTagConfigurationAggregations | cdktf.IResolvable): any;
export declare class MetricTagConfigurationAggregationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MetricTagConfigurationAggregations | cdktf.IResolvable | undefined;
    set internalValue(value: MetricTagConfigurationAggregations | cdktf.IResolvable | undefined);
    private _space?;
    get space(): string;
    set space(value: string);
    get spaceInput(): string | undefined;
    private _time?;
    get time(): string;
    set time(value: string);
    get timeInput(): string | undefined;
}
export declare class MetricTagConfigurationAggregationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MetricTagConfigurationAggregations[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MetricTagConfigurationAggregationsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/metric_tag_configuration datadog_metric_tag_configuration}
*/
export declare class MetricTagConfiguration extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_metric_tag_configuration";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/metric_tag_configuration datadog_metric_tag_configuration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MetricTagConfigurationConfig
    */
    constructor(scope: Construct, id: string, config: MetricTagConfigurationConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _includePercentiles?;
    get includePercentiles(): boolean | cdktf.IResolvable;
    set includePercentiles(value: boolean | cdktf.IResolvable);
    resetIncludePercentiles(): void;
    get includePercentilesInput(): boolean | cdktf.IResolvable | undefined;
    private _metricName?;
    get metricName(): string;
    set metricName(value: string);
    get metricNameInput(): string | undefined;
    private _metricType?;
    get metricType(): string;
    set metricType(value: string);
    get metricTypeInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    get tagsInput(): string[] | undefined;
    private _aggregations;
    get aggregations(): MetricTagConfigurationAggregationsList;
    putAggregations(value: MetricTagConfigurationAggregations[] | cdktf.IResolvable): void;
    resetAggregations(): void;
    get aggregationsInput(): cdktf.IResolvable | MetricTagConfigurationAggregations[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
