import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MonitorConfigPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor_config_policy#id MonitorConfigPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The monitor config policy type Valid values are `tag`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor_config_policy#policy_type MonitorConfigPolicy#policy_type}
    */
    readonly policyType: string;
    /**
    * tag_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor_config_policy#tag_policy MonitorConfigPolicy#tag_policy}
    */
    readonly tagPolicy?: MonitorConfigPolicyTagPolicy;
}
export interface MonitorConfigPolicyTagPolicy {
    /**
    * The key of the tag
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor_config_policy#tag_key MonitorConfigPolicy#tag_key}
    */
    readonly tagKey: string;
    /**
    * If a tag key is required for monitor creation
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor_config_policy#tag_key_required MonitorConfigPolicy#tag_key_required}
    */
    readonly tagKeyRequired: boolean | cdktf.IResolvable;
    /**
    * Valid values for the tag
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor_config_policy#valid_tag_values MonitorConfigPolicy#valid_tag_values}
    */
    readonly validTagValues: string[];
}
export declare function monitorConfigPolicyTagPolicyToTerraform(struct?: MonitorConfigPolicyTagPolicyOutputReference | MonitorConfigPolicyTagPolicy): any;
export declare class MonitorConfigPolicyTagPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorConfigPolicyTagPolicy | undefined;
    set internalValue(value: MonitorConfigPolicyTagPolicy | undefined);
    private _tagKey?;
    get tagKey(): string;
    set tagKey(value: string);
    get tagKeyInput(): string | undefined;
    private _tagKeyRequired?;
    get tagKeyRequired(): boolean | cdktf.IResolvable;
    set tagKeyRequired(value: boolean | cdktf.IResolvable);
    get tagKeyRequiredInput(): boolean | cdktf.IResolvable | undefined;
    private _validTagValues?;
    get validTagValues(): string[];
    set validTagValues(value: string[]);
    get validTagValuesInput(): string[] | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/monitor_config_policy datadog_monitor_config_policy}
*/
export declare class MonitorConfigPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_monitor_config_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/monitor_config_policy datadog_monitor_config_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MonitorConfigPolicyConfig
    */
    constructor(scope: Construct, id: string, config: MonitorConfigPolicyConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _policyType?;
    get policyType(): string;
    set policyType(value: string);
    get policyTypeInput(): string | undefined;
    private _tagPolicy;
    get tagPolicy(): MonitorConfigPolicyTagPolicyOutputReference;
    putTagPolicy(value: MonitorConfigPolicyTagPolicy): void;
    resetTagPolicy(): void;
    get tagPolicyInput(): MonitorConfigPolicyTagPolicy | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
