import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MonitorJsonConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor_json#id MonitorJson#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The JSON formatted definition of the monitor.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor_json#monitor MonitorJson#monitor}
    */
    readonly monitor: string;
    /**
    * The URL of the monitor.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor_json#url MonitorJson#url}
    */
    readonly url?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/monitor_json datadog_monitor_json}
*/
export declare class MonitorJson extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_monitor_json";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/monitor_json datadog_monitor_json} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MonitorJsonConfig
    */
    constructor(scope: Construct, id: string, config: MonitorJsonConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _monitor?;
    get monitor(): string;
    set monitor(value: string);
    get monitorInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    resetUrl(): void;
    get urlInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
