import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MonitorConfig extends cdktf.TerraformMetaArguments {
    /**
    * A boolean indicating whether or not to include a list of log values which triggered the alert. This is only used by log monitors. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#enable_logs_sample Monitor#enable_logs_sample}
    */
    readonly enableLogsSample?: boolean | cdktf.IResolvable;
    /**
    * A message to include with a re-notification. Supports the `@username` notification allowed elsewhere.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#escalation_message Monitor#escalation_message}
    */
    readonly escalationMessage?: string;
    /**
    * (Only applies to metric alert) Time (in seconds) to delay evaluation, as a non-negative integer.
  
  For example, if the value is set to `300` (5min), the `timeframe` is set to `last_5m` and the time is 7:00, the monitor will evaluate data from 6:50 to 6:55. This is useful for AWS CloudWatch and other backfilled metrics to ensure the monitor will always have data during evaluation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#evaluation_delay Monitor#evaluation_delay}
    */
    readonly evaluationDelay?: number;
    /**
    * A boolean indicating whether this monitor can be deleted even if it’s referenced by other resources (e.g. SLO, composite monitor).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#force_delete Monitor#force_delete}
    */
    readonly forceDelete?: boolean | cdktf.IResolvable;
    /**
    * The time span after which groups with missing data are dropped from the monitor state. The minimum value is one hour, and the maximum value is 72 hours. Example values are: 60m, 1h, and 2d. This option is only available for APM Trace Analytics, Audit Trail, CI, Error Tracking, Event, Logs, and RUM monitors.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#group_retention_duration Monitor#group_retention_duration}
    */
    readonly groupRetentionDuration?: string;
    /**
    * Whether or not to trigger one alert if any source breaches a threshold. This is only used by log monitors. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#groupby_simple_monitor Monitor#groupby_simple_monitor}
    */
    readonly groupbySimpleMonitor?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#id Monitor#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A boolean indicating whether notifications from this monitor automatically insert its triggering tags into the title. Defaults to `true`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#include_tags Monitor#include_tags}
    */
    readonly includeTags?: boolean | cdktf.IResolvable;
    /**
    * A boolean indicating whether changes to this monitor should be restricted to the creator or admins. Defaults to `false`. **Deprecated.** Use `restricted_roles`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#locked Monitor#locked}
    */
    readonly locked?: boolean | cdktf.IResolvable;
    /**
    * A message to include with notifications for this monitor.
  
  Email notifications can be sent to specific users by using the same `@username` notation as events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#message Monitor#message}
    */
    readonly message: string;
    /**
    * Name of Datadog monitor.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#name Monitor#name}
    */
    readonly name: string;
    /**
    * The time (in seconds) to skip evaluations for new groups.
  
  `new_group_delay` overrides `new_host_delay` if it is set to a nonzero value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#new_group_delay Monitor#new_group_delay}
    */
    readonly newGroupDelay?: number;
    /**
    * **Deprecated**. See `new_group_delay`. Time (in seconds) to allow a host to boot and applications to fully start before starting the evaluation of monitor results. Should be a non-negative integer. This value is ignored for simple monitors and monitors not grouped by host. Defaults to `300`. The only case when this should be used is to override the default and set `new_host_delay` to zero for monitors grouped by host. **Deprecated.** Use `new_group_delay` except when setting `new_host_delay` to zero.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#new_host_delay Monitor#new_host_delay}
    */
    readonly newHostDelay?: number;
    /**
    * The number of minutes before a monitor will notify when data stops reporting. Provider defaults to 10 minutes.
  
  We recommend at least 2x the monitor timeframe for metric alerts or 2 minutes for service checks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#no_data_timeframe Monitor#no_data_timeframe}
    */
    readonly noDataTimeframe?: number;
    /**
    * Toggles the display of additional content sent in the monitor notification. Valid values are `show_all`, `hide_query`, `hide_handles`, `hide_all`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#notification_preset_name Monitor#notification_preset_name}
    */
    readonly notificationPresetName?: string;
    /**
    * A boolean indicating whether tagged users will be notified on changes to this monitor. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#notify_audit Monitor#notify_audit}
    */
    readonly notifyAudit?: boolean | cdktf.IResolvable;
    /**
    * Controls what granularity a monitor alerts on. Only available for monitors with groupings. For instance, a monitor grouped by `cluster`, `namespace`, and `pod` can be configured to only notify on each new `cluster` violating the alert conditions by setting `notify_by` to `['cluster']`. Tags mentioned in `notify_by` must be a subset of the grouping tags in the query. For example, a query grouped by `cluster` and `namespace` cannot notify on `region`. Setting `notify_by` to `[*]` configures the monitor to notify as a simple-alert. **NOTE:** Currently in private beta. To request access, contact Support at support@datadoghq.com
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#notify_by Monitor#notify_by}
    */
    readonly notifyBy?: string[];
    /**
    * A boolean indicating whether this monitor will notify when data stops reporting. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#notify_no_data Monitor#notify_no_data}
    */
    readonly notifyNoData?: boolean | cdktf.IResolvable;
    /**
    * Controls how groups or monitors are treated if an evaluation does not return any data points. The default option results in different behavior depending on the monitor query type. For monitors using `Count` queries, an empty monitor evaluation is treated as 0 and is compared to the threshold conditions. For monitors using any query type other than `Count`, for example `Gauge`, `Measure`, or `Rate`, the monitor shows the last known status. This option is only available for APM Trace Analytics, Audit Trail, CI, Error Tracking, Event, Logs, and RUM monitors. Valid values are: `show_no_data`, `show_and_notify_no_data`, `resolve`, and `default`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#on_missing_data Monitor#on_missing_data}
    */
    readonly onMissingData?: string;
    /**
    * Integer from 1 (high) to 5 (low) indicating alert severity.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#priority Monitor#priority}
    */
    readonly priority?: number;
    /**
    * The monitor query to notify on. Note this is not the same query you see in the UI and the syntax is different depending on the monitor type, please see the [API Reference](https://docs.datadoghq.com/api/v1/monitors/#create-a-monitor) for details. `terraform plan` will validate query contents unless `validate` is set to `false`.
  
  **Note:** APM latency data is now available as Distribution Metrics. Existing monitors have been migrated automatically but all terraformed monitors can still use the existing metrics. We strongly recommend updating monitor definitions to query the new metrics. To learn more, or to see examples of how to update your terraform definitions to utilize the new distribution metrics, see the [detailed doc](https://docs.datadoghq.com/tracing/guide/ddsketch_trace_metrics/).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#query Monitor#query}
    */
    readonly query: string;
    /**
    * The number of minutes after the last notification before a monitor will re-notify on the current status. It will only re-notify if it's not resolved.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#renotify_interval Monitor#renotify_interval}
    */
    readonly renotifyInterval?: number;
    /**
    * The number of re-notification messages that should be sent on the current status.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#renotify_occurrences Monitor#renotify_occurrences}
    */
    readonly renotifyOccurrences?: number;
    /**
    * The types of statuses for which re-notification messages should be sent. Valid values are `alert`, `warn`, `no data`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#renotify_statuses Monitor#renotify_statuses}
    */
    readonly renotifyStatuses?: string[];
    /**
    * A boolean indicating whether this monitor needs a full window of data before it's evaluated.
  
  We highly recommend you set this to `false` for sparse metrics, otherwise some evaluations will be skipped. Default: `true` for `on average`, `at all times` and `in total` aggregation. `false` otherwise.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#require_full_window Monitor#require_full_window}
    */
    readonly requireFullWindow?: boolean | cdktf.IResolvable;
    /**
    * A list of unique role identifiers to define which roles are allowed to edit the monitor. Editing a monitor includes any updates to the monitor configuration, monitor deletion, and muting of the monitor for any amount of time. Roles unique identifiers can be pulled from the [Roles API](https://docs.datadoghq.com/api/latest/roles/#list-roles) in the `data.id` field.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#restricted_roles Monitor#restricted_roles}
    */
    readonly restrictedRoles?: string[];
    /**
    * A list of tags to associate with your monitor. This can help you categorize and filter monitors in the manage monitors page of the UI. Note: it's not currently possible to filter by these tags when querying via the API
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#tags Monitor#tags}
    */
    readonly tags?: string[];
    /**
    * The number of hours of the monitor not reporting data before it automatically resolves from a triggered state. The minimum allowed value is 0 hours. The maximum allowed value is 24 hours.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#timeout_h Monitor#timeout_h}
    */
    readonly timeoutH?: number;
    /**
    * The type of the monitor. The mapping from these types to the types found in the Datadog Web UI can be found in the Datadog API [documentation page](https://docs.datadoghq.com/api/v1/monitors/#create-a-monitor). Note: The monitor type cannot be changed after a monitor is created. Valid values are `composite`, `event alert`, `log alert`, `metric alert`, `process alert`, `query alert`, `rum alert`, `service check`, `synthetics alert`, `trace-analytics alert`, `slo alert`, `event-v2 alert`, `audit alert`, `ci-pipelines alert`, `ci-tests alert`, `error-tracking alert`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#type Monitor#type}
    */
    readonly type: string;
    /**
    * If set to `false`, skip the validation call done during plan.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#validate Monitor#validate}
    */
    readonly validate?: boolean | cdktf.IResolvable;
    /**
    * monitor_threshold_windows block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#monitor_threshold_windows Monitor#monitor_threshold_windows}
    */
    readonly monitorThresholdWindows?: MonitorMonitorThresholdWindows;
    /**
    * monitor_thresholds block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#monitor_thresholds Monitor#monitor_thresholds}
    */
    readonly monitorThresholds?: MonitorMonitorThresholds;
    /**
    * scheduling_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#scheduling_options Monitor#scheduling_options}
    */
    readonly schedulingOptions?: MonitorSchedulingOptions[] | cdktf.IResolvable;
    /**
    * variables block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#variables Monitor#variables}
    */
    readonly variables?: MonitorVariables;
}
export interface MonitorMonitorThresholdWindows {
    /**
    * Describes how long an anomalous metric must be normal before the alert recovers.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#recovery_window Monitor#recovery_window}
    */
    readonly recoveryWindow?: string;
    /**
    * Describes how long a metric must be anomalous before an alert triggers.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#trigger_window Monitor#trigger_window}
    */
    readonly triggerWindow?: string;
}
export declare function monitorMonitorThresholdWindowsToTerraform(struct?: MonitorMonitorThresholdWindowsOutputReference | MonitorMonitorThresholdWindows): any;
export declare class MonitorMonitorThresholdWindowsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorMonitorThresholdWindows | undefined;
    set internalValue(value: MonitorMonitorThresholdWindows | undefined);
    private _recoveryWindow?;
    get recoveryWindow(): string;
    set recoveryWindow(value: string);
    resetRecoveryWindow(): void;
    get recoveryWindowInput(): string | undefined;
    private _triggerWindow?;
    get triggerWindow(): string;
    set triggerWindow(value: string);
    resetTriggerWindow(): void;
    get triggerWindowInput(): string | undefined;
}
export interface MonitorMonitorThresholds {
    /**
    * The monitor `CRITICAL` threshold. Must be a number.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#critical Monitor#critical}
    */
    readonly critical?: string;
    /**
    * The monitor `CRITICAL` recovery threshold. Must be a number.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#critical_recovery Monitor#critical_recovery}
    */
    readonly criticalRecovery?: string;
    /**
    * The monitor `OK` threshold. Only supported in monitor type `service check`. Must be a number.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#ok Monitor#ok}
    */
    readonly ok?: string;
    /**
    * The monitor `UNKNOWN` threshold. Only supported in monitor type `service check`. Must be a number.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#unknown Monitor#unknown}
    */
    readonly unknown?: string;
    /**
    * The monitor `WARNING` threshold. Must be a number.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#warning Monitor#warning}
    */
    readonly warning?: string;
    /**
    * The monitor `WARNING` recovery threshold. Must be a number.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#warning_recovery Monitor#warning_recovery}
    */
    readonly warningRecovery?: string;
}
export declare function monitorMonitorThresholdsToTerraform(struct?: MonitorMonitorThresholdsOutputReference | MonitorMonitorThresholds): any;
export declare class MonitorMonitorThresholdsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorMonitorThresholds | undefined;
    set internalValue(value: MonitorMonitorThresholds | undefined);
    private _critical?;
    get critical(): string;
    set critical(value: string);
    resetCritical(): void;
    get criticalInput(): string | undefined;
    private _criticalRecovery?;
    get criticalRecovery(): string;
    set criticalRecovery(value: string);
    resetCriticalRecovery(): void;
    get criticalRecoveryInput(): string | undefined;
    private _ok?;
    get ok(): string;
    set ok(value: string);
    resetOk(): void;
    get okInput(): string | undefined;
    private _unknown?;
    get unknown(): string;
    set unknown(value: string);
    resetUnknown(): void;
    get unknownInput(): string | undefined;
    private _warning?;
    get warning(): string;
    set warning(value: string);
    resetWarning(): void;
    get warningInput(): string | undefined;
    private _warningRecovery?;
    get warningRecovery(): string;
    set warningRecovery(value: string);
    resetWarningRecovery(): void;
    get warningRecoveryInput(): string | undefined;
}
export interface MonitorSchedulingOptionsEvaluationWindow {
    /**
    * The time of the day at which a one day cumulative evaluation window starts. Must be defined in UTC time in `HH:mm` format.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#day_starts Monitor#day_starts}
    */
    readonly dayStarts?: string;
    /**
    * The minute of the hour at which a one hour cumulative evaluation window starts. Must be between 0 and 59.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#hour_starts Monitor#hour_starts}
    */
    readonly hourStarts?: number;
    /**
    * The day of the month at which a one month cumulative evaluation window starts. Must be a value of 1.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#month_starts Monitor#month_starts}
    */
    readonly monthStarts?: number;
}
export declare function monitorSchedulingOptionsEvaluationWindowToTerraform(struct?: MonitorSchedulingOptionsEvaluationWindow | cdktf.IResolvable): any;
export declare class MonitorSchedulingOptionsEvaluationWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorSchedulingOptionsEvaluationWindow | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorSchedulingOptionsEvaluationWindow | cdktf.IResolvable | undefined);
    private _dayStarts?;
    get dayStarts(): string;
    set dayStarts(value: string);
    resetDayStarts(): void;
    get dayStartsInput(): string | undefined;
    private _hourStarts?;
    get hourStarts(): number;
    set hourStarts(value: number);
    resetHourStarts(): void;
    get hourStartsInput(): number | undefined;
    private _monthStarts?;
    get monthStarts(): number;
    set monthStarts(value: number);
    resetMonthStarts(): void;
    get monthStartsInput(): number | undefined;
}
export declare class MonitorSchedulingOptionsEvaluationWindowList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorSchedulingOptionsEvaluationWindow[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorSchedulingOptionsEvaluationWindowOutputReference;
}
export interface MonitorSchedulingOptions {
    /**
    * evaluation_window block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#evaluation_window Monitor#evaluation_window}
    */
    readonly evaluationWindow: MonitorSchedulingOptionsEvaluationWindow[] | cdktf.IResolvable;
}
export declare function monitorSchedulingOptionsToTerraform(struct?: MonitorSchedulingOptions | cdktf.IResolvable): any;
export declare class MonitorSchedulingOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorSchedulingOptions | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorSchedulingOptions | cdktf.IResolvable | undefined);
    private _evaluationWindow;
    get evaluationWindow(): MonitorSchedulingOptionsEvaluationWindowList;
    putEvaluationWindow(value: MonitorSchedulingOptionsEvaluationWindow[] | cdktf.IResolvable): void;
    get evaluationWindowInput(): cdktf.IResolvable | MonitorSchedulingOptionsEvaluationWindow[] | undefined;
}
export declare class MonitorSchedulingOptionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorSchedulingOptions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorSchedulingOptionsOutputReference;
}
export interface MonitorVariablesEventQueryCompute {
    /**
    * The aggregation methods for event platform queries. Valid values are `count`, `cardinality`, `median`, `pc75`, `pc90`, `pc95`, `pc98`, `pc99`, `sum`, `min`, `max`, `avg`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#aggregation Monitor#aggregation}
    */
    readonly aggregation: string;
    /**
    * A time interval in milliseconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#interval Monitor#interval}
    */
    readonly interval?: number;
    /**
    * The measurable attribute to compute.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#metric Monitor#metric}
    */
    readonly metric?: string;
}
export declare function monitorVariablesEventQueryComputeToTerraform(struct?: MonitorVariablesEventQueryCompute | cdktf.IResolvable): any;
export declare class MonitorVariablesEventQueryComputeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorVariablesEventQueryCompute | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorVariablesEventQueryCompute | cdktf.IResolvable | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
    private _metric?;
    get metric(): string;
    set metric(value: string);
    resetMetric(): void;
    get metricInput(): string | undefined;
}
export declare class MonitorVariablesEventQueryComputeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorVariablesEventQueryCompute[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorVariablesEventQueryComputeOutputReference;
}
export interface MonitorVariablesEventQueryGroupBySort {
    /**
    * The aggregation methods for the event platform queries. Valid values are `count`, `cardinality`, `median`, `pc75`, `pc90`, `pc95`, `pc98`, `pc99`, `sum`, `min`, `max`, `avg`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#aggregation Monitor#aggregation}
    */
    readonly aggregation: string;
    /**
    * The metric used for sorting group by results.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#metric Monitor#metric}
    */
    readonly metric?: string;
    /**
    * Direction of sort. Valid values are `asc`, `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#order Monitor#order}
    */
    readonly order?: string;
}
export declare function monitorVariablesEventQueryGroupBySortToTerraform(struct?: MonitorVariablesEventQueryGroupBySortOutputReference | MonitorVariablesEventQueryGroupBySort): any;
export declare class MonitorVariablesEventQueryGroupBySortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorVariablesEventQueryGroupBySort | undefined;
    set internalValue(value: MonitorVariablesEventQueryGroupBySort | undefined);
    private _aggregation?;
    get aggregation(): string;
    set aggregation(value: string);
    get aggregationInput(): string | undefined;
    private _metric?;
    get metric(): string;
    set metric(value: string);
    resetMetric(): void;
    get metricInput(): string | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    resetOrder(): void;
    get orderInput(): string | undefined;
}
export interface MonitorVariablesEventQueryGroupBy {
    /**
    * The event facet.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#facet Monitor#facet}
    */
    readonly facet: string;
    /**
    * The number of groups to return.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#limit Monitor#limit}
    */
    readonly limit?: number;
    /**
    * sort block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#sort Monitor#sort}
    */
    readonly sort?: MonitorVariablesEventQueryGroupBySort;
}
export declare function monitorVariablesEventQueryGroupByToTerraform(struct?: MonitorVariablesEventQueryGroupBy | cdktf.IResolvable): any;
export declare class MonitorVariablesEventQueryGroupByOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorVariablesEventQueryGroupBy | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorVariablesEventQueryGroupBy | cdktf.IResolvable | undefined);
    private _facet?;
    get facet(): string;
    set facet(value: string);
    get facetInput(): string | undefined;
    private _limit?;
    get limit(): number;
    set limit(value: number);
    resetLimit(): void;
    get limitInput(): number | undefined;
    private _sort;
    get sort(): MonitorVariablesEventQueryGroupBySortOutputReference;
    putSort(value: MonitorVariablesEventQueryGroupBySort): void;
    resetSort(): void;
    get sortInput(): MonitorVariablesEventQueryGroupBySort | undefined;
}
export declare class MonitorVariablesEventQueryGroupByList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorVariablesEventQueryGroupBy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorVariablesEventQueryGroupByOutputReference;
}
export interface MonitorVariablesEventQuerySearch {
    /**
    * The events search string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#query Monitor#query}
    */
    readonly query: string;
}
export declare function monitorVariablesEventQuerySearchToTerraform(struct?: MonitorVariablesEventQuerySearchOutputReference | MonitorVariablesEventQuerySearch): any;
export declare class MonitorVariablesEventQuerySearchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorVariablesEventQuerySearch | undefined;
    set internalValue(value: MonitorVariablesEventQuerySearch | undefined);
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
}
export interface MonitorVariablesEventQuery {
    /**
    * The data source for event platform-based queries. Valid values are `rum`, `ci_pipelines`, `ci_tests`, `audit`, `events`, `logs`, `spans`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#data_source Monitor#data_source}
    */
    readonly dataSource: string;
    /**
    * An array of index names to query in the stream.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#indexes Monitor#indexes}
    */
    readonly indexes?: string[];
    /**
    * The name of query for use in formulas.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#name Monitor#name}
    */
    readonly name: string;
    /**
    * compute block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#compute Monitor#compute}
    */
    readonly compute: MonitorVariablesEventQueryCompute[] | cdktf.IResolvable;
    /**
    * group_by block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#group_by Monitor#group_by}
    */
    readonly groupBy?: MonitorVariablesEventQueryGroupBy[] | cdktf.IResolvable;
    /**
    * search block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#search Monitor#search}
    */
    readonly search?: MonitorVariablesEventQuerySearch;
}
export declare function monitorVariablesEventQueryToTerraform(struct?: MonitorVariablesEventQuery | cdktf.IResolvable): any;
export declare class MonitorVariablesEventQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorVariablesEventQuery | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorVariablesEventQuery | cdktf.IResolvable | undefined);
    private _dataSource?;
    get dataSource(): string;
    set dataSource(value: string);
    get dataSourceInput(): string | undefined;
    private _indexes?;
    get indexes(): string[];
    set indexes(value: string[]);
    resetIndexes(): void;
    get indexesInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _compute;
    get compute(): MonitorVariablesEventQueryComputeList;
    putCompute(value: MonitorVariablesEventQueryCompute[] | cdktf.IResolvable): void;
    get computeInput(): cdktf.IResolvable | MonitorVariablesEventQueryCompute[] | undefined;
    private _groupBy;
    get groupBy(): MonitorVariablesEventQueryGroupByList;
    putGroupBy(value: MonitorVariablesEventQueryGroupBy[] | cdktf.IResolvable): void;
    resetGroupBy(): void;
    get groupByInput(): cdktf.IResolvable | MonitorVariablesEventQueryGroupBy[] | undefined;
    private _search;
    get search(): MonitorVariablesEventQuerySearchOutputReference;
    putSearch(value: MonitorVariablesEventQuerySearch): void;
    resetSearch(): void;
    get searchInput(): MonitorVariablesEventQuerySearch | undefined;
}
export declare class MonitorVariablesEventQueryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorVariablesEventQuery[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorVariablesEventQueryOutputReference;
}
export interface MonitorVariables {
    /**
    * event_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/monitor#event_query Monitor#event_query}
    */
    readonly eventQuery?: MonitorVariablesEventQuery[] | cdktf.IResolvable;
}
export declare function monitorVariablesToTerraform(struct?: MonitorVariablesOutputReference | MonitorVariables): any;
export declare class MonitorVariablesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorVariables | undefined;
    set internalValue(value: MonitorVariables | undefined);
    private _eventQuery;
    get eventQuery(): MonitorVariablesEventQueryList;
    putEventQuery(value: MonitorVariablesEventQuery[] | cdktf.IResolvable): void;
    resetEventQuery(): void;
    get eventQueryInput(): cdktf.IResolvable | MonitorVariablesEventQuery[] | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/monitor datadog_monitor}
*/
export declare class Monitor extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_monitor";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/monitor datadog_monitor} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MonitorConfig
    */
    constructor(scope: Construct, id: string, config: MonitorConfig);
    private _enableLogsSample?;
    get enableLogsSample(): boolean | cdktf.IResolvable;
    set enableLogsSample(value: boolean | cdktf.IResolvable);
    resetEnableLogsSample(): void;
    get enableLogsSampleInput(): boolean | cdktf.IResolvable | undefined;
    get enableSamples(): cdktf.IResolvable;
    private _escalationMessage?;
    get escalationMessage(): string;
    set escalationMessage(value: string);
    resetEscalationMessage(): void;
    get escalationMessageInput(): string | undefined;
    private _evaluationDelay?;
    get evaluationDelay(): number;
    set evaluationDelay(value: number);
    resetEvaluationDelay(): void;
    get evaluationDelayInput(): number | undefined;
    private _forceDelete?;
    get forceDelete(): boolean | cdktf.IResolvable;
    set forceDelete(value: boolean | cdktf.IResolvable);
    resetForceDelete(): void;
    get forceDeleteInput(): boolean | cdktf.IResolvable | undefined;
    private _groupRetentionDuration?;
    get groupRetentionDuration(): string;
    set groupRetentionDuration(value: string);
    resetGroupRetentionDuration(): void;
    get groupRetentionDurationInput(): string | undefined;
    private _groupbySimpleMonitor?;
    get groupbySimpleMonitor(): boolean | cdktf.IResolvable;
    set groupbySimpleMonitor(value: boolean | cdktf.IResolvable);
    resetGroupbySimpleMonitor(): void;
    get groupbySimpleMonitorInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _includeTags?;
    get includeTags(): boolean | cdktf.IResolvable;
    set includeTags(value: boolean | cdktf.IResolvable);
    resetIncludeTags(): void;
    get includeTagsInput(): boolean | cdktf.IResolvable | undefined;
    private _locked?;
    get locked(): boolean | cdktf.IResolvable;
    set locked(value: boolean | cdktf.IResolvable);
    resetLocked(): void;
    get lockedInput(): boolean | cdktf.IResolvable | undefined;
    private _message?;
    get message(): string;
    set message(value: string);
    get messageInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _newGroupDelay?;
    get newGroupDelay(): number;
    set newGroupDelay(value: number);
    resetNewGroupDelay(): void;
    get newGroupDelayInput(): number | undefined;
    private _newHostDelay?;
    get newHostDelay(): number;
    set newHostDelay(value: number);
    resetNewHostDelay(): void;
    get newHostDelayInput(): number | undefined;
    private _noDataTimeframe?;
    get noDataTimeframe(): number;
    set noDataTimeframe(value: number);
    resetNoDataTimeframe(): void;
    get noDataTimeframeInput(): number | undefined;
    private _notificationPresetName?;
    get notificationPresetName(): string;
    set notificationPresetName(value: string);
    resetNotificationPresetName(): void;
    get notificationPresetNameInput(): string | undefined;
    private _notifyAudit?;
    get notifyAudit(): boolean | cdktf.IResolvable;
    set notifyAudit(value: boolean | cdktf.IResolvable);
    resetNotifyAudit(): void;
    get notifyAuditInput(): boolean | cdktf.IResolvable | undefined;
    private _notifyBy?;
    get notifyBy(): string[];
    set notifyBy(value: string[]);
    resetNotifyBy(): void;
    get notifyByInput(): string[] | undefined;
    private _notifyNoData?;
    get notifyNoData(): boolean | cdktf.IResolvable;
    set notifyNoData(value: boolean | cdktf.IResolvable);
    resetNotifyNoData(): void;
    get notifyNoDataInput(): boolean | cdktf.IResolvable | undefined;
    private _onMissingData?;
    get onMissingData(): string;
    set onMissingData(value: string);
    resetOnMissingData(): void;
    get onMissingDataInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
    private _renotifyInterval?;
    get renotifyInterval(): number;
    set renotifyInterval(value: number);
    resetRenotifyInterval(): void;
    get renotifyIntervalInput(): number | undefined;
    private _renotifyOccurrences?;
    get renotifyOccurrences(): number;
    set renotifyOccurrences(value: number);
    resetRenotifyOccurrences(): void;
    get renotifyOccurrencesInput(): number | undefined;
    private _renotifyStatuses?;
    get renotifyStatuses(): string[];
    set renotifyStatuses(value: string[]);
    resetRenotifyStatuses(): void;
    get renotifyStatusesInput(): string[] | undefined;
    private _requireFullWindow?;
    get requireFullWindow(): boolean | cdktf.IResolvable;
    set requireFullWindow(value: boolean | cdktf.IResolvable);
    resetRequireFullWindow(): void;
    get requireFullWindowInput(): boolean | cdktf.IResolvable | undefined;
    private _restrictedRoles?;
    get restrictedRoles(): string[];
    set restrictedRoles(value: string[]);
    resetRestrictedRoles(): void;
    get restrictedRolesInput(): string[] | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _timeoutH?;
    get timeoutH(): number;
    set timeoutH(value: number);
    resetTimeoutH(): void;
    get timeoutHInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _validate?;
    get validate(): boolean | cdktf.IResolvable;
    set validate(value: boolean | cdktf.IResolvable);
    resetValidate(): void;
    get validateInput(): boolean | cdktf.IResolvable | undefined;
    private _monitorThresholdWindows;
    get monitorThresholdWindows(): MonitorMonitorThresholdWindowsOutputReference;
    putMonitorThresholdWindows(value: MonitorMonitorThresholdWindows): void;
    resetMonitorThresholdWindows(): void;
    get monitorThresholdWindowsInput(): MonitorMonitorThresholdWindows | undefined;
    private _monitorThresholds;
    get monitorThresholds(): MonitorMonitorThresholdsOutputReference;
    putMonitorThresholds(value: MonitorMonitorThresholds): void;
    resetMonitorThresholds(): void;
    get monitorThresholdsInput(): MonitorMonitorThresholds | undefined;
    private _schedulingOptions;
    get schedulingOptions(): MonitorSchedulingOptionsList;
    putSchedulingOptions(value: MonitorSchedulingOptions[] | cdktf.IResolvable): void;
    resetSchedulingOptions(): void;
    get schedulingOptionsInput(): cdktf.IResolvable | MonitorSchedulingOptions[] | undefined;
    private _variables;
    get variables(): MonitorVariablesOutputReference;
    putVariables(value: MonitorVariables): void;
    resetVariables(): void;
    get variablesInput(): MonitorVariables | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
