import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OrganizationSettingsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/organization_settings#id OrganizationSettings#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name for Organization.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/organization_settings#name OrganizationSettings#name}
    */
    readonly name?: string;
    /**
    * settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/organization_settings#settings OrganizationSettings#settings}
    */
    readonly settings?: OrganizationSettingsSettings;
}
export interface OrganizationSettingsSettingsSaml {
    /**
    * Whether or not SAML is enabled for this organization.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/organization_settings#enabled OrganizationSettings#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function organizationSettingsSettingsSamlToTerraform(struct?: OrganizationSettingsSettingsSamlOutputReference | OrganizationSettingsSettingsSaml): any;
export declare class OrganizationSettingsSettingsSamlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OrganizationSettingsSettingsSaml | undefined;
    set internalValue(value: OrganizationSettingsSettingsSaml | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface OrganizationSettingsSettingsSamlAutocreateUsersDomains {
    /**
    * List of domains where the SAML automated user creation is enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/organization_settings#domains OrganizationSettings#domains}
    */
    readonly domains?: string[];
    /**
    * Whether or not the automated user creation based on SAML domain is enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/organization_settings#enabled OrganizationSettings#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function organizationSettingsSettingsSamlAutocreateUsersDomainsToTerraform(struct?: OrganizationSettingsSettingsSamlAutocreateUsersDomainsOutputReference | OrganizationSettingsSettingsSamlAutocreateUsersDomains): any;
export declare class OrganizationSettingsSettingsSamlAutocreateUsersDomainsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OrganizationSettingsSettingsSamlAutocreateUsersDomains | undefined;
    set internalValue(value: OrganizationSettingsSettingsSamlAutocreateUsersDomains | undefined);
    private _domains?;
    get domains(): string[];
    set domains(value: string[]);
    resetDomains(): void;
    get domainsInput(): string[] | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface OrganizationSettingsSettingsSamlIdpInitiatedLogin {
    /**
    * Whether or not a SAML identity provider metadata file was provided to the Datadog organization.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/organization_settings#enabled OrganizationSettings#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function organizationSettingsSettingsSamlIdpInitiatedLoginToTerraform(struct?: OrganizationSettingsSettingsSamlIdpInitiatedLoginOutputReference | OrganizationSettingsSettingsSamlIdpInitiatedLogin): any;
export declare class OrganizationSettingsSettingsSamlIdpInitiatedLoginOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OrganizationSettingsSettingsSamlIdpInitiatedLogin | undefined;
    set internalValue(value: OrganizationSettingsSettingsSamlIdpInitiatedLogin | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface OrganizationSettingsSettingsSamlStrictMode {
    /**
    * Whether or not the SAML strict mode is enabled. If true, all users must log in with SAML.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/organization_settings#enabled OrganizationSettings#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function organizationSettingsSettingsSamlStrictModeToTerraform(struct?: OrganizationSettingsSettingsSamlStrictModeOutputReference | OrganizationSettingsSettingsSamlStrictMode): any;
export declare class OrganizationSettingsSettingsSamlStrictModeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OrganizationSettingsSettingsSamlStrictMode | undefined;
    set internalValue(value: OrganizationSettingsSettingsSamlStrictMode | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface OrganizationSettingsSettings {
    /**
    * Whether or not the organization users can share widgets outside of Datadog.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/organization_settings#private_widget_share OrganizationSettings#private_widget_share}
    */
    readonly privateWidgetShare?: boolean | cdktf.IResolvable;
    /**
    * The access role of the user. Options are `st` (standard user), `adm` (admin user), or `ro` (read-only user). Allowed enum values: `st`, `adm` , `ro`, `ERROR`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/organization_settings#saml_autocreate_access_role OrganizationSettings#saml_autocreate_access_role}
    */
    readonly samlAutocreateAccessRole?: string;
    /**
    * saml block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/organization_settings#saml OrganizationSettings#saml}
    */
    readonly saml: OrganizationSettingsSettingsSaml;
    /**
    * saml_autocreate_users_domains block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/organization_settings#saml_autocreate_users_domains OrganizationSettings#saml_autocreate_users_domains}
    */
    readonly samlAutocreateUsersDomains: OrganizationSettingsSettingsSamlAutocreateUsersDomains;
    /**
    * saml_idp_initiated_login block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/organization_settings#saml_idp_initiated_login OrganizationSettings#saml_idp_initiated_login}
    */
    readonly samlIdpInitiatedLogin: OrganizationSettingsSettingsSamlIdpInitiatedLogin;
    /**
    * saml_strict_mode block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/organization_settings#saml_strict_mode OrganizationSettings#saml_strict_mode}
    */
    readonly samlStrictMode: OrganizationSettingsSettingsSamlStrictMode;
}
export declare function organizationSettingsSettingsToTerraform(struct?: OrganizationSettingsSettingsOutputReference | OrganizationSettingsSettings): any;
export declare class OrganizationSettingsSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OrganizationSettingsSettings | undefined;
    set internalValue(value: OrganizationSettingsSettings | undefined);
    private _privateWidgetShare?;
    get privateWidgetShare(): boolean | cdktf.IResolvable;
    set privateWidgetShare(value: boolean | cdktf.IResolvable);
    resetPrivateWidgetShare(): void;
    get privateWidgetShareInput(): boolean | cdktf.IResolvable | undefined;
    private _samlAutocreateAccessRole?;
    get samlAutocreateAccessRole(): string;
    set samlAutocreateAccessRole(value: string);
    resetSamlAutocreateAccessRole(): void;
    get samlAutocreateAccessRoleInput(): string | undefined;
    get samlCanBeEnabled(): cdktf.IResolvable;
    get samlIdpEndpoint(): string;
    get samlIdpMetadataUploaded(): cdktf.IResolvable;
    get samlLoginUrl(): string;
    private _saml;
    get saml(): OrganizationSettingsSettingsSamlOutputReference;
    putSaml(value: OrganizationSettingsSettingsSaml): void;
    get samlInput(): OrganizationSettingsSettingsSaml | undefined;
    private _samlAutocreateUsersDomains;
    get samlAutocreateUsersDomains(): OrganizationSettingsSettingsSamlAutocreateUsersDomainsOutputReference;
    putSamlAutocreateUsersDomains(value: OrganizationSettingsSettingsSamlAutocreateUsersDomains): void;
    get samlAutocreateUsersDomainsInput(): OrganizationSettingsSettingsSamlAutocreateUsersDomains | undefined;
    private _samlIdpInitiatedLogin;
    get samlIdpInitiatedLogin(): OrganizationSettingsSettingsSamlIdpInitiatedLoginOutputReference;
    putSamlIdpInitiatedLogin(value: OrganizationSettingsSettingsSamlIdpInitiatedLogin): void;
    get samlIdpInitiatedLoginInput(): OrganizationSettingsSettingsSamlIdpInitiatedLogin | undefined;
    private _samlStrictMode;
    get samlStrictMode(): OrganizationSettingsSettingsSamlStrictModeOutputReference;
    putSamlStrictMode(value: OrganizationSettingsSettingsSamlStrictMode): void;
    get samlStrictModeInput(): OrganizationSettingsSettingsSamlStrictMode | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/organization_settings datadog_organization_settings}
*/
export declare class OrganizationSettings extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_organization_settings";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/organization_settings datadog_organization_settings} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OrganizationSettingsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: OrganizationSettingsConfig);
    get description(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get publicId(): string;
    private _settings;
    get settings(): OrganizationSettingsSettingsOutputReference;
    putSettings(value: OrganizationSettingsSettings): void;
    resetSettings(): void;
    get settingsInput(): OrganizationSettingsSettings | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
