import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DatadogProviderConfig {
    /**
    * (Required unless validate is false) Datadog API key. This can also be set via the DD_API_KEY environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog#api_key DatadogProvider#api_key}
    */
    readonly apiKey?: string;
    /**
    * The API URL. This can also be set via the DD_HOST environment variable. Note that this URL must not end with the `/api/` path. For example, `https://api.datadoghq.com/` is a correct value, while `https://api.datadoghq.com/api/` is not. And if you're working with "EU" version of Datadog, use `https://api.datadoghq.eu/`. Other Datadog region examples: `https://api.us5.datadoghq.com/`, `https://api.us3.datadoghq.com/` and `https://api.ddog-gov.com/`. See https://docs.datadoghq.com/getting_started/site/ for all available regions.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog#api_url DatadogProvider#api_url}
    */
    readonly apiUrl?: string;
    /**
    * (Required unless validate is false) Datadog APP key. This can also be set via the DD_APP_KEY environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog#app_key DatadogProvider#app_key}
    */
    readonly appKey?: string;
    /**
    * Enables request retries on HTTP status codes 429 and 5xx. Defaults to `true`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog#http_client_retry_enabled DatadogProvider#http_client_retry_enabled}
    */
    readonly httpClientRetryEnabled?: boolean | cdktf.IResolvable;
    /**
    * The HTTP request retry timeout period. Defaults to 60 seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog#http_client_retry_timeout DatadogProvider#http_client_retry_timeout}
    */
    readonly httpClientRetryTimeout?: number;
    /**
    * Enables validation of the provided API and APP keys during provider initialization. Default is true. When false, api_key and app_key won't be checked.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog#validate DatadogProvider#validate}
    */
    readonly validate?: boolean | cdktf.IResolvable;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog#alias DatadogProvider#alias}
    */
    readonly alias?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog datadog}
*/
export declare class DatadogProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "datadog";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog datadog} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DatadogProviderConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DatadogProviderConfig);
    private _apiKey?;
    get apiKey(): string | undefined;
    set apiKey(value: string | undefined);
    resetApiKey(): void;
    get apiKeyInput(): string | undefined;
    private _apiUrl?;
    get apiUrl(): string | undefined;
    set apiUrl(value: string | undefined);
    resetApiUrl(): void;
    get apiUrlInput(): string | undefined;
    private _appKey?;
    get appKey(): string | undefined;
    set appKey(value: string | undefined);
    resetAppKey(): void;
    get appKeyInput(): string | undefined;
    private _httpClientRetryEnabled?;
    get httpClientRetryEnabled(): boolean | cdktf.IResolvable | undefined;
    set httpClientRetryEnabled(value: boolean | cdktf.IResolvable | undefined);
    resetHttpClientRetryEnabled(): void;
    get httpClientRetryEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _httpClientRetryTimeout?;
    get httpClientRetryTimeout(): number | undefined;
    set httpClientRetryTimeout(value: number | undefined);
    resetHttpClientRetryTimeout(): void;
    get httpClientRetryTimeoutInput(): number | undefined;
    private _validate?;
    get validate(): boolean | cdktf.IResolvable | undefined;
    set validate(value: boolean | cdktf.IResolvable | undefined);
    resetValidate(): void;
    get validateInput(): boolean | cdktf.IResolvable | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
