"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DatadogProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog datadog}
*/
class DatadogProvider extends cdktf.TerraformProvider {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog datadog} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DatadogProviderConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'datadog',
            terraformGeneratorMetadata: {
                providerName: 'datadog',
                providerVersion: '3.21.0',
                providerVersionConstraint: '~> 3.0'
            },
            terraformProviderSource: 'DataDog/datadog'
        });
        this._apiKey = config.apiKey;
        this._apiUrl = config.apiUrl;
        this._appKey = config.appKey;
        this._httpClientRetryEnabled = config.httpClientRetryEnabled;
        this._httpClientRetryTimeout = config.httpClientRetryTimeout;
        this._validate = config.validate;
        this._alias = config.alias;
    }
    get apiKey() {
        return this._apiKey;
    }
    set apiKey(value) {
        this._apiKey = value;
    }
    resetApiKey() {
        this._apiKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get apiKeyInput() {
        return this._apiKey;
    }
    get apiUrl() {
        return this._apiUrl;
    }
    set apiUrl(value) {
        this._apiUrl = value;
    }
    resetApiUrl() {
        this._apiUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get apiUrlInput() {
        return this._apiUrl;
    }
    get appKey() {
        return this._appKey;
    }
    set appKey(value) {
        this._appKey = value;
    }
    resetAppKey() {
        this._appKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get appKeyInput() {
        return this._appKey;
    }
    get httpClientRetryEnabled() {
        return this._httpClientRetryEnabled;
    }
    set httpClientRetryEnabled(value) {
        this._httpClientRetryEnabled = value;
    }
    resetHttpClientRetryEnabled() {
        this._httpClientRetryEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get httpClientRetryEnabledInput() {
        return this._httpClientRetryEnabled;
    }
    get httpClientRetryTimeout() {
        return this._httpClientRetryTimeout;
    }
    set httpClientRetryTimeout(value) {
        this._httpClientRetryTimeout = value;
    }
    resetHttpClientRetryTimeout() {
        this._httpClientRetryTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get httpClientRetryTimeoutInput() {
        return this._httpClientRetryTimeout;
    }
    get validate() {
        return this._validate;
    }
    set validate(value) {
        this._validate = value;
    }
    resetValidate() {
        this._validate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get validateInput() {
        return this._validate;
    }
    get alias() {
        return this._alias;
    }
    set alias(value) {
        this._alias = value;
    }
    resetAlias() {
        this._alias = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aliasInput() {
        return this._alias;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            api_key: cdktf.stringToTerraform(this._apiKey),
            api_url: cdktf.stringToTerraform(this._apiUrl),
            app_key: cdktf.stringToTerraform(this._appKey),
            http_client_retry_enabled: cdktf.booleanToTerraform(this._httpClientRetryEnabled),
            http_client_retry_timeout: cdktf.numberToTerraform(this._httpClientRetryTimeout),
            validate: cdktf.booleanToTerraform(this._validate),
            alias: cdktf.stringToTerraform(this._alias),
        };
    }
}
exports.DatadogProvider = DatadogProvider;
_a = JSII_RTTI_SYMBOL_1;
DatadogProvider[_a] = { fqn: "@cdktf/provider-datadog.provider.DatadogProvider", version: "5.0.1" };
// =================
// STATIC PROPERTIES
// =================
DatadogProvider.tfResourceType = "datadog";
//# sourceMappingURL=data:application/json;base64,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