import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/role#id Role#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/role#name Role#name}
    */
    readonly name: string;
    /**
    * If set to `false`, skip the validation call done during plan.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/role#validate Role#validate}
    */
    readonly validate?: boolean | cdktf.IResolvable;
    /**
    * permission block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/role#permission Role#permission}
    */
    readonly permission?: RolePermission[] | cdktf.IResolvable;
}
export interface RolePermission {
    /**
    * ID of the permission to assign.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/role#id Role#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
}
export declare function rolePermissionToTerraform(struct?: RolePermission | cdktf.IResolvable): any;
export declare class RolePermissionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): RolePermission | cdktf.IResolvable | undefined;
    set internalValue(value: RolePermission | cdktf.IResolvable | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    get name(): string;
}
export declare class RolePermissionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: RolePermission[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): RolePermissionOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/role datadog_role}
*/
export declare class Role extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/role datadog_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RoleConfig
    */
    constructor(scope: Construct, id: string, config: RoleConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get userCount(): number;
    private _validate?;
    get validate(): boolean | cdktf.IResolvable;
    set validate(value: boolean | cdktf.IResolvable);
    resetValidate(): void;
    get validateInput(): boolean | cdktf.IResolvable | undefined;
    private _permission;
    get permission(): RolePermissionList;
    putPermission(value: RolePermission[] | cdktf.IResolvable): void;
    resetPermission(): void;
    get permissionInput(): cdktf.IResolvable | RolePermission[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
