import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RumApplicationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/rum_application#id RumApplication#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the RUM application
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/rum_application#name RumApplication#name}
    */
    readonly name: string;
    /**
    * The RUM application type. Supported values are `browser`, `ios`, `android`, `react-native`, `flutter`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/rum_application#type RumApplication#type}
    */
    readonly type?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/rum_application datadog_rum_application}
*/
export declare class RumApplication extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_rum_application";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/rum_application datadog_rum_application} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RumApplicationConfig
    */
    constructor(scope: Construct, id: string, config: RumApplicationConfig);
    get clientToken(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
