import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SecurityMonitoringDefaultRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Enable the rule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_default_rule#enabled SecurityMonitoringDefaultRule#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_default_rule#id SecurityMonitoringDefaultRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * case block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_default_rule#case SecurityMonitoringDefaultRule#case}
    */
    readonly case?: SecurityMonitoringDefaultRuleCase[] | cdktf.IResolvable;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_default_rule#filter SecurityMonitoringDefaultRule#filter}
    */
    readonly filter?: SecurityMonitoringDefaultRuleFilter[] | cdktf.IResolvable;
    /**
    * options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_default_rule#options SecurityMonitoringDefaultRule#options}
    */
    readonly options?: SecurityMonitoringDefaultRuleOptions;
}
export interface SecurityMonitoringDefaultRuleCase {
    /**
    * Notification targets for each rule case.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_default_rule#notifications SecurityMonitoringDefaultRule#notifications}
    */
    readonly notifications: string[];
    /**
    * Status of the rule case to match. Valid values are `info`, `low`, `medium`, `high`, `critical`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_default_rule#status SecurityMonitoringDefaultRule#status}
    */
    readonly status: string;
}
export declare function securityMonitoringDefaultRuleCaseToTerraform(struct?: SecurityMonitoringDefaultRuleCase | cdktf.IResolvable): any;
export declare class SecurityMonitoringDefaultRuleCaseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SecurityMonitoringDefaultRuleCase | cdktf.IResolvable | undefined;
    set internalValue(value: SecurityMonitoringDefaultRuleCase | cdktf.IResolvable | undefined);
    private _notifications?;
    get notifications(): string[];
    set notifications(value: string[]);
    get notificationsInput(): string[] | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    get statusInput(): string | undefined;
}
export declare class SecurityMonitoringDefaultRuleCaseList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SecurityMonitoringDefaultRuleCase[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SecurityMonitoringDefaultRuleCaseOutputReference;
}
export interface SecurityMonitoringDefaultRuleFilter {
    /**
    * The type of filtering action. Allowed enum values: require, suppress Valid values are `require`, `suppress`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_default_rule#action SecurityMonitoringDefaultRule#action}
    */
    readonly action: string;
    /**
    * Query for selecting logs to apply the filtering action.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_default_rule#query SecurityMonitoringDefaultRule#query}
    */
    readonly query: string;
}
export declare function securityMonitoringDefaultRuleFilterToTerraform(struct?: SecurityMonitoringDefaultRuleFilter | cdktf.IResolvable): any;
export declare class SecurityMonitoringDefaultRuleFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SecurityMonitoringDefaultRuleFilter | cdktf.IResolvable | undefined;
    set internalValue(value: SecurityMonitoringDefaultRuleFilter | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
}
export declare class SecurityMonitoringDefaultRuleFilterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SecurityMonitoringDefaultRuleFilter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SecurityMonitoringDefaultRuleFilterOutputReference;
}
export interface SecurityMonitoringDefaultRuleOptions {
    /**
    * If true, signals in non-production environments have a lower severity than what is defined by the rule case, which can reduce noise. The decrement is applied when the environment tag of the signal starts with `staging`, `test`, or `dev`. Only available when the rule type is `log_detection`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_default_rule#decrease_criticality_based_on_env SecurityMonitoringDefaultRule#decrease_criticality_based_on_env}
    */
    readonly decreaseCriticalityBasedOnEnv?: boolean | cdktf.IResolvable;
}
export declare function securityMonitoringDefaultRuleOptionsToTerraform(struct?: SecurityMonitoringDefaultRuleOptionsOutputReference | SecurityMonitoringDefaultRuleOptions): any;
export declare class SecurityMonitoringDefaultRuleOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SecurityMonitoringDefaultRuleOptions | undefined;
    set internalValue(value: SecurityMonitoringDefaultRuleOptions | undefined);
    private _decreaseCriticalityBasedOnEnv?;
    get decreaseCriticalityBasedOnEnv(): boolean | cdktf.IResolvable;
    set decreaseCriticalityBasedOnEnv(value: boolean | cdktf.IResolvable);
    resetDecreaseCriticalityBasedOnEnv(): void;
    get decreaseCriticalityBasedOnEnvInput(): boolean | cdktf.IResolvable | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_default_rule datadog_security_monitoring_default_rule}
*/
export declare class SecurityMonitoringDefaultRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_security_monitoring_default_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_default_rule datadog_security_monitoring_default_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SecurityMonitoringDefaultRuleConfig = {}
    */
    constructor(scope: Construct, id: string, config?: SecurityMonitoringDefaultRuleConfig);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get type(): string;
    private _case;
    get case(): SecurityMonitoringDefaultRuleCaseList;
    putCase(value: SecurityMonitoringDefaultRuleCase[] | cdktf.IResolvable): void;
    resetCase(): void;
    get caseInput(): cdktf.IResolvable | SecurityMonitoringDefaultRuleCase[] | undefined;
    private _filter;
    get filter(): SecurityMonitoringDefaultRuleFilterList;
    putFilter(value: SecurityMonitoringDefaultRuleFilter[] | cdktf.IResolvable): void;
    resetFilter(): void;
    get filterInput(): cdktf.IResolvable | SecurityMonitoringDefaultRuleFilter[] | undefined;
    private _options;
    get options(): SecurityMonitoringDefaultRuleOptionsOutputReference;
    putOptions(value: SecurityMonitoringDefaultRuleOptions): void;
    resetOptions(): void;
    get optionsInput(): SecurityMonitoringDefaultRuleOptions | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
